/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.jps;

import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.workspace.api.EntitySource;
import com.intellij.workspace.api.ModuleEntity;
import com.intellij.workspace.api.VirtualFileUrl;
import com.intellij.workspace.api.VirtualFileUrlKt;
import com.intellij.workspace.ide.JpsFileEntitySource;
import com.intellij.workspace.jps.JpsFileContentReader;
import com.intellij.workspace.jps.JpsFileContentWriter;
import com.intellij.workspace.jps.JpsFileEntitiesSerializer;
import com.intellij.workspace.jps.JpsFileSerializerFactory;
import com.intellij.workspace.jps.ModuleImlFileEntitiesSerializer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010 \u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/workspace/jps/ModuleSerializersFactory;", "Lcom/intellij/workspace/jps/JpsFileSerializerFactory;", "Lcom/intellij/workspace/api/ModuleEntity;", "fileUrl", "", "serializeFacets", "", "(Ljava/lang/String;Z)V", "entityClass", "Ljava/lang/Class;", "getEntityClass", "()Ljava/lang/Class;", "getFileUrl", "()Ljava/lang/String;", "createSerializer", "Lcom/intellij/workspace/jps/JpsFileEntitiesSerializer;", "source", "Lcom/intellij/workspace/ide/JpsFileEntitySource;", "Lcom/intellij/workspace/api/VirtualFileUrl;", "deleteObsoleteFile", "", "writer", "Lcom/intellij/workspace/jps/JpsFileContentWriter;", "getFileName", "entity", "getModuleFileUrl", "Lcom/intellij/workspace/ide/JpsFileEntitySource$FileInDirectory;", "module", "loadFileList", "", "reader", "Lcom/intellij/workspace/jps/JpsFileContentReader;", "saveEntitiesList", "entities", "Lkotlin/sequences/Sequence;", "intellij.platform.workspaceModel.ide"})
public final class ModuleSerializersFactory
implements JpsFileSerializerFactory<ModuleEntity> {
    @NotNull
    private final String fileUrl;
    private final boolean serializeFacets;

    @Override
    @NotNull
    public Class<ModuleEntity> getEntityClass() {
        return ModuleEntity.class;
    }

    @Override
    @NotNull
    public String getFileName(@NotNull ModuleEntity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return entity.getName() + ".iml";
    }

    @Override
    @NotNull
    public JpsFileEntitiesSerializer<ModuleEntity> createSerializer(@NotNull JpsFileEntitySource source, @NotNull VirtualFileUrl fileUrl) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)fileUrl, (String)"fileUrl");
        String string = JpsPathUtil.urlToPath((String)fileUrl.getFilePath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JpsPathUtil.urlToPath(fileUrl.filePath)");
        return new ModuleImlFileEntitiesSerializer(new ModulePath(string, null), fileUrl, source, this.serializeFacets);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<VirtualFileUrl> loadFileList(@NotNull JpsFileContentReader reader) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Element element2 = reader.loadComponent(this.getFileUrl(), "ProjectModuleManager");
        if (element2 == null) {
            return CollectionsKt.emptyList();
        }
        Element moduleManagerTag = element2;
        Set<ModulePath> set = ModuleManagerImpl.getPathsToModuleFiles(moduleManagerTag);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"ModuleManagerImpl.getPat\u2026leFiles(moduleManagerTag)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModulePath modulePath = (ModulePath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VirtualFileUrl virtualFileUrl = VirtualFileUrlKt.toVirtualFileUrl(new File(it.getPath()));
            collection.add(virtualFileUrl);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveEntitiesList(@NotNull Sequence<? extends ModuleEntity> entities2, @NotNull JpsFileContentWriter writer) {
        Object it;
        Object object;
        boolean bl;
        boolean bl2;
        Object element$iv;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkParameterIsNotNull(entities2, (String)"entities");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Element componentTag = JDomSerializationUtil.createComponentElement((String)"ProjectModuleManager");
        Sequence<? extends ModuleEntity> sequence = entities2;
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach22 = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv;
            element$iv = element$iv$iv = iterator2.next();
            boolean bl3 = false;
            ModuleEntity module = (ModuleEntity)element$iv;
            boolean bl4 = false;
            EntitySource entitySource = module.getEntitySource();
            if (!(entitySource instanceof JpsFileEntitySource.FileInDirectory)) {
                entitySource = null;
            }
            if ((JpsFileEntitySource.FileInDirectory)entitySource != null) {
                bl2 = false;
                bl = false;
                it = object;
                boolean bl5 = false;
                pair = new Pair(it, (Object)module);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl6 = false;
            boolean bl7 = false;
            Pair it$iv = pair2;
            boolean bl8 = false;
            destination$iv.add(it$iv);
        }
        Iterable $this$sortedBy$iv = destination$iv;
        boolean $i$f$sortedBy = false;
        Iterable $i$f$mapNotNullTo22 = $this$sortedBy$iv;
        boolean bl9 = false;
        Comparator $i$f$forEach22 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)((ModuleEntity)it.getSecond()).getName());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = ((ModuleEntity)it.getSecond()).getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        List entitiesToSave2 = CollectionsKt.sortedWith((Iterable)$i$f$mapNotNullTo22, (Comparator)$i$f$forEach22);
        $this$sortedBy$iv = entitiesToSave2;
        $i$f$sortedBy = false;
        if (!$this$sortedBy$iv.isEmpty()) {
            Element modulesTag = new Element("modules");
            Iterable $this$forEach$iv = entitiesToSave2;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                void source;
                Pair $dstr$source$module = (Pair)element$iv2;
                boolean bl10 = false;
                element$iv = (JpsFileEntitySource.FileInDirectory)$dstr$source$module.component1();
                ModuleEntity module = (ModuleEntity)$dstr$source$module.component2();
                Element moduleTag = new Element("module");
                String fileUrl = this.getModuleFileUrl((JpsFileEntitySource.FileInDirectory)source, module);
                moduleTag.setAttribute("fileurl", fileUrl);
                moduleTag.setAttribute("filepath", JpsPathUtil.urlToPath((String)fileUrl));
                if (module.getGroupPath() != null) {
                    bl2 = false;
                    bl = false;
                    it = object;
                    boolean bl11 = false;
                    moduleTag.setAttribute("group", CollectionsKt.joinToString$default((Iterable)it.getPath(), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
                }
                modulesTag.addContent(moduleTag);
            }
            componentTag.addContent(modulesTag);
        }
        writer.saveComponent(this.getFileUrl(), "ProjectModuleManager", componentTag);
    }

    @Override
    public void deleteObsoleteFile(@NotNull String fileUrl, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        writer.saveComponent(fileUrl, "NewModuleRootManager", null);
    }

    private final String getModuleFileUrl(JpsFileEntitySource.FileInDirectory source, ModuleEntity module) {
        return source.getDirectory().getUrl() + "/" + module.getName() + ".iml";
    }

    @Override
    @NotNull
    public String getFileUrl() {
        return this.fileUrl;
    }

    public ModuleSerializersFactory(@NotNull String fileUrl, boolean serializeFacets) {
        Intrinsics.checkParameterIsNotNull((Object)fileUrl, (String)"fileUrl");
        this.fileUrl = fileUrl;
        this.serializeFacets = serializeFacets;
    }
}

