/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.evaluate.ExpressionInputComponent;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0014J\u0006\u0010\u0013\u001a\u00020\fJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/xdebugger/impl/evaluate/XExpressionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "editorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "historyId", "", "title", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "expression", "Lcom/intellij/xdebugger/XExpression;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/xdebugger/XSourcePosition;Lcom/intellij/xdebugger/XExpression;)V", "myInputComponent", "Lcom/intellij/xdebugger/impl/evaluate/EvaluationInputComponent;", "createCenterPanel", "Ljavax/swing/JComponent;", "getDimensionServiceKey", "getExpression", "getPreferredFocusedComponent", "intellij.platform.debugger.impl"})
public class XExpressionDialog
extends DialogWrapper {
    private final EvaluationInputComponent myInputComponent;

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myInputComponent.getMainComponent();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        XDebuggerEditorBase xDebuggerEditorBase = this.myInputComponent.getInputEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerEditorBase, (String)"myInputComponent.inputEditor");
        return xDebuggerEditorBase.getPreferredFocusedComponent();
    }

    @NotNull
    public final XExpression getExpression() {
        XDebuggerEditorBase xDebuggerEditorBase = this.myInputComponent.getInputEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerEditorBase, (String)"myInputComponent.inputEditor");
        XDebuggerEditorBase editor = xDebuggerEditorBase;
        editor.saveTextInHistory();
        XExpression xExpression = editor.getExpression();
        Intrinsics.checkExpressionValueIsNotNull((Object)xExpression, (String)"editor.expression");
        return xExpression;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "#debugger.expression.dialog";
    }

    public XExpressionDialog(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull String historyId, @NotNull String title, @Nullable XSourcePosition sourcePosition, @Nullable XExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editorsProvider, (String)"editorsProvider");
        Intrinsics.checkParameterIsNotNull((Object)historyId, (String)"historyId");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        super(project);
        this.myInputComponent = new ExpressionInputComponent(project, editorsProvider, historyId, sourcePosition, expression, this.myDisposable, false);
        this.setTitle(title);
        this.init();
    }
}

