/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.CommonBundle;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import gnu.trove.TObjectIntHashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XFramesView
extends XDebugView {
    private static final Logger LOG = Logger.getInstance(XFramesView.class);
    private final JPanel myMainPanel;
    private final XDebuggerFramesList myFramesList;
    private final ComboBox<XExecutionStack> myThreadComboBox;
    private final TObjectIntHashMap<XExecutionStack> myExecutionStacksWithSelection;
    private XExecutionStack mySelectedStack;
    private int mySelectedFrameIndex;
    private Rectangle myVisibleRect;
    private boolean myListenersEnabled;
    private final Map<XExecutionStack, StackFramesListBuilder> myBuilders;
    private final ActionToolbarImpl myToolbar;
    private final Wrapper myThreadsPanel;
    private boolean myThreadsCalculated;
    private boolean myRefresh;

    public XFramesView(@NotNull Project project) {
        if (project == null) {
            XFramesView.$$$reportNull$$$0(0);
        }
        this.myExecutionStacksWithSelection = new TObjectIntHashMap();
        this.myBuilders = new HashMap<XExecutionStack, StackFramesListBuilder>();
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myFramesList = new XDebuggerFramesList(project);
        this.myFramesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (XFramesView.this.myListenersEnabled && !e.getValueIsAdjusting() && XFramesView.this.mySelectedFrameIndex != XFramesView.this.myFramesList.getSelectedIndex()) {
                    XFramesView.this.processFrameSelection(XDebugView.getSession(e), true);
                }
            }
        });
        this.myFramesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int i;
                if (XFramesView.this.myListenersEnabled && (i = XFramesView.this.myFramesList.locationToIndex(e.getPoint())) != -1 && XFramesView.this.myFramesList.isSelectedIndex(i)) {
                    XFramesView.this.processFrameSelection(XDebugView.getSession(e), true);
                }
            }
        });
        this.myFramesList.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionManager actionManager = ActionManager.getInstance();
                ActionGroup group = (ActionGroup)actionManager.getAction("XDebugger.Frames.Tree.Popup");
                actionManager.createActionPopupMenu("unknown", group).getComponent().show(comp, x, y);
            }
        });
        this.myMainPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myFramesList)), "Center");
        this.myThreadComboBox = new ComboBox();
        this.myThreadComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value2, index) -> {
            if (value2 != null) {
                label2.setText(value2.getDisplayName());
                label2.setIcon(value2.getIcon());
            } else if (index >= 0) {
                label2.setText(CommonBundle.getLoadingTreeNodeText());
            }
        }));
        this.myThreadComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XDebugSession session2;
                Object item;
                if (!XFramesView.this.myListenersEnabled) {
                    return;
                }
                if (e.getStateChange() == 1 && (item = e.getItem()) != XFramesView.this.mySelectedStack && item instanceof XExecutionStack && (session2 = XDebugView.getSession(e)) != null) {
                    XFramesView.this.myRefresh = false;
                    XFramesView.this.updateFrames((XExecutionStack)item, session2, null, false);
                }
            }
        });
        this.myThreadComboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){
            ThreadsBuilder myBuilder;

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.stopBuilder();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                this.stopBuilder();
            }

            private void stopBuilder() {
                if (this.myBuilder != null) {
                    this.myBuilder.setObsolete();
                    this.myBuilder = null;
                }
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                XSuspendContext context;
                XDebugSession session2 = XDebugView.getSession(e);
                XSuspendContext xSuspendContext = context = session2 == null ? null : session2.getSuspendContext();
                if (context != null && !XFramesView.this.myThreadsCalculated) {
                    this.myBuilder = new ThreadsBuilder();
                    context.computeExecutionStacks((XSuspendContext.XExecutionStackContainer)this.myBuilder);
                }
            }
        });
        new ComboboxSpeedSearch((JComboBox)this.myThreadComboBox){

            @Override
            protected String getElementText(Object element2) {
                return ((XExecutionStack)element2).getDisplayName();
            }
        };
        this.myToolbar = this.createToolbar();
        this.myThreadsPanel = new Wrapper();
        this.myThreadsPanel.setBorder((Border)new CustomLineBorder(CaptionPanel.CNT_ACTIVE_BORDER_COLOR, 0, 0, 1, 0));
        this.myThreadsPanel.add((Component)this.myToolbar.getComponent(), (Object)"East");
        this.myMainPanel.add((Component)this.myThreadsPanel, "North");
        this.myMainPanel.setFocusCycleRoot(true);
        this.myMainPanel.setFocusTraversalPolicy(new MyFocusPolicy());
    }

    public JComponent getDefaultFocusedComponent() {
        return this.myFramesList;
    }

    private ActionToolbarImpl createToolbar() {
        DefaultActionGroup framesGroup = new DefaultActionGroup();
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        framesGroup.add(actionsManager.createPrevOccurenceAction((OccurenceNavigator)this.myFramesList));
        framesGroup.add(actionsManager.createNextOccurenceAction((OccurenceNavigator)this.myFramesList));
        framesGroup.addAll(new AnAction[]{ActionManager.getInstance().getAction("XDebugger.Frames.TopToolbar")});
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("DebuggerToolbar", (ActionGroup)framesGroup, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        return toolbar;
    }

    private StackFramesListBuilder getOrCreateBuilder(XExecutionStack executionStack, XDebugSession session2) {
        return this.myBuilders.computeIfAbsent(executionStack, k -> new StackFramesListBuilder(executionStack, session2));
    }

    private void withCurrentBuilder(Consumer<? super StackFramesListBuilder> consumer) {
        StackFramesListBuilder builder2 = this.myBuilders.get(this.mySelectedStack);
        if (builder2 != null) {
            consumer.consume((Object)builder2);
        }
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event, @NotNull XDebugSession session2) {
        if (event == null) {
            XFramesView.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            XFramesView.$$$reportNull$$$0(2);
        }
        boolean bl = this.myRefresh = event == XDebugView.SessionEvent.SETTINGS_CHANGED;
        if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
            return;
        }
        XExecutionStack currentExecutionStack = ((XDebugSessionImpl)session2).getCurrentExecutionStack();
        XStackFrame currentStackFrame = session2.getCurrentStackFrame();
        XSuspendContext suspendContext = session2.getSuspendContext();
        if (event == XDebugView.SessionEvent.FRAME_CHANGED && Objects.equals(this.mySelectedStack, currentExecutionStack)) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (currentStackFrame != null) {
                this.myFramesList.setSelectedValue(currentStackFrame, true);
                this.mySelectedFrameIndex = this.myFramesList.getSelectedIndex();
                this.myExecutionStacksWithSelection.put((Object)this.mySelectedStack, this.mySelectedFrameIndex);
            }
            return;
        }
        EdtExecutorService.getInstance().execute(() -> {
            if (event != XDebugView.SessionEvent.SETTINGS_CHANGED) {
                this.mySelectedFrameIndex = 0;
                this.mySelectedStack = null;
                this.myVisibleRect = null;
            } else {
                this.myVisibleRect = this.myFramesList.getVisibleRect();
            }
            this.myListenersEnabled = false;
            this.myBuilders.values().forEach(StackFramesListBuilder::dispose);
            this.myBuilders.clear();
            if (suspendContext == null) {
                this.requestClear();
                return;
            }
            if (event == XDebugView.SessionEvent.PAUSED) {
                this.cancelClear();
                this.clear();
            }
            XExecutionStack activeExecutionStack = this.mySelectedStack != null ? this.mySelectedStack : currentExecutionStack;
            this.addExecutionStacks(Collections.singletonList(activeExecutionStack), false);
            this.myThreadComboBox.setSelectedItem((Object)activeExecutionStack);
            boolean invisible = activeExecutionStack == null || StringUtil.isEmpty((String)activeExecutionStack.getDisplayName());
            if (invisible != (this.myThreadComboBox.getParent() == null)) {
                if (invisible) {
                    this.myThreadsPanel.remove(this.myThreadComboBox);
                } else {
                    this.myThreadsPanel.add(this.myThreadComboBox, (Object)"Center");
                }
                this.myThreadsPanel.revalidate();
            }
            this.updateFrames(activeExecutionStack, session2, (XStackFrame)(event == XDebugView.SessionEvent.FRAME_CHANGED ? currentStackFrame : null), event == XDebugView.SessionEvent.SETTINGS_CHANGED);
        });
    }

    @Override
    protected void clear() {
        this.myThreadComboBox.removeAllItems();
        this.myFramesList.clear();
        this.myThreadsCalculated = false;
        this.myExecutionStacksWithSelection.clear();
    }

    private boolean addExecutionStacks(List<? extends XExecutionStack> executionStacks, boolean addBeforeSelection) {
        int count = this.myThreadComboBox.getItemCount();
        boolean loading = count > 0 && this.myThreadComboBox.getItemAt(count - 1) == null;
        Object selectedItem = this.myThreadComboBox.getSelectedItem();
        for (XExecutionStack xExecutionStack : executionStacks) {
            if (addBeforeSelection && xExecutionStack.equals(selectedItem)) {
                addBeforeSelection = false;
            }
            if (this.myExecutionStacksWithSelection.contains((Object)xExecutionStack)) continue;
            if (addBeforeSelection) {
                this.myThreadComboBox.insertItemAt((Object)xExecutionStack, this.myThreadComboBox.getSelectedIndex());
            } else if (loading) {
                this.myThreadComboBox.insertItemAt((Object)xExecutionStack, this.myThreadComboBox.getItemCount() - 1);
            } else {
                this.myThreadComboBox.addItem((Object)xExecutionStack);
            }
            this.myExecutionStacksWithSelection.put((Object)xExecutionStack, 0);
        }
        return addBeforeSelection;
    }

    private void updateFrames(XExecutionStack executionStack, @NotNull XDebugSession session2, @Nullable XStackFrame frameToSelect, boolean refresh2) {
        if (session2 == null) {
            XFramesView.$$$reportNull$$$0(3);
        }
        if (this.mySelectedStack != null) {
            this.withCurrentBuilder((Consumer<? super StackFramesListBuilder>)((Consumer)StackFramesListBuilder::stop));
        }
        this.mySelectedStack = executionStack;
        if (executionStack != null) {
            this.mySelectedFrameIndex = this.myExecutionStacksWithSelection.get((Object)executionStack);
            StackFramesListBuilder builder2 = this.getOrCreateBuilder(executionStack, session2);
            builder2.setRefresh(refresh2);
            builder2.setToSelect(frameToSelect != null ? frameToSelect : Integer.valueOf(this.mySelectedFrameIndex));
            this.myListenersEnabled = false;
            boolean selected2 = builder2.initModel(this.myFramesList.getModel());
            this.myListenersEnabled = !builder2.start() || selected2;
        }
    }

    public void dispose() {
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private void processFrameSelection(XDebugSession session2, boolean force) {
        this.mySelectedFrameIndex = this.myFramesList.getSelectedIndex();
        this.myExecutionStacksWithSelection.put((Object)this.mySelectedStack, this.mySelectedFrameIndex);
        this.withCurrentBuilder((Consumer<? super StackFramesListBuilder>)((Consumer)b -> b.setToSelect(null)));
        Object selected2 = this.myFramesList.getSelectedValue();
        if (selected2 instanceof XStackFrame && session2 != null && (force || !this.myRefresh && session2.getCurrentStackFrame() != selected2)) {
            session2.setCurrentStackFrame(this.mySelectedStack, (XStackFrame)selected2, this.mySelectedFrameIndex == 0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/frame/XFramesView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processSessionEvent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFrames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class StackFramesListBuilder
    implements XStackFrameContainerEx {
        private XExecutionStack myExecutionStack;
        private final List<XStackFrame> myStackFrames;
        private String myErrorMessage;
        private int myNextFrameIndex;
        private volatile boolean myRunning;
        private boolean myAllFramesLoaded;
        private final XDebugSession mySession;
        private Object myToSelect;
        private boolean myRefresh;

        private StackFramesListBuilder(XExecutionStack executionStack, XDebugSession session2) {
            this.myExecutionStack = executionStack;
            this.mySession = session2;
            this.myStackFrames = new ArrayList<XStackFrame>();
        }

        void setToSelect(Object toSelect2) {
            this.myToSelect = toSelect2;
        }

        private void setRefresh(boolean refresh2) {
            this.myRefresh = refresh2;
        }

        public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, boolean last) {
            if (stackFrames == null) {
                StackFramesListBuilder.$$$reportNull$$$0(0);
            }
            this.addStackFrames(stackFrames, null, last);
        }

        @Override
        public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, @Nullable XStackFrame toSelect2, boolean last) {
            if (stackFrames == null) {
                StackFramesListBuilder.$$$reportNull$$$0(1);
            }
            if (this.isObsolete()) {
                return;
            }
            EdtExecutorService.getInstance().execute(() -> {
                if (this.isObsolete()) {
                    return;
                }
                this.myStackFrames.addAll(stackFrames);
                this.addFrameListElements(stackFrames, last);
                if (toSelect2 != null && !this.myRefresh) {
                    this.setToSelect(toSelect2);
                }
                this.myNextFrameIndex += stackFrames.size();
                this.myAllFramesLoaded = last;
                this.selectCurrentFrame();
                if (last) {
                    if (XFramesView.this.myVisibleRect != null) {
                        XFramesView.this.myFramesList.scrollRectToVisible(XFramesView.this.myVisibleRect);
                    }
                    this.myRunning = false;
                    XFramesView.this.myListenersEnabled = true;
                }
            });
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                StackFramesListBuilder.$$$reportNull$$$0(2);
            }
            if (this.isObsolete()) {
                return;
            }
            EdtExecutorService.getInstance().execute(() -> {
                if (this.isObsolete()) {
                    return;
                }
                if (this.myErrorMessage == null) {
                    this.myErrorMessage = errorMessage;
                    this.addFrameListElements(Collections.singletonList(errorMessage), true);
                    this.myRunning = false;
                    XFramesView.this.myListenersEnabled = true;
                }
            });
        }

        private void addFrameListElements(List<?> values2, boolean last) {
            if (this.myExecutionStack != null && this.myExecutionStack == XFramesView.this.mySelectedStack) {
                boolean loadingPresent;
                CollectionListModel model = XFramesView.this.myFramesList.getModel();
                int insertIndex = model.getSize();
                boolean bl = loadingPresent = insertIndex > 0 && model.getElementAt(insertIndex - 1) == null;
                if (loadingPresent) {
                    --insertIndex;
                }
                model.addAll(insertIndex, values2);
                if (last) {
                    if (loadingPresent) {
                        model.remove(model.getSize() - 1);
                    }
                } else if (!loadingPresent) {
                    model.add(null);
                }
                XFramesView.this.myFramesList.repaint();
            }
        }

        public boolean isObsolete() {
            return !this.myRunning;
        }

        public void dispose() {
            this.myRunning = false;
            this.myExecutionStack = null;
        }

        public boolean start() {
            if (this.myExecutionStack == null || this.myErrorMessage != null) {
                return false;
            }
            this.myRunning = true;
            this.myExecutionStack.computeStackFrames(this.myNextFrameIndex, (XExecutionStack.XStackFrameContainer)this);
            return true;
        }

        public void stop() {
            this.myRunning = false;
        }

        private boolean selectCurrentFrame() {
            if (this.myToSelect instanceof XStackFrame) {
                if (!Objects.equals(XFramesView.this.myFramesList.getSelectedValue(), this.myToSelect) && XFramesView.this.myFramesList.getModel().contains(this.myToSelect)) {
                    XFramesView.this.myFramesList.setSelectedValue(this.myToSelect, true);
                    XFramesView.this.processFrameSelection(this.mySession, false);
                    XFramesView.this.myListenersEnabled = true;
                    return true;
                }
                if (this.myAllFramesLoaded && XFramesView.this.myFramesList.getSelectedValue() == null) {
                    LOG.error("Frame was not found, " + this.myToSelect.getClass() + " must correctly override equals");
                }
            } else if (this.myToSelect instanceof Integer) {
                int selectedFrameIndex = (Integer)this.myToSelect;
                if (XFramesView.this.myFramesList.getSelectedIndex() != selectedFrameIndex && XFramesView.this.myFramesList.getElementCount() > selectedFrameIndex && XFramesView.this.myFramesList.getModel().getElementAt(selectedFrameIndex) != null) {
                    XFramesView.this.myFramesList.setSelectedIndex(selectedFrameIndex);
                    XFramesView.this.processFrameSelection(this.mySession, false);
                    XFramesView.this.myListenersEnabled = true;
                    return true;
                }
            }
            return false;
        }

        public boolean initModel(CollectionListModel model) {
            model.replaceAll(this.myStackFrames);
            if (this.myErrorMessage != null) {
                model.add((Object)this.myErrorMessage);
            } else if (!this.myAllFramesLoaded) {
                model.add(null);
            }
            return this.selectCurrentFrame();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stackFrames";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/frame/XFramesView$StackFramesListBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addStackFrames";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ThreadsBuilder
    implements XSuspendContext.XExecutionStackContainer {
        private volatile boolean myObsolete;
        private boolean myAddBeforeSelection = true;

        ThreadsBuilder() {
            XFramesView.this.myThreadComboBox.addItem(null);
        }

        public void addExecutionStack(@NotNull List<? extends XExecutionStack> executionStacks, boolean last) {
            if (executionStacks == null) {
                ThreadsBuilder.$$$reportNull$$$0(0);
            }
            ArrayList<? extends XExecutionStack> copyStacks = new ArrayList<XExecutionStack>(executionStacks);
            ApplicationManager.getApplication().invokeLater(() -> {
                ComboPopup popup2;
                int initialCount = XFramesView.this.myThreadComboBox.getItemCount();
                if (last) {
                    this.removeLoading();
                    XFramesView.this.myThreadsCalculated = true;
                }
                this.myAddBeforeSelection = XFramesView.this.addExecutionStacks(copyStacks, this.myAddBeforeSelection);
                int newCount = XFramesView.this.myThreadComboBox.getItemCount();
                int maxComboboxRows = XFramesView.this.myThreadComboBox.getMaximumRowCount();
                if (newCount != initialCount && (initialCount < maxComboboxRows || newCount < maxComboboxRows) && (popup2 = XFramesView.this.myThreadComboBox.getPopup()) != null && popup2.isVisible()) {
                    popup2.hide();
                    popup2.show();
                }
            });
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                ThreadsBuilder.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().invokeLater(this::removeLoading);
        }

        public boolean isObsolete() {
            return this.myObsolete;
        }

        public void setObsolete() {
            if (!this.myObsolete) {
                this.myObsolete = true;
                this.removeLoading();
            }
        }

        void removeLoading() {
            XFramesView.this.myThreadComboBox.removeItem(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executionStacks";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/frame/XFramesView$ThreadsBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addExecutionStack";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFocusPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyFocusPolicy() {
        }

        @Override
        @NotNull
        protected List<Component> getOrderedComponents() {
            List<Component> list2 = Arrays.asList(new Component[]{XFramesView.this.myFramesList, XFramesView.this.myThreadComboBox});
            if (list2 == null) {
                MyFocusPolicy.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/frame/XFramesView$MyFocusPolicy", "getOrderedComponents"));
        }
    }
}

