/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.execution.configurations.RemoteRunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.pinned.items.XDebuggerPinToTopManager;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRenderer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeSpeedSearch;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueGroupNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerTree
extends DnDAwareTree
implements DataProvider,
Disposable {
    private final ComponentListener myMoveListener;
    public static final DataKey<XDebuggerTree> XDEBUGGER_TREE_KEY = DataKey.create((String)"xdebugger.tree");
    private final SingleAlarm myAlarm;
    private static final Convertor<TreePath, String> SPEED_SEARCH_CONVERTER = o -> {
        Object node;
        String text2 = null;
        if (o != null && (node = o.getLastPathComponent()) instanceof XDebuggerTreeNode) {
            text2 = ((XDebuggerTreeNode)node).getText().toString();
        }
        return StringUtil.notNullize(text2);
    };
    private static final TransferHandler DEFAULT_TRANSFER_HANDLER = new TransferHandler(){

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (!(c instanceof XDebuggerTree)) {
                return null;
            }
            XDebuggerTree tree = (XDebuggerTree)((Object)c);
            TreePath[] selectedPaths = tree.getSelectionPaths();
            if (selectedPaths == null || selectedPaths.length == 0) {
                return null;
            }
            StringBuilder plainBuf = new StringBuilder();
            StringBuilder htmlBuf = new StringBuilder();
            htmlBuf.append("<html>\n<body>\n<ul>\n");
            TextTransferable.ColoredStringBuilder coloredTextContainer = new TextTransferable.ColoredStringBuilder();
            for (TreePath path : selectedPaths) {
                htmlBuf.append("  <li>");
                Object node = path.getLastPathComponent();
                if (node != null) {
                    if (node instanceof XDebuggerTreeNode) {
                        ((XDebuggerTreeNode)node).appendToComponent(coloredTextContainer);
                        coloredTextContainer.appendTo(plainBuf, htmlBuf);
                    } else {
                        String text2 = node.toString();
                        plainBuf.append(text2);
                        htmlBuf.append(text2);
                    }
                }
                plainBuf.append('\n');
                htmlBuf.append("</li>\n");
            }
            plainBuf.setLength(plainBuf.length() - 1);
            htmlBuf.append("</ul>\n</body>\n</html>");
            return new TextTransferable(htmlBuf, plainBuf);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    };
    private final DefaultTreeModel myTreeModel;
    private final Project myProject;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private XSourcePosition mySourcePosition;
    private final List<XDebuggerTreeListener> myListeners;
    private final XValueMarkers<?, ?> myValueMarkers;
    private final TreeExpansionListener myTreeExpansionListener;
    private final XDebuggerPinToTopManager myPinToTopManager;

    public XDebuggerTree(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSourcePosition sourcePosition, final @NotNull String popupActionGroupId, @Nullable XValueMarkers<?, ?> valueMarkers) {
        if (project == null) {
            XDebuggerTree.$$$reportNull$$$0(0);
        }
        if (editorsProvider == null) {
            XDebuggerTree.$$$reportNull$$$0(1);
        }
        if (popupActionGroupId == null) {
            XDebuggerTree.$$$reportNull$$$0(2);
        }
        super(new DefaultTreeModel(null));
        this.myMoveListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                XDebuggerTree.this.repaint();
            }
        };
        this.myAlarm = new SingleAlarm(new Runnable(){

            @Override
            public void run() {
                DebuggerUIUtil.repaintCurrentEditor(XDebuggerTree.this.myProject);
            }
        }, 100, this);
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myValueMarkers = valueMarkers;
        this.myProject = project;
        this.myEditorsProvider = editorsProvider;
        this.mySourcePosition = sourcePosition;
        this.myTreeModel = (DefaultTreeModel)this.getModel();
        this.myPinToTopManager = XDebuggerPinToTopManager.Companion.getInstance(project);
        this.setCellRenderer((TreeCellRenderer)((Object)new XDebuggerTreeRenderer()));
        new TreeLinkMouseListener(new XDebuggerTreeRenderer()){

            @Override
            protected boolean doCacheLastNode() {
                return false;
            }

            protected void handleTagClick(@Nullable Object tag2, @NotNull MouseEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (tag2 instanceof XDebuggerTreeNodeHyperlink) {
                    ((XDebuggerTreeNodeHyperlink)tag2).onClick(event);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                if (!XDebuggerTree.this.myPinToTopManager.isEnabled()) {
                    return;
                }
                TreePath pathForLocation = XDebuggerTree.this.getPathForLocation(e.getX(), e.getY());
                if (pathForLocation == null) {
                    XDebuggerTree.this.myPinToTopManager.onNodeHovered(null, XDebuggerTree.this);
                    return;
                }
                Object lastPathComponent = pathForLocation.getLastPathComponent();
                XDebuggerTree.this.myPinToTopManager.onNodeHovered(lastPathComponent instanceof XDebuggerTreeNode ? (XDebuggerTreeNode)lastPathComponent : null, XDebuggerTree.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$4", "handleTagClick"));
            }
        }.installOn((Component)((Object)this));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                return XDebuggerTree.this.expandIfEllipsis();
            }
        }.installOn((Component)((Object)this));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10 || key == 32 || key == 39) {
                    XDebuggerTree.this.expandIfEllipsis();
                }
            }
        });
        if (Registry.is((String)"debugger.variablesView.rss")) {
            new XDebuggerTreeSpeedSearch(this, SPEED_SEARCH_CONVERTER);
        } else {
            new TreeSpeedSearch(this, SPEED_SEARCH_CONVERTER);
        }
        final ActionManager actionManager = ActionManager.getInstance();
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup group = (ActionGroup)actionManager.getAction(popupActionGroupId);
                actionManager.createActionPopupMenu("unknown", group).getComponent().show(comp, x, y);
            }
        });
        this.registerShortcuts();
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                TreePath[] paths;
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                if ((paths = XDebuggerTree.this.getSelectionPaths()) != null) {
                    for (TreePath path : paths) {
                        XDebuggerTreeNodeHyperlink link;
                        Object component2 = path.getLastPathComponent();
                        if (!(component2 instanceof XDebuggerTreeNode) || (link = ((XDebuggerTreeNode)component2).getLink()) == null) continue;
                        link.onClick(new MouseEvent((Component)((Object)XDebuggerTree.this), 0, 0L, 0, 0, 0, 1, false));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$8", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)((Object)this), (Disposable)this);
        this.setTransferHandler(DEFAULT_TRANSFER_HANDLER);
        this.addComponentListener(this.myMoveListener);
        this.myTreeExpansionListener = new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                this.handleExpansion(event, true);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                this.handleExpansion(event, false);
            }

            private void handleExpansion(TreeExpansionEvent event, boolean expanded) {
                Object component2;
                TreePath path = event.getPath();
                Object object = component2 = path != null ? path.getLastPathComponent() : null;
                if (component2 instanceof XValueGroupNodeImpl) {
                    ((XValueGroupNodeImpl)component2).onExpansion(expanded);
                }
            }
        };
        this.addTreeExpansionListener(this.myTreeExpansionListener);
    }

    public void updateEditor() {
        this.myAlarm.cancelAndRequest();
    }

    public boolean isUnderRemoteDebug() {
        DataContext context = DataManager.getInstance().getDataContext((Component)((Object)this));
        ExecutionEnvironment env = (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(context);
        return env != null && env.getRunProfile() instanceof RemoteRunProfile;
    }

    private boolean expandIfEllipsis() {
        TreeNode parent;
        MessageTreeNode node;
        MessageTreeNode[] treeNodes = (MessageTreeNode[])this.getSelectedNodes(MessageTreeNode.class, null);
        if (treeNodes.length == 1 && (node = treeNodes[0]).isEllipsis() && (parent = node.getParent()) instanceof XValueContainerNode) {
            this.selectNodeOnLoad((Condition<? super TreeNode>)((Condition)n -> n.getParent() == parent), (Condition<? super TreeNode>)((Condition)n -> ((XValueContainerNode)parent).isObsolete()));
            ((XValueContainerNode)parent).startComputingChildren();
            return true;
        }
        return false;
    }

    public void addTreeListener(@NotNull XDebuggerTreeListener listener2) {
        if (listener2 == null) {
            XDebuggerTree.$$$reportNull$$$0(3);
        }
        this.myListeners.add(listener2);
    }

    public void removeTreeListener(@NotNull XDebuggerTreeListener listener2) {
        if (listener2 == null) {
            XDebuggerTree.$$$reportNull$$$0(4);
        }
        this.myListeners.remove(listener2);
    }

    public void setRoot(XDebuggerTreeNode root, boolean rootVisible) {
        this.setRootVisible(rootVisible);
        this.myTreeModel.setRoot(root);
    }

    public XDebuggerTreeNode getRoot() {
        return (XDebuggerTreeNode)this.myTreeModel.getRoot();
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    public void setSourcePosition(@Nullable XSourcePosition sourcePosition) {
        this.mySourcePosition = sourcePosition;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        XDebuggerEditorsProvider xDebuggerEditorsProvider = this.myEditorsProvider;
        if (xDebuggerEditorsProvider == null) {
            XDebuggerTree.$$$reportNull$$$0(5);
        }
        return xDebuggerEditorsProvider;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            XDebuggerTree.$$$reportNull$$$0(6);
        }
        return project;
    }

    @Nullable
    public XValueMarkers<?, ?> getValueMarkers() {
        return this.myValueMarkers;
    }

    @NotNull
    public XDebuggerPinToTopManager getPinToTopManager() {
        XDebuggerPinToTopManager xDebuggerPinToTopManager = this.myPinToTopManager;
        if (xDebuggerPinToTopManager == null) {
            XDebuggerTree.$$$reportNull$$$0(7);
        }
        return xDebuggerPinToTopManager;
    }

    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        XValueNodeImpl[] selectedNodes;
        if (dataId == null) {
            XDebuggerTree.$$$reportNull$$$0(8);
        }
        if (XDEBUGGER_TREE_KEY.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId) && (selectedNodes = (XValueNodeImpl[])this.getSelectedNodes(XValueNodeImpl.class, null)).length == 1 && selectedNodes[0].getFullValueEvaluator() == null) {
            return DebuggerUIUtil.getNodeRawValue(selectedNodes[0]);
        }
        return null;
    }

    public void rebuildAndRestore(XDebuggerTreeState treeState) {
        Object rootNode = this.myTreeModel.getRoot();
        if (rootNode instanceof XDebuggerTreeNode) {
            ((XDebuggerTreeNode)rootNode).clearChildren();
            if (this.isRootVisible() && rootNode instanceof XValueNodeImpl) {
                ((XValue)((XValueNodeImpl)rootNode).getValueContainer()).computePresentation((XValueNode)rootNode, XValuePlace.TREE);
            }
            treeState.restoreState(this);
            this.repaint();
        }
    }

    public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<? extends XValueContainerNode<?>> children2, boolean last) {
        if (node == null) {
            XDebuggerTree.$$$reportNull$$$0(9);
        }
        if (children2 == null) {
            XDebuggerTree.$$$reportNull$$$0(10);
        }
        for (XDebuggerTreeListener listener2 : this.myListeners) {
            listener2.childrenLoaded(node, children2, last);
        }
    }

    public void nodeLoaded(@NotNull RestorableStateNode node, @NotNull String name) {
        if (node == null) {
            XDebuggerTree.$$$reportNull$$$0(11);
        }
        if (name == null) {
            XDebuggerTree.$$$reportNull$$$0(12);
        }
        for (XDebuggerTreeListener listener2 : this.myListeners) {
            listener2.nodeLoaded(node, name);
        }
    }

    public void markNodesObsolete() {
        Object root = this.myTreeModel.getRoot();
        if (root instanceof XValueContainerNode) {
            XDebuggerTree.markNodesObsolete((XValueContainerNode)root);
        }
    }

    public void dispose() {
        this.setModel(null);
        this.myTreeModel.setRoot(null);
        this.setCellRenderer(null);
        UIUtil.dispose((Component)((Object)this));
        this.setLeadSelectionPath(null);
        this.setAnchorSelectionPath(null);
        this.accessibleContext = null;
        this.removeComponentListener(this.myMoveListener);
        this.removeTreeExpansionListener(this.myTreeExpansionListener);
        this.myListeners.clear();
    }

    private void registerShortcuts() {
        DebuggerUIUtil.registerActionOnComponent("XDebugger.SetValue", (JComponent)((Object)this), this);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.CopyValue", (JComponent)((Object)this), this);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.JumpToSource", (JComponent)((Object)this), this);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.JumpToTypeSource", (JComponent)((Object)this), this);
        DebuggerUIUtil.registerActionOnComponent("Debugger.MarkObject", (JComponent)((Object)this), this);
    }

    private static void markNodesObsolete(XValueContainerNode<?> node) {
        node.setObsolete();
        node.getLoadedChildren().forEach(XDebuggerTree::markNodesObsolete);
    }

    @Nullable
    public static XDebuggerTree getTree(AnActionEvent e) {
        return (XDebuggerTree)((Object)e.getData(XDEBUGGER_TREE_KEY));
    }

    @Nullable
    public static XDebuggerTree getTree(DataContext context) {
        return (XDebuggerTree)((Object)XDEBUGGER_TREE_KEY.getData(context));
    }

    public void invokeLater(Runnable runnable2) {
        EdtExecutorService.getInstance().execute(runnable2);
    }

    public void selectNodeOnLoad(final Condition<? super TreeNode> nodeFilter, final Condition<? super TreeNode> obsoleteChecker) {
        this.addTreeListener(new XDebuggerTreeListener(){

            @Override
            public void nodeLoaded(@NotNull RestorableStateNode node, @NotNull String name) {
                if (node == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (name == null) {
                    10.$$$reportNull$$$0(1);
                }
                if (obsoleteChecker.value((Object)node)) {
                    XDebuggerTree.this.removeTreeListener(this);
                }
                if (nodeFilter.value((Object)node)) {
                    XDebuggerTree.this.setSelectionPath(node.getPath());
                    XDebuggerTree.this.removeTreeListener(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$10";
                objectArray[2] = "nodeLoaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void expandNodesOnLoad(final Condition<? super TreeNode> nodeFilter) {
        this.addTreeListener(new XDebuggerTreeListener(){

            @Override
            public void nodeLoaded(@NotNull RestorableStateNode node, @NotNull String name) {
                if (node == null) {
                    11.$$$reportNull$$$0(0);
                }
                if (name == null) {
                    11.$$$reportNull$$$0(1);
                }
                if (nodeFilter.value((Object)node) && !node.isLeaf()) {
                    node.getChildCount();
                }
            }

            @Override
            public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<? extends XValueContainerNode<?>> children2, boolean last) {
                if (node == null) {
                    11.$$$reportNull$$$0(2);
                }
                if (children2 == null) {
                    11.$$$reportNull$$$0(3);
                }
                if (nodeFilter.value((Object)node)) {
                    XDebuggerTree.this.expandPath(node.getPath());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "children";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$11";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "nodeLoaded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenLoaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public boolean isDetached() {
        return DataManager.getInstance().getDataContext((Component)((Object)this)).getData(XDebugSessionTab.TAB_KEY) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActionGroupId";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPinToTopManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTreeListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeTreeListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "childrenLoaded";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "nodeLoaded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

