/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.stream.JsonWriter;
import com.intellij.ide.plugins.PluginRepositoryRequests;
import com.intellij.ide.plugins.PluginsMetaLoader;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppIcon;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.StringKt;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.InstallPluginService;
import org.jetbrains.ide.RestService;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0014J\"\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/ide/InstallPluginService;", "Lorg/jetbrains/ide/RestService;", "()V", "isAvailable", "", "()Z", "setAvailable", "(Z)V", "checkCompatibility", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "pluginId", "", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "getServiceName", "installPlugin", "isAccessible", "Lio/netty/handler/codec/http/HttpRequest;", "isHostTrusted", "productInfo", "writeIDEInfo", "", "out", "Ljava/io/OutputStream;", "intellij.platform.builtInServer.impl"})
public final class InstallPluginService
extends RestService {
    private boolean isAvailable = true;

    @Override
    @NotNull
    protected String getServiceName() {
        return "installPlugin";
    }

    public boolean isAccessible(@NotNull HttpRequest request2) {
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        return true;
    }

    public final boolean isAvailable() {
        return this.isAvailable;
    }

    public final void setAvailable(boolean bl) {
        this.isAvailable = bl;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        block6: {
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                pluginId = RestService.Companion.getStringParameter("pluginId", urlDecoder);
                action = RestService.Companion.getStringParameter("action", urlDecoder);
                var6_6 = pluginId;
                var7_7 = false;
                var8_8 = false;
                if (var6_6 == null || StringsKt.isBlank((CharSequence)var6_6) != false) {
                    return (String)this.productInfo(request, context);
                }
                v0 = action;
                if (v0 == null) break block5;
                var6_6 = v0;
                switch (var6_6.hashCode()) {
                    case 1957569947: {
                        if (!var6_6.equals("install")) ** break;
                        break;
                    }
                    case -1762427576: {
                        if (!var6_6.equals("checkCompatibility")) ** break;
                        v1 = (String)this.checkCompatibility(request, context, pluginId);
                        break block6;
                    }
                }
                v1 = (String)this.installPlugin(request, context, pluginId);
                break block6;
            }
            v1 = (String)this.productInfo(request, context);
        }
        return v1;
    }

    private final Void checkCompatibility(FullHttpRequest request2, ChannelHandlerContext context, String pluginId) {
        String buildNumber = PluginRepositoryRequests.getBuildForPluginRepositoryRequests();
        PluginsMetaLoader.INSTANCE.getLastCompatiblePluginUpdate(CollectionsKt.listOf((Object)pluginId), BuildNumber.fromString((String)buildNumber));
        Collection collection = PluginsMetaLoader.INSTANCE.getLastCompatiblePluginUpdate(CollectionsKt.listOf((Object)pluginId), BuildNumber.fromString((String)buildNumber));
        boolean bl = false;
        boolean compatibleUpdateExists = !collection.isEmpty();
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        JsonWriter writer = RestService.Companion.createJsonWriter((OutputStream)out);
        writer.beginObject();
        writer.name("compatible").value(compatibleUpdateExists);
        writer.endObject();
        writer.close();
        RestService.Companion.send(out, (HttpRequest)request2, context);
        return null;
    }

    private final Void installPlugin(FullHttpRequest request2, ChannelHandlerContext context, String pluginId) {
        if (this.isAvailable) {
            this.isAvailable = false;
            Project project = RestService.Companion.getLastFocusedOrOpenedProject();
            if (project == null) {
                ProjectManager projectManager = ProjectManager.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
                Project project2 = projectManager.getDefaultProject();
                project = project2;
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"ProjectManager.getInstance().defaultProject");
            }
            Project effectiveProject = project;
            PluginId pluginId2 = PluginId.findId((String[])new String[]{pluginId});
            if (pluginId2 != null) {
                PluginId pluginId3 = pluginId2;
                boolean bl = false;
                boolean bl2 = false;
                PluginId it = pluginId3;
                boolean bl3 = false;
                ApplicationManager.getApplication().invokeLater(new Runnable(it, this, effectiveProject){
                    final /* synthetic */ PluginId $it;
                    final /* synthetic */ InstallPluginService this$0;
                    final /* synthetic */ Project $effectiveProject$inlined;
                    {
                        this.$it = pluginId;
                        this.this$0 = installPluginService;
                        this.$effectiveProject$inlined = project;
                    }

                    public final void run() {
                        AppIcon.getInstance().requestAttention(this.$effectiveProject$inlined, true);
                        PluginsAdvertiser.installAndEnable(SetsKt.setOf((Object)this.$it), installPlugin.1.1.INSTANCE);
                        this.this$0.setAvailable(true);
                    }
                }, effectiveProject.getDisposed());
            }
        }
        RestService.Companion.sendOk(request2, context);
        return null;
    }

    private final Void productInfo(FullHttpRequest request2, ChannelHandlerContext context) {
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        this.writeIDEInfo((OutputStream)out);
        RestService.Companion.send(out, (HttpRequest)request2, context);
        return null;
    }

    private final void writeIDEInfo(OutputStream out) {
        JsonWriter writer = RestService.Companion.createJsonWriter(out);
        writer.beginObject();
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)applicationInfoEx), (String)"ApplicationInfoEx.getInstanceEx()");
        String appName = applicationInfoEx.getFullApplicationName();
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        BuildNumber build2 = buildNumber;
        if (!PlatformUtils.isIdeaUltimate()) {
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
            String productName = applicationNamesInfo.getProductName();
            String string = appName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"appName");
            String string2 = productName + " (" + productName + ')';
            String string3 = productName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"productName");
            appName = StringsKt.replace$default((String)string, (String)string2, (String)string3, (boolean)false, (int)4, null);
            appName = StringUtil.trimStart((String)appName, (String)"JetBrains ");
        }
        writer.name("name").value(appName);
        writer.name("buildNumber").value(build2.asString());
        writer.endObject();
        writer.close();
    }

    @Override
    protected boolean isHostTrusted(@NotNull FullHttpRequest request2, @NotNull QueryStringDecoder urlDecoder) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
        String origin = NettyKt.getOrigin((HttpRequest)((HttpRequest)request2));
        try {
            string = origin == null ? null : StringKt.nullize$default((String)new URI(origin).getHost(), (boolean)false, (int)1, null);
        }
        catch (URISyntaxException ignored) {
            return false;
        }
        String originHost = string;
        return originHost != null && (CollectionsKt.listOf((Object[])new String[]{"plugins.jetbrains.com", "package-search.services.jetbrains.com", "package-search.jetbrains.com"}).contains(originHost) || StringsKt.endsWith$default((String)originHost, (String)".dev.marketplace.intellij.net", (boolean)false, (int)2, null) || NetUtils.isLocalhost((String)originHost)) || super.isHostTrusted(request2, urlDecoder);
    }
}

