/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.events.impl.DerivedResultImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.ArtifactSyncListener;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole$WhenMappings;
import org.jetbrains.idea.maven.buildtool.quickfix.OffMavenOfflineModeQuickFix;
import org.jetbrains.idea.maven.buildtool.quickfix.OpenMavenSettingsQuickFix;
import org.jetbrains.idea.maven.buildtool.quickfix.UseBundledMavenQuickFix;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001EB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\tJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0007J\u001a\u0010\u001b\u001a\u00020\u00172\b\b\u0001\u0010\u0019\u001a\u00020\u00072\b\b\u0001\u0010\u001c\u001a\u00020\u0007J \u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u001c\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00072\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0002J\b\u0010'\u001a\u00020\u0017H\u0002J\u0017\u0010(\u001a\u00020\u00172\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170*H\u0082\bJ\u0018\u0010+\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0007H\u0002J*\u0010-\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00072\b\u0010/\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u00100\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0007H\u0002J\u0006\u00101\u001a\u00020\u0017J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\u0010\u00106\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0007H\u0002J\u000e\u00107\u001a\u00020\u00172\u0006\u00108\u001a\u000209J\u0018\u0010:\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0007H\u0002J\u0016\u0010;\u001a\u00020\u00172\u0006\u0010<\u001a\u00020\u00072\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\u0014J\u0018\u0010A\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u000e\u0010B\u001a\u00020\u00172\u0006\u0010C\u001a\u00020DR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\f\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u000e0\rj\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u000e`\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "JAVADOC_AND_SOURCE_CLASSIFIERS", "", "", "finished", "", "hasErrors", "hasUnresolved", "myStartedSet", "Ljava/util/LinkedHashSet;", "Lkotlin/Pair;", "Lkotlin/collections/LinkedHashSet;", "mySyncId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "Lorg/jetbrains/annotations/NotNull;", "mySyncView", "Lcom/intellij/build/BuildProgressListener;", "started", "addText", "", "parentId", "text", "stdout", "addWarning", "description", "completeTask", "taskName", "result", "Lcom/intellij/build/events/EventResult;", "completeUmbrellaEvents", "keyPrefix", "debugLog", "s", "exception", "", "doFinish", "doIfImportInProcess", "action", "Lkotlin/Function0;", "downloadEventCompleted", "dependency", "downloadEventFailed", "error", "stackTrace", "downloadEventStarted", "finishImport", "getListener", "Lorg/jetbrains/idea/maven/buildtool/ArtifactSyncListener;", "type", "Lorg/jetbrains/idea/maven/server/MavenServerProgressIndicator$ResolveType;", "isJavadocOrSource", "notifyReadingProblems", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "showError", "showQuickFixBadMaven", "message", "kind", "Lcom/intellij/build/events/MessageEvent$Kind;", "startImport", "syncView", "startTask", "terminated", "exitCode", "", "ArtifactSyncListenerImpl", "intellij.maven"})
public final class MavenSyncConsole {
    private volatile BuildProgressListener mySyncView;
    private ExternalSystemTaskId mySyncId;
    private boolean finished;
    private boolean started;
    private boolean hasErrors;
    private boolean hasUnresolved;
    private final Set<String> JAVADOC_AND_SOURCE_CLASSIFIERS;
    private LinkedHashSet<Pair<Object, String>> myStartedSet;
    private final Project myProject;

    public final synchronized void startImport(@NotNull BuildProgressListener syncView) {
        Intrinsics.checkParameterIsNotNull((Object)syncView, (String)"syncView");
        if (this.started) {
            return;
        }
        AnAction restartAction2 = new AnAction(this){
            final /* synthetic */ MavenSyncConsole this$0;

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Presentation presentation = e.getPresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(!MavenSyncConsole.access$getStarted$p(this.this$0) || MavenSyncConsole.access$getFinished$p(this.this$0));
                Presentation presentation2 = e.getPresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
                presentation2.setIcon(AllIcons.Actions.Refresh);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    Project project = e.getProject();
                    if (project == null) break block0;
                    Project project2 = project;
                    boolean bl = false;
                    boolean bl2 = false;
                    Project it = project2;
                    boolean bl3 = false;
                    MavenProjectsManager.getInstance(it).forceUpdateAllProjectsOrFindAllAvailablePomFiles();
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.started = true;
        this.finished = false;
        this.hasErrors = false;
        this.hasUnresolved = false;
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)MavenUtil.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)externalSystemTaskId, (String)"ExternalSystemTaskId.cre\u2026SOLVE_PROJECT, myProject)");
        this.mySyncId = externalSystemTaskId;
        String string = this.myProject.getBasePath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        DefaultBuildDescriptor descriptor2 = new DefaultBuildDescriptor((Object)this.mySyncId, "Sync", string, System.currentTimeMillis());
        this.mySyncView = syncView;
        BuildContentDescriptor runDescr2 = new BuildContentDescriptor(null, null, new JComponent(){}, "Sync");
        runDescr2.setActivateToolWindowWhenFailed(true);
        runDescr2.setActivateToolWindowWhenAdded(false);
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new StartBuildEventImpl((BuildDescriptor)descriptor2, "Sync " + this.myProject.getName()).withContentDescriptorSupplier((Supplier)new Supplier<RunContentDescriptor>(runDescr2){
            final /* synthetic */ BuildContentDescriptor $runDescr;

            @NotNull
            public final BuildContentDescriptor get() {
                return this.$runDescr;
            }
            {
                this.$runDescr = buildContentDescriptor;
            }
        }).withRestartAction(restartAction2));
        MavenSyncConsole.debugLog$default(this, "maven sync: started importing " + this.myProject, null, 2, null);
    }

    public final synchronized void addText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.addText(this.mySyncId, text, true);
        }
    }

    public final synchronized void addText(@NotNull Object parentId, @NotNull String text, boolean stdout) {
        Intrinsics.checkParameterIsNotNull((Object)parentId, (String)"parentId");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            if (StringUtil.isEmpty((String)text)) {
                return;
            }
            String toPrint = StringsKt.endsWith$default((CharSequence)text, (char)'\n', (boolean)false, (int)2, null) ? text : text + '\n';
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new OutputBuildEventImpl(parentId, toPrint, stdout));
        }
    }

    public final synchronized void addWarning(@Nls @NotNull String text, @Nls @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new MessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.WARNING, "Compiler", text, description));
        }
    }

    public final synchronized void finishImport() {
        MavenSyncConsole.debugLog$default(this, "Maven sync: finishImport", null, 2, null);
        this.doFinish();
    }

    public final synchronized void terminated(int exitCode) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            List tasks = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)this.myStartedSet));
            MavenSyncConsole.debugLog$default(this, "Tasks " + tasks + " are not completed! Force complete", null, 2, null);
            Iterable $this$forEach$iv = tasks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl2 = false;
                this.completeTask(it.getFirst(), (String)it.getSecond(), (EventResult)new FailureResultImpl("Terminated with exit code = " + exitCode));
            }
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishBuildEventImpl((Object)this.mySyncId, null, System.currentTimeMillis(), "", (EventResult)new FailureResultImpl("Terminated with exit code = " + exitCode)));
            this.finished = true;
            this.started = false;
        }
    }

    public final synchronized void notifyReadingProblems(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            MavenSyncConsole.debugLog$default(this, "reading problems in " + file, null, 2, null);
            this.hasErrors = true;
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FileMessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.ERROR, "Error", "Error reading " + file.getPath(), "Error reading " + file.getPath(), new FilePosition(new File(file.getPath()), -1, -1)));
        }
    }

    @NotNull
    public final ArtifactSyncListener getListener(@NotNull MavenServerProgressIndicator.ResolveType type) {
        ArtifactSyncListener artifactSyncListener;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        switch (MavenSyncConsole$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                artifactSyncListener = new ArtifactSyncListenerImpl("maven.sync.plugins");
                break;
            }
            case 2: {
                artifactSyncListener = new ArtifactSyncListenerImpl("maven.sync.dependencies");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return artifactSyncListener;
    }

    private final synchronized void doFinish() {
        List tasks = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)this.myStartedSet));
        MavenSyncConsole.debugLog$default(this, "Tasks " + tasks + " are not completed! Force complete", null, 2, null);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.completeTask(it.getFirst(), (String)it.getSecond(), (EventResult)new DerivedResultImpl());
        }
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishBuildEventImpl((Object)this.mySyncId, null, System.currentTimeMillis(), "", this.hasErrors ? (EventResult)new FailureResultImpl() : (EventResult)new DerivedResultImpl()));
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent = MavenWorkspaceSettingsComponent.getInstance(this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenWorkspaceSettingsComponent, (String)"MavenWorkspaceSettingsCo\u2026nt.getInstance(myProject)");
        MavenGeneralSettings generalSettings = mavenWorkspaceSettingsComponent.getSettings().generalSettings;
        if (this.hasUnresolved) {
            MavenGeneralSettings mavenGeneralSettings = generalSettings;
            Intrinsics.checkExpressionValueIsNotNull((Object)mavenGeneralSettings, (String)"generalSettings");
            if (mavenGeneralSettings.isWorkOffline()) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)this.mySyncId, new BuildIssue(){
                    @NotNull
                    private final String title = "Dependency Resolution Failed";
                    @NotNull
                    private final String description = "<a href=\"off_maven_offline_mode_quick_fix\">Switch Off Offline Mode</a>\n";
                    @NotNull
                    private final List<BuildIssueQuickFix> quickFixes;

                    @NotNull
                    public String getTitle() {
                        return this.title;
                    }

                    @NotNull
                    public String getDescription() {
                        return this.description;
                    }

                    @NotNull
                    public List<BuildIssueQuickFix> getQuickFixes() {
                        return this.quickFixes;
                    }

                    @Nullable
                    public Navigatable getNavigatable(@NotNull Project project) {
                        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                        return null;
                    }
                    {
                        this.title = "Dependency Resolution Failed";
                        this.description = "<a href=\"off_maven_offline_mode_quick_fix\">Switch Off Offline Mode</a>\n";
                        this.quickFixes = CollectionsKt.listOf((Object)new OffMavenOfflineModeQuickFix());
                    }
                }, MessageEvent.Kind.ERROR));
            }
        }
        this.finished = true;
        this.started = false;
    }

    private final synchronized void showError(String keyPrefix, String dependency) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = true;
            this.hasUnresolved = true;
            String umbrellaString = SyncBundle.message(keyPrefix + ".resolve", new Object[0]);
            String errorString = SyncBundle.message(keyPrefix + ".resolve.error", dependency);
            String string = umbrellaString;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"umbrellaString");
            this.startTask(this.mySyncId, string);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new MessageEventImpl((Object)umbrellaString, MessageEvent.Kind.ERROR, "Error", errorString, errorString));
            String string2 = errorString;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"errorString");
            this.addText(this.mySyncId, string2, false);
        }
    }

    private final synchronized void startTask(Object parentId, String taskName) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            MavenSyncConsole.debugLog$default(this, "Maven sync: start " + taskName, null, 2, null);
            if (this.myStartedSet.add((Pair<Object, String>)TuplesKt.to((Object)parentId, (Object)taskName))) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new StartEventImpl((Object)taskName, parentId, System.currentTimeMillis(), taskName));
            }
        }
    }

    private final synchronized void completeTask(Object parentId, String taskName, EventResult result) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = this.hasErrors || result instanceof FailureResultImpl;
            MavenSyncConsole.debugLog$default(this, "Maven sync: complete " + taskName + " with " + result, null, 2, null);
            if (this.myStartedSet.remove(TuplesKt.to((Object)parentId, (Object)taskName))) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishEventImpl((Object)taskName, parentId, System.currentTimeMillis(), taskName, result));
            }
        }
    }

    private final void debugLog(String s, Throwable exception) {
        MavenLog.LOG.debug(s, exception);
    }

    static /* synthetic */ void debugLog$default(MavenSyncConsole mavenSyncConsole, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        mavenSyncConsole.debugLog(string, throwable);
    }

    private final synchronized void completeUmbrellaEvents(String keyPrefix) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            String taskName;
            boolean bl = false;
            String string = taskName = SyncBundle.message(keyPrefix + ".resolve", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"taskName");
            this.completeTask(this.mySyncId, string, (EventResult)new DerivedResultImpl());
        }
    }

    private final synchronized void downloadEventStarted(String keyPrefix, String dependency) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            String downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", dependency);
            String string = downloadString;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"downloadString");
            this.startTask(this.mySyncId, string);
            String string2 = downloadArtifactString;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"downloadArtifactString");
            this.startTask(downloadString, string2);
        }
    }

    private final synchronized void downloadEventCompleted(String keyPrefix, String dependency) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            String downloadArtifactString;
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            String string = downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", dependency);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"downloadArtifactString");
            this.addText(string, downloadArtifactString, true);
            String string2 = downloadString;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"downloadString");
            this.completeTask(string2, downloadArtifactString, (EventResult)new SuccessResultImpl(false));
        }
    }

    private final synchronized void downloadEventFailed(String keyPrefix, String dependency, String error, String stackTrace) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            String downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", dependency);
            if (this.isJavadocOrSource(dependency)) {
                String string = downloadArtifactString;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"downloadArtifactString");
                this.addText(string, dependency + " not found", true);
                String string2 = downloadString;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"downloadString");
                this.completeTask(string2, downloadArtifactString, (EventResult)new MessageEventResult(this, keyPrefix, dependency, stackTrace, error){
                    final /* synthetic */ MavenSyncConsole this$0;
                    final /* synthetic */ String $keyPrefix$inlined;
                    final /* synthetic */ String $dependency$inlined;
                    final /* synthetic */ String $stackTrace$inlined;
                    final /* synthetic */ String $error$inlined;
                    {
                        this.this$0 = mavenSyncConsole;
                        this.$keyPrefix$inlined = string;
                        this.$dependency$inlined = string2;
                        this.$stackTrace$inlined = string3;
                        this.$error$inlined = string4;
                    }

                    @NotNull
                    public MessageEvent.Kind getKind() {
                        return MessageEvent.Kind.WARNING;
                    }

                    @Nullable
                    public String getDetails() {
                        return this.$dependency$inlined + " not found";
                    }
                });
            } else {
                if (stackTrace != null && Registry.is((String)"maven.spy.events.debug")) {
                    String string = downloadArtifactString;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"downloadArtifactString");
                    this.addText(string, stackTrace, false);
                } else {
                    String string = downloadArtifactString;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"downloadArtifactString");
                    this.addText(string, error, true);
                }
                String string = downloadString;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"downloadString");
                this.completeTask(string, downloadArtifactString, (EventResult)new FailureResultImpl(error));
            }
        }
    }

    public final synchronized void showQuickFixBadMaven(@NotNull String message, @NotNull MessageEvent.Kind kind) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        String bundledVersion = MavenServerManager.getInstance().getMavenVersion("Bundled (Maven 3)");
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)this.mySyncId, new BuildIssue(message, bundledVersion){
            @NotNull
            private final String title = "Maven version issue";
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ String $message;
            final /* synthetic */ String $bundledVersion;

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                return null;
            }
            {
                this.$message = $captured_local_variable$0;
                this.$bundledVersion = $captured_local_variable$1;
                this.title = "Maven version issue";
                this.description = $captured_local_variable$0 + '\n' + "- <a href=\"open_maven_settings_quick_fix\">Open Settings</a>\n" + "- <a href=\"use_bundled_maven_quick_fix\">Use Bundled (" + $captured_local_variable$1 + ")</a>\n";
                this.quickFixes = CollectionsKt.listOf((Object[])new BuildIssueQuickFix[]{new OpenMavenSettingsQuickFix(), new UseBundledMavenQuickFix()});
            }
        }, kind));
    }

    private final boolean isJavadocOrSource(String dependency) {
        List split = StringsKt.split$default((CharSequence)dependency, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null);
        if (split.size() < 4) {
            return false;
        }
        String classifier = (String)split.get(2);
        return this.JAVADOC_AND_SOURCE_CLASSIFIERS.contains(classifier);
    }

    private final void doIfImportInProcess(Function0<Unit> action) {
        int $i$f$doIfImportInProcess = 0;
        if (!this.started || this.finished) {
            return;
        }
        action.invoke();
    }

    public MavenSyncConsole(@NotNull Project myProject) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.mySyncView = mySyncView.1.INSTANCE;
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)MavenUtil.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)externalSystemTaskId, (String)"ExternalSystemTaskId.cre\u2026SOLVE_PROJECT, myProject)");
        this.mySyncId = externalSystemTaskId;
        this.JAVADOC_AND_SOURCE_CLASSIFIERS = SetsKt.setOf((Object[])new String[]{"javadoc", "sources", "test-javadoc", "test-sources"});
        this.myStartedSet = new LinkedHashSet();
    }

    public static final /* synthetic */ void access$setStarted$p(MavenSyncConsole $this, boolean bl) {
        $this.started = bl;
    }

    public static final /* synthetic */ void access$setFinished$p(MavenSyncConsole $this, boolean bl) {
        $this.finished = bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\"\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole$ArtifactSyncListenerImpl;", "Lorg/jetbrains/idea/maven/buildtool/ArtifactSyncListener;", "keyPrefix", "", "(Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;Ljava/lang/String;)V", "getKeyPrefix", "()Ljava/lang/String;", "downloadCompleted", "", "dependency", "downloadFailed", "error", "stackTrace", "downloadStarted", "finish", "showError", "intellij.maven"})
    private final class ArtifactSyncListenerImpl
    implements ArtifactSyncListener {
        @NotNull
        private final String keyPrefix;

        @Override
        public void downloadStarted(@NotNull String dependency) {
            Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
            MavenSyncConsole.this.downloadEventStarted(this.keyPrefix, dependency);
        }

        @Override
        public void downloadCompleted(@NotNull String dependency) {
            Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
            MavenSyncConsole.this.downloadEventCompleted(this.keyPrefix, dependency);
        }

        @Override
        public void downloadFailed(@NotNull String dependency, @NotNull String error, @Nullable String stackTrace) {
            Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            MavenSyncConsole.this.downloadEventFailed(this.keyPrefix, dependency, error, stackTrace);
        }

        @Override
        public void finish() {
            MavenSyncConsole.this.completeUmbrellaEvents(this.keyPrefix);
        }

        @Override
        public void showError(@NotNull String dependency) {
            Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
            MavenSyncConsole.this.showError(this.keyPrefix, dependency);
        }

        @NotNull
        public final String getKeyPrefix() {
            return this.keyPrefix;
        }

        public ArtifactSyncListenerImpl(String keyPrefix) {
            Intrinsics.checkParameterIsNotNull((Object)keyPrefix, (String)"keyPrefix");
            this.keyPrefix = keyPrefix;
        }
    }
}

