/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerPanel;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.project.MavenDisablePanelCheckbox;

public class MavenRunnerSettingsEditor
extends SettingsEditor<MavenRunConfiguration> {
    private final MavenRunnerPanel myPanel;
    private JCheckBox myUseProjectSettings;

    public MavenRunnerSettingsEditor(@NotNull Project project) {
        if (project == null) {
            MavenRunnerSettingsEditor.$$$reportNull$$$0(0);
        }
        this.myPanel = new MavenRunnerPanel(project, true);
    }

    protected void resetEditorFrom(@NotNull MavenRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MavenRunnerSettingsEditor.$$$reportNull$$$0(1);
        }
        this.myUseProjectSettings.setSelected(runConfiguration.getRunnerSettings() == null);
        if (runConfiguration.getRunnerSettings() == null) {
            MavenRunnerSettings settings = MavenRunner.getInstance(this.myPanel.getProject()).getSettings();
            this.myPanel.getData(settings);
        } else {
            this.myPanel.getData(runConfiguration.getRunnerSettings());
        }
    }

    protected void applyEditorTo(@NotNull MavenRunConfiguration runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            MavenRunnerSettingsEditor.$$$reportNull$$$0(2);
        }
        if (this.myUseProjectSettings.isSelected()) {
            runConfiguration.setRunnerSettings(null);
        } else if (runConfiguration.getRunnerSettings() != null) {
            this.myPanel.setData(runConfiguration.getRunnerSettings());
        } else {
            MavenRunnerSettings settings = MavenRunner.getInstance(this.myPanel.getProject()).getSettings().clone();
            this.myPanel.setData(settings);
            runConfiguration.setRunnerSettings(settings);
        }
    }

    @NotNull
    protected JComponent createEditor() {
        Pair<JPanel, JCheckBox> pair = MavenDisablePanelCheckbox.createPanel(this.myPanel.createComponent(), "Use project settings");
        this.myUseProjectSettings = (JCheckBox)pair.second;
        JComponent jComponent = (JComponent)pair.first;
        if (jComponent == null) {
            MavenRunnerSettingsEditor.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunnerSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunnerSettingsEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

