/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.parsers;

import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.LogMessageType;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLogEntryReader;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLoggedEventParser;

public abstract class BuildErrorNotification
implements MavenLoggedEventParser {
    private static final Pattern LINE_AND_COLUMN = Pattern.compile("[^\\d]*?(\\d+)[^\\d]*(\\d*)[])]");
    private final String myLanguage;
    private final String myExtension;
    private final String myMessageGroup;

    protected BuildErrorNotification(String language, String extension, String messageGroup) {
        this.myLanguage = language;
        this.myExtension = extension;
        this.myMessageGroup = messageGroup;
    }

    @Override
    public boolean supportsType(@Nullable LogMessageType type) {
        return type == LogMessageType.ERROR;
    }

    @Override
    public boolean checkLogLine(@NotNull Object parentId, @NotNull MavenLogEntryReader.MavenLogEntry logLine, @NotNull MavenLogEntryReader logEntryReader, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        String message;
        FilePosition position;
        String line;
        if (parentId == null) {
            BuildErrorNotification.$$$reportNull$$$0(0);
        }
        if (logLine == null) {
            BuildErrorNotification.$$$reportNull$$$0(1);
        }
        if (logEntryReader == null) {
            BuildErrorNotification.$$$reportNull$$$0(2);
        }
        if (messageConsumer == null) {
            BuildErrorNotification.$$$reportNull$$$0(3);
        }
        if ((line = logLine.getLine()).endsWith("java.lang.OutOfMemoryError")) {
            messageConsumer.accept((BuildEvent)new MessageEventImpl(parentId, MessageEvent.Kind.ERROR, this.myMessageGroup, "Out of memory.", line));
            return true;
        }
        int fileNameIdx = line.indexOf("." + this.myExtension + ":");
        if (fileNameIdx < 0) {
            return false;
        }
        int fullFileNameIdx = line.indexOf(":", fileNameIdx);
        if (fullFileNameIdx < 0) {
            return false;
        }
        int start = SystemInfo.isWindows && line.charAt(0) == '/' ? 1 : 0;
        String filename = FileUtil.toSystemDependentName((String)(line.substring(start, fileNameIdx) + "." + this.myExtension));
        File parsedFile = new File(filename);
        String lineWithPosition = line.substring(fullFileNameIdx);
        Matcher matcher = LINE_AND_COLUMN.matcher(lineWithPosition);
        if (matcher.find()) {
            position = BuildErrorNotification.withLineAndColumn(parsedFile, matcher);
            message = lineWithPosition.substring(matcher.end());
        } else {
            position = new FilePosition(parsedFile, 0, 0);
            message = lineWithPosition;
        }
        String errorMessage = this.getErrorMessage(position, message);
        messageConsumer.accept((BuildEvent)new FileMessageEventImpl(parentId, MessageEvent.Kind.ERROR, this.myMessageGroup, errorMessage, errorMessage, position));
        return true;
    }

    @NotNull
    private String getErrorMessage(@NotNull FilePosition position, @NotNull String message) {
        if (position == null) {
            BuildErrorNotification.$$$reportNull$$$0(4);
        }
        if (message == null) {
            BuildErrorNotification.$$$reportNull$$$0(5);
        }
        if (position.getStartLine() == 0) {
            String string = "Error: " + this.myLanguage + ":" + message;
            if (string == null) {
                BuildErrorNotification.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (position.getStartColumn() == 0) {
            String string = "Error:(" + (position.getStartLine() + 1) + ") " + this.myLanguage + ":" + message;
            if (string == null) {
                BuildErrorNotification.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = "Error:(" + (position.getStartLine() + 1) + "," + (position.getStartColumn() + 1) + ") " + this.myLanguage + ":" + message;
        if (string == null) {
            BuildErrorNotification.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static FilePosition withLineAndColumn(File toTest, Matcher matcher) {
        try {
            if (matcher.groupCount() == 2) {
                if (matcher.start(2) < 0) {
                    return new FilePosition(toTest, Integer.valueOf(matcher.group(1)) - 1, 0);
                }
                return new FilePosition(toTest, Integer.valueOf(matcher.group(1)) - 1, Integer.valueOf(matcher.group(2)) - 1);
            }
            return new FilePosition(toTest, 0, 0);
        }
        catch (NumberFormatException ignore) {
            return new FilePosition(toTest, 0, 0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logEntryReader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/externalSystemIntegration/output/parsers/BuildErrorNotification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/externalSystemIntegration/output/parsers/BuildErrorNotification";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkLogLine";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

