/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SmartList;
import java.text.MessageFormat;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.BuildViewMavenConsole;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenConsoleImpl;

public abstract class MavenConsole {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final List<ProcessListener> myProcessListeners = new SmartList();
    private final List<AttachProcessListener> myAttachProcessListeners = new SmartList();
    private final int myOutputLevel;
    private boolean isFinished;
    private static final BiMap<String, Integer> PREFIX_TO_LEVEL = ImmutableBiMap.of((Object)"DEBUG", (Object)0, (Object)"INFO", (Object)1, (Object)"WARNING", (Object)2, (Object)"ERROR", (Object)3, (Object)"FATAL_ERROR", (Object)4);

    public static MavenConsole createGuiMavenConsole(@NotNull Project project, @NotNull String title, @NotNull String workingDir, @NotNull String toolWindowId, long executionId) {
        if (project == null) {
            MavenConsole.$$$reportNull$$$0(0);
        }
        if (title == null) {
            MavenConsole.$$$reportNull$$$0(1);
        }
        if (workingDir == null) {
            MavenConsole.$$$reportNull$$$0(2);
        }
        if (toolWindowId == null) {
            MavenConsole.$$$reportNull$$$0(3);
        }
        if (Registry.is((String)"maven.build.tool.window.enabled")) {
            return new BuildViewMavenConsole(project, title, workingDir, toolWindowId, executionId);
        }
        return new MavenConsoleImpl(title, project);
    }

    public MavenConsole(MavenExecutionOptions.LoggingLevel outputLevel, boolean printStackTrace) {
        this.myOutputLevel = outputLevel.getLevel();
    }

    public boolean isSuppressed(int level) {
        return level < this.myOutputLevel;
    }

    public void addProcessListener(ProcessListener processListener) {
        this.myProcessListeners.add(processListener);
    }

    public void addAttachProcessListener(AttachProcessListener listener) {
        this.myAttachProcessListeners.add(listener);
    }

    public boolean isSuppressed(String line) {
        return this.isSuppressed(MavenConsole.getLevel(line));
    }

    public abstract boolean canPause();

    public abstract boolean isOutputPaused();

    public abstract void setOutputPaused(boolean var1);

    public boolean isFinished() {
        return this.isFinished;
    }

    public void finish() {
        this.isFinished = true;
    }

    public void attachToProcess(ProcessHandler processHandler) {
        for (ProcessListener processListener : this.myProcessListeners) {
            processHandler.addProcessListener(processListener);
        }
        for (AttachProcessListener attachProcessListener : this.myAttachProcessListeners) {
            attachProcessListener.beforeProcessAttached(processHandler);
        }
    }

    public void printException(Throwable throwable) {
        this.systemMessage(3, RunnerBundle.message("embedded.build.failed", new Object[0]), throwable);
    }

    public void systemMessage(int level, String string, Throwable throwable) {
        this.printMessage(level, string, throwable);
    }

    public void printMessage(int level, String string, Throwable throwable) {
        String message;
        if (this.isSuppressed(level)) {
            return;
        }
        OutputType type = OutputType.NORMAL;
        if (throwable != null || level == 2 || level == 3 || level == 4) {
            type = OutputType.ERROR;
        }
        this.doPrint(MavenConsole.composeLine(level, string), type);
        if (level == 4) {
            this.setOutputPaused(false);
        }
        if (throwable != null && (message = throwable.getMessage()) != null) {
            message = message + LINE_SEPARATOR;
            this.doPrint(LINE_SEPARATOR + MavenConsole.composeLine(3, message), type);
        }
    }

    private static String appendExecutionFailureMessage(String message, String newMessage) {
        if (message == null) {
            return newMessage;
        }
        if (newMessage == null) {
            return message;
        }
        return message + LINE_SEPARATOR + LINE_SEPARATOR + newMessage;
    }

    protected abstract void doPrint(String var1, OutputType var2);

    private static int getLevel(String line) {
        return MavenConsole.getLevelByPrefix(MavenConsole.extractPrefix(line));
    }

    private static String extractPrefix(String line) {
        int closing;
        if (line.startsWith("[") && (closing = line.indexOf("] ", 1)) > 1) {
            return line.substring(1, closing);
        }
        return "";
    }

    private static int getLevelByPrefix(String prefix) {
        Integer level = (Integer)PREFIX_TO_LEVEL.get((Object)prefix);
        return level != null ? level : 2;
    }

    private static String composeLine(int level, String message) {
        return MessageFormat.format("[{0}] {1}", MavenConsole.getPrefixByLevel(level), message);
    }

    private static String getPrefixByLevel(int level) {
        return (String)PREFIX_TO_LEVEL.inverse().get((Object)level);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "workingDir";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "toolWindowId";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/project/MavenConsole";
        objectArray[2] = "createGuiMavenConsole";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface AttachProcessListener {
        public void beforeProcessAttached(@NotNull ProcessHandler var1);
    }

    public static enum OutputType {
        NORMAL,
        SYSTEM,
        ERROR;

    }
}

