/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Pair;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenUtil;

final class MavenEditorTabTitleUpdater
implements ApplicationInitializedListener {
    MavenEditorTabTitleUpdater() {
    }

    public void componentsInitialized() {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            return;
        }
        app.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(final @NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                MavenProjectsManager.getInstance(project).addProjectsTreeListener(new MavenProjectsTree.Listener(){

                    @Override
                    public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
                        if (updated == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (deleted == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        MavenEditorTabTitleUpdater.updateTabName(MavenUtil.collectFirsts(updated), project);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "updated";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "deleted";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/idea/maven/utils/MavenEditorTabTitleUpdater$1$1";
                        objectArray[2] = "projectsUpdated";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/MavenEditorTabTitleUpdater$1", "projectOpened"));
            }
        });
    }

    private static void updateTabName(@NotNull List<MavenProject> projects, @NotNull Project project) {
        if (projects == null) {
            MavenEditorTabTitleUpdater.$$$reportNull$$$0(0);
        }
        if (project == null) {
            MavenEditorTabTitleUpdater.$$$reportNull$$$0(1);
        }
        MavenUtil.invokeLater(project, () -> {
            for (MavenProject each : projects) {
                FileEditorManagerEx.getInstanceEx((Project)project).updateFilePresentation(each.getFile());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "projects";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/utils/MavenEditorTabTitleUpdater";
        objectArray[2] = "updateTabName";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

