/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.lw.LwXmlReader;
import com.intellij.uiDesigner.propertyInspector.editors.IntEnumEditor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Properties {
    private static final Logger LOG = Logger.getInstance(Properties.class);
    private final Map<String, String> myClass2InplaceProperty = new HashMap<String, String>();
    private final Map<String, Set<String>> myClass2ExpertProperties = new HashMap<String, Set<String>>();
    private final Map<String, Map<String, IntEnumEditor.Pair[]>> myClass2EnumProperties = new HashMap<String, Map<String, IntEnumEditor.Pair[]>>();
    private final Map<String, Set<String>> myClass2DeprecatedProperties = new HashMap<String, Set<String>>();

    public static Properties getInstance() {
        return (Properties)ServiceManager.getService(Properties.class);
    }

    public Properties() {
        try (InputStream inputStream = Properties.class.getResourceAsStream("/gui-designer-properties.xml");){
            if (inputStream != null) {
                this.loadState(JDOMUtil.load((InputStream)inputStream));
            }
        }
        catch (JDOMException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean isExpertProperty(Module module, @NotNull Class aClass, String propertyName) {
        if (aClass == null) {
            Properties.$$$reportNull$$$0(0);
        }
        for (Class c = aClass; c != null; c = c.getSuperclass()) {
            Set<String> properties = this.myClass2ExpertProperties.get(c.getName());
            if (properties == null || !properties.contains(propertyName)) continue;
            return true;
        }
        return this.isPropertyDeprecated(module, aClass, propertyName);
    }

    public boolean isPropertyDeprecated(Module module, Class aClass, String propertyName) {
        Set<String> deprecated = this.myClass2DeprecatedProperties.get(aClass.getName());
        if (deprecated == null) {
            deprecated = new HashSet<String>();
            PsiClass componentClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(aClass.getName(), module.getModuleWithDependenciesAndLibrariesScope(true));
            if (componentClass != null) {
                PsiMethod[] methods;
                for (PsiMethod method : methods = componentClass.getAllMethods()) {
                    if (!method.isDeprecated() || !PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) continue;
                    deprecated.add(PropertyUtilBase.getPropertyNameBySetter((PsiMethod)method));
                }
            }
            this.myClass2DeprecatedProperties.put(aClass.getName(), deprecated);
        }
        return deprecated.contains(propertyName);
    }

    @Nullable
    public String getInplaceProperty(Class aClass) {
        for (Class c = aClass; c != null; c = c.getSuperclass()) {
            String property = this.myClass2InplaceProperty.get(c.getName());
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public IntEnumEditor.Pair @Nullable [] getEnumPairs(Class aClass, String name) {
        for (Class c = aClass; c != null; c = c.getSuperclass()) {
            Map<String, IntEnumEditor.Pair[]> map = this.myClass2EnumProperties.get(c.getName());
            if (map == null) continue;
            return map.get(name);
        }
        return null;
    }

    private void loadState(@NotNull Element state) {
        if (state == null) {
            Properties.$$$reportNull$$$0(1);
        }
        for (Element classElement : state.getChildren("class")) {
            Element enumPropertyElement;
            Element inplacePropertyElement;
            String className = LwXmlReader.getRequiredString((Element)classElement, (String)"name");
            Element expertPropertiesElement = classElement.getChild("expert-properties");
            if (expertPropertiesElement != null) {
                HashSet<String> expertProperties = new HashSet<String>();
                for (Element e : expertPropertiesElement.getChildren("property")) {
                    expertProperties.add(LwXmlReader.getRequiredString((Element)e, (String)"name"));
                }
                this.myClass2ExpertProperties.put(className, expertProperties);
            }
            if ((inplacePropertyElement = classElement.getChild("inplace-property")) != null) {
                this.myClass2InplaceProperty.put(className, LwXmlReader.getRequiredString((Element)inplacePropertyElement, (String)"name"));
            }
            if ((enumPropertyElement = classElement.getChild("enum-properties")) == null) continue;
            this.loadEnumProperties(className, enumPropertyElement);
        }
    }

    private void loadEnumProperties(String className, Element enumPropertyElement) {
        HashMap<String, IntEnumEditor.Pair[]> map = new HashMap<String, IntEnumEditor.Pair[]>();
        for (Element e : enumPropertyElement.getChildren("property")) {
            String name = LwXmlReader.getRequiredString((Element)e, (String)"name");
            List list = e.getChildren("constant");
            IntEnumEditor.Pair[] pairs = new IntEnumEditor.Pair[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Element constant = (Element)list.get(i);
                int value = LwXmlReader.getRequiredInt((Element)constant, (String)"value");
                String message = constant.getAttributeValue("message");
                String text = message != null ? UIDesignerBundle.message(message, new Object[0]) : LwXmlReader.getRequiredString((Element)constant, (String)"name");
                pairs[i] = new IntEnumEditor.Pair(value, text);
            }
            map.put(name, pairs);
        }
        if (map.size() > 0) {
            this.myClass2EnumProperties.put(className, map);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uiDesigner/Properties";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isExpertProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

