/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.i18n;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.i18n.StringDescriptorAccessor;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;

public class I18nizeFormQuickFix
extends QuickFix {
    private static final Logger LOG = Logger.getInstance(I18nizeFormQuickFix.class);
    private final StringDescriptorAccessor myAccessor;

    I18nizeFormQuickFix(GuiEditor editor, String name, StringDescriptorAccessor accessor) {
        super(editor, name, accessor.getComponent());
        this.myAccessor = accessor;
    }

    @Override
    public void run() {
        String bundleName;
        StringDescriptor descriptor = this.getStringDescriptorValue();
        Project project = this.myEditor.getProject();
        PsiFile psiFile = this.myEditor.getPsiFile();
        if (!JavaI18nizeQuickFixDialog.isAvailable((PsiFile)this.myEditor.getPsiFile())) {
            return;
        }
        String initialValue = StringUtil.escapeStringCharacters((String)descriptor.getValue());
        JavaI18nizeQuickFixDialog dialog = new JavaI18nizeQuickFixDialog(project, psiFile, null, initialValue, null, false, false){

            protected String getDimensionServiceKey() {
                return "#com.intellij.codeInsight.i18n.I18nizeQuickFixDialog_Form";
            }
        };
        if (!dialog.showAndGet()) {
            return;
        }
        if (!this.myEditor.ensureEditable()) {
            return;
        }
        Collection propertiesFiles = dialog.getAllPropertiesFiles();
        PropertiesFile aPropertiesFile = null;
        for (PropertiesFile file : propertiesFiles) {
            if (!FileModificationService.getInstance().prepareFileForWrite(file.getContainingFile())) {
                return;
            }
            if (aPropertiesFile != null) continue;
            aPropertiesFile = file;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                I18nUtil.createProperty((Project)project, (Collection)propertiesFiles, (String)dialog.getKey(), (String)dialog.getValue());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }), PropertiesBundle.message((String)"quickfix.i18n.command.name", (Object[])new Object[0]), (Object)project);
        for (PropertiesFile file : propertiesFiles) {
            FileDocumentManager.getInstance().saveDocument(PsiDocumentManager.getInstance((Project)project).getDocument(file.getContainingFile()));
        }
        if (aPropertiesFile != null && (bundleName = I18nizeFormQuickFix.getBundleName(project, aPropertiesFile)) != null) {
            try {
                this.setStringDescriptorValue(new StringDescriptor(bundleName, dialog.getKey()));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            this.myEditor.refreshAndSave(true);
        }
    }

    static String getBundleName(Project project, PropertiesFile aPropertiesFile) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        String packageName = fileIndex.getPackageNameByDirectory(aPropertiesFile.getVirtualFile().getParent());
        if (packageName == null) {
            return null;
        }
        String bundleName = !packageName.isEmpty() ? packageName + "." + aPropertiesFile.getResourceBundle().getBaseName() : aPropertiesFile.getResourceBundle().getBaseName();
        return bundleName.replace('.', '/');
    }

    protected StringDescriptor getStringDescriptorValue() {
        return this.myAccessor.getStringDescriptorValue();
    }

    protected void setStringDescriptorValue(StringDescriptor descriptor) throws Exception {
        this.myAccessor.setStringDescriptorValue(descriptor);
    }
}

