/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.IntEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.ArrayUtil;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class IntFieldProperty
extends Property<RadComponent, Integer> {
    private final LabelPropertyRenderer<Integer> myRenderer;
    private final IntEditor myEditor;
    @NotNull
    private final Property myParent;
    private final String myFieldName;
    private final Object myTemplateValue;
    @NonNls
    private static final String METHOD_CLONE = "clone";

    public IntFieldProperty(@NotNull Property parent, @NonNls String fieldName, int lowBoundary, Object templateValue) {
        if (parent == null) {
            IntFieldProperty.$$$reportNull$$$0(0);
        }
        super(parent, fieldName);
        this.myParent = parent;
        this.myFieldName = fieldName;
        this.myTemplateValue = templateValue;
        this.myRenderer = new LabelPropertyRenderer();
        this.myEditor = new IntEditor(lowBoundary);
    }

    @Override
    public Integer getValue(RadComponent component) {
        Object parentValue = this.myParent.getValue(component);
        if (parentValue == null) {
            return 0;
        }
        try {
            return parentValue.getClass().getField(this.myFieldName).getInt(parentValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void setValueImpl(RadComponent component, Integer value) throws Exception {
        Object parentValue = this.myParent.getValue(component);
        if (parentValue == null) {
            parentValue = this.myTemplateValue;
        } else {
            Method method = parentValue.getClass().getMethod(METHOD_CLONE, ArrayUtil.EMPTY_CLASS_ARRAY);
            parentValue = method.invoke(parentValue, new Object[0]);
        }
        parentValue.getClass().getField(this.myFieldName).setInt(parentValue, value);
        this.myParent.setValue(component, parentValue);
    }

    @Override
    @NotNull
    public PropertyRenderer<Integer> getRenderer() {
        LabelPropertyRenderer<Integer> labelPropertyRenderer = this.myRenderer;
        if (labelPropertyRenderer == null) {
            IntFieldProperty.$$$reportNull$$$0(1);
        }
        return labelPropertyRenderer;
    }

    @Override
    public PropertyEditor<Integer> getEditor() {
        return this.myEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/propertyInspector/properties/IntFieldProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/propertyInspector/properties/IntFieldProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

