/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.renderers;

import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.ui.UIUtil;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class LabelPropertyRenderer<V>
extends JLabel
implements PropertyRenderer<V> {
    private String myStaticText;

    public LabelPropertyRenderer() {
        this.setOpaque(true);
        this.putClientProperty("html.disable", true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
    }

    public LabelPropertyRenderer(String staticText) {
        this();
        this.myStaticText = staticText;
    }

    @Override
    public JLabel getComponent(RadRootContainer rootContainer, V value, boolean selected, boolean hasFocus) {
        this.setText(null);
        this.setIcon(null);
        if (selected) {
            this.setForeground(UIUtil.getTableSelectionForeground());
            this.setBackground(UIUtil.getTableSelectionBackground((boolean)true));
        } else {
            this.setForeground(UIUtil.getTableForeground());
            this.setBackground(UIUtil.getTableBackground());
        }
        if (value != null) {
            this.customize(value);
        }
        return this;
    }

    protected void customize(@NotNull V value) {
        if (value == null) {
            LabelPropertyRenderer.$$$reportNull$$$0(0);
        }
        this.setText(this.myStaticText != null ? this.myStaticText : value.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/uiDesigner/propertyInspector/renderers/LabelPropertyRenderer", "customize"));
    }
}

