/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.lw.IButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RadButtonGroup
implements IButtonGroup {
    public static final RadButtonGroup NEW_GROUP = new RadButtonGroup(null);
    private String myName;
    private final List<String> myComponentIds = new ArrayList<String>();
    private boolean myBound;

    public RadButtonGroup(String name) {
        this.myName = name;
    }

    public void write(XmlWriter writer) {
        writer.startElement("group");
        writer.addAttribute("name", this.myName);
        if (this.myBound) {
            writer.addAttribute("bound", true);
        }
        for (String id : this.myComponentIds) {
            writer.startElement("member");
            writer.addAttribute("id", id);
            writer.endElement();
        }
        writer.endElement();
    }

    public boolean contains(RadComponent component) {
        return this.myComponentIds.contains(component.getId());
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public boolean isBound() {
        return this.myBound;
    }

    public void setBound(boolean bound) {
        this.myBound = bound;
    }

    public void add(RadComponent component) {
        this.myComponentIds.add(component.getId());
    }

    public void remove(RadComponent component) {
        this.myComponentIds.remove(component.getId());
    }

    public void addComponentIds(String[] componentIds) {
        Collections.addAll(this.myComponentIds, componentIds);
    }

    public String[] getComponentIds() {
        return ArrayUtilRt.toStringArray(this.myComponentIds);
    }

    public boolean isEmpty() {
        return this.myComponentIds.size() == 0;
    }
}

