/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.gnu.trove;

import java.util.ConcurrentModificationException;
import org.gradle.internal.impldep.gnu.trove.TIterator;
import org.gradle.internal.impldep.gnu.trove.TObjectByteHashMap;
import org.gradle.internal.impldep.gnu.trove.TObjectHash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectByteIterator<K>
extends TIterator {
    private final TObjectByteHashMap<K> _map;

    public TObjectByteIterator(TObjectByteHashMap<K> map) {
        super(map);
        this._map = map;
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set = this._map._set;
        int i = this._index;
        while (i-- > 0 && (set[i] == null || set[i] == TObjectHash.REMOVED)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public K key() {
        return (K)this._map._set[this._index];
    }

    public byte value() {
        return this._map._values[this._index];
    }

    public byte setValue(byte val) {
        byte old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

