/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.plugin.version.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.Versioning;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import org.gradle.internal.impldep.org.apache.maven.model.Build;
import org.gradle.internal.impldep.org.apache.maven.model.Plugin;
import org.gradle.internal.impldep.org.apache.maven.plugin.MavenPluginManager;
import org.gradle.internal.impldep.org.apache.maven.plugin.PluginResolutionException;
import org.gradle.internal.impldep.org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.gradle.internal.impldep.org.apache.maven.plugin.version.PluginVersionRequest;
import org.gradle.internal.impldep.org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.gradle.internal.impldep.org.apache.maven.plugin.version.PluginVersionResolver;
import org.gradle.internal.impldep.org.apache.maven.plugin.version.PluginVersionResult;
import org.gradle.internal.impldep.org.apache.maven.plugin.version.internal.DefaultPluginVersionResult;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.Logger;
import org.gradle.internal.impldep.org.codehaus.plexus.util.StringUtils;
import org.gradle.internal.impldep.org.sonatype.aether.RepositoryEvent;
import org.gradle.internal.impldep.org.sonatype.aether.RepositoryListener;
import org.gradle.internal.impldep.org.sonatype.aether.RepositorySystem;
import org.gradle.internal.impldep.org.sonatype.aether.RepositorySystemSession;
import org.gradle.internal.impldep.org.sonatype.aether.RequestTrace;
import org.gradle.internal.impldep.org.sonatype.aether.metadata.Metadata;
import org.gradle.internal.impldep.org.sonatype.aether.repository.ArtifactRepository;
import org.gradle.internal.impldep.org.sonatype.aether.repository.RemoteRepository;
import org.gradle.internal.impldep.org.sonatype.aether.resolution.MetadataRequest;
import org.gradle.internal.impldep.org.sonatype.aether.resolution.MetadataResult;
import org.gradle.internal.impldep.org.sonatype.aether.util.DefaultRequestTrace;
import org.gradle.internal.impldep.org.sonatype.aether.util.listener.DefaultRepositoryEvent;
import org.gradle.internal.impldep.org.sonatype.aether.util.metadata.DefaultMetadata;
import org.gradle.internal.impldep.org.sonatype.aether.util.version.GenericVersionScheme;
import org.gradle.internal.impldep.org.sonatype.aether.version.InvalidVersionSpecificationException;
import org.gradle.internal.impldep.org.sonatype.aether.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PluginVersionResolver.class)
public class DefaultPluginVersionResolver
implements PluginVersionResolver {
    private static final String REPOSITORY_CONTEXT = "plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private MetadataReader metadataReader;
    @Requirement
    private MavenPluginManager pluginManager;

    @Override
    public PluginVersionResult resolve(PluginVersionRequest request) throws PluginVersionResolutionException {
        this.logger.debug("Resolving plugin version for " + request.getGroupId() + ":" + request.getArtifactId());
        PluginVersionResult result = this.resolveFromProject(request);
        if (result == null) {
            result = this.resolveFromRepository(request);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Resolved plugin version for " + request.getGroupId() + ":" + request.getArtifactId() + " to " + result.getVersion() + " from repository " + result.getRepository());
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolved plugin version for " + request.getGroupId() + ":" + request.getArtifactId() + " to " + result.getVersion() + " from POM " + request.getPom());
        }
        return result;
    }

    private PluginVersionResult resolveFromRepository(PluginVersionRequest request) throws PluginVersionResolutionException {
        RequestTrace trace = DefaultRequestTrace.newChild(null, request);
        DefaultPluginVersionResult result = new DefaultPluginVersionResult();
        DefaultMetadata metadata = new DefaultMetadata(request.getGroupId(), request.getArtifactId(), "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
        ArrayList<MetadataRequest> requests = new ArrayList<MetadataRequest>();
        requests.add(new MetadataRequest(metadata, null, REPOSITORY_CONTEXT).setTrace(trace));
        for (RemoteRepository repository : request.getRepositories()) {
            requests.add(new MetadataRequest(metadata, repository, REPOSITORY_CONTEXT).setTrace(trace));
        }
        List<MetadataResult> results = this.repositorySystem.resolveMetadata(request.getRepositorySession(), requests);
        Versions versions = new Versions();
        for (MetadataResult res : results) {
            ArtifactRepository repository = res.getRequest().getRepository();
            if (repository == null) {
                repository = request.getRepositorySession().getLocalRepository();
            }
            this.mergeMetadata(request.getRepositorySession(), trace, versions, res.getMetadata(), repository);
        }
        this.selectVersion(result, request, versions);
        return result;
    }

    private void selectVersion(DefaultPluginVersionResult result, PluginVersionRequest request, Versions versions) throws PluginVersionResolutionException {
        String version = null;
        ArtifactRepository repo = null;
        if (StringUtils.isNotEmpty(versions.releaseVersion)) {
            version = versions.releaseVersion;
            repo = versions.releaseRepository;
        } else if (StringUtils.isNotEmpty(versions.latestVersion)) {
            version = versions.latestVersion;
            repo = versions.latestRepository;
        }
        if (version != null && !this.isCompatible(request, version)) {
            versions.versions.remove(version);
            version = null;
        }
        if (version == null) {
            String ver;
            GenericVersionScheme versionScheme = new GenericVersionScheme();
            TreeSet releases = new TreeSet(Collections.reverseOrder());
            TreeSet snapshots = new TreeSet(Collections.reverseOrder());
            for (String ver2 : versions.versions.keySet()) {
                try {
                    Version v = versionScheme.parseVersion(ver2);
                    if (ver2.endsWith("-SNAPSHOT")) {
                        snapshots.add(v);
                        continue;
                    }
                    releases.add(v);
                }
                catch (InvalidVersionSpecificationException e) {}
            }
            for (Version v : releases) {
                ver = ((Object)v).toString();
                if (!this.isCompatible(request, ver)) continue;
                version = ver;
                repo = versions.versions.get(version);
                break;
            }
            if (version == null) {
                for (Version v : snapshots) {
                    ver = ((Object)v).toString();
                    if (!this.isCompatible(request, ver)) continue;
                    version = ver;
                    repo = versions.versions.get(version);
                    break;
                }
            }
        }
        if (version == null) {
            throw new PluginVersionResolutionException(request.getGroupId(), request.getArtifactId(), request.getRepositorySession().getLocalRepository(), request.getRepositories(), "Plugin not found in any plugin repository");
        }
        result.setVersion(version);
        result.setRepository(repo);
    }

    private boolean isCompatible(PluginVersionRequest request, String version) {
        PluginDescriptor pluginDescriptor;
        Plugin plugin = new Plugin();
        plugin.setGroupId(request.getGroupId());
        plugin.setArtifactId(request.getArtifactId());
        plugin.setVersion(version);
        try {
            pluginDescriptor = this.pluginManager.getPluginDescriptor(plugin, request.getRepositories(), request.getRepositorySession());
        }
        catch (PluginResolutionException e) {
            this.logger.debug("Ignoring unresolvable plugin version " + version, e);
            return false;
        }
        catch (Exception e) {
            return true;
        }
        try {
            this.pluginManager.checkRequiredMavenVersion(pluginDescriptor);
        }
        catch (Exception e) {
            this.logger.debug("Ignoring incompatible plugin version " + version + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    private void mergeMetadata(RepositorySystemSession session, RequestTrace trace, Versions versions, Metadata metadata, ArtifactRepository repository) {
        if (metadata != null && metadata.getFile() != null && metadata.getFile().isFile()) {
            try {
                Map<String, Boolean> options = Collections.singletonMap("org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.io.isStrict", Boolean.FALSE);
                org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.Metadata repoMetadata = this.metadataReader.read(metadata.getFile(), options);
                this.mergeMetadata(versions, repoMetadata, repository);
            }
            catch (IOException e) {
                this.invalidMetadata(session, trace, metadata, repository, e);
            }
        }
    }

    private void invalidMetadata(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, Exception exception) {
        RepositoryListener listener = session.getRepositoryListener();
        if (listener != null) {
            DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.METADATA_INVALID, session, trace);
            event.setMetadata(metadata);
            event.setException(exception);
            event.setRepository(repository);
            listener.metadataInvalid(event);
        }
    }

    private void mergeMetadata(Versions versions, org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.Metadata source, ArtifactRepository repository) {
        Versioning versioning = source.getVersioning();
        if (versioning != null) {
            String timestamp = StringUtils.clean(versioning.getLastUpdated());
            if (StringUtils.isNotEmpty(versioning.getRelease()) && timestamp.compareTo(versions.releaseTimestamp) > 0) {
                versions.releaseVersion = versioning.getRelease();
                versions.releaseTimestamp = timestamp;
                versions.releaseRepository = repository;
            }
            if (StringUtils.isNotEmpty(versioning.getLatest()) && timestamp.compareTo(versions.latestTimestamp) > 0) {
                versions.latestVersion = versioning.getLatest();
                versions.latestTimestamp = timestamp;
                versions.latestRepository = repository;
            }
            for (String version : versioning.getVersions()) {
                if (versions.versions.containsKey(version)) continue;
                versions.versions.put(version, repository);
            }
        }
    }

    private PluginVersionResult resolveFromProject(PluginVersionRequest request) {
        Build build;
        PluginVersionResult result = null;
        if (request.getPom() != null && request.getPom().getBuild() != null && (result = this.resolveFromProject(request, (build = request.getPom().getBuild()).getPlugins())) == null && build.getPluginManagement() != null) {
            result = this.resolveFromProject(request, build.getPluginManagement().getPlugins());
        }
        return result;
    }

    private PluginVersionResult resolveFromProject(PluginVersionRequest request, List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!request.getGroupId().equals(plugin.getGroupId()) || !request.getArtifactId().equals(plugin.getArtifactId())) continue;
            if (plugin.getVersion() != null) {
                return new DefaultPluginVersionResult(plugin.getVersion());
            }
            return null;
        }
        return null;
    }

    static class Versions {
        String releaseVersion = "";
        String releaseTimestamp = "";
        ArtifactRepository releaseRepository;
        String latestVersion = "";
        String latestTimestamp = "";
        ArtifactRepository latestRepository;
        Map<String, ArtifactRepository> versions = new LinkedHashMap<String, ArtifactRepository>();

        Versions() {
        }
    }
}

