/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.plexus.configuration;

import org.gradle.internal.impldep.org.codehaus.plexus.configuration.PlexusConfiguration;
import org.gradle.internal.impldep.org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.gradle.internal.impldep.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;

public class PlexusConfigurationMerger {
    public static PlexusConfiguration merge(PlexusConfiguration user, PlexusConfiguration system) {
        PlexusConfiguration logging;
        PlexusConfiguration[] configurationsDirectories;
        PlexusConfiguration systemProperties;
        XmlPlexusConfiguration mergedConfiguration = new XmlPlexusConfiguration("plexus");
        PlexusConfiguration loadOnStart = user.getChild("load-on-start");
        if (loadOnStart.getChildCount() != 0) {
            mergedConfiguration.addChild(loadOnStart);
        }
        if ((systemProperties = user.getChild("system-properties")).getChildCount() != 0) {
            mergedConfiguration.addChild(systemProperties);
        }
        if ((configurationsDirectories = user.getChildren("configurations-directory")).length != 0) {
            for (PlexusConfiguration configurationsDirectory : configurationsDirectories) {
                mergedConfiguration.addChild(configurationsDirectory);
            }
        }
        if ((logging = user.getChild("logging")).getChildCount() != 0) {
            mergedConfiguration.addChild(logging);
        } else {
            mergedConfiguration.addChild(system.getChild("logging"));
        }
        mergedConfiguration.addChild(system.getChild("container-initialization"));
        mergedConfiguration.addChild(system.getChild("component-lookup-manager"));
        PlexusConfiguration componentRepository = user.getChild("component-repository");
        if (componentRepository.getChildCount() != 0) {
            mergedConfiguration.addChild(componentRepository);
        } else {
            mergedConfiguration.addChild(system.getChild("component-repository"));
        }
        PlexusConfigurationMerger.copyResources(system, mergedConfiguration);
        PlexusConfigurationMerger.copyResources(user, mergedConfiguration);
        PlexusConfiguration componentManagerManager = user.getChild("component-manager-manager");
        if (componentManagerManager.getChildCount() != 0) {
            mergedConfiguration.addChild(componentManagerManager);
            PlexusConfigurationMerger.copyComponentManagers(system.getChild("component-manager-manager"), componentManagerManager);
        } else {
            mergedConfiguration.addChild(system.getChild("component-manager-manager"));
        }
        PlexusConfiguration componentDiscovererManager = user.getChild("component-discoverer-manager");
        if (componentDiscovererManager.getChildCount() != 0) {
            mergedConfiguration.addChild(componentDiscovererManager);
            PlexusConfigurationMerger.copyComponentDiscoverers(system.getChild("component-discoverer-manager"), componentDiscovererManager);
        } else {
            mergedConfiguration.addChild(system.getChild("component-discoverer-manager"));
        }
        PlexusConfiguration componentFactoryManager = user.getChild("component-factory-manager");
        if (componentFactoryManager.getChildCount() != 0) {
            mergedConfiguration.addChild(componentFactoryManager);
            PlexusConfigurationMerger.copyComponentFactories(system.getChild("component-factory-manager"), componentFactoryManager);
        } else {
            mergedConfiguration.addChild(system.getChild("component-factory-manager"));
        }
        PlexusConfiguration lifecycleHandlerManager = user.getChild("lifecycle-handler-manager");
        if (lifecycleHandlerManager.getChildCount() != 0) {
            mergedConfiguration.addChild(lifecycleHandlerManager);
            PlexusConfigurationMerger.copyLifecycles(system.getChild("lifecycle-handler-manager"), lifecycleHandlerManager);
        } else {
            mergedConfiguration.addChild(system.getChild("lifecycle-handler-manager"));
        }
        PlexusConfiguration componentComposerManager = user.getChild("component-composer-manager");
        if (componentComposerManager.getChildCount() != 0) {
            mergedConfiguration.addChild(componentComposerManager);
            PlexusConfigurationMerger.copyComponentComposers(system.getChild("component-composer-manager"), componentComposerManager);
        } else {
            mergedConfiguration.addChild(system.getChild("component-composer-manager"));
        }
        PlexusConfiguration components = system.getChild("components");
        mergedConfiguration.addChild(components);
        PlexusConfigurationMerger.copyComponents(user.getChild("components"), components);
        return mergedConfiguration;
    }

    private static void copyResources(PlexusConfiguration source, PlexusConfiguration destination) {
        PlexusConfiguration[] handlers = source.getChild("resources").getChildren();
        PlexusConfiguration dest = destination.getChild("resources");
        for (PlexusConfiguration handler : handlers) {
            dest.addChild(handler);
        }
    }

    private static void copyComponentManagers(PlexusConfiguration source, PlexusConfiguration destination) {
        try {
            PlexusConfiguration id = destination.getChild("default-component-manager-id");
            String sid = source.getChild("default-component-manager-id").getValue();
            if (id.getValue() == null) {
                id.setValue(sid);
            }
        }
        catch (PlexusConfigurationException e) {
            // empty catch block
        }
        PlexusConfiguration[] handlers = source.getChild("component-managers").getChildren("component-manager");
        PlexusConfiguration dest = destination.getChild("component-managers");
        for (PlexusConfiguration handler : handlers) {
            dest.addChild(handler);
        }
    }

    private static void copyComponentDiscoverers(PlexusConfiguration source, PlexusConfiguration destination) {
        PlexusConfiguration[] handlers = source.getChild("component-discoverers").getChildren("component-discoverer");
        PlexusConfiguration dest = destination.getChild("component-discoverers");
        for (PlexusConfiguration handler : handlers) {
            dest.addChild(handler);
        }
    }

    private static void copyComponentFactories(PlexusConfiguration source, PlexusConfiguration destination) {
        PlexusConfiguration[] handlers = source.getChild("component-factories").getChildren("component-factory");
        PlexusConfiguration dest = destination.getChild("component-factories");
        for (PlexusConfiguration handler : handlers) {
            dest.addChild(handler);
        }
    }

    private static void copyComponentComposers(PlexusConfiguration source, PlexusConfiguration destination) {
        try {
            PlexusConfiguration id = destination.getChild("default-component-composer-id");
            String sid = source.getChild("default-component-composer-id").getValue();
            if (id.getValue() == null) {
                id.setValue(sid);
            }
        }
        catch (PlexusConfigurationException e) {
            // empty catch block
        }
        PlexusConfiguration[] composers = source.getChild("component-composers").getChildren("component-composer");
        PlexusConfiguration dest = destination.getChild("component-composers");
        for (PlexusConfiguration composer : composers) {
            dest.addChild(composer);
        }
    }

    private static void copyLifecycles(PlexusConfiguration source, PlexusConfiguration destination) {
        PlexusConfiguration[] handlers = source.getChild("lifecycle-handlers").getChildren("lifecycle-handler");
        PlexusConfiguration dest = destination.getChild("lifecycle-handlers");
        for (PlexusConfiguration handler : handlers) {
            dest.addChild(handler);
        }
    }

    private static void copyComponents(PlexusConfiguration source, PlexusConfiguration destination) {
        PlexusConfiguration[] components;
        for (PlexusConfiguration component : components = source.getChildren("component")) {
            destination.addChild(component);
        }
    }
}

