/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.util.List;
import java.util.PriorityQueue;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftable.LogCursor;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftable.Reftable;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.AnyObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Ref;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ReflogEntry;

public class MergedReftable
extends Reftable {
    private final Reftable[] tables;

    public MergedReftable(List<Reftable> tableStack) {
        Reftable[] reftableArray = this.tables = tableStack.toArray(new Reftable[0]);
        int n = this.tables.length;
        int n2 = 0;
        while (n2 < n) {
            Reftable t = reftableArray[n2];
            t.setIncludeDeletes(true);
            ++n2;
        }
    }

    @Override
    public RefCursor allRefs() throws IOException {
        MergedRefCursor m = new MergedRefCursor();
        int i = 0;
        while (i < this.tables.length) {
            m.add(new RefQueueEntry(this.tables[i].allRefs(), i));
            ++i;
        }
        return m;
    }

    @Override
    public RefCursor seekRef(String name) throws IOException {
        MergedRefCursor m = new MergedRefCursor();
        int i = 0;
        while (i < this.tables.length) {
            m.add(new RefQueueEntry(this.tables[i].seekRef(name), i));
            ++i;
        }
        return m;
    }

    @Override
    public RefCursor seekRefsWithPrefix(String prefix) throws IOException {
        MergedRefCursor m = new MergedRefCursor();
        int i = 0;
        while (i < this.tables.length) {
            m.add(new RefQueueEntry(this.tables[i].seekRefsWithPrefix(prefix), i));
            ++i;
        }
        return m;
    }

    @Override
    public RefCursor byObjectId(AnyObjectId name) throws IOException {
        MergedRefCursor m = new MergedRefCursor();
        int i = 0;
        while (i < this.tables.length) {
            m.add(new RefQueueEntry(this.tables[i].byObjectId(name), i));
            ++i;
        }
        return m;
    }

    @Override
    public LogCursor allLogs() throws IOException {
        MergedLogCursor m = new MergedLogCursor();
        int i = 0;
        while (i < this.tables.length) {
            m.add(new LogQueueEntry(this.tables[i].allLogs(), i));
            ++i;
        }
        return m;
    }

    @Override
    public LogCursor seekLog(String refName, long updateIdx) throws IOException {
        MergedLogCursor m = new MergedLogCursor();
        int i = 0;
        while (i < this.tables.length) {
            m.add(new LogQueueEntry(this.tables[i].seekLog(refName, updateIdx), i));
            ++i;
        }
        return m;
    }

    @Override
    public void close() throws IOException {
        Reftable[] reftableArray = this.tables;
        int n = this.tables.length;
        int n2 = 0;
        while (n2 < n) {
            Reftable t = reftableArray[n2];
            t.close();
            ++n2;
        }
    }

    int queueSize() {
        return Math.max(1, this.tables.length);
    }

    private static class LogQueueEntry {
        final LogCursor lc;
        final int stackIdx;

        static int compare(LogQueueEntry a, LogQueueEntry b) {
            int cmp = a.name().compareTo(b.name());
            if (cmp == 0) {
                cmp = Long.signum(b.index() - a.index());
            }
            if (cmp == 0) {
                cmp = b.stackIdx - a.stackIdx;
            }
            return cmp;
        }

        LogQueueEntry(LogCursor lc, int stackIdx) {
            this.lc = lc;
            this.stackIdx = stackIdx;
        }

        String name() {
            return this.lc.getRefName();
        }

        long index() {
            return this.lc.getUpdateIndex();
        }
    }

    private class MergedLogCursor
    extends LogCursor {
        private final PriorityQueue<LogQueueEntry> queue;
        private String refName;
        private long updateIndex;
        private ReflogEntry entry;

        MergedLogCursor() {
            this.queue = new PriorityQueue(MergedReftable.this.queueSize(), LogQueueEntry::compare);
        }

        void add(LogQueueEntry t) throws IOException {
            if (t.lc.next()) {
                this.queue.add(t);
            } else {
                t.lc.close();
            }
        }

        @Override
        public boolean next() throws IOException {
            boolean include;
            do {
                LogQueueEntry t;
                if ((t = this.queue.poll()) == null) {
                    return false;
                }
                this.refName = t.lc.getRefName();
                this.updateIndex = t.lc.getUpdateIndex();
                this.entry = t.lc.getReflogEntry();
                include = MergedReftable.this.includeDeletes || this.entry != null;
                this.skipShadowed(this.refName, this.updateIndex);
                this.add(t);
            } while (!include);
            return true;
        }

        private void skipShadowed(String name, long index) throws IOException {
            LogQueueEntry t;
            while ((t = this.queue.peek()) != null && name.equals(t.name()) && index == t.index()) {
                this.add((LogQueueEntry)this.queue.remove());
            }
        }

        @Override
        public String getRefName() {
            return this.refName;
        }

        @Override
        public long getUpdateIndex() {
            return this.updateIndex;
        }

        @Override
        public ReflogEntry getReflogEntry() {
            return this.entry;
        }

        @Override
        public void close() {
            while (!this.queue.isEmpty()) {
                ((LogQueueEntry)this.queue.remove()).lc.close();
            }
        }
    }

    private class MergedRefCursor
    extends RefCursor {
        private final PriorityQueue<RefQueueEntry> queue;
        private RefQueueEntry head;
        private Ref ref;

        MergedRefCursor() {
            this.queue = new PriorityQueue(MergedReftable.this.queueSize(), RefQueueEntry::compare);
        }

        void add(RefQueueEntry t) throws IOException {
            if (!t.rc.next()) {
                t.rc.close();
            } else if (this.head == null) {
                RefQueueEntry p = this.queue.peek();
                if (p == null || RefQueueEntry.compare(t, p) < 0) {
                    this.head = t;
                } else {
                    this.head = this.queue.poll();
                    this.queue.add(t);
                }
            } else if (RefQueueEntry.compare(t, this.head) > 0) {
                this.queue.add(t);
            } else {
                this.queue.add(this.head);
                this.head = t;
            }
        }

        @Override
        public boolean next() throws IOException {
            boolean include;
            do {
                RefQueueEntry t;
                if ((t = this.poll()) == null) {
                    return false;
                }
                this.ref = t.rc.getRef();
                include = MergedReftable.this.includeDeletes || !t.rc.wasDeleted();
                this.add(t);
                this.skipShadowedRefs(this.ref.getName());
            } while (!include);
            return true;
        }

        private RefQueueEntry poll() {
            RefQueueEntry e = this.head;
            if (e != null) {
                this.head = null;
                return e;
            }
            return this.queue.poll();
        }

        private void skipShadowedRefs(String name) throws IOException {
            while (true) {
                RefQueueEntry t;
                RefQueueEntry refQueueEntry = t = this.head != null ? this.head : this.queue.peek();
                if (t == null || !name.equals(t.name())) break;
                this.add(this.poll());
            }
        }

        @Override
        public Ref getRef() {
            return this.ref;
        }

        @Override
        public void close() {
            if (this.head != null) {
                this.head.rc.close();
                this.head = null;
            }
            while (!this.queue.isEmpty()) {
                ((RefQueueEntry)this.queue.remove()).rc.close();
            }
        }
    }

    private static class RefQueueEntry {
        final RefCursor rc;
        final int stackIdx;

        static int compare(RefQueueEntry a, RefQueueEntry b) {
            int cmp = a.name().compareTo(b.name());
            if (cmp == 0) {
                cmp = Long.signum(b.updateIndex() - a.updateIndex());
            }
            if (cmp == 0) {
                cmp = b.stackIdx - a.stackIdx;
            }
            return cmp;
        }

        RefQueueEntry(RefCursor rc, int stackIdx) {
            this.rc = rc;
            this.stackIdx = stackIdx;
        }

        String name() {
            return this.rc.getRef().getName();
        }

        long updateIndex() {
            return this.rc.getRef().getUpdateIndex();
        }
    }
}

