/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.util.graph.selector;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact;
import org.gradle.internal.impldep.org.sonatype.aether.collection.DependencyCollectionContext;
import org.gradle.internal.impldep.org.sonatype.aether.collection.DependencySelector;
import org.gradle.internal.impldep.org.sonatype.aether.graph.Dependency;
import org.gradle.internal.impldep.org.sonatype.aether.graph.Exclusion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusionDependencySelector
implements DependencySelector {
    private final Collection<Exclusion> exclusions;

    public ExclusionDependencySelector() {
        this(Collections.emptySet());
    }

    public ExclusionDependencySelector(Set<Exclusion> exclusions) {
        this.exclusions = exclusions != null && !exclusions.isEmpty() ? exclusions : Collections.emptySet();
    }

    @Override
    public boolean selectDependency(Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        for (Exclusion exclusion : this.exclusions) {
            if (!this.matches(exclusion, artifact)) continue;
            return false;
        }
        return true;
    }

    private boolean matches(Exclusion exclusion, Artifact artifact) {
        if (!this.matches(exclusion.getArtifactId(), artifact.getArtifactId())) {
            return false;
        }
        if (!this.matches(exclusion.getGroupId(), artifact.getGroupId())) {
            return false;
        }
        if (!this.matches(exclusion.getExtension(), artifact.getExtension())) {
            return false;
        }
        return this.matches(exclusion.getClassifier(), artifact.getClassifier());
    }

    private boolean matches(String pattern, String value) {
        return "*".equals(pattern) || pattern.equals(value);
    }

    @Override
    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        Collection<Exclusion> exclusions;
        Dependency dependency = context.getDependency();
        Collection<Exclusion> collection = exclusions = dependency != null ? dependency.getExclusions() : null;
        if (exclusions == null || exclusions.isEmpty()) {
            return this;
        }
        LinkedHashSet<Exclusion> merged = new LinkedHashSet<Exclusion>();
        merged.addAll(this.exclusions);
        merged.addAll(exclusions);
        return new ExclusionDependencySelector(merged);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ExclusionDependencySelector that = (ExclusionDependencySelector)obj;
        return ((Object)this.exclusions).equals(that.exclusions);
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + ((Object)this.exclusions).hashCode();
        return hash;
    }
}

