/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.konan.debugger;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.jetbrains.konan.IdeaKonanWorkspace;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016JB\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/konan/debugger/KonanGradleTaskManagerExtension;", "Lorg/jetbrains/plugins/gradle/service/task/GradleTaskManagerExtension;", "()V", "cancelTask", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "listener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "executeTasks", "taskNames", "", "", "projectPath", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "jvmParametersSetup", "ultimate-native"})
public final class KonanGradleTaskManagerExtension
implements GradleTaskManagerExtension {
    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath2, @Nullable GradleExecutionSettings settings2, @Nullable String jvmParametersSetup, @NotNull ExternalSystemTaskNotificationListener listener2) {
        block9: {
            void $this$mapTo$iv$iv;
            Project project2;
            Object it;
            block8: {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull(taskNames, (String)"taskNames");
                Intrinsics.checkParameterIsNotNull((Object)projectPath2, (String)"projectPath");
                Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
                ProjectManager projectManager = ProjectManager.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
                Project[] projectArray = projectManager.getOpenProjects();
                Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
                Project[] $this$firstOrNull$iv = projectArray;
                boolean $i$f$firstOrNull = false;
                Project[] projectArray2 = $this$firstOrNull$iv;
                int n = projectArray2.length;
                for (int j = 0; j < n; ++j) {
                    Project element$iv;
                    it = element$iv = projectArray2[j];
                    boolean bl = false;
                    Project project3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"it");
                    if (!Intrinsics.areEqual((Object)project3.getBasePath(), (Object)projectPath2)) continue;
                    project2 = element$iv;
                    break block8;
                }
                project2 = null;
            }
            if (project2 == null) {
                return false;
            }
            Project project4 = project2;
            IdeaKonanWorkspace workspace = IdeaKonanWorkspace.Companion.getInstance(project4);
            if (Intrinsics.areEqual((Object)HostManager.Companion.getHost(), (Object)KonanTarget.MINGW_X64.INSTANCE) || workspace.getLldbHome() == null) {
                return super.executeTasks(id, taskNames, projectPath2, settings2, jvmParametersSetup, listener2);
            }
            HashMap params2 = new HashMap();
            String debugServerPath = "";
            KonanTarget konanTarget = HostManager.Companion.getHost();
            if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_X64.INSTANCE)) {
                debugServerPath = "LLDB.framework/Resources/debugserver";
            } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_X64.INSTANCE)) {
                debugServerPath = "bin/lldb-server";
                ((Map)params2).put("DEBUG_SERVER_ARGS", "g");
            }
            Map map2 = params2;
            File file2 = workspace.getLldbHome();
            if (file2 == null) {
                Intrinsics.throwNpe();
            }
            String string = FilesKt.resolve((File)file2, (String)debugServerPath).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"workspace.lldbHome!!.res\u2026bugServerPath).toString()");
            map2.put("DEBUG_SERVER_PATH", string);
            Map $this$map$iv = params2;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var17_22 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator2 = var17_22.entrySet().iterator();
            while (iterator2.hasNext()) {
                void key;
                void $dstr$key$value;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var23_28 = $dstr$key$value;
                boolean bl3 = false;
                String string2 = (String)var23_28.getKey();
                var23_28 = $dstr$key$value;
                bl3 = false;
                String value2 = (String)var23_28.getValue();
                String string3 = (String)key + '=' + value2;
                collection.add(string3);
            }
            String serializedParams = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
            GradleExecutionSettings gradleExecutionSettings = settings2;
            if (gradleExecutionSettings == null) break block9;
            gradleExecutionSettings.putUserData(GradleRunConfiguration.DEBUGGER_PARAMETERS_KEY, (Object)serializedParams);
        }
        return super.executeTasks(id, taskNames, projectPath2, settings2, jvmParametersSetup, listener2);
    }
}

