/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.builder;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclarationKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"collectClassNames", "", "javaFileStub", "Lcom/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "findDelegate", "Lcom/intellij/psi/PsiClass;", "classFqName", "Lorg/jetbrains/kotlin/name/FqName;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "light-classes"})
public final class LightClassDataHolderKt {
    @NotNull
    public static final PsiClass findDelegate(@NotNull PsiJavaFileStub $this$findDelegate, @NotNull KtClassOrObject classOrObject) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$findDelegate, (String)"$this$findDelegate");
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        PsiClass psiClass2 = LightClassUtil.INSTANCE.findClass((StubElement)$this$findDelegate, (Function1)new Function1<PsiClassStub<?>, Boolean>(classOrObject){
            final /* synthetic */ KtClassOrObject $classOrObject;

            public final boolean invoke(@NotNull PsiClassStub<?> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return Intrinsics.areEqual((Object)ClsWrapperStubPsiFactory.getOriginalElement((StubElement)it), (Object)this.$classOrObject);
            }
            {
                this.$classOrObject = ktClassOrObject;
                super(1);
            }
        });
        if (psiClass2 != null) {
            PsiClass psiClass3 = psiClass2;
            boolean bl = false;
            boolean bl2 = false;
            PsiClass it = psiClass3;
            boolean bl3 = false;
            return it;
        }
        KtClassOrObject outermostClassOrObject = KtLightClassForSourceDeclarationKt.getOutermostClassOrObject(classOrObject);
        try {
            PsiFile psiFile2 = outermostClassOrObject.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"outermostClassOrObject.containingFile");
            string = psiFile2.getText();
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw (Throwable)e;
            }
            string = "Can't get text for outermost class";
        }
        String ktFileText = string;
        String string2 = DebugUtil.stubTreeToString((Stub)((Stub)$this$findDelegate));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"DebugUtil.stubTreeToString(this)");
        String stubFileText = string2;
        KotlinExceptionWithAttachments kotlinExceptionWithAttachments = new KotlinExceptionWithAttachments("Couldn't get delegate for class");
        String string3 = classOrObject.getName();
        if (string3 == null) {
            string3 = "unnamed class or object";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"classOrObject.name ?: \"unnamed class or object\"");
        throw (Throwable)kotlinExceptionWithAttachments.withAttachment(string3, DebugTextUtilKt.getDebugText(classOrObject)).withAttachment("file.kt", ktFileText).withAttachment("stub text", stubFileText);
    }

    @NotNull
    public static final PsiClass findDelegate(@NotNull PsiJavaFileStub $this$findDelegate, @NotNull FqName classFqName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$findDelegate, (String)"$this$findDelegate");
        Intrinsics.checkParameterIsNotNull((Object)classFqName, (String)"classFqName");
        PsiClass psiClass2 = LightClassUtil.INSTANCE.findClass((StubElement)$this$findDelegate, (Function1)new Function1<PsiClassStub<?>, Boolean>(classFqName){
            final /* synthetic */ FqName $classFqName;

            public final boolean invoke(@NotNull PsiClassStub<?> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return Intrinsics.areEqual((Object)this.$classFqName.asString(), (Object)it.getQualifiedName());
            }
            {
                this.$classFqName = fqName2;
                super(1);
            }
        });
        if (psiClass2 == null) {
            throw (Throwable)new IllegalStateException("Facade class " + classFqName + " not found; classes in Java file stub: " + LightClassDataHolderKt.collectClassNames($this$findDelegate));
        }
        return psiClass2;
    }

    private static final String collectClassNames(PsiJavaFileStub javaFileStub) {
        boolean bl = false;
        List names2 = new ArrayList();
        LightClassUtil.INSTANCE.findClass((StubElement)javaFileStub, (Function1)new Function1<PsiClassStub<?>, Boolean>(names2){
            final /* synthetic */ List $names;

            public final boolean invoke(@NotNull PsiClassStub<?> cls) {
                Intrinsics.checkParameterIsNotNull(cls, (String)"cls");
                String string = cls.getQualifiedName();
                if (string == null) {
                    string = "<null>";
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cls.qualifiedName ?: \"<null>\"");
                this.$names.add(string);
                return false;
            }
            {
                this.$names = list2;
                super(1);
            }
        });
        return CollectionsKt.joinToString$default((Iterable)names2, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null);
    }
}

