/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.descriptors.WrappedVariableDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetVariableImpl;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LateinitLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "backendContext", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "nullableFields", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "buildOrGetNullableField", "originalField", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "ir.backend.common"})
public final class LateinitLowering
implements FileLoweringPass {
    private final Map<IrField, IrField> nullableFields;
    @NotNull
    private final CommonBackendContext backendContext;

    private final IrField buildOrGetNullableField(IrField originalField) {
        IrField irField;
        if (IrTypePredicatesKt.isMarkedNullable(originalField.getType())) {
            return originalField;
        }
        Map<IrField, IrField> $this$getOrPut$iv = this.nullableFields;
        boolean $i$f$getOrPut = false;
        IrField value$iv = $this$getOrPut$iv.get(originalField);
        if (value$iv == null) {
            boolean bl = false;
            boolean $i$f$buildField = false;
            IrFieldBuilder irFieldBuilder = new IrFieldBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            IrFieldBuilder $this$run$iv = irFieldBuilder;
            boolean bl4 = false;
            IrFieldBuilder $this$buildField = $this$run$iv;
            boolean bl5 = false;
            $this$buildField.updateFrom(originalField);
            $this$buildField.setType(IrTypesKt.makeNullable(originalField.getType()));
            $this$buildField.setName(originalField.getName());
            IrField irField2 = DeclarationBuildersKt.buildField($this$run$iv);
            boolean bl6 = false;
            bl2 = false;
            IrField $this$apply = irField2;
            boolean bl7 = false;
            $this$apply.setParent(originalField.getParent());
            $this$apply.setCorrespondingPropertySymbol(originalField.getCorrespondingPropertySymbol());
            Collection collection = $this$apply.getAnnotations();
            Iterable iterable = originalField.getAnnotations();
            boolean bl8 = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            IrField answer$iv = irField2;
            $this$getOrPut$iv.put(originalField, answer$iv);
            irField = answer$iv;
        } else {
            irField = value$iv;
        }
        return irField;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        boolean bl = false;
        Map nullableVariables = new LinkedHashMap();
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this, nullableVariables){
            final /* synthetic */ LateinitLowering this$0;
            final /* synthetic */ Map $nullableVariables;

            @NotNull
            public IrStatement visitProperty(@NotNull IrProperty declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementTransformerVoidKt.transformChildrenVoid(declaration2, this);
                if (declaration2.isLateinit() && Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE) ^ true) {
                    IrField irField = declaration2.getBackingField();
                    if (irField == null) {
                        Intrinsics.throwNpe();
                    }
                    IrField oldField = irField;
                    IrField newField = LateinitLowering.access$buildOrGetNullableField(this.this$0, oldField);
                    declaration2.setBackingField(newField);
                    IrSimpleFunction irSimpleFunction = declaration2.getGetter();
                    if (irSimpleFunction == null) {
                        Intrinsics.throwNpe();
                    }
                    this.transformGetter(newField, irSimpleFunction);
                }
                return declaration2;
            }

            @NotNull
            public IrStatement visitVariable(@NotNull IrVariable declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementTransformerVoidKt.transformChildrenVoid(declaration2, this);
                if (!declaration2.isLateinit()) {
                    return declaration2;
                }
                WrappedVariableDescriptor descriptor2 = new WrappedVariableDescriptor(null, null, 3, null);
                IrType type2 = IrTypesKt.makeNullable(declaration2.getType());
                IrVariableImpl irVariableImpl = new IrVariableImpl(declaration2.getStartOffset(), declaration2.getEndOffset(), declaration2.getOrigin(), new IrVariableSymbolImpl(descriptor2, 0L, 2, null), declaration2.getName(), type2, true, false, true);
                boolean bl = false;
                boolean bl2 = false;
                IrVariableImpl it = irVariableImpl;
                boolean bl3 = false;
                descriptor2.bind((IrDeclaration)it);
                it.setParent(declaration2.getParent());
                it.setInitializer(IrConstImpl.Companion.constNull(declaration2.getStartOffset(), declaration2.getEndOffset(), this.this$0.getBackendContext().getIrBuiltIns().getNothingNType()));
                IrVariableImpl newVar = irVariableImpl;
                this.$nullableVariables.put(declaration2, newVar);
                return newVar;
            }

            private final void transformGetter(IrField backingField2, IrFunction getter2) {
                IrGetValueImpl irGetValueImpl;
                DeclarationIrBuilder irBuilder;
                IrType type2 = backingField2.getType();
                boolean bl = !IrTypePredicatesKt.isPrimitiveType(type2);
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-LateinitLowering$lower$1$transformGetter$22 = false;
                    String $i$a$-assert-LateinitLowering$lower$1$transformGetter$22 = "'lateinit' modifier is not allowed on primitive types";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-LateinitLowering$lower$1$transformGetter$22));
                }
                int startOffset = getter2.getStartOffset();
                int endOffset = getter2.getEndOffset();
                DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getBackendContext(), getter2.getSymbol(), startOffset, endOffset);
                boolean bl3 = false;
                boolean bl4 = false;
                DeclarationIrBuilder $this$run = declarationIrBuilder;
                boolean bl5 = false;
                IrBlockBodyImpl body2 = new IrBlockBodyImpl(startOffset, endOffset);
                Scope scope2 = $this$run.getScope();
                IrBuilderWithScope irBuilderWithScope = $this$run;
                IrValueParameter irValueParameter = getter2.getDispatchReceiverParameter();
                if (irValueParameter != null) {
                    IrValueParameter irValueParameter2 = irValueParameter;
                    IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
                    Scope scope3 = scope2;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    IrValueParameter it = irValueParameter2;
                    boolean bl8 = false;
                    IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet($this$run, it);
                    scope2 = scope3;
                    irBuilderWithScope = irBuilderWithScope2;
                    irGetValueImpl = irGetValueImpl2;
                } else {
                    irGetValueImpl = null;
                }
                IrVariable resultVar = Scope.createTemporaryVariable$default(scope2, ExpressionHelpersKt.irGetField(irBuilderWithScope, irGetValueImpl, backingField2), null, false, null, null, null, 62, null);
                resultVar.setParent(getter2);
                body2.getStatements().add(resultVar);
                IrBuilderWithScope irBuilderWithScope3 = $this$run;
                IrType irType = $this$run.getContext().getIrBuiltIns().getNothingType();
                IrExpression irExpression = ExpressionHelpersKt.irNotEquals($this$run, ExpressionHelpersKt.irGet($this$run, resultVar), ExpressionHelpersKt.irNull($this$run));
                IrExpression irExpression2 = ExpressionHelpersKt.irReturn($this$run, ExpressionHelpersKt.irGet($this$run, resultVar));
                CommonBackendContext commonBackendContext = this.this$0.getBackendContext();
                IrBuilderWithScope irBuilderWithScope4 = $this$run;
                String string = backingField2.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"backingField.name.asString()");
                IrIfThenElseImpl throwIfNull = ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope3, irType, irExpression, irExpression2, commonBackendContext.throwUninitializedPropertyAccessException(irBuilderWithScope4, string), null, 16, null);
                body2.getStatements().add(throwIfNull);
                getter2.setBody(body2);
            }
            {
                this.this$0 = $outer;
                this.$nullableVariables = $captured_local_variable$1;
            }
        });
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this, nullableVariables){
            final /* synthetic */ LateinitLowering this$0;
            final /* synthetic */ Map $nullableVariables;

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                DeclarationIrBuilder irBuilder;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Map map2 = this.$nullableVariables;
                IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                boolean bl = false;
                IrVariable irVariable2 = (IrVariable)map2.get(irValueDeclaration);
                if (irVariable2 == null) {
                    return expression2;
                }
                IrVariable irVar = irVariable2;
                IrDeclarationParent irDeclarationParent = irVar.getParent();
                if (irDeclarationParent == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
                }
                IrSymbolOwner parent2 = (IrSymbolOwner)((Object)irDeclarationParent);
                DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getBackendContext(), parent2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
                boolean bl2 = false;
                boolean bl3 = false;
                DeclarationIrBuilder $this$run = declarationIrBuilder;
                boolean bl4 = false;
                IrBuilderWithScope irBuilderWithScope = $this$run;
                IrType irType = expression2.getType();
                IrExpression irExpression = ExpressionHelpersKt.irEqualsNull($this$run, ExpressionHelpersKt.irGet($this$run, irVar));
                CommonBackendContext commonBackendContext = this.this$0.getBackendContext();
                IrBuilderWithScope irBuilderWithScope2 = $this$run;
                String string = irVar.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"irVar.name.asString()");
                return ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope, irType, irExpression, commonBackendContext.throwUninitializedPropertyAccessException(irBuilderWithScope2, string), ExpressionHelpersKt.irGet($this$run, irVar), null, 16, null);
            }

            @NotNull
            public IrExpression visitSetVariable(@NotNull IrSetVariable expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrVariable irVariable2 = (IrVariable)this.$nullableVariables.get(expression2.getSymbol().getOwner());
                if (irVariable2 == null) {
                    return expression2;
                }
                IrVariable newVar = irVariable2;
                boolean bl = false;
                boolean bl2 = false;
                IrSetVariable $this$with = expression2;
                boolean bl3 = false;
                return new IrSetVariableImpl($this$with.getStartOffset(), $this$with.getEndOffset(), $this$with.getType(), (IrVariableSymbol)newVar.getSymbol(), $this$with.getValue(), $this$with.getOrigin());
            }

            @NotNull
            public IrExpression visitGetField(@NotNull IrGetField expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrField irField = (IrField)LateinitLowering.access$getNullableFields$p(this.this$0).get(expression2.getSymbol().getOwner());
                if (irField == null) {
                    return expression2;
                }
                IrField newField = irField;
                boolean bl = false;
                boolean bl2 = false;
                IrGetField $this$with = expression2;
                boolean bl3 = false;
                return new IrGetFieldImpl($this$with.getStartOffset(), $this$with.getEndOffset(), (IrFieldSymbol)newField.getSymbol(), newField.getType(), $this$with.getReceiver(), $this$with.getOrigin(), $this$with.getSuperQualifierSymbol());
            }

            @NotNull
            public IrExpression visitSetField(@NotNull IrSetField expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrField irField = (IrField)LateinitLowering.access$getNullableFields$p(this.this$0).get(expression2.getSymbol().getOwner());
                if (irField == null) {
                    return expression2;
                }
                IrField newField = irField;
                boolean bl = false;
                boolean bl2 = false;
                IrSetField $this$with = expression2;
                boolean bl3 = false;
                return new IrSetFieldImpl($this$with.getStartOffset(), $this$with.getEndOffset(), (IrFieldSymbol)newField.getSymbol(), $this$with.getReceiver(), $this$with.getValue(), $this$with.getType(), $this$with.getOrigin(), $this$with.getSuperQualifierSymbol());
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                if (!Symbols.Companion.isLateinitIsInitializedPropertyGetter(expression2.getSymbol())) {
                    return expression2;
                }
                IrExpression irExpression = expression2.getExtensionReceiver();
                if (irExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrPropertyReference");
                }
                IrPropertyReference receiver2 = (IrPropertyReference)irExpression;
                Object object = receiver2.getGetter();
                IrBindableSymbol<PropertyDescriptor, IrProperty> irBindableSymbol = object != null && (object = (IrSimpleFunction)object.getOwner()) != null && (object = IrUtilsKt.resolveFakeOverride((IrSimpleFunction)object)) != null ? object.getCorrespondingPropertySymbol() : null;
                if (irBindableSymbol == null) {
                    Intrinsics.throwNpe();
                }
                B b = irBindableSymbol.getOwner();
                boolean bl = false;
                boolean bl2 = false;
                IrProperty it = (IrProperty)b;
                boolean bl3 = false;
                boolean bl4 = it.isLateinit();
                boolean bl5 = false;
                boolean bl6 = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl7 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                IrProperty property2 = (IrProperty)b;
                LateinitLowering lateinitLowering = this.this$0;
                IrField irField = property2.getBackingField();
                if (irField == null) {
                    String string = "Lateinit property is supposed to have backing field";
                    LateinitLowering lateinitLowering2 = lateinitLowering;
                    bl2 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                IrField nullableField = LateinitLowering.access$buildOrGetNullableField(lateinitLowering, irField);
                Object object2 = expression2;
                bl2 = false;
                boolean bl8 = false;
                Object $this$run = object2;
                boolean bl9 = false;
                object2 = LowerUtilsKt.createIrBuilder(this.this$0.getBackendContext(), $this$run.getSymbol(), $this$run.getStartOffset(), $this$run.getEndOffset());
                bl2 = false;
                bl8 = false;
                $this$run = object2;
                boolean bl10 = false;
                return ExpressionHelpersKt.irNotEquals((IrBuilderWithScope)$this$run, ExpressionHelpersKt.irGetField((IrBuilderWithScope)$this$run, receiver2.getDispatchReceiver(), nullableField), ExpressionHelpersKt.irNull((IrBuilderWithScope)$this$run));
            }
            {
                this.this$0 = $outer;
                this.$nullableVariables = $captured_local_variable$1;
            }
        });
    }

    @NotNull
    public final CommonBackendContext getBackendContext() {
        return this.backendContext;
    }

    public LateinitLowering(@NotNull CommonBackendContext backendContext) {
        Intrinsics.checkParameterIsNotNull((Object)backendContext, (String)"backendContext");
        this.backendContext = backendContext;
        this.nullableFields = this.backendContext.getLateinitNullableFields();
    }

    public static final /* synthetic */ IrField access$buildOrGetNullableField(LateinitLowering $this, IrField originalField) {
        return $this.buildOrGetNullableField(originalField);
    }

    public static final /* synthetic */ Map access$getNullableFields$p(LateinitLowering $this) {
        return $this.nullableFields;
    }
}

