/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.ConstLoweringKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\r*\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ConstLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "lowerConstRead", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "backend.jvm"})
public final class ConstLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        this.transformChildrenVoid(irFile);
    }

    private final IrExpression lowerConstRead(@NotNull IrExpression $this$lowerConstRead, IrField field2) {
        IrStatement irStatement = field2;
        if (irStatement == null || (irStatement = ConstLoweringKt.constantValue$default(irStatement, null, 1, null)) == null) {
            return null;
        }
        IrStatement value2 = irStatement;
        return this.context.getState().getShouldInlineConstVals() ? (IrExpressionBase)ConstLoweringKt.access$copyWithOffsets((IrConst)value2, $this$lowerConstRead.getStartOffset(), $this$lowerConstRead.getEndOffset()) : (IrExpressionBase)new IrGetFieldImpl($this$lowerConstRead.getStartOffset(), $this$lowerConstRead.getEndOffset(), (IrFieldSymbol)field2.getSymbol(), field2.getType(), null, null, 48, null);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrFunction irFunction = expression2.getSymbol().getOwner();
        if (!(irFunction instanceof IrSimpleFunction)) {
            irFunction = null;
        }
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)irFunction;
        if (irSimpleFunction == null) {
            return super.visitCall(expression2);
        }
        IrSimpleFunction function2 = irSimpleFunction;
        Object object = function2.getCorrespondingPropertySymbol();
        if (object == null || (object = (IrProperty)object.getOwner()) == null) {
            return super.visitCall(expression2);
        }
        Object property2 = object;
        IrExpression irExpression = this.lowerConstRead(expression2, property2.getBackingField());
        if (irExpression == null) {
            irExpression = super.visitCall(expression2);
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrExpression irExpression = this.lowerConstRead(expression2, (IrField)expression2.getSymbol().getOwner());
        if (irExpression == null) {
            irExpression = super.visitGetField(expression2);
        }
        return irExpression;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public ConstLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
    }
}

