/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.description;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.ContractDescriptionVisitor;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.ContractDescriptionValue;
import org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalAnd;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalOr;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u001d\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010#J\u001d\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010'J\u001d\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010+J\u001d\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010/J\u001d\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u0002022\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u00103J\u001d\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u0002062\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u00107J\f\u00108\u001a\u00020\u000e*\u00020\tH\u0002R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/contracts/description/ContractDescriptionRenderer;", "Lorg/jetbrains/kotlin/contracts/description/ContractDescriptionVisitor;", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/lang/StringBuilder;)V", "inBracketsIfNecessary", "parent", "Lorg/jetbrains/kotlin/contracts/description/ContractDescriptionElement;", "child", "block", "Lkotlin/Function0;", "needsBrackets", "", "visitCallsEffectDeclaration", "callsEffect", "Lorg/jetbrains/kotlin/contracts/description/CallsEffectDeclaration;", "data", "(Lorg/jetbrains/kotlin/contracts/description/CallsEffectDeclaration;Lkotlin/Unit;)V", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/contracts/description/ConditionalEffectDeclaration;", "(Lorg/jetbrains/kotlin/contracts/description/ConditionalEffectDeclaration;Lkotlin/Unit;)V", "visitConstantDescriptor", "constantReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;Lkotlin/Unit;)V", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/contracts/description/expressions/IsInstancePredicate;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/IsInstancePredicate;Lkotlin/Unit;)V", "visitIsNullPredicate", "isNullPredicate", "Lorg/jetbrains/kotlin/contracts/description/expressions/IsNullPredicate;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/IsNullPredicate;Lkotlin/Unit;)V", "visitLogicalAnd", "logicalAnd", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalAnd;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalAnd;Lkotlin/Unit;)V", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalNot;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalNot;Lkotlin/Unit;)V", "visitLogicalOr", "logicalOr", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalOr;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalOr;Lkotlin/Unit;)V", "visitReturnsEffectDeclaration", "returnsEffect", "Lorg/jetbrains/kotlin/contracts/description/ReturnsEffectDeclaration;", "(Lorg/jetbrains/kotlin/contracts/description/ReturnsEffectDeclaration;Lkotlin/Unit;)V", "visitVariableReference", "variableReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;Lkotlin/Unit;)V", "isAtom", "resolution"})
public final class ContractDescriptionRenderer
implements ContractDescriptionVisitor<Unit, Unit> {
    private final StringBuilder builder;

    @Override
    public void visitConditionalEffectDeclaration(@NotNull ConditionalEffectDeclaration conditionalEffect, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)conditionalEffect, (String)"conditionalEffect");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        conditionalEffect.getEffect().accept(this, data2);
        this.builder.append(" -> ");
        conditionalEffect.getCondition().accept(this, data2);
    }

    @Override
    public void visitReturnsEffectDeclaration(@NotNull ReturnsEffectDeclaration returnsEffect, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)returnsEffect, (String)"returnsEffect");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        this.builder.append("Returns(");
        returnsEffect.getValue().accept(this, data2);
        this.builder.append(")");
    }

    @Override
    public void visitCallsEffectDeclaration(@NotNull CallsEffectDeclaration callsEffect, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)callsEffect, (String)"callsEffect");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        this.builder.append("CallsInPlace(");
        callsEffect.getVariableReference().accept(this, data2);
        this.builder.append(", " + (Object)((Object)callsEffect.getKind()) + ')');
    }

    @Override
    public void visitLogicalOr(@NotNull LogicalOr logicalOr, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)logicalOr, (String)"logicalOr");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        this.inBracketsIfNecessary(logicalOr, logicalOr.getLeft(), (Function0<Unit>)((Function0)new Function0<Unit>(this, logicalOr, data2){
            final /* synthetic */ ContractDescriptionRenderer this$0;
            final /* synthetic */ LogicalOr $logicalOr;
            final /* synthetic */ Unit $data;

            public final void invoke() {
                this.$logicalOr.getLeft().accept(this.this$0, this.$data);
            }
            {
                this.this$0 = contractDescriptionRenderer;
                this.$logicalOr = logicalOr;
                this.$data = unit;
                super(0);
            }
        }));
        this.builder.append(" || ");
        this.inBracketsIfNecessary(logicalOr, logicalOr.getRight(), (Function0<Unit>)((Function0)new Function0<Unit>(this, logicalOr, data2){
            final /* synthetic */ ContractDescriptionRenderer this$0;
            final /* synthetic */ LogicalOr $logicalOr;
            final /* synthetic */ Unit $data;

            public final void invoke() {
                this.$logicalOr.getRight().accept(this.this$0, this.$data);
            }
            {
                this.this$0 = contractDescriptionRenderer;
                this.$logicalOr = logicalOr;
                this.$data = unit;
                super(0);
            }
        }));
    }

    @Override
    public void visitLogicalAnd(@NotNull LogicalAnd logicalAnd, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)logicalAnd, (String)"logicalAnd");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        this.inBracketsIfNecessary(logicalAnd, logicalAnd.getLeft(), (Function0<Unit>)((Function0)new Function0<Unit>(this, logicalAnd, data2){
            final /* synthetic */ ContractDescriptionRenderer this$0;
            final /* synthetic */ LogicalAnd $logicalAnd;
            final /* synthetic */ Unit $data;

            public final void invoke() {
                this.$logicalAnd.getLeft().accept(this.this$0, this.$data);
            }
            {
                this.this$0 = contractDescriptionRenderer;
                this.$logicalAnd = logicalAnd;
                this.$data = unit;
                super(0);
            }
        }));
        this.builder.append(" && ");
        this.inBracketsIfNecessary(logicalAnd, logicalAnd.getRight(), (Function0<Unit>)((Function0)new Function0<Unit>(this, logicalAnd, data2){
            final /* synthetic */ ContractDescriptionRenderer this$0;
            final /* synthetic */ LogicalAnd $logicalAnd;
            final /* synthetic */ Unit $data;

            public final void invoke() {
                this.$logicalAnd.getRight().accept(this.this$0, this.$data);
            }
            {
                this.this$0 = contractDescriptionRenderer;
                this.$logicalAnd = logicalAnd;
                this.$data = unit;
                super(0);
            }
        }));
    }

    @Override
    public void visitLogicalNot(@NotNull LogicalNot logicalNot, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)logicalNot, (String)"logicalNot");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        this.inBracketsIfNecessary(logicalNot, logicalNot.getArg(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ContractDescriptionRenderer this$0;

            public final void invoke() {
                ContractDescriptionRenderer.access$getBuilder$p(this.this$0).append("!");
            }
            {
                this.this$0 = contractDescriptionRenderer;
                super(0);
            }
        }));
        logicalNot.getArg().accept(this, data2);
    }

    @Override
    public void visitIsInstancePredicate(@NotNull IsInstancePredicate isInstancePredicate, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)isInstancePredicate, (String)"isInstancePredicate");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        isInstancePredicate.getArg().accept(this, data2);
        this.builder.append(' ' + (isInstancePredicate.isNegated() ? "!" : "") + "is " + isInstancePredicate.getType());
    }

    @Override
    public void visitIsNullPredicate(@NotNull IsNullPredicate isNullPredicate, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)isNullPredicate, (String)"isNullPredicate");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        isNullPredicate.getArg().accept(this, data2);
        this.builder.append(' ' + (isNullPredicate.isNegated() ? "!=" : "==") + " null");
    }

    @Override
    public void visitConstantDescriptor(@NotNull ConstantReference constantReference, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)constantReference, (String)"constantReference");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        this.builder.append(constantReference.getName());
    }

    @Override
    public void visitVariableReference(@NotNull VariableReference variableReference, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)variableReference, (String)"variableReference");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        this.builder.append(variableReference.getDescriptor().getName());
    }

    private final boolean isAtom(@NotNull ContractDescriptionElement $this$isAtom) {
        return $this$isAtom instanceof VariableReference || $this$isAtom instanceof ConstantReference || $this$isAtom instanceof IsNullPredicate || $this$isAtom instanceof IsInstancePredicate;
    }

    private final boolean needsBrackets(ContractDescriptionElement parent2, ContractDescriptionElement child) {
        if (this.isAtom(child)) {
            return false;
        }
        if (parent2 instanceof LogicalNot) {
            return true;
        }
        return Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(parent2.getClass()), (Object)Reflection.getOrCreateKotlinClass(child.getClass())) ^ true;
    }

    private final void inBracketsIfNecessary(ContractDescriptionElement parent2, ContractDescriptionElement child, Function0<Unit> block) {
        if (this.needsBrackets(parent2, child)) {
            this.builder.append("(");
            block.invoke();
            this.builder.append(")");
        } else {
            block.invoke();
        }
    }

    public ContractDescriptionRenderer(@NotNull StringBuilder builder2) {
        Intrinsics.checkParameterIsNotNull((Object)builder2, (String)"builder");
        this.builder = builder2;
    }

    @Override
    public void visitContractDescriptionElement(@NotNull ContractDescriptionElement contractDescriptionElement, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)contractDescriptionElement, (String)"contractDescriptionElement");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        ContractDescriptionVisitor.DefaultImpls.visitContractDescriptionElement(this, contractDescriptionElement, data2);
    }

    @Override
    public void visitEffectDeclaration(@NotNull EffectDeclaration effectDeclaration, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)effectDeclaration, (String)"effectDeclaration");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        ContractDescriptionVisitor.DefaultImpls.visitEffectDeclaration(this, effectDeclaration, data2);
    }

    @Override
    public void visitBooleanExpression(@NotNull BooleanExpression booleanExpression, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)booleanExpression, (String)"booleanExpression");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        ContractDescriptionVisitor.DefaultImpls.visitBooleanExpression(this, booleanExpression, data2);
    }

    @Override
    public void visitValue(@NotNull ContractDescriptionValue value2, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        ContractDescriptionVisitor.DefaultImpls.visitValue(this, value2, data2);
    }

    @Override
    public void visitBooleanConstantDescriptor(@NotNull BooleanConstantReference booleanConstantDescriptor, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)booleanConstantDescriptor, (String)"booleanConstantDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        ContractDescriptionVisitor.DefaultImpls.visitBooleanConstantDescriptor(this, booleanConstantDescriptor, data2);
    }

    @Override
    public void visitBooleanVariableReference(@NotNull BooleanVariableReference booleanVariableReference, @NotNull Unit data2) {
        Intrinsics.checkParameterIsNotNull((Object)booleanVariableReference, (String)"booleanVariableReference");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        ContractDescriptionVisitor.DefaultImpls.visitBooleanVariableReference(this, booleanVariableReference, data2);
    }

    public static final /* synthetic */ StringBuilder access$getBuilder$p(ContractDescriptionRenderer $this) {
        return $this.builder;
    }
}

