/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSealedClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSealedClassInheritorsTransformer;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J/\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u0002H\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "()V", "transformElement", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "InheritorsCollector", "InheritorsTransformer", "resolve"})
public final class FirSealedClassInheritorsTransformer
extends FirTransformer {
    @NotNull
    public <E extends FirElement> CompositeTransformResult<E> transformElement(@NotNull E element3, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(element3, (String)"element");
        throw (Throwable)new IllegalStateException("Should not be there");
    }

    @NotNull
    public CompositeTransformResult<FirDeclaration> transformFile(@NotNull FirFile file2, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        boolean bl = false;
        Map sealedClassInheritorsMap = new LinkedHashMap();
        file2.accept(InheritorsCollector.INSTANCE, sealedClassInheritorsMap);
        if (sealedClassInheritorsMap.isEmpty()) {
            FirElement $this$compose$iv = file2;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }
        return file2.transform(new InheritorsTransformer(sealedClassInheritorsMap), null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\u0002\u0010\bJ/\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u0002H\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\u0006\u0010\u0019\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsTransformer$InheritorsTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "inheritorsMap", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSealedClass;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "(Ljava/util/Map;)V", "transformElement", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformSealedClass", "sealedClass", "resolve"})
    private static final class InheritorsTransformer
    extends FirTransformer {
        private final Map<FirSealedClass, List<ClassId>> inheritorsMap;

        @NotNull
        public <E extends FirElement> CompositeTransformResult<E> transformElement(@NotNull E element3, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(element3, (String)"element");
            E $this$compose$iv = element3;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }

        @NotNull
        public CompositeTransformResult<FirDeclaration> transformFile(@NotNull FirFile file2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            FirElement firElement = file2.transformChildren(this, data2);
            if (firElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirFile");
            }
            FirElement $this$compose$iv = (FirFile)firElement;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }

        @NotNull
        public CompositeTransformResult<FirStatement> transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull((Object)regularClass, (String)"regularClass");
            if (this.inheritorsMap.isEmpty()) {
                FirElement $this$compose$iv = regularClass;
                boolean $i$f$compose = false;
                return CompositeTransformResult.Companion.single($this$compose$iv);
            }
            FirElement firElement = regularClass.transformChildren(this, data2);
            if (firElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
            }
            FirElement $this$compose$iv = (FirRegularClass)firElement;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }

        @NotNull
        public CompositeTransformResult<FirStatement> transformSealedClass(@NotNull FirSealedClass sealedClass, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull((Object)sealedClass, (String)"sealedClass");
            List<ClassId> inheritors2 = this.inheritorsMap.remove(sealedClass);
            if (inheritors2 != null) {
                sealedClass.replaceInheritors(inheritors2);
            }
            return this.transformRegularClass((FirRegularClass)sealedClass, data2);
        }

        public InheritorsTransformer(@NotNull Map<FirSealedClass, List<ClassId>> inheritorsMap) {
            Intrinsics.checkParameterIsNotNull(inheritorsMap, (String)"inheritorsMap");
            this.inheritorsMap = inheritorsMap;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016J*\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016J*\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\t2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsTransformer$InheritorsCollector;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSealedClass;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "()V", "extractClassFromTypeRef", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/FirSymbolProvider;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "visitRegularClass", "regularClass", "resolve"})
    private static final class InheritorsCollector
    extends FirDefaultVisitor<Unit, Map<FirSealedClass, List<ClassId>>> {
        public static final InheritorsCollector INSTANCE;

        @Override
        public void visitElement(@NotNull FirElement element3, @NotNull Map<FirSealedClass, List<ClassId>> data2) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull(data2, (String)"data");
        }

        @Override
        public void visitFile(@NotNull FirFile file2, @NotNull Map<FirSealedClass, List<ClassId>> data2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull(data2, (String)"data");
            Iterable $this$forEach$iv = file2.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl = false;
                it.accept(INSTANCE, data2);
            }
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull Map<FirSealedClass, List<ClassId>> data2) {
            FirDeclaration it;
            Intrinsics.checkParameterIsNotNull((Object)regularClass, (String)"regularClass");
            Intrinsics.checkParameterIsNotNull(data2, (String)"data");
            Iterable $this$forEach$iv = regularClass.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                it.accept(INSTANCE, data2);
            }
            FirSymbolProvider symbolProvider2 = ResolveUtilsKt.getFirSymbolProvider(regularClass.getSession());
            for (FirTypeRef typeRef : regularClass.getSuperTypeRefs()) {
                List<ClassId> inheritors2;
                FirDeclaration parent2;
                Modality modality2;
                it = this.extractClassFromTypeRef(symbolProvider2, typeRef);
                boolean bl = false;
                boolean bl2 = false;
                FirDeclaration it2 = it;
                boolean bl3 = false;
                FirDeclaration firDeclaration = it2;
                if (firDeclaration != null) {
                    FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)firDeclaration;
                    boolean $i$f$getModality = false;
                    modality2 = $this$modality$iv.getStatus().getModality();
                } else {
                    modality2 = null;
                }
                FirDeclaration firDeclaration2 = modality2 == Modality.SEALED ? it : null;
                if (firDeclaration2 == null) {
                    continue;
                }
                FirDeclaration firDeclaration3 = parent2 = firDeclaration2;
                if (firDeclaration3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirSealedClass");
                }
                Intrinsics.checkExpressionValueIsNotNull(data2.computeIfAbsent((FirSealedClass)firDeclaration3, visitRegularClass.inheritors.1.INSTANCE), (String)"data.computeIfAbsent(par\u2026lass) { mutableListOf() }");
                Collection collection = inheritors2;
                ClassId classId = regularClass.getSymbol().getClassId();
                boolean bl4 = false;
                collection.add(classId);
            }
        }

        private final FirRegularClass extractClassFromTypeRef(FirSymbolProvider symbolProvider2, FirTypeRef typeRef) {
            FirClassifierSymbol<?> classLikeSymbol;
            Object object;
            FirTypeRef firTypeRef = typeRef;
            if (firTypeRef == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
            }
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)firTypeRef).getType();
            if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                coneKotlinType = null;
            }
            if ((object = (ConeLookupTagBasedType)coneKotlinType) == null || (object = ((ConeLookupTagBasedType)object).getLookupTag()) == null) {
                return null;
            }
            Object lookupTag = object;
            FirClassifierSymbol<?> firClassifierSymbol = symbolProvider2.getSymbolByLookupTag((ConeClassifierLookupTag)lookupTag);
            if (firClassifierSymbol == null) {
                return null;
            }
            FirClassifierSymbol<?> firClassifierSymbol2 = classLikeSymbol = firClassifierSymbol;
            return firClassifierSymbol2 instanceof FirRegularClassSymbol ? (FirRegularClass)((FirRegularClassSymbol)classLikeSymbol).getFir() : (firClassifierSymbol2 instanceof FirTypeAliasSymbol ? this.extractClassFromTypeRef(symbolProvider2, ((FirTypeAlias)((FirTypeAliasSymbol)classLikeSymbol).getFir()).getExpandedTypeRef()) : null);
        }

        private InheritorsCollector() {
        }

        static {
            InheritorsCollector inheritorsCollector;
            INSTANCE = inheritorsCollector = new InheritorsCollector();
        }
    }
}

