/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.TypeRendererKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\u001c\u0010\u0004\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001d\u0010\t\u001a\u00020\b*\u0004\u0018\u00010\u0006\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0003\u0010\u0000\u00a8\u0006\n"}, d2={"render", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinTypeProjection;", "renderFunctionType", "kind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassDescriptor$Kind;", "isExtension", "", "withPrettyRender", "cones"})
public final class TypeRendererKt {
    @NotNull
    public static final String render(@NotNull ConeKotlinType $this$render) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$render, (String)"$this$render");
        String nullabilitySuffix = !($this$render instanceof ConeClassErrorType) && !($this$render instanceof ConeClassErrorType) ? $this$render.getNullability().getSuffix() : "";
        StringBuilder stringBuilder2 = new StringBuilder();
        ConeKotlinType coneKotlinType = $this$render;
        if (coneKotlinType instanceof ConeTypeVariableType) {
            string = "TypeVariable(" + ((ConeTypeVariableType)$this$render).getLookupTag().getName() + ')';
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            string = TypeRendererKt.render(((ConeDefinitelyNotNullType)$this$render).getOriginal()) + '!';
        } else if (coneKotlinType instanceof ConeClassErrorType) {
            string = "class error: " + ((ConeClassErrorType)$this$render).getReason();
        } else if (coneKotlinType instanceof ConeCapturedType) {
            ConeKotlinType coneKotlinType2 = ((ConeCapturedType)$this$render).getLowerType();
            string = "captured type: lowerType = " + (coneKotlinType2 != null ? TypeRendererKt.render(coneKotlinType2) : null);
        } else if (coneKotlinType instanceof ConeClassLikeType) {
            StringBuilder stringBuilder3 = stringBuilder2;
            boolean bl = false;
            StringBuilder stringBuilder4 = new StringBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            StringBuilder $this$buildString = stringBuilder4;
            boolean bl4 = false;
            $this$buildString.append(((ConeClassLikeType)$this$render).getLookupTag().getClassId().asString());
            ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = $this$render.getTypeArguments();
            boolean bl5 = false;
            ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray2 = coneKotlinTypeProjectionArray;
            boolean bl6 = false;
            if (!(coneKotlinTypeProjectionArray2.length == 0)) {
                $this$buildString.append(ArraysKt.joinToString$default((Object[])$this$render.getTypeArguments(), null, (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)render.1.1.INSTANCE, (int)25, null));
            }
            String string2 = stringBuilder4.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            String string3 = string2;
            stringBuilder2 = stringBuilder3;
            string = string3;
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            String string4 = ((ConeLookupTagBasedType)$this$render).getLookupTag().getName().asString();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"lookupTag.name.asString()");
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            StringBuilder stringBuilder5 = stringBuilder2;
            boolean bl = false;
            StringBuilder stringBuilder6 = new StringBuilder();
            boolean bl7 = false;
            boolean bl8 = false;
            StringBuilder $this$buildString = stringBuilder6;
            boolean bl9 = false;
            $this$buildString.append("ft<");
            $this$buildString.append(TypeRendererKt.render(((ConeFlexibleType)$this$render).getLowerBound()));
            $this$buildString.append(", ");
            $this$buildString.append(TypeRendererKt.render(((ConeFlexibleType)$this$render).getUpperBound()));
            $this$buildString.append(">");
            String string5 = stringBuilder6.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
            String string6 = string5;
            stringBuilder2 = stringBuilder5;
            string = string6;
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            string = CollectionsKt.joinToString$default((Iterable)((ConeIntersectionType)$this$render).getIntersectedTypes(), (CharSequence)" & ", (CharSequence)"it(", (CharSequence)")", (int)0, null, null, (int)56, null);
        } else if (coneKotlinType instanceof ConeStubType) {
            string = "stub type: " + ((ConeStubType)$this$render).getVariable();
        } else if (coneKotlinType instanceof ConeIntegerLiteralType) {
            string = "ILT: " + ((ConeIntegerLiteralType)$this$render).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return stringBuilder2.append(string).append(nullabilitySuffix).toString();
    }

    private static final String render(@NotNull ConeKotlinTypeProjection $this$render) {
        String string;
        ConeKotlinTypeProjection coneKotlinTypeProjection = $this$render;
        if (Intrinsics.areEqual((Object)coneKotlinTypeProjection, (Object)ConeStarProjection.INSTANCE)) {
            string = "*";
        } else if (coneKotlinTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            string = "in " + TypeRendererKt.render(((ConeKotlinTypeProjectionIn)$this$render).getType());
        } else if (coneKotlinTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            string = "out " + TypeRendererKt.render(((ConeKotlinTypeProjectionOut)$this$render).getType());
        } else if (coneKotlinTypeProjection instanceof ConeKotlinType) {
            string = TypeRendererKt.render((ConeKotlinType)$this$render);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderFunctionType(@NotNull ConeKotlinType $this$renderFunctionType, @Nullable FunctionClassDescriptor.Kind kind2, boolean isExtension) {
        void receiver2;
        Intrinsics.checkParameterIsNotNull((Object)$this$renderFunctionType, (String)"$this$renderFunctionType");
        if (!TypeRendererKt.withPrettyRender(kind2)) {
            return TypeRendererKt.render($this$renderFunctionType);
        }
        boolean bl = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder2;
        boolean bl4 = false;
        if (kind2 == FunctionClassDescriptor.Kind.SuspendFunction) {
            $this$buildString.append("suspend ");
        }
        Pair pair2 = isExtension && Intrinsics.areEqual((Object)((ConeKotlinTypeProjection)ArraysKt.first((Object[])$this$renderFunctionType.getTypeArguments())), (Object)ConeStarProjection.INSTANCE) ^ true ? TuplesKt.to((Object)ArraysKt.first((Object[])$this$renderFunctionType.getTypeArguments()), (Object)ArraysKt.drop((Object[])$this$renderFunctionType.getTypeArguments(), (int)1)) : TuplesKt.to(null, (Object)ArraysKt.toList((Object[])$this$renderFunctionType.getTypeArguments()));
        ConeKotlinTypeProjection coneKotlinTypeProjection = (ConeKotlinTypeProjection)pair2.component1();
        List otherTypeArguments = (List)pair2.component2();
        List arguments2 = otherTypeArguments.subList(0, otherTypeArguments.size() - 1);
        ConeKotlinTypeProjection returnType2 = (ConeKotlinTypeProjection)CollectionsKt.last((List)otherTypeArguments);
        if (receiver2 != null) {
            $this$buildString.append(TypeRendererKt.render((ConeKotlinTypeProjection)receiver2));
            $this$buildString.append(".");
        }
        $this$buildString.append(CollectionsKt.joinToString$default((Iterable)arguments2, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)renderFunctionType.1.1.INSTANCE, (int)24, null));
        $this$buildString.append(" -> ");
        $this$buildString.append(TypeRendererKt.render(returnType2));
        String string = stringBuilder2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static final boolean withPrettyRender(@Nullable FunctionClassDescriptor.Kind $this$withPrettyRender) {
        boolean bl = false;
        return $this$withPrettyRender != null && $this$withPrettyRender != FunctionClassDescriptor.Kind.KSuspendFunction && $this$withPrettyRender != FunctionClassDescriptor.Kind.KFunction;
    }

    public static final /* synthetic */ String access$render(ConeKotlinTypeProjection $this$access_u24render) {
        return TypeRendererKt.render($this$access_u24render);
    }
}

