/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ide.konan;

import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ide.konan.decompiler.KotlinNativeLoadingMetadataCache;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.impl.KotlinLibraryImpl;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.library.metadata.PackageAccessHandler;
import org.jetbrains.kotlin.metadata.ProtoBuf;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\tH\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u001c\u0010\u001e\u001a\u00020\f*\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\nR\u0018\u0010\u000b\u001a\u00020\f*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ide/konan/CachingIdeKonanLibraryMetadataLoader;", "Lorg/jetbrains/kotlin/library/metadata/PackageAccessHandler;", "()V", "cache", "Lorg/jetbrains/kotlin/ide/konan/decompiler/KotlinNativeLoadingMetadataCache;", "getCache", "()Lorg/jetbrains/kotlin/ide/konan/decompiler/KotlinNativeLoadingMetadataCache;", "isZipped", "", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;)Z", "moduleHeaderFile", "Lorg/jetbrains/kotlin/konan/file/File;", "getModuleHeaderFile", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;)Lorg/jetbrains/kotlin/konan/file/File;", "asJarFileSystemFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "jarFile", "localFile", "asLocalFile", "getVirtualFile", "library", "file", "loadModuleHeader", "Lorg/jetbrains/kotlin/library/metadata/KlibMetadataProtoBuf$Header;", "loadPackageFragment", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "packageFqName", "", "partName", "packageFragmentFile", "idea-native"})
public final class CachingIdeKonanLibraryMetadataLoader
implements PackageAccessHandler {
    public static final CachingIdeKonanLibraryMetadataLoader INSTANCE;

    @NotNull
    public KlibMetadataProtoBuf.Header loadModuleHeader(@NotNull KotlinLibrary library2) {
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        VirtualFile virtualFile2 = this.getVirtualFile(library2, this.getModuleHeaderFile(library2));
        KlibMetadataProtoBuf.Header header = this.getCache().getCachedModuleHeader(virtualFile2);
        if (header == null) {
            Intrinsics.throwNpe();
        }
        return header;
    }

    @NotNull
    public ProtoBuf.PackageFragment loadPackageFragment(@NotNull KotlinLibrary library2, @NotNull String packageFqName, @NotNull String partName) {
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
        VirtualFile virtualFile2 = this.getVirtualFile(library2, this.packageFragmentFile(library2, packageFqName, partName));
        ProtoBuf.PackageFragment packageFragment2 = this.getCache().getCachedPackageFragment(virtualFile2);
        if (packageFragment2 == null) {
            Intrinsics.throwNpe();
        }
        return packageFragment2;
    }

    private final VirtualFile getVirtualFile(KotlinLibrary library2, File file2) {
        return this.isZipped(library2) ? this.asJarFileSystemFile(library2.getLibraryFile(), file2) : this.asLocalFile(file2);
    }

    private final VirtualFile asJarFileSystemFile(File jarFile, File localFile) {
        String fullPath = jarFile.getAbsolutePath() + "!" + PathUtil.toSystemIndependentName((String)localFile.getPath());
        VirtualFile virtualFile2 = StandardFileSystems.jar().findFileByPath(fullPath);
        if (virtualFile2 == null) {
            String string = "File not found: " + fullPath;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return virtualFile2;
    }

    private final VirtualFile asLocalFile(File localFile) {
        String fullPath = localFile.getAbsolutePath();
        VirtualFile virtualFile2 = StandardFileSystems.local().findFileByPath(fullPath);
        if (virtualFile2 == null) {
            String string = "File not found: " + fullPath;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return virtualFile2;
    }

    private final KotlinNativeLoadingMetadataCache getCache() {
        return KotlinNativeLoadingMetadataCache.Companion.getInstance();
    }

    private final File getModuleHeaderFile(@NotNull KotlinLibrary $this$moduleHeaderFile) {
        KotlinLibrary kotlinLibrary = $this$moduleHeaderFile;
        if (kotlinLibrary == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.library.impl.KotlinLibraryImpl");
        }
        return ((KotlinLibraryImpl)kotlinLibrary).getMetadata().getAccess().getLayout().getModuleHeaderFile();
    }

    private final File packageFragmentFile(@NotNull KotlinLibrary $this$packageFragmentFile, String packageFqName, String partName) {
        KotlinLibrary kotlinLibrary = $this$packageFragmentFile;
        if (kotlinLibrary == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.library.impl.KotlinLibraryImpl");
        }
        return ((KotlinLibraryImpl)kotlinLibrary).getMetadata().getAccess().getLayout().packageFragmentFile(packageFqName, partName);
    }

    private final boolean isZipped(@NotNull KotlinLibrary $this$isZipped) {
        KotlinLibrary kotlinLibrary = $this$isZipped;
        if (kotlinLibrary == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.library.impl.KotlinLibraryImpl");
        }
        return ((KotlinLibraryImpl)kotlinLibrary).getBase().getAccess().getLayout().isZipped();
    }

    private CachingIdeKonanLibraryMetadataLoader() {
    }

    static {
        CachingIdeKonanLibraryMetadataLoader cachingIdeKonanLibraryMetadataLoader;
        INSTANCE = cachingIdeKonanLibraryMetadataLoader = new CachingIdeKonanLibraryMetadataLoader();
    }

    @NotNull
    public ProtoBuf.PackageFragment loadPackageFragmentByteArray(@NotNull byte[] byteArray) {
        Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
        return PackageAccessHandler.DefaultImpls.loadPackageFragmentByteArray((PackageAccessHandler)this, (byte[])byteArray);
    }

    public void markNeededForLink(@NotNull KotlinLibrary library2, @NotNull String fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        PackageAccessHandler.DefaultImpls.markNeededForLink((PackageAccessHandler)this, (KotlinLibrary)library2, (String)fqName2);
    }
}

