/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.generate;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsAndHashcodeAction;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsAndHashcodeActionKt;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsWizard;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateMemberActionBase;
import org.jetbrains.kotlin.idea.actions.generate.UtilsKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002$%B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J(\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u0002H\u0014J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J$\u0010 \u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\f\u0010\"\u001a\u00020\t*\u00020#H\u0002\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/actions/generate/KotlinGenerateEqualsAndHashcodeAction;", "Lorg/jetbrains/kotlin/idea/actions/generate/KotlinGenerateMemberActionBase;", "Lorg/jetbrains/kotlin/idea/actions/generate/KotlinGenerateEqualsAndHashcodeAction$Info;", "()V", "generateArrayHashCodeCall", "", "variable", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "canUseContentFunctions", "", "argument", "generateArraysEqualsCall", "arg1", "arg2", "generateClassLiteral", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "generateClassLiteralsNotEqual", "paramName", "generateEquals", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "project", "Lcom/intellij/openapi/project/Project;", "info", "generateHashCode", "generateMembers", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isNestedArray", "isValidForClass", "prepareMembersInfo", "klass", "canUseArrayContentFunctions", "Lorg/jetbrains/kotlin/psi/KtElement;", "Companion", "Info", "idea"})
public final class KotlinGenerateEqualsAndHashcodeAction
extends KotlinGenerateMemberActionBase<Info> {
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    protected boolean isValidForClass(@NotNull KtClassOrObject targetClass) {
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        return targetClass instanceof KtClass && !(targetClass instanceof KtEnumEntry) && !((KtClass)targetClass).isEnum() && !targetClass.isAnnotation() && !((KtClass)targetClass).isInterface();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected Info prepareMembersInfo(@NotNull KtClassOrObject klass2, @NotNull Project project2, @Nullable Editor editor2) {
        Object object;
        KtNamedDeclaration it;
        Collection<VariableDescriptor> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List<KtNamedDeclaration> properties2;
        void needHashCode;
        void needEquals;
        ClassDescriptor classDescriptor2;
        BindingContext context2;
        block17: {
            void $this$mapTo$iv$iv2;
            block16: {
                Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                if (!(klass2 instanceof KtClass)) {
                    throw (Throwable)((Object)new AssertionError((Object)("Not a class: " + PsiUtilsKt.getElementTextWithContext(klass2))));
                }
                context2 = ResolutionUtils.analyzeWithContent((KtDeclaration)klass2);
                ClassDescriptor classDescriptor3 = (ClassDescriptor)context2.get(BindingContext.CLASS, klass2);
                if (classDescriptor3 == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor3, (String)"context.get(BindingConte\u2026SS, klass) ?: return null");
                classDescriptor2 = classDescriptor3;
                FunctionDescriptor equalsDescriptor = KotlinGenerateEqualsAndHashcodeActionKt.findDeclaredEquals(classDescriptor2, false);
                FunctionDescriptor hashCodeDescriptor = KotlinGenerateEqualsAndHashcodeActionKt.findDeclaredHashCode(classDescriptor2, false);
                Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                booleanRef.element = equalsDescriptor == null;
                Ref.BooleanRef booleanRef2 = new Ref.BooleanRef();
                boolean bl = booleanRef2.element = hashCodeDescriptor == null;
                if (!needEquals.element && !needHashCode.element) {
                    KtClass ktClass2 = (KtClass)klass2;
                    FunctionDescriptor[] functionDescriptorArray = new FunctionDescriptor[2];
                    FunctionDescriptor functionDescriptor2 = equalsDescriptor;
                    if (functionDescriptor2 == null) {
                        Intrinsics.throwNpe();
                    }
                    functionDescriptorArray[0] = functionDescriptor2;
                    FunctionDescriptor functionDescriptor3 = hashCodeDescriptor;
                    if (functionDescriptor3 == null) {
                        Intrinsics.throwNpe();
                    }
                    functionDescriptorArray[1] = functionDescriptor3;
                    if (!UtilsKt.confirmMemberRewrite(ktClass2, functionDescriptorArray)) {
                        return null;
                    }
                    ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(equalsDescriptor, hashCodeDescriptor, (Ref.BooleanRef)needEquals, (Ref.BooleanRef)needHashCode){
                        final /* synthetic */ FunctionDescriptor $equalsDescriptor;
                        final /* synthetic */ FunctionDescriptor $hashCodeDescriptor;
                        final /* synthetic */ Ref.BooleanRef $needEquals;
                        final /* synthetic */ Ref.BooleanRef $needHashCode;

                        public final void invoke() {
                            try {
                                SourceElement sourceElement = this.$equalsDescriptor.getSource();
                                Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"equalsDescriptor.source");
                                PsiElement psiElement2 = KotlinSourceElementKt.getPsi(sourceElement);
                                if (psiElement2 != null) {
                                    psiElement2.delete();
                                }
                                SourceElement sourceElement2 = this.$hashCodeDescriptor.getSource();
                                Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement2, (String)"hashCodeDescriptor.source");
                                PsiElement psiElement3 = KotlinSourceElementKt.getPsi(sourceElement2);
                                if (psiElement3 != null) {
                                    psiElement3.delete();
                                }
                                this.$needEquals.element = true;
                                this.$needHashCode.element = true;
                            }
                            catch (IncorrectOperationException e) {
                                KotlinGenerateEqualsAndHashcodeAction.access$getLOG$cp().error((Throwable)e);
                            }
                        }
                        {
                            this.$equalsDescriptor = functionDescriptor2;
                            this.$hashCodeDescriptor = functionDescriptor3;
                            this.$needEquals = booleanRef;
                            this.$needHashCode = booleanRef2;
                            super(0);
                        }
                    });
                }
                if ((properties2 = UtilsKt.getPropertiesToUseInGeneratedMember(klass2)).isEmpty()) break block16;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) break block17;
            }
            Iterable $this$map$iv2 = properties2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                DeclarationDescriptor declarationDescriptor = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, it2);
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
                }
                VariableDescriptor variableDescriptor = (VariableDescriptor)declarationDescriptor;
                collection2.add(variableDescriptor);
            }
            List descriptors2 = (List)destination$iv$iv;
            return new Info(needEquals.element, needHashCode.element, classDescriptor2, descriptors2, descriptors2);
        }
        KotlinGenerateEqualsWizard kotlinGenerateEqualsWizard = new KotlinGenerateEqualsWizard(project2, (KtClass)klass2, properties2, needEquals.element, needHashCode.element);
        boolean bl = false;
        boolean bl2 = false;
        KotlinGenerateEqualsWizard $this$with = kotlinGenerateEqualsWizard;
        boolean bl3 = false;
        if (!PsiUtilsKt.hasExpectModifier(klass2) && !$this$with.showAndGet()) {
            return null;
        }
        Iterable $i$f$mapTo = $this$with.getPropertiesForEquals();
        ClassDescriptor classDescriptor4 = classDescriptor2;
        boolean bl4 = needHashCode.element;
        boolean bl5 = needEquals.element;
        boolean $i$f$map = false;
        void var23_33 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl6 = false;
            DeclarationDescriptor declarationDescriptor = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, it);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
            }
            object = (VariableDescriptor)declarationDescriptor;
            collection.add((VariableDescriptor)object);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = $this$with.getPropertiesForHashCode();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KtNamedDeclaration)item$iv$iv;
            object = destination$iv$iv;
            boolean bl7 = false;
            DeclarationDescriptor declarationDescriptor = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, it);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
            }
            VariableDescriptor variableDescriptor = (VariableDescriptor)declarationDescriptor;
            object.add(variableDescriptor);
        }
        Object object2 = object = (List)destination$iv$iv;
        Collection<VariableDescriptor> collection3 = collection;
        ClassDescriptor classDescriptor5 = classDescriptor4;
        boolean bl8 = bl4;
        boolean bl9 = bl5;
        return new Info(bl9, bl8, classDescriptor5, (List<? extends VariableDescriptor>)collection3, (List<? extends VariableDescriptor>)object2);
    }

    private final String generateClassLiteralsNotEqual(String paramName, KtClassOrObject targetClass) {
        String defaultExpression = "javaClass != " + paramName + "?.javaClass";
        if (!PlatformKt.getLanguageVersionSettings(targetClass).supportsFeature(LanguageFeature.BoundCallableReferences)) {
            return defaultExpression;
        }
        return JsPlatformKt.isJs(PlatformKt.getPlatform(targetClass)) ? "other == null || this::class.js != " + paramName + "::class.js" : (TargetPlatformKt.isCommon(PlatformKt.getPlatform(targetClass)) ? "other == null || this::class != " + paramName + "::class" : defaultExpression);
    }

    private final String generateClassLiteral(KtClassOrObject targetClass) {
        String defaultExpression = "javaClass";
        if (!PlatformKt.getLanguageVersionSettings(targetClass).supportsFeature(LanguageFeature.BoundCallableReferences)) {
            return defaultExpression;
        }
        return JsPlatformKt.isJs(PlatformKt.getPlatform(targetClass)) ? "this::class.js" : (TargetPlatformKt.isCommon(PlatformKt.getPlatform(targetClass)) ? "this::class" : defaultExpression);
    }

    private final boolean isNestedArray(VariableDescriptor variable2) {
        return KotlinBuiltIns.isArrayOrPrimitiveArray(DescriptorUtilsKt.getBuiltIns(variable2).getArrayElementType(variable2.getType()));
    }

    private final boolean canUseArrayContentFunctions(@NotNull KtElement $this$canUseArrayContentFunctions) {
        return PlatformKt.getLanguageVersionSettings((PsiElement)$this$canUseArrayContentFunctions).getApiVersion().compareTo(ApiVersion.KOTLIN_1_1) >= 0;
    }

    private final String generateArraysEqualsCall(VariableDescriptor variable2, boolean canUseContentFunctions, String arg1, String arg2) {
        String string;
        if (canUseContentFunctions) {
            String methodName2 = this.isNestedArray(variable2) ? "contentDeepEquals" : "contentEquals";
            string = arg1 + '.' + methodName2 + '(' + arg2 + ')';
        } else {
            String methodName3 = this.isNestedArray(variable2) ? "deepEquals" : "equals";
            string = "java.util.Arrays." + methodName3 + '(' + arg1 + ", " + arg2 + ')';
        }
        return string;
    }

    private final String generateArrayHashCodeCall(VariableDescriptor variable2, boolean canUseContentFunctions, String argument2) {
        String string;
        if (canUseContentFunctions) {
            String methodName2 = this.isNestedArray(variable2) ? "contentDeepHashCode" : "contentHashCode";
            String dot = TypeUtils.isNullableType(variable2.getType()) ? "?." : ".";
            string = argument2 + dot + methodName2 + "()";
        } else {
            String methodName3 = this.isNestedArray(variable2) ? "deepHashCode" : "hashCode";
            string = "java.util.Arrays." + methodName3 + '(' + argument2 + ')';
        }
        return string;
    }

    private final KtNamedFunction generateEquals(Project project2, Info info2, KtClassOrObject targetClass) {
        boolean useIsCheck;
        boolean bl = false;
        boolean bl2 = false;
        Info $this$with = info2;
        boolean bl3 = false;
        if (!$this$with.getNeedEquals()) {
            return null;
        }
        FunctionDescriptor functionDescriptor2 = KotlinGenerateEqualsAndHashcodeActionKt.findDeclaredEquals(DescriptorUtilsKt.getSuperClassOrAny($this$with.getClassDescriptor()), true);
        if (functionDescriptor2 == null) {
            Intrinsics.throwNpe();
        }
        FunctionDescriptor superEquals = functionDescriptor2;
        KtNamedFunction equalsFun = UtilsKt.generateFunctionSkeleton(superEquals, targetClass);
        List<KtParameter> list2 = equalsFun.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"equalsFun.valueParameters");
        Object object = kotlin.collections.CollectionsKt.first(list2);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"equalsFun.valueParameters.first()");
        String string = ((KtParameter)object).getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"equalsFun.valueParameters.first().name!!");
        String paramName = KtPsiUtilKt.quoteIfNeeded(string);
        String typeForCast = IdeDescriptorRenderers.SOURCE_CODE.renderClassifierName($this$with.getClassDescriptor());
        List<TypeParameterDescriptor> list3 = $this$with.getClassDescriptor().getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"classDescriptor.declaredTypeParameters");
        List<TypeParameterDescriptor> typeParams = list3;
        Collection collection = typeParams;
        boolean bl4 = false;
        if (!collection.isEmpty()) {
            typeForCast = typeForCast + kotlin.collections.CollectionsKt.joinToString$default((Iterable)typeParams, null, (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)generateEquals.1.1.INSTANCE, (int)25, null);
        }
        String isNotInstanceCondition = (useIsCheck = CodeInsightSettings.getInstance().USE_INSTANCEOF_ON_EQUALS_PARAMETER) ? paramName + " !is " + typeForCast : this.generateClassLiteralsNotEqual(paramName, targetClass);
        boolean bl5 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        StringBuilder $this$buildString = stringBuilder2;
        boolean bl8 = false;
        $this$buildString.append("if (this === " + paramName + ") return true\n");
        $this$buildString.append("if (" + isNotInstanceCondition + ") return false\n");
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(superEquals);
        if (!builtIns.isMemberOfAny(superEquals)) {
            $this$buildString.append("if (!super.equals(" + paramName + ")) return false\n");
        }
        Collection collection2 = $this$with.getVariablesForEquals();
        boolean bl9 = false;
        if (!collection2.isEmpty()) {
            if (!useIsCheck) {
                $this$buildString.append('\n' + paramName + " as " + typeForCast + '\n');
            }
            $this$buildString.append('\n');
            Iterable $this$forEach$iv = $this$with.getVariablesForEquals();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string2;
                VariableDescriptor it = (VariableDescriptor)element$iv;
                boolean bl10 = false;
                boolean isNullable2 = TypeUtils.isNullableType(it.getType());
                boolean isArray = KotlinBuiltIns.isArrayOrPrimitiveArray(it.getType());
                boolean canUseArrayContentFunctions = this.canUseArrayContentFunctions(targetClass);
                PsiElement psiElement2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, it);
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiNameIdentifierOwner");
                }
                PsiElement psiElement3 = ((PsiNameIdentifierOwner)psiElement2).getNameIdentifier();
                if (psiElement3 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"(DescriptorToSourceUtils\u2026erOwner).nameIdentifier!!");
                String propName = psiElement3.getText();
                if (isArray) {
                    StringBuilder stringBuilder3 = new StringBuilder().append('!');
                    String string3 = propName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"propName");
                    string2 = stringBuilder3.append(this.generateArraysEqualsCall(it, canUseArrayContentFunctions, string3, paramName + '.' + propName)).toString();
                } else {
                    string2 = propName + " != " + paramName + '.' + propName;
                }
                String notEquals = string2;
                String equalsCheck = "if (" + notEquals + ") return false\n";
                if (isArray && isNullable2 && canUseArrayContentFunctions) {
                    $this$buildString.append("if (" + propName + " != null) {\n");
                    $this$buildString.append("if (" + paramName + '.' + propName + " == null) return false\n");
                    $this$buildString.append(equalsCheck);
                    $this$buildString.append("} else if (" + paramName + '.' + propName + " != null) return false\n");
                    continue;
                }
                $this$buildString.append(equalsCheck);
            }
            $this$buildString.append('\n');
        }
        $this$buildString.append("return true");
        String string4 = stringBuilder2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        String bodyText = string4;
        this.replaceBody(equalsFun, (Function0<KtExpression>)((Function0)new Function0<KtBlockExpression>(bodyText, this, targetClass, project2){
            final /* synthetic */ String $bodyText;
            final /* synthetic */ KotlinGenerateEqualsAndHashcodeAction this$0;
            final /* synthetic */ KtClassOrObject $targetClass$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.$bodyText = string;
                this.this$0 = kotlinGenerateEqualsAndHashcodeAction;
                this.$targetClass$inlined = ktClassOrObject;
                this.$project$inlined = project2;
                super(0);
            }

            @NotNull
            public final KtBlockExpression invoke() {
                return new KtPsiFactory(this.$project$inlined, false, 2, null).createBlock(this.$bodyText);
            }
        }));
        return equalsFun;
    }

    /*
     * WARNING - void declaration
     */
    private final KtNamedFunction generateHashCode(Project project2, Info info2, KtClassOrObject targetClass) {
        String string;
        String initialValue;
        Function2<VariableDescriptor, Boolean, String> $fun$genVariableHashCode$1 = new Function2<VariableDescriptor, Boolean, String>(this, project2, targetClass){
            final /* synthetic */ KotlinGenerateEqualsAndHashcodeAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ KtClassOrObject $targetClass;

            @NotNull
            public final String invoke(@NotNull VariableDescriptor $this$genVariableHashCode, boolean parenthesesNeeded) {
                String text2;
                String string;
                Intrinsics.checkParameterIsNotNull((Object)$this$genVariableHashCode, (String)"$this$genVariableHashCode");
                PsiElement psiElement2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.$project, $this$genVariableHashCode);
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiNameIdentifierOwner");
                }
                PsiElement psiElement3 = ((PsiNameIdentifierOwner)psiElement2).getNameIdentifier();
                if (psiElement3 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"(DescriptorToSourceUtils\u2026erOwner).nameIdentifier!!");
                String ref2 = psiElement3.getText();
                boolean isNullable2 = TypeUtils.isNullableType($this$genVariableHashCode.getType());
                KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns($this$genVariableHashCode);
                ClassifierDescriptor typeClass = $this$genVariableHashCode.getType().getConstructor().getDeclarationDescriptor();
                if (Intrinsics.areEqual((Object)typeClass, (Object)builtIns.getByte()) || Intrinsics.areEqual((Object)typeClass, (Object)builtIns.getShort()) || Intrinsics.areEqual((Object)typeClass, (Object)builtIns.getInt())) {
                    string = ref2;
                } else if (KotlinBuiltIns.isArrayOrPrimitiveArray($this$genVariableHashCode.getType())) {
                    String hashCodeArg;
                    boolean canUseArrayContentFunctions = KotlinGenerateEqualsAndHashcodeAction.access$canUseArrayContentFunctions(this.this$0, this.$targetClass);
                    boolean shouldWrapInLet = isNullable2 && !canUseArrayContentFunctions;
                    String string2 = hashCodeArg = shouldWrapInLet ? "it" : ref2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"hashCodeArg");
                    String hashCodeCall = KotlinGenerateEqualsAndHashcodeAction.access$generateArrayHashCodeCall(this.this$0, $this$genVariableHashCode, canUseArrayContentFunctions, string2);
                    string = shouldWrapInLet ? ref2 + "?.let { " + hashCodeCall + " }" : hashCodeCall;
                } else {
                    string = text2 = isNullable2 ? ref2 + "?.hashCode()" : ref2 + ".hashCode()";
                }
                if (isNullable2) {
                    text2 = text2 + " ?: 0";
                    if (parenthesesNeeded) {
                        text2 = '(' + text2 + ')';
                    }
                }
                String string3 = text2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"text");
                return string3;
            }
            {
                this.this$0 = kotlinGenerateEqualsAndHashcodeAction;
                this.$project = project2;
                this.$targetClass = ktClassOrObject;
                super(2);
            }
        };
        boolean bl = false;
        boolean bl2 = false;
        Info $this$with = info2;
        boolean bl3 = false;
        if (!$this$with.getNeedHashCode()) {
            return null;
        }
        FunctionDescriptor functionDescriptor2 = KotlinGenerateEqualsAndHashcodeActionKt.findDeclaredHashCode(DescriptorUtilsKt.getSuperClassOrAny($this$with.getClassDescriptor()), true);
        if (functionDescriptor2 == null) {
            Intrinsics.throwNpe();
        }
        FunctionDescriptor superHashCode = functionDescriptor2;
        KtNamedFunction hashCodeFun = UtilsKt.generateFunctionSkeleton(superHashCode, targetClass);
        KotlinBuiltIns builtins = DescriptorUtilsKt.getBuiltIns(superHashCode);
        Iterator<VariableDescriptor> propertyIterator = $this$with.getVariablesForHashCode().iterator();
        String string2 = !builtins.isMemberOfAny(superHashCode) ? "super.hashCode()" : (initialValue = propertyIterator.hasNext() ? $fun$genVariableHashCode$1.invoke(propertyIterator.next(), false) : this.generateClassLiteral(targetClass) + ".hashCode()");
        if (propertyIterator.hasNext()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$with.getVariablesForEquals();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VariableDescriptor variableDescriptor = (VariableDescriptor)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                String string3 = it.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.name.asString()");
                String string4 = KtPsiUtilKt.quoteIfNeeded(string3);
                collection.add(string4);
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            Function1 function1 = null;
            Collection collection2 = collection;
            CollectingNameValidator validator2 = new CollectingNameValidator(collection2, function1, n, defaultConstructorMarker);
            String resultVarName = KotlinNameSuggester.INSTANCE.suggestNameByName("result", (Function1<? super String, Boolean>)((Function1)validator2));
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl5 = false;
            boolean bl6 = false;
            StringBuilder $this$apply = stringBuilder2;
            boolean bl7 = false;
            $this$apply.append("var " + resultVarName + " = " + initialValue + '\n');
            Iterator<VariableDescriptor> $this$forEach$iv = propertyIterator;
            boolean $i$f$forEach = false;
            Iterator<VariableDescriptor> iterator2 = $this$forEach$iv;
            boolean bl8 = false;
            Iterator<VariableDescriptor> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                VariableDescriptor element$iv;
                VariableDescriptor it = element$iv = iterator3.next();
                boolean bl9 = false;
                $this$apply.append(resultVarName + " = 31 * " + resultVarName + " + " + $fun$genVariableHashCode$1.invoke(it, true) + '\n');
            }
            $this$apply.append("return " + resultVarName);
            string = stringBuilder2.toString();
        } else {
            string = "return " + initialValue;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (propertyIterator.has\u2026se \"return $initialValue\"");
        String bodyText = string;
        this.replaceBody(hashCodeFun, (Function0<KtExpression>)((Function0)new Function0<KtBlockExpression>(bodyText, this, targetClass, $fun$genVariableHashCode$1, project2){
            final /* synthetic */ String $bodyText;
            final /* synthetic */ KotlinGenerateEqualsAndHashcodeAction this$0;
            final /* synthetic */ KtClassOrObject $targetClass$inlined;
            final /* synthetic */ generateHashCode.1 $genVariableHashCode$1$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.$bodyText = string;
                this.this$0 = kotlinGenerateEqualsAndHashcodeAction;
                this.$targetClass$inlined = ktClassOrObject;
                this.$genVariableHashCode$1$inlined = var4_4;
                this.$project$inlined = project2;
                super(0);
            }

            @NotNull
            public final KtBlockExpression invoke() {
                return new KtPsiFactory(this.$project$inlined, false, 2, null).createBlock(this.$bodyText);
            }
        }));
        return hashCodeFun;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<KtDeclaration> generateMembers(@NotNull Project project2, @Nullable Editor editor2, @NotNull Info info2) {
        Object v2;
        List<KtDeclaration> $this$with;
        ArrayList prototypes2;
        KtClass targetClass;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)info2, (String)"info");
            SourceElement sourceElement = info2.getClassDescriptor().getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"info.classDescriptor.source");
            PsiElement psiElement2 = KotlinSourceElementKt.getPsi(sourceElement);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
            }
            targetClass = (KtClass)psiElement2;
            ArrayList arrayList = new ArrayList(2);
            boolean bl = false;
            boolean bl2 = false;
            ArrayList $this$apply = arrayList;
            boolean bl3 = false;
            CollectionsKt.addIfNotNull($this$apply, this.generateEquals(project2, info2, targetClass));
            CollectionsKt.addIfNotNull($this$apply, this.generateHashCode(project2, info2, targetClass));
            prototypes2 = arrayList;
            List<KtDeclaration> list2 = targetClass.getDeclarations();
            bl2 = false;
            boolean bl4 = false;
            $this$with = list2;
            boolean bl5 = false;
            Iterable $this$lastIsInstanceOrNull$iv = $this$with;
            boolean $i$f$lastIsInstanceOrNull = false;
            Iterable iterable = $this$lastIsInstanceOrNull$iv;
            if (iterable instanceof List) {
                int n = ((Collection)$this$lastIsInstanceOrNull$iv).size();
                --n;
                boolean bl6 = false;
                while (n >= 0) {
                    void i$iv;
                    Object element$iv = ((List)$this$lastIsInstanceOrNull$iv).get((int)i$iv);
                    if (element$iv instanceof KtNamedFunction) {
                        v2 = element$iv;
                        break block6;
                    }
                    --i$iv;
                }
                v2 = null;
            } else {
                Iterable $this$firstIsInstanceOrNull$iv$iv = kotlin.collections.CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                    if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                    v2 = element$iv$iv;
                    break block6;
                }
                v2 = null;
            }
        }
        KtNamedFunction ktNamedFunction = v2;
        KtDeclaration anchor2 = ktNamedFunction != null ? (KtDeclaration)ktNamedFunction : (KtDeclaration)kotlin.collections.CollectionsKt.lastOrNull($this$with);
        return GenerateUtilKt.insertMembersAfter$default(editor2, targetClass, prototypes2, anchor2, null, 16, null);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinGenerateEqualsAndHashcodeAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Kotli\u2026shcodeAction::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$canUseArrayContentFunctions(KotlinGenerateEqualsAndHashcodeAction $this, KtElement $this$access_u24canUseArrayContentFunctions) {
        return $this.canUseArrayContentFunctions($this$access_u24canUseArrayContentFunctions);
    }

    public static final /* synthetic */ String access$generateArrayHashCodeCall(KotlinGenerateEqualsAndHashcodeAction $this, VariableDescriptor variable2, boolean canUseContentFunctions, String argument2) {
        return $this.generateArrayHashCodeCall(variable2, canUseContentFunctions, argument2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/actions/generate/KotlinGenerateEqualsAndHashcodeAction$Info;", "", "needEquals", "", "needHashCode", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "variablesForEquals", "", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "variablesForHashCode", "(ZZLorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/List;Ljava/util/List;)V", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getNeedEquals", "()Z", "getNeedHashCode", "getVariablesForEquals", "()Ljava/util/List;", "getVariablesForHashCode", "idea"})
    public static final class Info {
        private final boolean needEquals;
        private final boolean needHashCode;
        @NotNull
        private final ClassDescriptor classDescriptor;
        @NotNull
        private final List<VariableDescriptor> variablesForEquals;
        @NotNull
        private final List<VariableDescriptor> variablesForHashCode;

        public final boolean getNeedEquals() {
            return this.needEquals;
        }

        public final boolean getNeedHashCode() {
            return this.needHashCode;
        }

        @NotNull
        public final ClassDescriptor getClassDescriptor() {
            return this.classDescriptor;
        }

        @NotNull
        public final List<VariableDescriptor> getVariablesForEquals() {
            return this.variablesForEquals;
        }

        @NotNull
        public final List<VariableDescriptor> getVariablesForHashCode() {
            return this.variablesForHashCode;
        }

        public Info(boolean needEquals, boolean needHashCode, @NotNull ClassDescriptor classDescriptor2, @NotNull List<? extends VariableDescriptor> variablesForEquals, @NotNull List<? extends VariableDescriptor> variablesForHashCode) {
            Intrinsics.checkParameterIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
            Intrinsics.checkParameterIsNotNull(variablesForEquals, (String)"variablesForEquals");
            Intrinsics.checkParameterIsNotNull(variablesForHashCode, (String)"variablesForHashCode");
            this.needEquals = needEquals;
            this.needHashCode = needHashCode;
            this.classDescriptor = classDescriptor2;
            this.variablesForEquals = variablesForEquals;
            this.variablesForHashCode = variablesForHashCode;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/actions/generate/KotlinGenerateEqualsAndHashcodeAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

