/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiManager;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.KotlinPackageContentModificationListener;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/caches/KotlinPackageContentModificationListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "Lorg/jetbrains/annotations/NotNull;", "getConnection", "()Lcom/intellij/util/messages/MessageBusConnection;", "dispose", "", "idea-core"})
public final class KotlinPackageContentModificationListener
implements Disposable {
    @NotNull
    private final MessageBusConnection connection;
    private final Project project;

    @NotNull
    public final MessageBusConnection getConnection() {
        return this.connection;
    }

    public void dispose() {
        this.connection.disconnect();
    }

    public KotlinPackageContentModificationListener(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"project.messageBus.connect()");
        this.connection = messageBusConnection;
        this.connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                this.onEvents(events);
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                this.onEvents(events);
            }

            private final boolean isRelevant(VFileEvent it) {
                return it instanceof VFileMoveEvent || it instanceof VFileCreateEvent || it instanceof VFileCopyEvent || it instanceof VFileDeleteEvent;
            }

            public final void onEvents(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                PerModulePackageCacheService service2 = PerModulePackageCacheService.Companion.getInstance(project);
                if (events.size() >= 1000) {
                    service2.onTooComplexChange$idea_core();
                } else {
                    Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)events), (Function1)((Function1)new Function1<VFileEvent, Boolean>(this){

                        public final boolean invoke(@NotNull VFileEvent p1) {
                            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                            return 1.access$isRelevant(this.receiver, p1);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(1.class);
                        }

                        public final String getName() {
                            return "isRelevant";
                        }

                        public final String getSignature() {
                            return "isRelevant(Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;)Z";
                        }
                    })), (Function1)onEvents.2.INSTANCE), (Function1)onEvents.3.INSTANCE), (Function1)((Function1)new Function1<VFileEvent, Boolean>(this){
                        final /* synthetic */ 1 this$0;

                        public final boolean invoke(@NotNull VFileEvent it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            Object origin = it.getRequestor();
                            return origin instanceof Project ? Intrinsics.areEqual((Object)origin, (Object)KotlinPackageContentModificationListener.access$getProject$p(this.this$0.this)) : (origin instanceof PsiManager ? Intrinsics.areEqual((Object)((PsiManager)origin).getProject(), (Object)KotlinPackageContentModificationListener.access$getProject$p(this.this$0.this)) : true);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        VFileEvent event = (VFileEvent)element$iv;
                        boolean bl = false;
                        service2.notifyPackageChange$idea_core(event);
                    }
                }
            }

            public static final /* synthetic */ boolean access$isRelevant(1 $this, VFileEvent it) {
                return $this.isRelevant(it);
            }
        });
        this.connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                PerModulePackageCacheService.Companion.getInstance(project).onTooComplexChange$idea_core();
            }
        });
    }
}

