/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.caches.resolve.IdePlatformKindResolutionKt;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.project.ModuleProductionSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfoWithExpectedBy;
import org.jetbrains.kotlin.idea.caches.project.ModuleTestSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.caches.project.PlatformModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.framework.LibraryKindsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.KonanPlatformKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0014\u0010!\u001a\u00020\u001b*\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u0010*\u00020\u0019H\u0000\u001a\f\u0010#\u001a\u00020\u001b*\u00020\u0019H\u0002\u001a\u0018\u0010$\u001a\u00020\u001b*\u00020\u00192\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0002\u001a\f\u0010'\u001a\u00020\u001b*\u00020\u0019H\u0002\u001a\n\u0010(\u001a\u00020\u001b*\u00020\u0017\u001a\f\u0010)\u001a\u0004\u0018\u00010**\u00020\u0019\u001a\u0012\u0010+\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0010*\u00020\u0017\u001a\f\u0010,\u001a\u0004\u0018\u00010-*\u00020\u0019\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006."}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "OriginCapability", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor$Capability;", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "getOriginCapability", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor$Capability;", "sourceType", "Lorg/jetbrains/kotlin/idea/caches/project/SourceType;", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;", "getSourceType", "(Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;)Lorg/jetbrains/kotlin/idea/caches/project/SourceType;", "createLibraryInfo", "", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "ideaModelDependencies", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "module", "Lcom/intellij/openapi/module/Module;", "forProduction", "", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "orderEntryToModuleInfo", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "acceptAsDependency", "correspondingModuleInfos", "hasProductionRoots", "hasRootsOfType", "sourceRootType", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "hasTestRoots", "isLibraryClasses", "productionSourceInfo", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleProductionSourceInfo;", "projectSourceModules", "testSourceInfo", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleTestSourceInfo;", "idea-core"})
public final class IdeaModuleInfosKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ModuleDescriptor.Capability<ModuleOrigin> OriginCapability;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final List<IdeaModuleInfo> orderEntryToModuleInfo(Project project2, OrderEntry orderEntry, boolean forProduction) {
        List<Object> list2;
        Function1<Module, List<? extends ModuleSourceInfo>> $fun$toInfos$1 = new Function1<Module, List<? extends ModuleSourceInfo>>(forProduction){
            final /* synthetic */ boolean $forProduction;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ModuleSourceInfo> invoke(@NotNull Module $this$toInfos) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)$this$toInfos, (String)"$this$toInfos");
                Iterable $this$filter$iv = IdeaModuleInfosKt.correspondingModuleInfos($this$toInfos);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    ModuleSourceInfo it = (ModuleSourceInfo)element$iv$iv;
                    boolean bl = false;
                    if (!(!this.$forProduction || it instanceof ModuleProductionSourceInfo)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$forProduction = bl;
                super(1);
            }
        };
        if (!orderEntry.isValid()) {
            return CollectionsKt.emptyList();
        }
        OrderEntry orderEntry2 = orderEntry;
        if (orderEntry2 instanceof ModuleSourceOrderEntry) {
            Module module = orderEntry.getOwnerModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"orderEntry.getOwnerModule()");
            list2 = $fun$toInfos$1.invoke(module);
        } else if (orderEntry2 instanceof ModuleOrderEntry) {
            Module module = ((ModuleOrderEntry)orderEntry).getModule();
            if (module == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"orderEntry.module ?: return emptyList()");
            Module module2 = module;
            list2 = forProduction && orderEntry instanceof ModuleOrderEntryImpl && ((ModuleOrderEntryImpl)orderEntry).isProductionOnTestDependency() ? CollectionsKt.listOfNotNull((Object)IdeaModuleInfosKt.testSourceInfo(module2)) : $fun$toInfos$1.invoke(module2);
        } else if (orderEntry2 instanceof LibraryOrderEntry) {
            Library library2 = ((LibraryOrderEntry)orderEntry).getLibrary();
            if (library2 == null) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)library2, (String)"orderEntry.library ?: return listOf()");
            Library library3 = library2;
            list2 = IdeaModuleInfosKt.createLibraryInfo(project2, library3);
        } else if (orderEntry2 instanceof JdkOrderEntry) {
            Sdk sdk2 = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk2 == null) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            Sdk sdk3 = sdk2;
            list2 = CollectionsKt.listOfNotNull((Object)new SdkInfo(project2, sdk3));
        } else {
            throw (Throwable)new IllegalStateException("Unexpected order entry " + orderEntry);
        }
        return list2;
    }

    @NotNull
    public static final List<LibraryInfo> createLibraryInfo(@NotNull Project project2, @NotNull Library library2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        return IdePlatformKindResolutionKt.getResolution(IdePlatformKindUtil.getIdePlatformKind(LibraryKindsKt.getLibraryPlatform(project2, library2))).createLibraryInfo(project2, library2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean acceptAsDependency(@NotNull OrderEntry $this$acceptAsDependency, boolean forProduction) {
        if (!($this$acceptAsDependency instanceof ExportableOrderEntry)) return true;
        if (!forProduction) return true;
        if ($this$acceptAsDependency instanceof ModuleOrderEntryImpl) {
            if (((ModuleOrderEntryImpl)$this$acceptAsDependency).isProductionOnTestDependency()) return true;
        }
        DependencyScope dependencyScope = ((ExportableOrderEntry)$this$acceptAsDependency).getScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencyScope, (String)"scope");
        if (!dependencyScope.isForProductionCompile()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IdeaModuleInfo> ideaModelDependencies(Module module, boolean forProduction, TargetPlatform platform) {
        void $this$filterNotTo$iv$iv;
        Function2<TargetPlatform, TargetPlatform, Boolean> $fun$canDependOn$1 = new Function2<TargetPlatform, TargetPlatform, Boolean>(module){
            final /* synthetic */ Module $module;

            public final boolean invoke(@NotNull TargetPlatform $this$canDependOn, @NotNull TargetPlatform other) {
                Intrinsics.checkParameterIsNotNull((Object)$this$canDependOn, (String)"$this$canDependOn");
                Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                return PlatformKt.isHMPPEnabled(this.$module) ? other.getComponentPlatforms().containsAll((Collection)$this$canDependOn.getComponentPlatforms()) : JvmPlatformKt.isJvm($this$canDependOn) && JvmPlatformKt.isJvm(other) || JsPlatformKt.isJs($this$canDependOn) && JsPlatformKt.isJs(other) || KonanPlatformKt.isNative($this$canDependOn) && KonanPlatformKt.isNative(other) || TargetPlatformKt.isCommon($this$canDependOn) && TargetPlatformKt.isCommon(other);
            }
            {
                this.$module = module;
                super(2);
            }
        };
        LinkedHashSet result2 = new LinkedHashSet();
        OrderEnumerator orderEnumerator = ModuleRootManager.getInstance((Module)module).orderEntries().compileOnly().recursively().exportedOnly();
        Intrinsics.checkExpressionValueIsNotNull((Object)orderEnumerator, (String)"ModuleRootManager.getIns\u2026ursively().exportedOnly()");
        OrderEnumerator dependencyEnumerator = orderEnumerator;
        if (forProduction && Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType(module), (Object)BuildSystemType.JPS.INSTANCE)) {
            dependencyEnumerator.productionOnly();
        }
        dependencyEnumerator.forEach((Processor)new Processor<OrderEntry>(forProduction, result2, module){
            final /* synthetic */ boolean $forProduction;
            final /* synthetic */ LinkedHashSet $result;
            final /* synthetic */ Module $module;

            public final boolean process(OrderEntry orderEntry) {
                OrderEntry orderEntry2 = orderEntry;
                Intrinsics.checkExpressionValueIsNotNull((Object)orderEntry2, (String)"orderEntry");
                if (IdeaModuleInfosKt.access$acceptAsDependency(orderEntry2, this.$forProduction)) {
                    Project project2 = this.$module.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"module.project");
                    this.$result.addAll(IdeaModuleInfosKt.access$orderEntryToModuleInfo(project2, orderEntry, this.$forProduction));
                }
                return true;
            }
            {
                this.$forProduction = bl;
                this.$result = linkedHashSet;
                this.$module = module;
            }
        });
        Iterable $this$filterNot$iv = result2;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            IdeaModuleInfo it = (IdeaModuleInfo)element$iv$iv;
            boolean bl = false;
            if (it instanceof LibraryInfo && !$fun$canDependOn$1.invoke(platform, it.getPlatform())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ModuleProductionSourceInfo productionSourceInfo(@NotNull Module $this$productionSourceInfo) {
        Intrinsics.checkParameterIsNotNull((Object)$this$productionSourceInfo, (String)"$this$productionSourceInfo");
        return IdeaModuleInfosKt.hasProductionRoots($this$productionSourceInfo) ? new ModuleProductionSourceInfo($this$productionSourceInfo) : null;
    }

    @Nullable
    public static final ModuleTestSourceInfo testSourceInfo(@NotNull Module $this$testSourceInfo) {
        Intrinsics.checkParameterIsNotNull((Object)$this$testSourceInfo, (String)"$this$testSourceInfo");
        return IdeaModuleInfosKt.hasTestRoots($this$testSourceInfo) ? new ModuleTestSourceInfo($this$testSourceInfo) : null;
    }

    @NotNull
    public static final List<ModuleSourceInfo> correspondingModuleInfos(@NotNull Module $this$correspondingModuleInfos) {
        Intrinsics.checkParameterIsNotNull((Object)$this$correspondingModuleInfos, (String)"$this$correspondingModuleInfos");
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new ModuleSourceInfoWithExpectedBy[]{IdeaModuleInfosKt.testSourceInfo($this$correspondingModuleInfos), IdeaModuleInfosKt.productionSourceInfo($this$correspondingModuleInfos)}));
    }

    private static final boolean hasProductionRoots(@NotNull Module $this$hasProductionRoots) {
        JavaSourceRootType javaSourceRootType = JavaSourceRootType.SOURCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaSourceRootType, (String)"JavaSourceRootType.SOURCE");
        return IdeaModuleInfosKt.hasRootsOfType($this$hasProductionRoots, (JpsModuleSourceRootType)javaSourceRootType) || IdeaModuleInfosKt.hasRootsOfType($this$hasProductionRoots, SourceKotlinRootType.INSTANCE) || MultiplatformUtilKt.isNewMPPModule($this$hasProductionRoots) && MultiplatformUtilKt.getSourceType($this$hasProductionRoots) == SourceType.PRODUCTION;
    }

    private static final boolean hasTestRoots(@NotNull Module $this$hasTestRoots) {
        JavaSourceRootType javaSourceRootType = JavaSourceRootType.TEST_SOURCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaSourceRootType, (String)"JavaSourceRootType.TEST_SOURCE");
        return IdeaModuleInfosKt.hasRootsOfType($this$hasTestRoots, (JpsModuleSourceRootType)javaSourceRootType) || IdeaModuleInfosKt.hasRootsOfType($this$hasTestRoots, TestSourceKotlinRootType.INSTANCE) || MultiplatformUtilKt.isNewMPPModule($this$hasTestRoots) && MultiplatformUtilKt.getSourceType($this$hasTestRoots) == SourceType.TEST;
    }

    private static final boolean hasRootsOfType(@NotNull Module $this$hasRootsOfType, JpsModuleSourceRootType<?> sourceRootType) {
        boolean bl;
        block1: {
            ContentEntry[] contentEntryArray = ProjectRootsUtilKt.getRootManager($this$hasRootsOfType).getContentEntries();
            Intrinsics.checkExpressionValueIsNotNull((Object)contentEntryArray, (String)"rootManager.contentEntries");
            ContentEntry[] $this$any$iv = contentEntryArray;
            boolean $i$f$any = false;
            ContentEntry[] contentEntryArray2 = $this$any$iv;
            int n = contentEntryArray2.length;
            for (int j = 0; j < n; ++j) {
                ContentEntry element$iv;
                ContentEntry it = element$iv = contentEntryArray2[j];
                boolean bl2 = false;
                List list2 = it.getSourceFolders(sourceRootType);
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"it.getSourceFolders(sourceRootType)");
                Collection collection = list2;
                boolean bl3 = false;
                if (!(!collection.isEmpty())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isLibraryClasses(@NotNull IdeaModuleInfo $this$isLibraryClasses) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isLibraryClasses, (String)"$this$isLibraryClasses");
        return $this$isLibraryClasses instanceof SdkInfo || $this$isLibraryClasses instanceof LibraryInfo;
    }

    @NotNull
    public static final ModuleDescriptor.Capability<ModuleOrigin> getOriginCapability() {
        return OriginCapability;
    }

    @Nullable
    public static final List<ModuleSourceInfo> projectSourceModules(@NotNull IdeaModuleInfo $this$projectSourceModules) {
        List<ModuleSourceInfo> list2;
        block6: {
            IdeaModuleInfo ideaModuleInfo;
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)$this$projectSourceModules, (String)"$this$projectSourceModules");
                IdeaModuleInfo ideaModuleInfo2 = $this$projectSourceModules;
                if (!(ideaModuleInfo2 instanceof ModuleSourceInfo)) {
                    ideaModuleInfo2 = null;
                }
                if ((list2 = (ModuleSourceInfo)ideaModuleInfo2) == null) break block5;
                ModuleSourceInfo moduleSourceInfo = list2;
                boolean bl = false;
                boolean bl2 = false;
                ModuleSourceInfo p1 = moduleSourceInfo;
                boolean bl3 = false;
                list2 = CollectionsKt.listOf((Object)p1);
                if (list2 != null) break block6;
            }
            if (!((ideaModuleInfo = $this$projectSourceModules) instanceof PlatformModuleInfo)) {
                ideaModuleInfo = null;
            }
            PlatformModuleInfo platformModuleInfo = (PlatformModuleInfo)ideaModuleInfo;
            list2 = platformModuleInfo != null ? platformModuleInfo.getContainedModules() : null;
        }
        return list2;
    }

    @NotNull
    public static final SourceType getSourceType(@NotNull ModuleSourceInfo $this$sourceType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$sourceType, (String)"$this$sourceType");
        return $this$sourceType instanceof ModuleTestSourceInfo ? SourceType.TEST : SourceType.PRODUCTION;
    }

    static {
        Logger logger = Logger.getInstance(IdeaModuleInfo.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(IdeaModuleInfo::class.java)");
        LOG = logger;
        OriginCapability = new ModuleDescriptor.Capability("MODULE_ORIGIN");
    }

    public static final /* synthetic */ List access$ideaModelDependencies(Module module, boolean forProduction, TargetPlatform platform) {
        return IdeaModuleInfosKt.ideaModelDependencies(module, forProduction, platform);
    }

    public static final /* synthetic */ boolean access$acceptAsDependency(OrderEntry $this$access_u24acceptAsDependency, boolean forProduction) {
        return IdeaModuleInfosKt.acceptAsDependency($this$access_u24acceptAsDependency, forProduction);
    }

    public static final /* synthetic */ List access$orderEntryToModuleInfo(Project project2, OrderEntry orderEntry, boolean forProduction) {
        return IdeaModuleInfosKt.orderEntryToModuleInfo(project2, orderEntry, forProduction);
    }
}

