/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.LibraryModuleInfo;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.KotlinIdeaAnalysisBundle;
import org.jetbrains.kotlin.idea.caches.project.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.LibraryDependenciesCache;
import org.jetbrains.kotlin.idea.caches.project.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.caches.project.LibraryWithoutSourceScope;
import org.jetbrains.kotlin.idea.caches.project.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.framework.LibraryKindsKt;
import org.jetbrains.kotlin.idea.project.AnalyzerServicesKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010$H\u0016J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020+H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/LibraryInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/LibraryModuleInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/BinaryModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/libraries/Library;)V", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getLibrary", "()Lcom/intellij/openapi/roots/libraries/Library;", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "sourcesModuleInfo", "Lorg/jetbrains/kotlin/idea/caches/project/SourceForBinaryModuleInfo;", "getSourcesModuleInfo", "()Lorg/jetbrains/kotlin/idea/caches/project/SourceForBinaryModuleInfo;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "dependencies", "", "equals", "", "other", "", "getLibraryRoots", "", "", "hashCode", "", "toString", "idea-core"})
public class LibraryInfo
implements IdeaModuleInfo,
LibraryModuleInfo,
BinaryModuleInfo {
    @NotNull
    private final Name name;
    @NotNull
    private final Project project;
    @NotNull
    private final Library library;

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.LIBRARY;
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    @Override
    @NotNull
    public GlobalSearchScope contentScope() {
        return (GlobalSearchScope)new LibraryWithoutSourceScope(this.project, this.library);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        void $this$filterTo$iv$iv;
        void libraries;
        LinkedHashSet<LibraryInfo> result2 = new LinkedHashSet<LibraryInfo>();
        result2.add(this);
        Pair<List<Library>, List<Sdk>> pair2 = LibraryDependenciesCache.Companion.getInstance(this.project).getLibrariesAndSdksUsedWith(this.library);
        List list2 = (List)pair2.component1();
        List sdks = (List)pair2.component2();
        Iterable $this$mapTo$iv = sdks;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Sdk sdk2 = (Sdk)item$iv;
            Collection collection = result2;
            boolean bl = false;
            SdkInfo sdkInfo = new SdkInfo(this.project, (Sdk)it);
            collection.add(sdkInfo);
        }
        Iterable $this$filter$iv = (Iterable)libraries;
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Library it = (Library)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof LibraryEx && !((LibraryEx)it).isDisposed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMapTo$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Library it = (Library)element$iv;
            boolean bl = false;
            Iterable list$iv = IdeaModuleInfosKt.createLibraryInfo(this.project, it);
            CollectionsKt.addAll((Collection)result2, (Iterable)list$iv);
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    @Override
    @NotNull
    public TargetPlatform getPlatform() {
        return LibraryKindsKt.getLibraryPlatform(this.project, this.library);
    }

    @Override
    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return AnalyzerServicesKt.getFindAnalyzerServices(this.getPlatform());
    }

    @Override
    @NotNull
    public SourceForBinaryModuleInfo getSourcesModuleInfo() {
        return new LibrarySourceInfo(this.project, this.library, this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<String> getLibraryRoots() {
        void $this$mapNotNullTo$iv$iv;
        VirtualFile[] virtualFileArray = this.library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        VirtualFile[] $this$mapNotNull$iv = virtualFileArray;
        boolean $i$f$mapNotNull = false;
        VirtualFile[] virtualFileArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var8_8 = $this$forEach$iv$iv$iv;
        int n = ((void)var8_8).length;
        for (int j = 0; j < n; ++j) {
            String string;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var8_8[j];
            boolean bl = false;
            void p1 = element$iv$iv;
            boolean bl2 = false;
            if (PathUtil.getLocalPath((VirtualFile)p1) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String toString() {
        return "LibraryInfo(libraryName=" + this.library.getName() + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LibraryInfo && Intrinsics.areEqual((Object)this.library, (Object)((LibraryInfo)other).library);
    }

    public int hashCode() {
        return 43 * this.library.hashCode();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Library getLibrary() {
        return this.library;
    }

    public LibraryInfo(@NotNull Project project2, @NotNull Library library2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        this.project = project2;
        this.library = library2;
        Name name2 = Name.special(KotlinIdeaAnalysisBundle.message("library.0", String.valueOf(this.library.getName())));
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.special(KotlinIdeaA\u2026library.name.toString()))");
        this.name = name2;
    }

    @Override
    @NotNull
    public Map<ModuleDescriptor.Capability<?>, Object> getCapabilities() {
        return IdeaModuleInfo.DefaultImpls.getCapabilities(this);
    }

    @Override
    @NotNull
    public String getDisplayedName() {
        return IdeaModuleInfo.DefaultImpls.getDisplayedName(this);
    }

    @Override
    @NotNull
    public List<ModuleInfo> getExpectedBy() {
        return IdeaModuleInfo.DefaultImpls.getExpectedBy(this);
    }

    @Override
    @Nullable
    public Name getStableName() {
        return IdeaModuleInfo.DefaultImpls.getStableName(this);
    }

    @Override
    @NotNull
    public ModuleInfo.DependencyOnBuiltIns dependencyOnBuiltIns() {
        return IdeaModuleInfo.DefaultImpls.dependencyOnBuiltIns(this);
    }

    @Override
    @NotNull
    public Collection<ModuleInfo> modulesWhoseInternalsAreVisible() {
        return IdeaModuleInfo.DefaultImpls.modulesWhoseInternalsAreVisible(this);
    }

    @Override
    @NotNull
    public GlobalSearchScope binariesScope() {
        return BinaryModuleInfo.DefaultImpls.binariesScope(this);
    }
}

