/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J$\u0010\r\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinNativeLibraryNameUtil;", "", "()V", "IDE_LIBRARY_NAME_REGEX", "Lkotlin/text/Regex;", "buildIDELibraryName", "", "kotlinVersion", "libraryName", "platform", "isGradleLibraryName", "", "ideLibraryName", "parseIDELibraryName", "Lkotlin/Triple;", "idea-gradle"})
public final class KotlinNativeLibraryNameUtil {
    private static final Regex IDE_LIBRARY_NAME_REGEX;
    public static final KotlinNativeLibraryNameUtil INSTANCE;

    @NotNull
    public final String buildIDELibraryName(@NotNull String kotlinVersion2, @NotNull String libraryName, @Nullable String platform) {
        String string;
        boolean bl;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)kotlinVersion2, (String)"kotlinVersion");
        Intrinsics.checkParameterIsNotNull((Object)libraryName, (String)"libraryName");
        String string3 = platform;
        if (string3 != null) {
            string2 = string3;
            bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            string = " [" + it + ']';
        } else {
            string = null;
        }
        string2 = string;
        bl = false;
        String string4 = string2;
        if (string4 == null) {
            string4 = "";
        }
        String platformNamePart = string4;
        return "Kotlin/Native " + kotlinVersion2 + " - " + libraryName + platformNamePart;
    }

    @Nullable
    public final Triple<String, String, String> parseIDELibraryName(@NotNull String ideLibraryName) {
        Intrinsics.checkParameterIsNotNull((Object)ideLibraryName, (String)"ideLibraryName");
        MatchResult matchResult = IDE_LIBRARY_NAME_REGEX.matchEntire((CharSequence)ideLibraryName);
        if (matchResult == null) {
            return null;
        }
        MatchResult match2 = matchResult;
        MatchGroup matchGroup = match2.getGroups().get(1);
        if (matchGroup == null) {
            Intrinsics.throwNpe();
        }
        String kotlinVersion2 = matchGroup.getValue();
        MatchGroup matchGroup2 = match2.getGroups().get(2);
        if (matchGroup2 == null) {
            Intrinsics.throwNpe();
        }
        String libraryName = matchGroup2.getValue();
        MatchGroup matchGroup3 = match2.getGroups().get(4);
        String platform = matchGroup3 != null ? matchGroup3.getValue() : null;
        return new Triple((Object)kotlinVersion2, (Object)libraryName, (Object)platform);
    }

    public final boolean isGradleLibraryName(@NotNull String ideLibraryName) {
        Intrinsics.checkParameterIsNotNull((Object)ideLibraryName, (String)"ideLibraryName");
        return StringsKt.startsWith$default((String)ideLibraryName, (String)"Gradle: ", (boolean)false, (int)2, null);
    }

    private KotlinNativeLibraryNameUtil() {
    }

    static {
        KotlinNativeLibraryNameUtil kotlinNativeLibraryNameUtil;
        INSTANCE = kotlinNativeLibraryNameUtil = new KotlinNativeLibraryNameUtil();
        IDE_LIBRARY_NAME_REGEX = new Regex("^Kotlin/Native ([^\\s]+) - ([^\\s]+)( \\[([\\w]+)\\])?$");
    }
}

