/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.Gradle;
import org.jetbrains.kotlin.idea.configuration.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.configuration.GradleBuildScriptManipulatorKt;
import org.jetbrains.kotlin.idea.configuration.GroovyBuildScriptManipulator;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildScriptManipulator;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.kotlin.idea.quickfix.ChangeCoroutineSupportFix;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 F2\u00020\u0001:\u0001FB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0014J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u001e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#H\u0017J(\u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0002J>\u0010'\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0)H\u0016J\u0018\u0010*\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0004J$\u0010+\u001a\u00020&2\u0006\u0010 \u001a\u00020!2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\f\u001a\u00020\u0004J2\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0.2\u0006\u0010 \u001a\u00020!2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u00100\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&J\u001c\u00101\u001a\u0004\u0018\u00010\u00042\b\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\f\u001a\u00020\u0004H\u0014J\u0010\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\bH$J\b\u00106\u001a\u00020\u0004H\u0014J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u001a\u0010;\u001a\u00020\u00042\b\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\f\u001a\u00020\u0004H\u0014J\u0010\u0010<\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\nH\u0002J4\u0010?\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010@\u001a\u0004\u0018\u00010\u00042\b\u0010A\u001a\u0004\u0018\u00010\u00042\u0006\u0010B\u001a\u00020C2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\f\u0010D\u001a\u00020\b*\u00020\nH\u0002J\f\u0010E\u001a\u00020\b*\u00020\nH\u0004R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "()V", "kotlinPluginName", "", "getKotlinPluginName", "()Ljava/lang/String;", "addElementsToFile", "", "file", "Lcom/intellij/psi/PsiFile;", "isTopLevelProjectFile", "version", "addLibraryDependency", "", "module", "Lcom/intellij/openapi/module/Module;", "element", "Lcom/intellij/psi/PsiElement;", "library", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "libraryJarDescriptors", "", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "changeCoroutineConfiguration", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "changeGeneralFeatureConfiguration", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "forTests", "configure", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "configureBuildScript", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "configureModule", "filesToOpen", "", "configureModuleBuildScript", "configureSilently", "modules", "configureWithVersion", "Ljava/util/HashSet;", "modulesToConfigure", "kotlinVersion", "getJvmTarget", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getKotlinPluginExpression", "forKotlinDsl", "getMinimumSupportedVersion", "getStatus", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "moduleSourceRootGroup", "Lorg/jetbrains/kotlin/idea/configuration/ModuleSourceRootGroup;", "getStdlibArtifactName", "isApplicable", "isFileConfigured", "buildScript", "updateLanguageVersion", "languageVersion", "apiVersion", "requiredStdlibVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "isConfiguredByAnyGradleConfigurator", "isKtDsl", "Companion", "idea-gradle"})
public abstract class KotlinWithGradleConfigurator
implements KotlinProjectConfigurator {
    @NotNull
    private static final String GROUP_ID = "org.jetbrains.kotlin";
    @NotNull
    private static final String GRADLE_PLUGIN_ID = "kotlin-gradle-plugin";
    @NotNull
    private static final String CLASSPATH = "classpath \"org.jetbrains.kotlin:kotlin-gradle-plugin:$kotlin_version\"";
    private static final String KOTLIN_BUILD_SCRIPT_NAME = "build.gradle.kts";
    private static final String KOTLIN_SETTINGS_SCRIPT_NAME = "settings.gradle.kts";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        boolean bl;
        block11: {
            boolean bl2;
            Module module;
            block10: {
                Intrinsics.checkParameterIsNotNull((Object)moduleSourceRootGroup, (String)"moduleSourceRootGroup");
                module = moduleSourceRootGroup.getBaseModule();
                if (!this.isApplicable(module)) {
                    return ConfigureKotlinStatus.NON_APPLICABLE;
                }
                Iterable $this$all$iv = moduleSourceRootGroup.getSourceRootModules();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Module p1 = (Module)element$iv;
                        boolean bl3 = false;
                        if (ConfigureKotlinInProjectUtilsKt.hasAnyKotlinRuntimeInScope(p1)) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return ConfigureKotlinStatus.CONFIGURED;
            }
            List buildFiles2 = (List)ApplicationUtilsKt.runReadAction((Function0)new Function0<List<? extends PsiFile>>(module){
                final /* synthetic */ Module $module;

                @NotNull
                public final List<PsiFile> invoke() {
                    Object[] objectArray = new PsiFile[2];
                    objectArray[0] = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$getBuildScriptPsiFile(KotlinWithGradleConfigurator.Companion, this.$module);
                    Project project2 = this.$module.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"module.project");
                    objectArray[1] = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$getTopLevelBuildScriptPsiFile(KotlinWithGradleConfigurator.Companion, project2);
                    return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])objectArray));
                }
                {
                    this.$module = module;
                    super(0);
                }
            });
            if (buildFiles2.isEmpty()) {
                return ConfigureKotlinStatus.NON_APPLICABLE;
            }
            Iterable $this$none$iv = buildFiles2;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    PsiFile it = (PsiFile)element$iv;
                    boolean bl4 = false;
                    if (!this.isConfiguredByAnyGradleConfigurator(it)) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl) {
            return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
        }
        return ConfigureKotlinStatus.BROKEN;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isConfiguredByAnyGradleConfigurator(@NotNull PsiFile $this$isConfiguredByAnyGradleConfigurator) {
        boolean bl;
        block4: {
            void $this$filterIsInstanceTo$iv$iv;
            KotlinProjectConfigurator[] extensions = (KotlinProjectConfigurator[])Extensions.getExtensions(KotlinProjectConfigurator.Companion.getEP_NAME());
            Intrinsics.checkExpressionValueIsNotNull((Object)extensions, (String)"extensions");
            KotlinProjectConfigurator[] $this$filterIsInstance$iv = extensions;
            boolean $i$f$filterIsInstance = false;
            KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KotlinWithGradleConfigurator)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinWithGradleConfigurator it = (KotlinWithGradleConfigurator)element$iv;
                    boolean bl2 = false;
                    if (!it.isFileConfigured($this$isConfiguredByAnyGradleConfigurator)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType(module), (Object)Gradle.INSTANCE);
    }

    @NotNull
    protected String getMinimumSupportedVersion() {
        return "1.0.0";
    }

    protected final boolean isKtDsl(@NotNull PsiFile $this$isKtDsl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isKtDsl, (String)"$this$isKtDsl");
        return $this$isKtDsl instanceof KtFile;
    }

    private final boolean isFileConfigured(PsiFile buildScript) {
        GradleBuildScriptManipulator gradleBuildScriptManipulator = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulatorIfAny$default(Companion, buildScript, false, 2, null);
        if (gradleBuildScriptManipulator == null) {
            return false;
        }
        GradleBuildScriptManipulator manipulator = gradleBuildScriptManipulator;
        boolean bl = false;
        boolean bl2 = false;
        GradleBuildScriptManipulator $this$with = manipulator;
        boolean bl3 = false;
        return $this$with.isConfiguredWithOldSyntax(this.getKotlinPluginName()) || $this$with.isConfigured(this.getKotlinPluginExpression(this.isKtDsl(buildScript)));
    }

    @Override
    @JvmSuppressWildcards
    public void configure(@NotNull Project project2, @NotNull Collection<Module> excludeModules) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        ConfigureDialogWithModulesAndVersion dialog2 = new ConfigureDialogWithModulesAndVersion(project2, this, excludeModules, this.getMinimumSupportedVersion());
        dialog2.show();
        if (!dialog2.isOK()) {
            return;
        }
        List<Module> list2 = dialog2.getModulesToConfigure();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"dialog.modulesToConfigure");
        String string = dialog2.getKotlinVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dialog.kotlinVersion");
        NotificationMessageCollector collector2 = this.configureSilently(project2, list2, string);
        collector2.showNotification();
    }

    @NotNull
    public final NotificationMessageCollector configureSilently(@NotNull Project project2, @NotNull List<? extends Module> modules2, @NotNull String version2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(modules2, (String)"modules");
        Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version");
        return (NotificationMessageCollector)ApplicationUtilsKt.executeCommand$default(project2, "Configure Kotlin", null, (Function0)new Function0<NotificationMessageCollector>(this, project2, modules2, version2){
            final /* synthetic */ KotlinWithGradleConfigurator this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ List $modules;
            final /* synthetic */ String $version;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final NotificationMessageCollector invoke() {
                void var1_1;
                NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(this.$project);
                HashSet<PsiFile> changedFiles = this.this$0.configureWithVersion(this.$project, this.$modules, this.$version, collector2);
                Iterator<PsiFile> iterator2 = changedFiles.iterator();
                while (iterator2.hasNext()) {
                    PsiFile file2;
                    PsiFile psiFile2 = file2 = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"file");
                    OpenFileAction.openFile((VirtualFile)psiFile2.getVirtualFile(), (Project)this.$project);
                }
                return var1_1;
            }
            {
                this.this$0 = kotlinWithGradleConfigurator;
                this.$project = project2;
                this.$modules = list2;
                this.$version = string;
                super(0);
            }
        }, 2, null);
    }

    @NotNull
    public final HashSet<PsiFile> configureWithVersion(@NotNull Project project2, @NotNull List<? extends Module> modulesToConfigure, @NotNull String kotlinVersion2, @NotNull NotificationMessageCollector collector2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(modulesToConfigure, (String)"modulesToConfigure");
        Intrinsics.checkParameterIsNotNull((Object)kotlinVersion2, (String)"kotlinVersion");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        HashSet<PsiFile> filesToOpen = new HashSet<PsiFile>();
        PsiFile buildScript = KotlinWithGradleConfigurator.Companion.getTopLevelBuildScriptPsiFile(project2);
        if (buildScript != null && KotlinWithGradleConfigurator.Companion.canConfigureFile(buildScript) && (bl = this.configureBuildScript(buildScript, true, kotlinVersion2, collector2))) {
            filesToOpen.add(buildScript);
        }
        for (Module module : modulesToConfigure) {
            PsiFile file2 = KotlinWithGradleConfigurator.Companion.getBuildScriptPsiFile(module);
            if (file2 != null && KotlinWithGradleConfigurator.Companion.canConfigureFile(file2)) {
                this.configureModule(module, file2, false, kotlinVersion2, collector2, (Collection<PsiFile>)filesToOpen);
                continue;
            }
            Object[] objectArray = new Object[1];
            String string = module.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.name");
            objectArray[0] = string;
            KotlinWithGradleConfigurator.Companion.showErrorMessage(project2, KotlinIdeaGradleBundle.message("error.text.cannot.find.build.gradle.file.for.module", objectArray));
        }
        return filesToOpen;
    }

    public void configureModule(@NotNull Module module, @NotNull PsiFile file2, boolean isTopLevelProjectFile, @NotNull String version2, @NotNull NotificationMessageCollector collector2, @NotNull Collection<PsiFile> filesToOpen) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        Intrinsics.checkParameterIsNotNull(filesToOpen, (String)"filesToOpen");
        boolean isModified2 = this.configureBuildScript(file2, isTopLevelProjectFile, version2, collector2);
        if (isModified2) {
            filesToOpen.add(file2);
        }
    }

    protected final boolean configureModuleBuildScript(@NotNull PsiFile file2, @NotNull String version2) {
        Sdk sdk2;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version");
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)file2));
        if (module != null) {
            Module module2 = module;
            boolean bl = false;
            boolean bl2 = false;
            Module it = module2;
            boolean bl3 = false;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(it)");
            sdk2 = moduleRootManager.getSdk();
        } else {
            sdk2 = null;
        }
        Sdk sdk3 = sdk2;
        String jvmTarget = this.getJvmTarget(sdk3, version2);
        return org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(Companion, file2, false, 2, null).configureModuleBuildScript(this.getKotlinPluginName(), this.getKotlinPluginExpression(this.isKtDsl(file2)), this.getStdlibArtifactName(sdk3, version2), version2, jvmTarget);
    }

    @NotNull
    protected String getStdlibArtifactName(@Nullable Sdk sdk2, @NotNull String version2) {
        Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version");
        return KotlinRuntimeLibraryUtilKt.getStdlibArtifactId(sdk2, version2);
    }

    @Nullable
    protected String getJvmTarget(@Nullable Sdk sdk2, @NotNull String version2) {
        Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version");
        return null;
    }

    @NotNull
    protected abstract String getKotlinPluginName();

    @NotNull
    protected abstract String getKotlinPluginExpression(boolean var1);

    protected boolean addElementsToFile(@NotNull PsiFile file2, boolean isTopLevelProjectFile, @NotNull String version2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version");
        if (!isTopLevelProjectFile) {
            boolean wasModified = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(Companion, file2, false, 2, null).configureProjectBuildScript(this.getKotlinPluginName(), version2);
            return wasModified |= this.configureModuleBuildScript(file2, version2);
        }
        return false;
    }

    private final boolean configureBuildScript(PsiFile file2, boolean isTopLevelProjectFile, String version2, NotificationMessageCollector collector2) {
        Project project2 = file2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"file.project");
        boolean isModified2 = (Boolean)ApplicationUtilsKt.executeWriteCommand(project2, "Configure " + file2.getName(), null, (Function0)new Function0<Boolean>(this, file2, isTopLevelProjectFile, version2){
            final /* synthetic */ KotlinWithGradleConfigurator this$0;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ boolean $isTopLevelProjectFile;
            final /* synthetic */ String $version;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void var1_1;
                boolean isModified2 = this.this$0.addElementsToFile(this.$file, this.$isTopLevelProjectFile, this.$version);
                CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)this.$file));
                return (boolean)var1_1;
            }
            {
                this.this$0 = kotlinWithGradleConfigurator;
                this.$file = psiFile2;
                this.$isTopLevelProjectFile = bl;
                this.$version = string;
                super(0);
            }
        });
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 != null && isModified2) {
            Object[] objectArray = new Object[1];
            String string = virtualFile2.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"virtualFile.path");
            objectArray[0] = string;
            collector2.addMessage(KotlinIdeaGradleBundle.message("text.was.modified", objectArray));
        }
        return isModified2;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateLanguageVersion(@NotNull Module module, @Nullable String languageVersion, @Nullable String apiVersion, @NotNull ApiVersion requiredStdlibVersion, boolean forTests) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)requiredStdlibVersion, (String)"requiredStdlibVersion");
            v0 = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module);
            if (v0 == null) ** GOTO lbl-1000
            var7_6 = v0;
            var8_7 = false;
            var9_9 = false;
            it = var7_6;
            $i$a$-let-KotlinWithGradleConfigurator$updateLanguageVersion$runtimeUpdateRequired$1 = false;
            v0 = ApiVersion.Companion.parse(it);
            if (v0 != null) {
                var7_6 = v0;
                var8_7 = false;
                var9_9 = false;
                runtimeVersion = var7_6;
                $i$a$-let-KotlinWithGradleConfigurator$updateLanguageVersion$runtimeUpdateRequired$2 = false;
                v1 = runtimeVersion.compareTo(requiredStdlibVersion) < 0;
            } else lbl-1000:
            // 2 sources

            {
                v1 = runtimeUpdateRequired = false;
            }
            if (runtimeUpdateRequired) {
                Messages.showErrorDialog((Project)module.getProject(), (String)KotlinIdeaGradleBundle.message("error.text.this.language.feature.requires.version", new Object[]{requiredStdlibVersion}), (String)KotlinIdeaGradleBundle.message("title.update.language.version", new Object[0]));
                return;
            }
            v2 = element = KotlinWithGradleConfigurator.Companion.changeLanguageVersion(module, languageVersion, apiVersion, forTests);
            if (v2 == null) break block3;
            var8_8 = v2;
            var9_9 = false;
            var10_11 = false;
            it = var8_8;
            $i$a$-let-KotlinWithGradleConfigurator$updateLanguageVersion$1 = false;
            v3 = module.getProject();
            v4 = it.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it.containingFile");
            v5 = v4.getVirtualFile();
            v6 = it.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it.textRange");
            new OpenFileDescriptor(v3, v5, v6.getStartOffset()).navigate(true);
        }
    }

    @Override
    public void changeCoroutineConfiguration(@NotNull Module module, @NotNull LanguageFeature.State state) {
        boolean runtimeUpdateRequired;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        boolean bl = runtimeUpdateRequired = state != LanguageFeature.State.DISABLED && Intrinsics.areEqual((Object)KotlinVersionInfoProviderKt.toApiVersion(KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module)), (Object)ApiVersion.KOTLIN_1_0);
        if (runtimeUpdateRequired) {
            Messages.showErrorDialog((Project)module.getProject(), (String)KotlinIdeaGradleBundle.message("error.text.coroutines.support.requires.version.1.1.or.later.of.the.kotlin.runtime.library", new Object[0]), (String)ChangeCoroutineSupportFix.Companion.getFixText(state));
            return;
        }
        PsiElement element3 = Companion.changeCoroutineConfiguration(module, CoroutineSupport.INSTANCE.getCompilerArgument(state));
        if (element3 != null) {
            Project project2 = module.getProject();
            PsiFile psiFile2 = element3.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"element.containingFile");
            VirtualFile virtualFile2 = psiFile2.getVirtualFile();
            TextRange textRange = element3.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.textRange");
            new OpenFileDescriptor(project2, virtualFile2, textRange.getStartOffset()).navigate(true);
        }
    }

    @Override
    public void changeGeneralFeatureConfiguration(@NotNull Module module, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State state, boolean forTests) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)((Object)feature), (String)"feature");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        ApiVersion sinceVersion = feature.getSinceApiVersion();
        if (state != LanguageFeature.State.DISABLED && KotlinVersionInfoProviderKt.toApiVersion(KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module)).compareTo(sinceVersion) < 0) {
            Messages.showErrorDialog((Project)module.getProject(), (String)KotlinIdeaGradleBundle.message("error.text.support.requires.version", feature.getPresentableName(), sinceVersion), (String)ChangeCoroutineSupportFix.Companion.getFixText(state));
            return;
        }
        PsiElement element3 = Companion.changeFeatureConfiguration(module, feature, state, forTests);
        if (element3 != null) {
            Project project2 = module.getProject();
            PsiFile psiFile2 = element3.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"element.containingFile");
            VirtualFile virtualFile2 = psiFile2.getVirtualFile();
            TextRange textRange = element3.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.textRange");
            new OpenFileDescriptor(project2, virtualFile2, textRange.getStartOffset()).navigate(true);
        }
    }

    @Override
    public void addLibraryDependency(@NotNull Module module, @NotNull PsiElement element3, @NotNull ExternalLibraryDescriptor library2, @NotNull List<? extends LibraryJarDescriptor> libraryJarDescriptors) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        Intrinsics.checkParameterIsNotNull(libraryJarDescriptors, (String)"libraryJarDescriptors");
        DependencyScope dependencyScope = OrderEntryFix.suggestScopeByLocation((Module)module, (PsiElement)element3);
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencyScope, (String)"OrderEntryFix.suggestSco\u2026Location(module, element)");
        DependencyScope scope2 = dependencyScope;
        Companion.addKotlinLibraryToModule(module, scope2, library2);
    }

    static {
        GROUP_ID = GROUP_ID;
        GRADLE_PLUGIN_ID = GRADLE_PLUGIN_ID;
        CLASSPATH = "classpath \"" + GROUP_ID + ':' + GRADLE_PLUGIN_ID + ":$kotlin_version\"";
        KOTLIN_BUILD_SCRIPT_NAME = KOTLIN_BUILD_SCRIPT_NAME;
        KOTLIN_SETTINGS_SCRIPT_NAME = KOTLIN_SETTINGS_SCRIPT_NAME;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u001cH\u0002J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0004J(\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0016J,\u0010%\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010&\u001a\u0004\u0018\u00010\u00042\b\u0010'\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020\u0016J+\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u00042\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040,\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004J&\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u000204J\u0010\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u00106\u001a\u0006\u0012\u0002\b\u0003072\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u00108\u001a\u00020\u0016J\u001e\u00109\u001a\b\u0012\u0002\b\u0003\u0018\u0001072\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u00108\u001a\u00020\u0016J\u001a\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010\u0004H\u0002J'\u0010>\u001a\u0004\u0018\u00010)*\u00020\u00102\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040,\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010?J\u0013\u0010@\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\bA*\u00020\u0010H\u0002J'\u0010B\u001a\u0004\u0018\u00010)*\u00020\u00102\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040,\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010?J\u0011\u0010C\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\bA*\u00020\u0010J\u001b\u0010D\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\bA*\u00020)2\u0006\u0010;\u001a\u00020<H\u0002J\u0013\u0010E\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\bA*\u00020<H\u0002J\u0011\u0010F\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\bA*\u00020\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator$Companion;", "", "()V", "CLASSPATH", "", "getCLASSPATH", "()Ljava/lang/String;", "GRADLE_PLUGIN_ID", "getGRADLE_PLUGIN_ID", "GROUP_ID", "getGROUP_ID", "KOTLIN_BUILD_SCRIPT_NAME", "KOTLIN_SETTINGS_SCRIPT_NAME", "addKotlinLibraryToModule", "", "module", "Lcom/intellij/openapi/module/Module;", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "libraryDescriptor", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "canConfigureFile", "", "file", "Lcom/intellij/psi/PsiFile;", "changeBuildGradle", "Lcom/intellij/psi/PsiElement;", "body", "Lkotlin/Function1;", "changeCoroutineConfiguration", "coroutineOption", "changeFeatureConfiguration", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "forTests", "changeLanguageVersion", "languageVersion", "apiVersion", "findBuildGradleFile", "Ljava/io/File;", "path", "fileNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/io/File;", "getGroovyApplyPluginDirective", "pluginName", "getGroovyDependencySnippet", "artifactName", "withVersion", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "getKotlinStdlibVersion", "getManipulator", "Lorg/jetbrains/kotlin/idea/configuration/GradleBuildScriptManipulator;", "preferNewSyntax", "getManipulatorIfAny", "showErrorMessage", "project", "Lcom/intellij/openapi/project/Project;", "message", "getBuildScriptFile", "(Lcom/intellij/openapi/module/Module;[Ljava/lang/String;)Ljava/io/File;", "getBuildScriptPsiFile", "Lorg/jetbrains/annotations/Nullable;", "getBuildScriptSettingsFile", "getBuildScriptSettingsPsiFile", "getPsiFile", "getTopLevelBuildScriptPsiFile", "getTopLevelBuildScriptSettingsPsiFile", "idea-gradle"})
    public static final class Companion {
        @Nullable
        public final GradleBuildScriptManipulator<?> getManipulatorIfAny(@NotNull PsiFile file2, boolean preferNewSyntax) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            PsiFile psiFile2 = file2;
            return psiFile2 instanceof KtFile ? (GradleBuildScriptManipulator)new KotlinBuildScriptManipulator((KtFile)file2, preferNewSyntax) : (psiFile2 instanceof GroovyFile ? (GradleBuildScriptManipulator)new GroovyBuildScriptManipulator((GroovyFile)file2, preferNewSyntax) : null);
        }

        public static /* synthetic */ GradleBuildScriptManipulator getManipulatorIfAny$default(Companion companion, PsiFile psiFile2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.getManipulatorIfAny(psiFile2, bl);
        }

        @NotNull
        public final GradleBuildScriptManipulator<?> getManipulator(@NotNull PsiFile file2, boolean preferNewSyntax) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            GradleBuildScriptManipulator<?> gradleBuildScriptManipulator = this.getManipulatorIfAny(file2, preferNewSyntax);
            if (gradleBuildScriptManipulator == null) {
                String string = "Unknown build script file type (" + Reflection.getOrCreateKotlinClass(file2.getClass()).getQualifiedName() + ")!";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return gradleBuildScriptManipulator;
        }

        public static /* synthetic */ GradleBuildScriptManipulator getManipulator$default(Companion companion, PsiFile psiFile2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.getManipulator(psiFile2, bl);
        }

        @NotNull
        public final String getGROUP_ID() {
            return GROUP_ID;
        }

        @NotNull
        public final String getGRADLE_PLUGIN_ID() {
            return GRADLE_PLUGIN_ID;
        }

        @NotNull
        public final String getCLASSPATH() {
            return CLASSPATH;
        }

        @NotNull
        public final String getGroovyDependencySnippet(@NotNull String artifactName, @NotNull String scope2, boolean withVersion, @NotNull GradleVersion gradleVersion) {
            Intrinsics.checkParameterIsNotNull((Object)artifactName, (String)"artifactName");
            Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
            Intrinsics.checkParameterIsNotNull((Object)gradleVersion, (String)"gradleVersion");
            String updatedScope = GradleBuildScriptManipulatorKt.scope(gradleVersion, scope2);
            String versionStr = withVersion ? ":$kotlin_version" : "";
            return updatedScope + " \"org.jetbrains.kotlin:" + artifactName + versionStr + '\"';
        }

        @NotNull
        public final String getGroovyApplyPluginDirective(@NotNull String pluginName) {
            Intrinsics.checkParameterIsNotNull((Object)pluginName, (String)"pluginName");
            return "apply plugin: '" + pluginName + '\'';
        }

        public final void addKotlinLibraryToModule(@NotNull Module module, @NotNull DependencyScope scope2, @NotNull ExternalLibraryDescriptor libraryDescriptor) {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
                Intrinsics.checkParameterIsNotNull((Object)libraryDescriptor, (String)"libraryDescriptor");
                PsiFile psiFile2 = this.getBuildScriptPsiFile(module);
                if (psiFile2 == null) {
                    return;
                }
                PsiFile buildScript = psiFile2;
                if (!this.canConfigureFile(buildScript)) {
                    return;
                }
                org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(this, buildScript, false, 2, null).addKotlinLibraryToModuleBuildScript(module, scope2, libraryDescriptor);
                VirtualFile virtualFile2 = buildScript.getVirtualFile();
                if (virtualFile2 == null) break block2;
                VirtualFile virtualFile3 = virtualFile2;
                boolean bl = false;
                boolean bl2 = false;
                VirtualFile it = virtualFile3;
                boolean bl3 = false;
                Project project2 = buildScript.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"buildScript.project");
                NotificationMessageCollector notificationMessageCollector = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project2);
                Object[] objectArray = new Object[1];
                String string = it.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.path");
                objectArray[0] = string;
                notificationMessageCollector.addMessage(KotlinIdeaGradleBundle.message("text.was.modified", objectArray)).showNotification();
            }
        }

        @Nullable
        public final PsiElement changeCoroutineConfiguration(@NotNull Module module, @NotNull String coroutineOption) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)coroutineOption, (String)"coroutineOption");
            return this.changeBuildGradle(module, (Function1<? super PsiFile, ? extends PsiElement>)((Function1)new Function1<PsiFile, PsiElement>(coroutineOption){
                final /* synthetic */ String $coroutineOption;

                @Nullable
                public final PsiElement invoke(@NotNull PsiFile it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(KotlinWithGradleConfigurator.Companion, it, false, 2, null).changeCoroutineConfiguration(this.$coroutineOption);
                }
                {
                    this.$coroutineOption = string;
                    super(1);
                }
            }));
        }

        @Nullable
        public final PsiElement changeFeatureConfiguration(@NotNull Module module, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State state, boolean forTests) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)((Object)feature), (String)"feature");
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            return this.changeBuildGradle(module, (Function1<? super PsiFile, ? extends PsiElement>)((Function1)new Function1<PsiFile, PsiElement>(feature, state, forTests){
                final /* synthetic */ LanguageFeature $feature;
                final /* synthetic */ LanguageFeature.State $state;
                final /* synthetic */ boolean $forTests;

                @Nullable
                public final PsiElement invoke(@NotNull PsiFile it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(KotlinWithGradleConfigurator.Companion, it, false, 2, null).changeLanguageFeatureConfiguration(this.$feature, this.$state, this.$forTests);
                }
                {
                    this.$feature = languageFeature;
                    this.$state = state;
                    this.$forTests = bl;
                    super(1);
                }
            }));
        }

        @Nullable
        public final PsiElement changeLanguageVersion(@NotNull Module module, @Nullable String languageVersion, @Nullable String apiVersion, boolean forTests) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            return this.changeBuildGradle(module, (Function1<? super PsiFile, ? extends PsiElement>)((Function1)new Function1<PsiFile, PsiElement>(languageVersion, forTests, apiVersion){
                final /* synthetic */ String $languageVersion;
                final /* synthetic */ boolean $forTests;
                final /* synthetic */ String $apiVersion;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final PsiElement invoke(@NotNull PsiFile buildScriptFile) {
                    void var3_3;
                    Intrinsics.checkParameterIsNotNull((Object)buildScriptFile, (String)"buildScriptFile");
                    GradleBuildScriptManipulator manipulator = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(KotlinWithGradleConfigurator.Companion, buildScriptFile, false, 2, null);
                    PsiElement result2 = null;
                    if (this.$languageVersion != null) {
                        result2 = manipulator.changeLanguageVersion(this.$languageVersion, this.$forTests);
                    }
                    if (this.$apiVersion != null) {
                        result2 = manipulator.changeApiVersion(this.$apiVersion, this.$forTests);
                    }
                    return var3_3;
                }
                {
                    this.$languageVersion = string;
                    this.$forTests = bl;
                    this.$apiVersion = string2;
                    super(1);
                }
            }));
        }

        private final PsiElement changeBuildGradle(Module module, Function1<? super PsiFile, ? extends PsiElement> body2) {
            PsiFile buildScriptFile = this.getBuildScriptPsiFile(module);
            if (buildScriptFile != null && this.canConfigureFile(buildScriptFile)) {
                Project project2 = buildScriptFile.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"buildScriptFile.project");
                return (PsiElement)ApplicationUtilsKt.executeWriteCommand(project2, KotlinIdeaGradleBundle.message("change.build.gradle.configuration", new Object[0]), null, (Function0)new Function0<PsiElement>(body2, buildScriptFile){
                    final /* synthetic */ Function1 $body;
                    final /* synthetic */ PsiFile $buildScriptFile;

                    @Nullable
                    public final PsiElement invoke() {
                        return (PsiElement)this.$body.invoke((Object)this.$buildScriptFile);
                    }
                    {
                        this.$body = function1;
                        this.$buildScriptFile = psiFile2;
                        super(0);
                    }
                });
            }
            return null;
        }

        @Nullable
        public final String getKotlinStdlibVersion(@NotNull Module module) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            PsiFile psiFile2 = this.getBuildScriptPsiFile(module);
            if (psiFile2 != null) {
                PsiFile psiFile3 = psiFile2;
                boolean bl = false;
                boolean bl2 = false;
                PsiFile it = psiFile3;
                boolean bl3 = false;
                string = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(Companion, it, false, 2, null).getKotlinStdlibVersion();
            } else {
                string = null;
            }
            return string;
        }

        private final boolean canConfigureFile(PsiFile file2) {
            return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file2.getVirtualFile(), null);
        }

        private final PsiFile getBuildScriptPsiFile(@NotNull Module $this$getBuildScriptPsiFile) {
            PsiFile psiFile2;
            File file2 = this.getBuildScriptFile($this$getBuildScriptPsiFile, "build.gradle", KOTLIN_BUILD_SCRIPT_NAME);
            if (file2 != null) {
                Project project2 = $this$getBuildScriptPsiFile.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                psiFile2 = this.getPsiFile(file2, project2);
            } else {
                psiFile2 = null;
            }
            return psiFile2;
        }

        @Nullable
        public final PsiFile getBuildScriptSettingsPsiFile(@NotNull Module $this$getBuildScriptSettingsPsiFile) {
            PsiFile psiFile2;
            Intrinsics.checkParameterIsNotNull((Object)$this$getBuildScriptSettingsPsiFile, (String)"$this$getBuildScriptSettingsPsiFile");
            File file2 = this.getBuildScriptSettingsFile($this$getBuildScriptSettingsPsiFile, "settings.gradle", KOTLIN_SETTINGS_SCRIPT_NAME);
            if (file2 != null) {
                Project project2 = $this$getBuildScriptSettingsPsiFile.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                psiFile2 = this.getPsiFile(file2, project2);
            } else {
                psiFile2 = null;
            }
            return psiFile2;
        }

        private final PsiFile getTopLevelBuildScriptPsiFile(@NotNull Project $this$getTopLevelBuildScriptPsiFile) {
            PsiFile psiFile2;
            String string = $this$getTopLevelBuildScriptPsiFile.getBasePath();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                String string3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
                File file2 = Companion.findBuildGradleFile(string3, "build.gradle", KOTLIN_BUILD_SCRIPT_NAME);
                psiFile2 = file2 != null ? Companion.getPsiFile(file2, $this$getTopLevelBuildScriptPsiFile) : null;
            } else {
                psiFile2 = null;
            }
            return psiFile2;
        }

        @Nullable
        public final PsiFile getTopLevelBuildScriptSettingsPsiFile(@NotNull Module $this$getTopLevelBuildScriptSettingsPsiFile) {
            PsiFile psiFile2;
            Intrinsics.checkParameterIsNotNull((Object)$this$getTopLevelBuildScriptSettingsPsiFile, (String)"$this$getTopLevelBuildScriptSettingsPsiFile");
            String string = ExternalSystemApiUtil.getExternalRootProjectPath((Module)$this$getTopLevelBuildScriptSettingsPsiFile);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String externalProjectPath = string2;
                boolean bl3 = false;
                String string3 = externalProjectPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"externalProjectPath");
                File file2 = Companion.findBuildGradleFile(string3, "settings.gradle", KOTLIN_SETTINGS_SCRIPT_NAME);
                if (file2 != null) {
                    Project project2 = $this$getTopLevelBuildScriptSettingsPsiFile.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                    psiFile2 = Companion.getPsiFile(file2, project2);
                } else {
                    psiFile2 = null;
                }
            } else {
                psiFile2 = null;
            }
            return psiFile2;
        }

        private final File getBuildScriptFile(@NotNull Module $this$getBuildScriptFile, String ... fileNames) {
            block3: {
                String moduleDir;
                String string = moduleDir = new File($this$getBuildScriptFile.getModuleFilePath()).getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"moduleDir");
                File file2 = this.findBuildGradleFile(string, Arrays.copyOf(fileNames, fileNames.length));
                if (file2 != null) {
                    File file3 = file2;
                    boolean bl = false;
                    boolean bl2 = false;
                    File it = file3;
                    boolean bl3 = false;
                    return it;
                }
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)$this$getBuildScriptFile);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(this)");
                VirtualFile[] virtualFileArray = moduleRootManager.getContentRoots();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"ModuleRootManager.getInstance(this).contentRoots");
                VirtualFile[] $this$forEach$iv = virtualFileArray;
                boolean $i$f$forEach = false;
                VirtualFile[] virtualFileArray2 = $this$forEach$iv;
                int it = virtualFileArray2.length;
                for (int bl3 = 0; bl3 < it; ++bl3) {
                    VirtualFile element$iv;
                    VirtualFile root2 = element$iv = virtualFileArray2[bl3];
                    boolean bl = false;
                    VirtualFile virtualFile2 = root2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"root");
                    String string2 = virtualFile2.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"root.path");
                    File file4 = Companion.findBuildGradleFile(string2, Arrays.copyOf(fileNames, fileNames.length));
                    if (file4 == null) continue;
                    File file5 = file4;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    File it2 = file5;
                    boolean bl6 = false;
                    return it2;
                }
                String string3 = ExternalSystemApiUtil.getExternalProjectPath((Module)$this$getBuildScriptFile);
                if (string3 == null) break block3;
                String string4 = string3;
                boolean bl = false;
                boolean bl7 = false;
                String externalProjectPath = string4;
                boolean bl8 = false;
                String string5 = externalProjectPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"externalProjectPath");
                File file6 = Companion.findBuildGradleFile(string5, Arrays.copyOf(fileNames, fileNames.length));
                if (file6 != null) {
                    File file7 = file6;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    File it3 = file7;
                    boolean bl11 = false;
                    return it3;
                }
            }
            return null;
        }

        private final File getBuildScriptSettingsFile(@NotNull Module $this$getBuildScriptSettingsFile, String ... fileNames) {
            String string = ExternalSystemApiUtil.getExternalProjectPath((Module)$this$getBuildScriptSettingsFile);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String externalProjectPath = string2;
                boolean bl3 = false;
                return (File)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)externalProjectPath, (Function1)getBuildScriptSettingsFile.1.1.INSTANCE), (Function1)((Function1)new Function1<String, File>(fileNames){
                    final /* synthetic */ String[] $fileNames$inlined;
                    {
                        this.$fileNames$inlined = stringArray;
                        super(1);
                    }

                    @Nullable
                    public final File invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$findBuildGradleFile(KotlinWithGradleConfigurator.Companion, it, Arrays.copyOf(this.$fileNames$inlined, this.$fileNames$inlined.length));
                    }
                })));
            }
            return null;
        }

        private final File findBuildGradleFile(String path2, String ... fileNames) {
            Object v0;
            block1: {
                Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])fileNames), (Function1)((Function1)new Function1<String, File>(path2){
                    final /* synthetic */ String $path;

                    @NotNull
                    public final File invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return new File(this.$path + '/' + it);
                    }
                    {
                        this.$path = string;
                        super(1);
                    }
                }));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    if (!it.exists()) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final PsiFile getPsiFile(@NotNull File $this$getPsiFile, Project project2) {
            PsiFile psiFile2;
            VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)$this$getPsiFile, (boolean)true);
            if (virtualFile2 != null) {
                VirtualFile virtualFile3 = virtualFile2;
                boolean bl = false;
                boolean bl2 = false;
                VirtualFile it = virtualFile3;
                boolean bl3 = false;
                psiFile2 = PsiManager.getInstance((Project)project2).findFile(it);
            } else {
                psiFile2 = null;
            }
            return psiFile2;
        }

        private final void showErrorMessage(Project project2, String message2) {
            Messages.showErrorDialog((Project)project2, (String)("<html>" + KotlinIdeaGradleBundle.message("text.couldn.t.configure.kotlin.gradle.plugin.automatically", new Object[0]) + "<br/>" + (message2 != null ? message2 + "<br/>" : "") + "<br/>" + KotlinIdeaGradleBundle.message("text.see.manual.installation.instructions", new Object[0]) + "</html>"), (String)KotlinIdeaGradleBundle.message("title.configure.kotlin.gradle.plugin", new Object[0]));
        }

        private Companion() {
        }

        public static final /* synthetic */ File access$findBuildGradleFile(Companion $this, String path2, String ... fileNames) {
            return $this.findBuildGradleFile(path2, fileNames);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

