/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.OutdatedBundledCompilerNotificationKt;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinConfigurationCheckerComponent;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.NewCodeStyleNotificationKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.DumbUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0016J\u0006\u0010\u000f\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\rR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerComponent;", "Lcom/intellij/openapi/components/ProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isSyncing", "", "()Z", "getProject", "()Lcom/intellij/openapi/project/Project;", "syncDepth", "Ljava/util/concurrent/atomic/AtomicInteger;", "performProjectPostOpenActions", "", "projectOpened", "syncDone", "syncStarted", "Companion", "idea-jvm"})
public final class KotlinConfigurationCheckerComponent
implements ProjectComponent {
    private final AtomicInteger syncDepth;
    @NotNull
    private final Project project;
    @NotNull
    public static final String CONFIGURE_NOTIFICATION_GROUP_ID = "Configure Kotlin in Project";
    public static final Companion Companion = new Companion(null);

    public void projectOpened() {
        super.projectOpened();
        StartupManager.getInstance((Project)this.project).registerPostStartupActivity(new Runnable(this){
            final /* synthetic */ KotlinConfigurationCheckerComponent this$0;

            public final void run() {
                this.this$0.performProjectPostOpenActions();
            }
            {
                this.this$0 = kotlinConfigurationCheckerComponent;
            }
        });
    }

    public final void performProjectPostOpenActions() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
            final /* synthetic */ KotlinConfigurationCheckerComponent this$0;

            public final void run() {
                Collection modulesWithKotlinFiles2 = (Collection)DumbUtilsKt.runReadActionInSmartMode(this.this$0.getProject(), (Function0)new Function0<Collection<? extends Module>>(this){
                    final /* synthetic */ performProjectPostOpenActions.1 this$0;

                    @NotNull
                    public final Collection<Module> invoke() {
                        return ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(this.this$0.this$0.getProject());
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                for (Module module : modulesWithKotlinFiles2) {
                    boolean $i$f$runReadAction = false;
                    ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(this, module){
                        final /* synthetic */ performProjectPostOpenActions.1 this$0;
                        final /* synthetic */ Module $module$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$module$inlined = module;
                        }

                        public final T compute() {
                            boolean bl = false;
                            if (!this.this$0.this$0.getProject().isDisposed()) {
                                PlatformKt.getAndCacheLanguageLevelByDependencies(this.$module$inlined);
                            }
                            return (T)Unit.INSTANCE;
                        }
                    });
                }
            }
            {
                this.this$0 = kotlinConfigurationCheckerComponent;
            }
        });
    }

    public final boolean isSyncing() {
        return this.syncDepth.get() > 0;
    }

    public final void syncStarted() {
        this.syncDepth.incrementAndGet();
    }

    public final void syncDone() {
        this.syncDepth.decrementAndGet();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinConfigurationCheckerComponent(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        this.syncDepth = new AtomicInteger();
        NotificationsConfiguration.getNotificationsConfiguration().register(CONFIGURE_NOTIFICATION_GROUP_ID, NotificationDisplayType.STICKY_BALLOON, true);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"project.messageBus.connect()");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(ProjectDataImportListener.TOPIC, (Object)new ProjectDataImportListener(){

            public final void onImportFinished(String it) {
                OutdatedBundledCompilerNotificationKt.notifyOutdatedBundledCompilerIfNecessary(this.getProject());
            }
        });
        NewCodeStyleNotificationKt.notifyKotlinStyleUpdateIfNeeded(this.project);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerComponent$Companion;", "", "()V", "CONFIGURE_NOTIFICATION_GROUP_ID", "", "getInstanceIfNotDisposed", "Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerComponent;", "project", "Lcom/intellij/openapi/project/Project;", "idea-jvm"})
    public static final class Companion {
        @Nullable
        public final KotlinConfigurationCheckerComponent getInstanceIfNotDisposed(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            boolean $i$f$runReadAction = false;
            return (KotlinConfigurationCheckerComponent)ApplicationManager.getApplication().runReadAction(new Computable<T>(project2){
                final /* synthetic */ Project $project$inlined;
                {
                    this.$project$inlined = project2;
                }

                public final T compute() {
                    KotlinConfigurationCheckerComponent kotlinConfigurationCheckerComponent;
                    boolean bl = false;
                    if (!this.$project$inlined.isDisposed()) {
                        kotlinConfigurationCheckerComponent = (KotlinConfigurationCheckerComponent)this.$project$inlined.getComponent(KotlinConfigurationCheckerComponent.class);
                        if (kotlinConfigurationCheckerComponent == null) {
                            String string = "Can't find " + Reflection.getOrCreateKotlinClass(KotlinConfigurationCheckerComponent.class) + " component";
                            boolean bl2 = false;
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                    } else {
                        kotlinConfigurationCheckerComponent = null;
                    }
                    return (T)kotlinConfigurationCheckerComponent;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

