/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui.notifications;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KtCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KtCodeStyleSettingsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/KotlinCodeStyleChangedNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "isProjectSettings", "", "(Lcom/intellij/openapi/project/Project;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "Companion", "idea-jvm"})
final class KotlinCodeStyleChangedNotification
extends Notification {
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinCodeStyleChangedNotification(@NotNull Project project2, boolean isProjectSettings) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super("Update Kotlin code style", "Kotlin Code Style", "<html>" + KotlinJvmBundle.message("default.code.style.was.updated.to.kotlin.coding.conventions", new Object[0]) + "</html>", NotificationType.WARNING, null);
        this.project = project2;
        KtCodeStyleSettings ktFormattingSettings = KtCodeStyleSettingsKt.ktCodeStyleSettings(this.project);
        if (isProjectSettings) {
            this.addAction((AnAction)new NotificationAction(KotlinJvmBundle.message("apply.new.code.style", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                    notification2.expire();
                    KtCodeStyleSettings ktCodeStyleSettings = KtCodeStyleSettingsKt.ktCodeStyleSettings(this.getProject());
                    if (ktCodeStyleSettings == null) {
                        return;
                    }
                    KtCodeStyleSettings ktSettings = ktCodeStyleSettings;
                    boolean $i$f$runWriteAction = false;
                    ApplicationManager.getApplication().runWriteAction(new Computable<T>(ktSettings){
                        final /* synthetic */ KtCodeStyleSettings $ktSettings$inlined;
                        {
                            this.$ktSettings$inlined = ktCodeStyleSettings;
                        }

                        public final T compute() {
                            boolean bl = false;
                            KotlinStyleGuideCodeStyle.Companion.apply(this.$ktSettings$inlined.getAll());
                            return (T)Unit.INSTANCE;
                        }
                    });
                }
            });
        }
        if (ktFormattingSettings != null && KtCodeStyleSettingsKt.canRestore(ktFormattingSettings)) {
            this.addAction((AnAction)new NotificationAction(KotlinJvmBundle.message("restore.old.settings", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                    notification2.expire();
                    KtCodeStyleSettings ktCodeStyleSettings = KtCodeStyleSettingsKt.ktCodeStyleSettings(this.getProject());
                    if (ktCodeStyleSettings == null) {
                        return;
                    }
                    KtCodeStyleSettings ktSettings = ktCodeStyleSettings;
                    boolean $i$f$runWriteAction = false;
                    ApplicationManager.getApplication().runWriteAction(new Computable<T>(ktSettings){
                        final /* synthetic */ KtCodeStyleSettings $ktSettings$inlined;
                        {
                            this.$ktSettings$inlined = ktCodeStyleSettings;
                        }

                        public final T compute() {
                            boolean bl = false;
                            KtCodeStyleSettingsKt.restore(this.$ktSettings$inlined);
                            return (T)Unit.INSTANCE;
                        }
                    });
                }
            });
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"KotlinCodeStyleChangedNotification");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"Kotl\u2026tyleChangedNotification\")");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/KotlinCodeStyleChangedNotification$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/KotlinCodeStyleChangedNotification;", "project", "Lcom/intellij/openapi/project/Project;", "isProjectSettings", "", "idea-jvm"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @Nullable
        public final KotlinCodeStyleChangedNotification create(@NotNull Project project2, boolean isProjectSettings) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            KtCodeStyleSettings ktCodeStyleSettings = KtCodeStyleSettingsKt.ktCodeStyleSettings(project2);
            if (ktCodeStyleSettings == null) {
                return null;
            }
            KtCodeStyleSettings ktFormattingSettings = ktCodeStyleSettings;
            if (isProjectSettings && !KtCodeStyleSettingsKt.hasDefaultLoadScheme(ktFormattingSettings)) {
                return null;
            }
            return new KotlinCodeStyleChangedNotification(project2, isProjectSettings);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

