/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.surroundWith;

import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.surroundWith.KotlinSurrounderUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

public abstract class KotlinExpressionSurrounder
implements Surrounder {
    public boolean isApplicable(@NotNull PsiElement[] elements2) {
        if (elements2 == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$1(0);
        }
        if (elements2 == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$0(0);
        }
        if (elements2.length != 1 || !(elements2[0] instanceof KtExpression)) {
            return false;
        }
        KtExpression expression2 = (KtExpression)elements2[0];
        if (expression2 instanceof KtCallExpression && expression2.getParent() instanceof KtQualifiedExpression) {
            return false;
        }
        return this.isApplicable(expression2);
    }

    protected boolean isApplicable(@NotNull KtExpression expression2) {
        BindingContext context2;
        KotlinType type2;
        if (expression2 == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$1(1);
        }
        if (expression2 == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$0(1);
        }
        if ((type2 = (context2 = ResolutionUtils.analyze((KtElement)expression2, (BodyResolveMode)BodyResolveMode.PARTIAL)).getType(expression2)) == null || KotlinBuiltIns.isUnit(type2) && this.isApplicableToStatements()) {
            return false;
        }
        return this.isApplicableToStatements() || !KotlinSurrounderUtils.isUsedAsStatement(expression2);
    }

    protected boolean isApplicableToStatements() {
        return true;
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiElement[] elements2) {
        if (project2 == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$1(2);
        }
        if (editor2 == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$1(3);
        }
        if (elements2 == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$1(4);
        }
        if (project2 == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$0(3);
        }
        if (elements2 == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$0(4);
        }
        assert (elements2.length == 1) : "KotlinExpressionSurrounder should be applicable only for 1 expression: " + elements2.length;
        return this.surroundExpression(project2, editor2, (KtExpression)elements2[0]);
    }

    @Nullable
    protected abstract TextRange surroundExpression(@NotNull Project var1, @NotNull Editor var2, @NotNull KtExpression var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/core/surroundWith/KotlinExpressionSurrounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/core/surroundWith/KotlinExpressionSurrounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

