/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.types.KotlinType;

public class CodeInsightUtils {
    @Nullable
    public static PsiElement findElement(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull ElementKind elementKind) {
        KtExpression statement2;
        List<KtExpression> statements2;
        Class elementClass;
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(0);
        }
        if (elementKind == null) {
            CodeInsightUtils.$$$reportNull$$$1(1);
        }
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(0);
        }
        if (elementKind == null) {
            CodeInsightUtils.$$$reportNull$$$0(1);
        }
        switch (elementKind) {
            case EXPRESSION: {
                elementClass = KtExpression.class;
                break;
            }
            case TYPE_ELEMENT: {
                elementClass = KtTypeElement.class;
                break;
            }
            case TYPE_CONSTRUCTOR: {
                elementClass = KtSimpleNameExpression.class;
                break;
            }
            default: {
                throw new IllegalArgumentException(elementKind.name());
            }
        }
        KtExpression element3 = CodeInsightUtils.findElementOfClassAtRange(file2, startOffset, endOffset, elementClass);
        if (elementKind == ElementKind.TYPE_ELEMENT) {
            return element3;
        }
        if (elementKind == ElementKind.TYPE_CONSTRUCTOR) {
            return element3 != null && KtPsiUtilKt.isTypeConstructorReference((PsiElement)element3) ? element3 : null;
        }
        if (element3 instanceof KtScriptInitializer) {
            element3 = ((KtScriptInitializer)element3).getBody();
        }
        if (element3 == null) {
            return null;
        }
        if (element3 instanceof KtOperationReferenceExpression && ((KtOperationReferenceExpression)element3).getReferencedNameElementType() != KtTokens.IDENTIFIER && element3.getParent() instanceof KtBinaryExpression) {
            return null;
        }
        if (KtPsiUtil.isLabelIdentifierExpression((PsiElement)element3)) {
            element3 = PsiTreeUtil.getParentOfType((PsiElement)element3, KtExpression.class);
        }
        if (element3 instanceof KtBlockExpression && (statements2 = ((KtBlockExpression)element3).getStatements()).size() == 1 && (statement2 = statements2.get(0)).getText().equals(element3.getText())) {
            return statement2;
        }
        KtExpression expression2 = element3;
        BindingContext context2 = ResolutionUtils.analyze((KtElement)expression2);
        Qualifier qualifier2 = context2.get(BindingContext.QUALIFIER, expression2);
        if (qualifier2 != null) {
            if (!(qualifier2 instanceof ClassQualifier)) {
                return null;
            }
            if (((ClassQualifier)qualifier2).getDescriptor().getKind() != ClassKind.OBJECT) {
                return null;
            }
        }
        return expression2;
    }

    @NotNull
    public static PsiElement[] findElements(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull ElementKind kind2) {
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(2);
        }
        if (kind2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(3);
        }
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(2);
        }
        if (kind2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(3);
        }
        PsiElement element12 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file2, startOffset);
        PsiElement element22 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file2, endOffset);
        if (element12 == null || element22 == null) {
            PsiElement[] psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtils.$$$reportNull$$$0(4);
            }
            if (psiElementArray == null) {
                CodeInsightUtils.$$$reportNull$$$1(4);
            }
            return psiElementArray;
        }
        startOffset = element12.getTextRange().getStartOffset();
        if (startOffset >= (endOffset = element22.getTextRange().getEndOffset())) {
            PsiElement[] psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtils.$$$reportNull$$$0(5);
            }
            if (psiElementArray == null) {
                CodeInsightUtils.$$$reportNull$$$1(5);
            }
            return psiElementArray;
        }
        PsiElement parent2 = PsiTreeUtil.findCommonParent((PsiElement)element12, (PsiElement)element22);
        if (parent2 == null) {
            PsiElement[] psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtils.$$$reportNull$$$0(6);
            }
            if (psiElementArray == null) {
                CodeInsightUtils.$$$reportNull$$$1(6);
            }
            return psiElementArray;
        }
        while (!(parent2 instanceof KtBlockExpression)) {
            if (parent2 == null || parent2 instanceof KtFile) {
                PsiElement[] psiElementArray = PsiElement.EMPTY_ARRAY;
                if (PsiElement.EMPTY_ARRAY == null) {
                    CodeInsightUtils.$$$reportNull$$$0(7);
                }
                if (psiElementArray == null) {
                    CodeInsightUtils.$$$reportNull$$$1(7);
                }
                return psiElementArray;
            }
            parent2 = parent2.getParent();
        }
        if (startOffset != (element12 = CodeInsightUtils.getTopmostParentInside(element12, parent2)).getTextRange().getStartOffset()) {
            PsiElement[] psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtils.$$$reportNull$$$0(8);
            }
            if (psiElementArray == null) {
                CodeInsightUtils.$$$reportNull$$$1(8);
            }
            return psiElementArray;
        }
        if (endOffset != (element22 = CodeInsightUtils.getTopmostParentInside(element22, parent2)).getTextRange().getEndOffset()) {
            PsiElement[] psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtils.$$$reportNull$$$0(9);
            }
            if (psiElementArray == null) {
                CodeInsightUtils.$$$reportNull$$$1(9);
            }
            return psiElementArray;
        }
        ArrayList<PsiElement> array2 = new ArrayList<PsiElement>();
        PsiElement stopElement = element22.getNextSibling();
        for (PsiElement currentElement = element12; currentElement != stopElement; currentElement = currentElement.getNextSibling()) {
            if (currentElement instanceof PsiWhiteSpace) continue;
            array2.add(currentElement);
        }
        for (PsiElement element3 : array2) {
            boolean correctType = kind2 == ElementKind.EXPRESSION && element3 instanceof KtExpression || kind2 == ElementKind.TYPE_ELEMENT && element3 instanceof KtTypeElement || kind2 == ElementKind.TYPE_CONSTRUCTOR && KtPsiUtilKt.isTypeConstructorReference(element3);
            if (correctType || element3.getNode().getElementType() == KtTokens.SEMICOLON || element3 instanceof PsiWhiteSpace || element3 instanceof PsiComment) continue;
            PsiElement[] psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtils.$$$reportNull$$$0(10);
            }
            if (psiElementArray == null) {
                CodeInsightUtils.$$$reportNull$$$1(10);
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array2);
        if (psiElementArray == null) {
            CodeInsightUtils.$$$reportNull$$$0(11);
        }
        if (psiElementArray == null) {
            CodeInsightUtils.$$$reportNull$$$1(11);
        }
        return psiElementArray;
    }

    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtRange(@NotNull PsiFile file2, int startOffset, int endOffset, Class<T> aClass2) {
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(12);
        }
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(12);
        }
        PsiElement element12 = CodeInsightUtils.getParentLabelOrElement(CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file2, startOffset));
        PsiElement element22 = CodeInsightUtils.getParentLabelOrElement(CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file2, endOffset));
        if (element12 == null || element22 == null) {
            return null;
        }
        startOffset = element12.getTextRange().getStartOffset();
        PsiElement newElement = PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)startOffset, (int)(endOffset = element22.getTextRange().getEndOffset()), aClass2);
        if (newElement == null || newElement.getTextRange().getStartOffset() != startOffset || newElement.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        return (T)newElement;
    }

    private static PsiElement getParentLabelOrElement(@Nullable PsiElement element3) {
        if (element3 != null && element3.getParent() instanceof KtLabelReferenceExpression) {
            return element3.getParent();
        }
        return element3;
    }

    @NotNull
    public static List<PsiElement> findElementsOfClassInRange(@NotNull PsiFile file2, int startOffset, int endOffset, Class<? extends PsiElement> ... classes2) {
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(13);
        }
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(13);
        }
        PsiElement element12 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file2, startOffset);
        PsiElement element22 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file2, endOffset);
        if (element12 == null || element22 == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                CodeInsightUtils.$$$reportNull$$$0(14);
            }
            if (list2 == null) {
                CodeInsightUtils.$$$reportNull$$$1(14);
            }
            return list2;
        }
        startOffset = element12.getTextRange().getStartOffset();
        endOffset = element22.getTextRange().getEndOffset();
        PsiElement parent2 = PsiTreeUtil.findCommonParent((PsiElement)element12, (PsiElement)element22);
        if (parent2 == null) {
            List<PsiElement> list3 = Collections.emptyList();
            if (list3 == null) {
                CodeInsightUtils.$$$reportNull$$$0(15);
            }
            if (list3 == null) {
                CodeInsightUtils.$$$reportNull$$$1(15);
            }
            return list3;
        }
        if (startOffset != (element12 = CodeInsightUtils.getTopmostParentInside(element12, parent2)).getTextRange().getStartOffset()) {
            List<PsiElement> list4 = Collections.emptyList();
            if (list4 == null) {
                CodeInsightUtils.$$$reportNull$$$0(16);
            }
            if (list4 == null) {
                CodeInsightUtils.$$$reportNull$$$1(16);
            }
            return list4;
        }
        if (endOffset != (element22 = CodeInsightUtils.getTopmostParentInside(element22, parent2)).getTextRange().getEndOffset()) {
            List<PsiElement> list5 = Collections.emptyList();
            if (list5 == null) {
                CodeInsightUtils.$$$reportNull$$$0(17);
            }
            if (list5 == null) {
                CodeInsightUtils.$$$reportNull$$$1(17);
            }
            return list5;
        }
        PsiElement stopElement = element22.getNextSibling();
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement currentElement = element12; currentElement != stopElement && currentElement != null; currentElement = currentElement.getNextSibling()) {
            for (Class<? extends PsiElement> aClass2 : classes2) {
                if (aClass2.isInstance(currentElement)) {
                    result2.add(currentElement);
                }
                result2.addAll(PsiTreeUtil.findChildrenOfType((PsiElement)currentElement, aClass2));
            }
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            CodeInsightUtils.$$$reportNull$$$0(18);
        }
        if (arrayList == null) {
            CodeInsightUtils.$$$reportNull$$$1(18);
        }
        return arrayList;
    }

    @NotNull
    private static PsiElement getTopmostParentInside(@NotNull PsiElement element3, @NotNull PsiElement parent2) {
        if (element3 == null) {
            CodeInsightUtils.$$$reportNull$$$1(19);
        }
        if (parent2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(20);
        }
        if (element3 == null) {
            CodeInsightUtils.$$$reportNull$$$0(19);
        }
        if (parent2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(20);
        }
        if (!parent2.equals(element3)) {
            while (!parent2.equals(element3.getParent())) {
                element3 = element3.getParent();
            }
        }
        PsiElement psiElement2 = element3;
        if (psiElement2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(21);
        }
        if (psiElement2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(21);
        }
        return psiElement2;
    }

    @Nullable
    public static PsiElement getElementAtOffsetIgnoreWhitespaceBefore(@NotNull PsiFile file2, int offset2) {
        PsiElement element3;
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(22);
        }
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(22);
        }
        if ((element3 = file2.findElementAt(offset2)) instanceof PsiWhiteSpace) {
            return file2.findElementAt(element3.getTextRange().getEndOffset());
        }
        return element3;
    }

    @Nullable
    public static PsiElement getElementAtOffsetIgnoreWhitespaceAfter(@NotNull PsiFile file2, int offset2) {
        PsiElement element3;
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(23);
        }
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(23);
        }
        if ((element3 = file2.findElementAt(offset2 - 1)) instanceof PsiWhiteSpace) {
            return file2.findElementAt(element3.getTextRange().getStartOffset() - 1);
        }
        return element3;
    }

    @Nullable
    public static String defaultInitializer(KotlinType type2) {
        if (type2.isMarkedNullable()) {
            return "null";
        }
        if (KotlinBuiltIns.isInt(type2) || KotlinBuiltIns.isLong(type2) || KotlinBuiltIns.isShort(type2) || KotlinBuiltIns.isByte(type2)) {
            return "0";
        }
        if (KotlinBuiltIns.isFloat(type2)) {
            return "0.0f";
        }
        if (KotlinBuiltIns.isDouble(type2)) {
            return "0.0";
        }
        if (KotlinBuiltIns.isChar(type2)) {
            return "'\\u0000'";
        }
        if (KotlinBuiltIns.isBoolean(type2)) {
            return "false";
        }
        if (KotlinBuiltIns.isUnit(type2)) {
            return "Unit";
        }
        if (KotlinBuiltIns.isString(type2)) {
            return "\"\"";
        }
        return null;
    }

    public static void showErrorHint(@NotNull Project project2, @NotNull Editor editor2, @NotNull String message2, @NotNull String title, @Nullable String helpId) {
        if (project2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(24);
        }
        if (editor2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(25);
        }
        if (message2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(26);
        }
        if (title == null) {
            CodeInsightUtils.$$$reportNull$$$1(27);
        }
        if (project2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(24);
        }
        if (editor2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(25);
        }
        if (message2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(26);
        }
        if (title == null) {
            CodeInsightUtils.$$$reportNull$$$0(27);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new CommonRefactoringUtil.RefactoringErrorHintException(message2);
        }
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)title, (String)helpId);
    }

    private CodeInsightUtils() {
    }

    @Nullable
    public static Integer getStartLineOffset(@NotNull PsiFile file2, int line) {
        Document document;
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(28);
        }
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(28);
        }
        if ((document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2)) == null) {
            return null;
        }
        if (line >= document.getLineCount()) {
            return null;
        }
        int lineStartOffset = document.getLineStartOffset(line);
        return CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)lineStartOffset, (String)" \t");
    }

    @Nullable
    public static Integer getEndLineOffset(@NotNull PsiFile file2, int line) {
        Document document;
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(29);
        }
        if (file2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(29);
        }
        if ((document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2)) == null) {
            return null;
        }
        if (line >= document.getLineCount()) {
            return null;
        }
        int lineStartOffset = document.getLineEndOffset(line);
        return CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)lineStartOffset, (String)" \t");
    }

    @NotNull
    public static PsiElement getTopmostElementAtOffset(@NotNull PsiElement element3, int offset2) {
        PsiElement parent2;
        if (element3 == null) {
            CodeInsightUtils.$$$reportNull$$$1(30);
        }
        if (element3 == null) {
            CodeInsightUtils.$$$reportNull$$$0(30);
        }
        while ((parent2 = element3.getParent()) != null && parent2.getTextOffset() >= offset2 && !(parent2 instanceof KtBlockExpression) && !(parent2 instanceof PsiFile)) {
            element3 = parent2;
        }
        PsiElement psiElement2 = element3;
        if (psiElement2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(31);
        }
        if (psiElement2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(31);
        }
        return psiElement2;
    }

    @NotNull
    public static PsiElement getTopParentWithEndOffset(@NotNull PsiElement element3, @NotNull Class<?> stopAt) {
        PsiElement parent2;
        if (element3 == null) {
            CodeInsightUtils.$$$reportNull$$$1(32);
        }
        if (stopAt == null) {
            CodeInsightUtils.$$$reportNull$$$1(33);
        }
        if (element3 == null) {
            CodeInsightUtils.$$$reportNull$$$0(32);
        }
        if (stopAt == null) {
            CodeInsightUtils.$$$reportNull$$$0(33);
        }
        int endOffset = element3.getTextOffset() + element3.getTextLength();
        while ((parent2 = element3.getParent()) != null && parent2.getTextOffset() + parent2.getTextLength() == endOffset && !stopAt.isInstance(element3 = parent2)) {
        }
        PsiElement psiElement2 = element3;
        if (psiElement2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(34);
        }
        if (psiElement2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(34);
        }
        return psiElement2;
    }

    @Nullable
    public static <T> T getTopmostElementAtOffset(@NotNull PsiElement element3, int offset2, Class<? extends T> ... classes2) {
        PsiElement parent2;
        if (element3 == null) {
            CodeInsightUtils.$$$reportNull$$$1(35);
        }
        if (classes2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(36);
        }
        if (element3 == null) {
            CodeInsightUtils.$$$reportNull$$$0(35);
        }
        if (classes2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(36);
        }
        PsiElement lastElementOfType = null;
        if (CodeInsightUtils.anyIsInstance(element3, classes2)) {
            lastElementOfType = element3;
        }
        while ((parent2 = element3.getParent()) != null && parent2.getTextOffset() >= offset2 && !(parent2 instanceof KtBlockExpression)) {
            if (CodeInsightUtils.anyIsInstance(parent2, classes2)) {
                lastElementOfType = parent2;
            }
            element3 = parent2;
        }
        return (T)lastElementOfType;
    }

    private static <T> boolean anyIsInstance(PsiElement finalElement, @NotNull Class<? extends T>[] klass2) {
        if (klass2 == null) {
            CodeInsightUtils.$$$reportNull$$$1(37);
        }
        if (klass2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(37);
        }
        return ArraysKt.any((Object[])klass2, aClass2 -> aClass2.isInstance(finalElement));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementKind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/core/util/CodeInsightUtils";
                break;
            }
            case 19: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/core/util/CodeInsightUtils";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findElements";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsOfClassInRange";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostParentInside";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostElementAtOffset";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopParentWithEndOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findElementOfClassAtRange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findElementsOfClassInRange";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParentInside";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtOffsetIgnoreWhitespaceBefore";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtOffsetIgnoreWhitespaceAfter";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getStartLineOffset";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getEndLineOffset";
                break;
            }
            case 30: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostElementAtOffset";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTopParentWithEndOffset";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "anyIsInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementKind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/core/util/CodeInsightUtils";
                break;
            }
            case 19: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/core/util/CodeInsightUtils";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findElements";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsOfClassInRange";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostParentInside";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostElementAtOffset";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopParentWithEndOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findElementOfClassAtRange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findElementsOfClassInRange";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParentInside";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtOffsetIgnoreWhitespaceBefore";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtOffsetIgnoreWhitespaceAfter";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getStartLineOffset";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getEndLineOffset";
                break;
            }
            case 30: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostElementAtOffset";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTopParentWithEndOffset";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "anyIsInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ElementKind {
        EXPRESSION,
        TYPE_ELEMENT,
        TYPE_CONSTRUCTOR;

    }
}

