/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineProjectConnectionListenerKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CreateContentParams;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CreateContentParamsProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.XCoroutineView;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\b\u0010\u001f\u001a\u00020\u0018H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020\u0018H\u0002R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineProjectConnectionListener;", "Lcom/intellij/xdebugger/XDebuggerManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "getConnection", "()Lcom/intellij/util/messages/MessageBusConnection;", "setConnection", "(Lcom/intellij/util/messages/MessageBusConnection;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "processCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getProcessCounter", "()Ljava/util/concurrent/atomic/AtomicInteger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "configurationStarting", "", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "connect", "createContent", "Lcom/intellij/ui/content/Content;", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "createContentParamProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CreateContentParamsProvider;", "gradleConfiguration", "", "configurationName", "", "processStarted", "debugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "processStopped", "registerXCoroutinesPanel", "session", "Lcom/intellij/xdebugger/XDebugSession;", "starting", "jvm-debugger-coroutine"})
public final class CoroutineProjectConnectionListener
implements XDebuggerManagerListener {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private MessageBusConnection connection;
    @NotNull
    private final AtomicInteger processCounter;
    private final ReadOnlyProperty log$delegate;
    @NotNull
    private final Project project;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(CoroutineProjectConnectionListener.class), "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;"))};
    }

    @Nullable
    public final MessageBusConnection getConnection() {
        return this.connection;
    }

    public final void setConnection(@Nullable MessageBusConnection messageBusConnection) {
        this.connection = messageBusConnection;
    }

    @NotNull
    public final AtomicInteger getProcessCounter() {
        return this.processCounter;
    }

    private final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void connect() {
        block0: {
            MessageBusConnection messageBusConnection = this.connection = this.project.getMessageBus().connect();
            if (messageBusConnection == null) break block0;
            messageBusConnection.subscribe(XDebuggerManager.TOPIC, (Object)this);
        }
    }

    public final void configurationStarting(@NotNull RunConfigurationBase<?> configuration2, @Nullable JavaParameters params2, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkParameterIsNotNull(configuration2, (String)"configuration");
        if (CoroutineProjectConnectionListenerKt.coroutineDebuggerEnabled()) {
            ConfigurationType configurationType = configuration2.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationType, (String)"configuration.type");
            String string = configurationType.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.type.id");
            String configurationName = string;
            try {
                if (!this.gradleConfiguration(configurationName)) {
                    String string2;
                    Object object = params2;
                    if (object != null && (object = object.getClassPath()) != null && (object = object.getPathList()) != null) {
                        Object element$iv2;
                        block8: {
                            Iterable $this$first$iv = (Iterable)object;
                            boolean $i$f$first = false;
                            for (Object element$iv2 : $this$first$iv) {
                                String it = (String)element$iv2;
                                boolean bl = false;
                                String string3 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
                                if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"kotlinx-coroutines-debug", (boolean)false, (int)2, null)) continue;
                                break block8;
                            }
                            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        string2 = (String)element$iv2;
                    } else {
                        string2 = null;
                    }
                    String kotlinxCoroutinesClassPathLib = string2;
                    JavaParameters javaParameters = params2;
                    if (javaParameters == null) {
                        Intrinsics.throwNpe();
                    }
                    CoroutineProjectConnectionListenerKt.initializeCoroutineAgent(javaParameters, kotlinxCoroutinesClassPathLib);
                }
                this.starting();
            }
            catch (NoSuchElementException e) {
                this.getLog().warn("'kotlinx-coroutines-debug' not found in classpath. Coroutine debugger disabled.");
            }
        }
    }

    private final void starting() {
        if (this.processCounter.compareAndSet(0, 1)) {
            this.connect();
        } else {
            this.processCounter.incrementAndGet();
        }
    }

    private final boolean gradleConfiguration(String configurationName) {
        return "GradleRunConfiguration".equals(configurationName) || "KotlinGradleRunConfiguration".equals(configurationName);
    }

    public void processStarted(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        DebuggerInvocationUtil.swingInvokeLater((Project)this.project, (Runnable)new Runnable(this, debugProcess){
            final /* synthetic */ CoroutineProjectConnectionListener this$0;
            final /* synthetic */ XDebugProcess $debugProcess;

            public final void run() {
                if (this.$debugProcess instanceof JavaDebugProcess) {
                    XDebugSession xDebugSession = ((JavaDebugProcess)this.$debugProcess).getSession();
                    Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
                    CoroutineProjectConnectionListener.access$registerXCoroutinesPanel(this.this$0, xDebugSession);
                }
            }
            {
                this.this$0 = coroutineProjectConnectionListener;
                this.$debugProcess = xDebugProcess;
            }
        });
    }

    public void processStopped(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        if (this.processCounter.compareAndSet(1, 0)) {
            MessageBusConnection messageBusConnection = this.connection;
            if (messageBusConnection != null) {
                messageBusConnection.disconnect();
            }
            this.connection = null;
        } else {
            this.processCounter.decrementAndGet();
        }
    }

    private final void registerXCoroutinesPanel(XDebugSession session2) {
        RunnerLayoutUi runnerLayoutUi = session2.getUI();
        if (runnerLayoutUi == null) {
            return;
        }
        RunnerLayoutUi ui = runnerLayoutUi;
        XDebugSession xDebugSession = session2;
        if (xDebugSession == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
        }
        XCoroutineView xCoroutineThreadView = new XCoroutineView(this.project, (XDebugSession)((XDebugSessionImpl)xDebugSession));
        Content framesContent = this.createContent(ui, xCoroutineThreadView);
        framesContent.setCloseable(false);
        ui.addContent(framesContent, 0, PlaceInGrid.right, false);
        session2.addSessionListener((XDebugSessionListener)xCoroutineThreadView.debugSessionListener(session2));
        session2.rebuildViews();
    }

    private final Content createContent(RunnerLayoutUi ui, CreateContentParamsProvider createContentParamProvider) {
        CreateContentParams param = createContentParamProvider.createContentParams();
        Content content2 = ui.createContent(param.getId(), param.getComponent(), param.getDisplayName(), param.getIcon(), param.getParentComponent());
        Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"ui.createContent(param.i\u2026n, param.parentComponent)");
        return content2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public CoroutineProjectConnectionListener(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        this.processCounter = new AtomicInteger(0);
        this.log$delegate = ProvidersKt.getLogger();
    }

    public static final /* synthetic */ void access$registerXCoroutinesPanel(CoroutineProjectConnectionListener $this, XDebugSession session2) {
        $this.registerXCoroutinesPanel(session2);
    }
}

