/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.ui.UISettings;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBList;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.EmptyIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineDumpPanel$WhenMappings;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0005./012B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\u000bH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010%\u001a\u00020&H\u0016J%\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020&2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,J\b\u0010-\u001a\u00020(H\u0002R\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u001dj\b\u0012\u0004\u0012\u00020\u000b`\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "toolbarActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "dump", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/ui/ConsoleView;Lcom/intellij/openapi/actionSystem/DefaultActionGroup;Ljava/util/List;)V", "coroutinesList", "Lcom/intellij/ui/components/JBList;", "", "kotlin.jvm.PlatformType", "getDump", "()Ljava/util/List;", "exporterToTextFile", "Lcom/intellij/ide/ExporterToTextFile;", "filterField", "Lcom/intellij/ui/SearchTextField;", "getFilterField", "()Lcom/intellij/ui/SearchTextField;", "filterPanel", "getFilterPanel", "()Ljavax/swing/JPanel;", "mergedDump", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "infoData", "getCoroutineStateIcon", "Ljavax/swing/Icon;", "getData", "dataId", "", "highlightOccurrences", "", "filter", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlightOccurrences$jvm_debugger_coroutine", "updateCoroutinesList", "CopyToClipboardAction", "CoroutineListCellRenderer", "FilterAction", "MergeStackTracesAction", "MyToFileExporter", "jvm-debugger-coroutine"})
public final class CoroutineDumpPanel
extends JPanel
implements DataProvider {
    private ExporterToTextFile exporterToTextFile;
    private ArrayList<CoroutineInfoData> mergedDump;
    @NotNull
    private final SearchTextField filterField;
    @NotNull
    private final JPanel filterPanel;
    private final JBList<Object> coroutinesList;
    @NotNull
    private final List<CoroutineInfoData> dump;

    @NotNull
    public final SearchTextField getFilterField() {
        return this.filterField;
    }

    @NotNull
    public final JPanel getFilterPanel() {
        return this.filterPanel;
    }

    private final void updateCoroutinesList() {
        String text2 = this.filterPanel.isVisible() ? this.filterField.getText() : "";
        Object selection = this.coroutinesList.getSelectedValue();
        ListModel listModel = this.coroutinesList.getModel();
        if (listModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.swing.DefaultListModel<kotlin.Any>");
        }
        DefaultListModel model2 = (DefaultListModel)listModel;
        model2.clear();
        int selectedIndex = 0;
        int index2 = 0;
        List states = UISettings.Companion.getInstance().getState().getMergeEqualStackTraces() ? (List)this.mergedDump : this.dump;
        for (CoroutineInfoData state : states) {
            if (!StringUtil.containsIgnoreCase((String)state.getStringStackTrace(), (String)text2) && !StringUtil.containsIgnoreCase((String)state.getName(), (String)text2)) continue;
            model2.addElement(state);
            if (selection == state) {
                selectedIndex = index2;
            }
            ++index2;
        }
        if (!model2.isEmpty()) {
            this.coroutinesList.setSelectedIndex(selectedIndex);
        }
        this.coroutinesList.revalidate();
        this.coroutinesList.repaint();
    }

    public final void highlightOccurrences$jvm_debugger_coroutine(@NotNull String filter2, @NotNull Project project2, @NotNull Editor editor2) {
        int nextOccurrence;
        EditorColorsManager colorManager;
        Intrinsics.checkParameterIsNotNull((Object)filter2, (String)"filter");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
        EditorColorsManager editorColorsManager = colorManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"colorManager");
        TextAttributes attributes = editorColorsManager.getGlobalScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
        Document document = editor2.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        String string = document.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"editor.document.text");
        String documentText = string;
        int i2 = -1;
        while ((nextOccurrence = StringUtil.indexOfIgnoreCase((String)documentText, (String)filter2, (int)(i2 + 1))) >= 0) {
            i2 = nextOccurrence;
            highlightManager.addOccurrenceHighlight(editor2, i2, i2 + filter2.length(), attributes, 4, null, null);
        }
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
        return PlatformDataKeys.EXPORTER_TO_TEXT_FILE.is(dataId) ? this.exporterToTextFile : null;
    }

    private final Icon getCoroutineStateIcon(CoroutineInfoData infoData) {
        Icon icon;
        switch (CoroutineDumpPanel$WhenMappings.$EnumSwitchMapping$0[infoData.getState().ordinal()]) {
            case 1: {
                icon = (Icon)new LayeredIcon(new Icon[]{AllIcons.Actions.Resume, AllIcons.Debugger.ThreadStates.Daemon_sign});
                break;
            }
            case 2: {
                Icon icon2 = AllIcons.Actions.Pause;
                icon = icon2;
                Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Actions.Pause");
                break;
            }
            default: {
                EmptyIcon emptyIcon = EmptyIcon.create((int)6);
                Intrinsics.checkExpressionValueIsNotNull((Object)emptyIcon, (String)"EmptyIcon.create(6)");
                icon = (Icon)emptyIcon;
            }
        }
        return icon;
    }

    private final SimpleTextAttributes getAttributes(CoroutineInfoData infoData) {
        SimpleTextAttributes simpleTextAttributes;
        if (infoData.isSuspended()) {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAY_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes2;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleTextAttributes2, (String)"SimpleTextAttributes.GRAY_ATTRIBUTES");
        } else if (infoData.isEmptyStackTrace()) {
            simpleTextAttributes = new SimpleTextAttributes(0, Color.GRAY.brighter());
        } else {
            SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes3;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleTextAttributes3, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
        }
        return simpleTextAttributes;
    }

    @NotNull
    public final List<CoroutineInfoData> getDump() {
        return this.dump;
    }

    public CoroutineDumpPanel(final @NotNull Project project2, @NotNull ConsoleView consoleView2, @NotNull DefaultActionGroup toolbarActions, @NotNull List<CoroutineInfoData> dump2) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)consoleView2, (String)"consoleView");
            Intrinsics.checkParameterIsNotNull((Object)toolbarActions, (String)"toolbarActions");
            Intrinsics.checkParameterIsNotNull(dump2, (String)"dump");
            super(new BorderLayout());
            this.dump = dump2;
            this.mergedDump = new ArrayList();
            this.filterField = new SearchTextField();
            this.filterPanel = new JPanel(new BorderLayout());
            this.coroutinesList = new JBList((ListModel)new DefaultListModel());
            this.mergedDump.addAll((Collection<CoroutineInfoData>)this.dump);
            this.filterField.addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    this.updateCoroutinesList();
                }
            });
            JBList<Object> jBList = this.filterPanel;
            boolean bl = false;
            boolean bl2 = false;
            JBList<Object> $this$apply = jBList;
            boolean bl3 = false;
            $this$apply.add((Component)new JLabel(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.filter.field", new Object[0])), (Object)"West");
            $this$apply.add((Component)this.filterField);
            $this$apply.setVisible(false);
            jBList = this.coroutinesList;
            bl = false;
            bl2 = false;
            $this$apply = jBList;
            boolean bl4 = false;
            $this$apply.setCellRenderer((ListCellRenderer)((Object)new CoroutineListCellRenderer()));
            $this$apply.setSelectionMode(0);
            $this$apply.addListSelectionListener(new ListSelectionListener($this$apply, this, consoleView2){
                final /* synthetic */ JBList $this_apply;
                final /* synthetic */ CoroutineDumpPanel this$0;
                final /* synthetic */ ConsoleView $consoleView$inlined;
                {
                    this.$this_apply = jBList;
                    this.this$0 = coroutineDumpPanel;
                    this.$consoleView$inlined = consoleView2;
                }

                public final void valueChanged(ListSelectionEvent it) {
                    int index2 = this.$this_apply.getSelectedIndex();
                    if (index2 >= 0) {
                        E e = this.$this_apply.getModel().getElementAt(index2);
                        if (e == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData");
                        }
                        CoroutineInfoData selection = (CoroutineInfoData)e;
                        AnalyzeStacktraceUtil.printStacktrace((ConsoleView)this.$consoleView$inlined, (String)selection.getStringStackTrace());
                    } else {
                        AnalyzeStacktraceUtil.printStacktrace((ConsoleView)this.$consoleView$inlined, (String)"");
                    }
                    this.$this_apply.repaint();
                }
            });
            this.exporterToTextFile = new MyToFileExporter(project2, this.dump);
            FilterAction filterAction = new FilterAction();
            bl2 = false;
            boolean $this$apply32 = false;
            FilterAction $this$apply2 = filterAction;
            boolean bl5 = false;
            AnAction anAction = ActionManager.getInstance().getAction("Find");
            Intrinsics.checkExpressionValueIsNotNull((Object)anAction, (String)"ActionManager.getInstanc\u2026n(IdeActions.ACTION_FIND)");
            $this$apply2.registerCustomShortcutSet(anAction.getShortcutSet(), (JComponent)this.coroutinesList);
            FilterAction filterAction2 = filterAction;
            filterAction = toolbarActions;
            bl2 = false;
            $this$apply32 = false;
            $this$apply2 = filterAction;
            boolean bl6 = false;
            $this$apply2.add((AnAction)filterAction2);
            $this$apply2.add((AnAction)new CopyToClipboardAction(this.dump, project2));
            $this$apply2.add(ActionManager.getInstance().getAction("ExportToTextFile"));
            $this$apply2.add((AnAction)new MergeStackTracesAction());
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("CoroutinesDump", (ActionGroup)toolbarActions, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026\", toolbarActions, false)");
            this.add((Component)actionToolbar.getComponent(), "West");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            $this$apply32 = false;
            boolean bl7 = false;
            JPanel $this$apply4 = jPanel2;
            boolean bl8 = false;
            $this$apply4.add((Component)this.filterPanel, "North");
            $this$apply4.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)this.coroutinesList), (int)5), "Center");
            JPanel leftPanel = jPanel2;
            Splitter $this$apply32 = new Splitter(false, 0.3f);
            bl7 = false;
            boolean bl9 = false;
            Splitter $this$apply5 = $this$apply32;
            boolean bl10 = false;
            $this$apply5.setFirstComponent((JComponent)leftPanel);
            $this$apply5.setSecondComponent(consoleView2.getComponent());
            Splitter splitter = $this$apply32;
            this.add((Component)splitter, "Center");
            new ListSpeedSearch((JList)this.coroutinesList).setComparator(new SpeedSearchComparator(false, true));
            this.updateCoroutinesList();
            final Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext((Component)consoleView2.getPreferredFocusableComponent()));
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getDocument()) == null) break block0;
            editor3.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    String filter2 = this.getFilterField().getText();
                    if (StringUtil.isNotEmpty((String)filter2)) {
                        String string = filter2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filter");
                        this.highlightOccurrences$jvm_debugger_coroutine(string, project2, editor2);
                    }
                }
            }, (Disposable)consoleView2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel$CoroutineListCellRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel;)V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "jvm-debugger-coroutine"})
    private final class CoroutineListCellRenderer
    extends ColoredListCellRenderer<Object> {
        protected void customizeCellRenderer(@NotNull JList<?> list2, @NotNull Object value2, int index2, boolean selected, boolean hasFocus) {
            Intrinsics.checkParameterIsNotNull(list2, (String)"list");
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            CoroutineInfoData state = (CoroutineInfoData)value2;
            this.setIcon(CoroutineDumpPanel.this.getCoroutineStateIcon(state));
            SimpleTextAttributes attrs = CoroutineDumpPanel.this.getAttributes(state);
            this.append(state.getName() + " (", attrs);
            String detail = state.getState().name();
            if (detail == null) {
                detail = state.getState().name();
            }
            if (detail.length() > 30) {
                String string = detail;
                int n = 0;
                int n2 = 30;
                StringBuilder stringBuilder2 = new StringBuilder();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string4 = string3;
                detail = stringBuilder2.append(string4).append("...").toString();
            }
            this.append(detail, attrs);
            this.append(")", attrs);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel$FilterAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "jvm-debugger-coroutine"})
    private final class FilterAction
    extends ToggleAction
    implements DumbAware {
        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return CoroutineDumpPanel.this.getFilterPanel().isVisible();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            CoroutineDumpPanel.this.getFilterPanel().setVisible(state);
            if (state) {
                IdeFocusManager.getInstance((Project)AnAction.getEventProject((AnActionEvent)e)).requestFocus((Component)CoroutineDumpPanel.this.getFilterField(), true);
                CoroutineDumpPanel.this.getFilterField().selectText();
            }
            CoroutineDumpPanel.this.updateCoroutinesList();
        }

        public FilterAction() {
            super(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.filter.action", new Object[0]), KotlinDebuggerCoroutinesBundle.message("coroutine.dump.filter.description", new Object[0]), AllIcons.General.Filter);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel$MergeStackTracesAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "jvm-debugger-coroutine"})
    private final class MergeStackTracesAction
    extends ToggleAction
    implements DumbAware {
        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return UISettings.Companion.getInstance().getState().getMergeEqualStackTraces();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            UISettings.Companion.getInstance().getState().setMergeEqualStackTraces(state);
            CoroutineDumpPanel.this.updateCoroutinesList();
        }

        public MergeStackTracesAction() {
            super(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.merge.action", new Object[0]), KotlinDebuggerCoroutinesBundle.message("coroutine.dump.merge.description", new Object[0]), AllIcons.Actions.Collapseall);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel$CopyToClipboardAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myCoroutinesDump", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Ljava/util/List;Lcom/intellij/openapi/project/Project;)V", "group", "Lcom/intellij/notification/NotificationGroup;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "jvm-debugger-coroutine"})
    private static final class CopyToClipboardAction
    extends DumbAwareAction {
        private final NotificationGroup group;
        private final List<CoroutineInfoData> myCoroutinesDump;
        private final Project myProject;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            StringBuilder buf = new StringBuilder();
            buf.append(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.full.title", new Object[0])).append("\n\n");
            for (CoroutineInfoData state : this.myCoroutinesDump) {
                buf.append(state.getStringStackTrace()).append("\n\n");
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(buf.toString()));
            String string = KotlinDebuggerCoroutinesBundle.message("coroutine.dump.full.copied", new Object[0]);
            MessageType messageType = MessageType.INFO;
            Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.INFO");
            this.group.createNotification(string, messageType).notify(this.myProject);
        }

        public CopyToClipboardAction(@NotNull List<CoroutineInfoData> myCoroutinesDump, @NotNull Project myProject) {
            Intrinsics.checkParameterIsNotNull(myCoroutinesDump, (String)"myCoroutinesDump");
            Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
            super(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.copy.action", new Object[0]), KotlinDebuggerCoroutinesBundle.message("coroutine.dump.copy.description", new Object[0]), PlatformIcons.COPY_ICON);
            this.myCoroutinesDump = myCoroutinesDump;
            this.myProject = myProject;
            this.group = NotificationGroup.Companion.toolWindowGroup(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.copy.analyze", new Object[0]), "Run", false);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel$MyToFileExporter;", "Lcom/intellij/ide/ExporterToTextFile;", "myProject", "Lcom/intellij/openapi/project/Project;", "infoData", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "defaultReportFileName", "", "canExport", "", "getDefaultFilePath", "getReportText", "jvm-debugger-coroutine"})
    private static final class MyToFileExporter
    implements ExporterToTextFile {
        private final String defaultReportFileName = "coroutines_report.txt";
        private final Project myProject;
        private final List<CoroutineInfoData> infoData;

        @NotNull
        public String getReportText() {
            boolean bl = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            StringBuilder $this$buildString = stringBuilder2;
            boolean bl4 = false;
            for (CoroutineInfoData state : this.infoData) {
                $this$buildString.append(state.getStringStackTrace()).append("\n\n");
            }
            String string = stringBuilder2.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public String getDefaultFilePath() {
            StringBuilder stringBuilder2 = new StringBuilder();
            String string = this.myProject.getBasePath();
            if (string == null) {
                string = "";
            }
            return stringBuilder2.append(string).append(File.separator).append(this.defaultReportFileName).toString();
        }

        public boolean canExport() {
            Collection collection = this.infoData;
            boolean bl = false;
            return !collection.isEmpty();
        }

        public MyToFileExporter(@NotNull Project myProject, @NotNull List<CoroutineInfoData> infoData) {
            Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
            Intrinsics.checkParameterIsNotNull(infoData, (String)"infoData");
            this.myProject = myProject;
            this.infoData = infoData;
            this.defaultReportFileName = "coroutines_report.txt";
        }
    }
}

