/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIcon;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIconPresentationRenderer$WhenMappings;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0014R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIconPresentationRenderer;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "settings", "Lcom/intellij/debugger/settings/ThreadsViewSettings;", "render", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;", "location", "Lcom/sun/jdi/Location;", "infoData", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "renderCreationNode", "renderErrorNode", "error", "", "renderGroup", "groupName", "renderRoorNode", "text", "jvm-debugger-coroutine"})
public final class SimpleColoredTextIconPresentationRenderer {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty log$delegate = ProvidersKt.getLogger();
    private final ThreadsViewSettings settings;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SimpleColoredTextIconPresentationRenderer.class), "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;"))};
    }

    @NotNull
    public final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final SimpleColoredTextIcon render(@NotNull CoroutineInfoData infoData) {
        Icon icon;
        Intrinsics.checkParameterIsNotNull((Object)infoData, (String)"infoData");
        ThreadReference thread = infoData.getActiveThread();
        Object object = thread;
        if (object == null || (object = object.name()) == null || (object = StringsKt.substringBefore$default((String)object, (String)(" @" + infoData.getName()), null, (int)2, null)) == null) {
            object = "";
        }
        Object name2 = object;
        String threadState = thread != null ? DebuggerUtilsEx.getThreadStatusText((int)thread.status()) : "";
        switch (SimpleColoredTextIconPresentationRenderer$WhenMappings.$EnumSwitchMapping$0[infoData.getState().ordinal()]) {
            case 1: {
                icon = AllIcons.Debugger.ThreadSuspended;
                break;
            }
            case 2: {
                icon = AllIcons.Debugger.ThreadRunning;
                break;
            }
            case 3: {
                icon = AllIcons.Debugger.ThreadStates.Idle;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Icon icon2 = icon;
        SimpleColoredTextIcon label2 = new SimpleColoredTextIcon(icon2, true);
        label2.append$jvm_debugger_coroutine("\"");
        label2.appendValue$jvm_debugger_coroutine(infoData.getName());
        label2.append$jvm_debugger_coroutine("\": " + (Object)((Object)infoData.getState()));
        CharSequence charSequence = (CharSequence)name2;
        boolean bl = false;
        if (charSequence.length() > 0) {
            label2.append$jvm_debugger_coroutine(" on thread \"");
            label2.appendValue$jvm_debugger_coroutine((String)name2);
            label2.append$jvm_debugger_coroutine("\": " + threadState);
        }
        return label2;
    }

    @NotNull
    public final SimpleColoredTextIcon render(@NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        SimpleColoredTextIcon label2 = new SimpleColoredTextIcon(null, false);
        DebuggerUIUtil.getColorScheme(null);
        if (location2.method() != null) {
            String methodDisplay;
            String myName = location2.method().name();
            String string = methodDisplay = this.settings.SHOW_ARGUMENTS_TYPES ? DebuggerUtilsEx.methodNameWithArguments((Method)location2.method()) : myName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"methodDisplay");
            label2.appendValue$jvm_debugger_coroutine(string);
        }
        if (this.settings.SHOW_LINE_NUMBER) {
            label2.append$jvm_debugger_coroutine(":");
            label2.append$jvm_debugger_coroutine("" + DebuggerUtilsEx.getLineNumber((Location)location2, (boolean)false));
        }
        if (this.settings.SHOW_CLASS_NAME) {
            Object refType;
            String name2 = null;
            try {
                ReferenceType referenceType = location2.declaringType();
                Intrinsics.checkExpressionValueIsNotNull((Object)referenceType, (String)"location.declaringType()");
                refType = referenceType;
                refType = refType.name();
            }
            catch (InternalError e) {
                refType = e.toString();
            }
            name2 = refType;
            if (name2 != null) {
                label2.append$jvm_debugger_coroutine(", ");
                int dotIndex = StringsKt.lastIndexOf$default((CharSequence)name2, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (dotIndex < 0) {
                    label2.append$jvm_debugger_coroutine(name2);
                } else {
                    String string = name2;
                    int n = dotIndex + 1;
                    SimpleColoredTextIcon simpleColoredTextIcon = label2;
                    boolean bl = false;
                    String string2 = string.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    CharSequence charSequence = string2;
                    simpleColoredTextIcon.append$jvm_debugger_coroutine((String)charSequence);
                    if (this.settings.SHOW_PACKAGE_NAME) {
                        string = name2;
                        n = 0;
                        charSequence = new StringBuilder().append(" (");
                        simpleColoredTextIcon = label2;
                        bl = false;
                        String string3 = string.substring(n, dotIndex);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string4 = string3;
                        simpleColoredTextIcon.append$jvm_debugger_coroutine(((StringBuilder)charSequence).append(string4).append(')').toString());
                    }
                }
            }
        }
        if (this.settings.SHOW_SOURCE_NAME) {
            String sourceName2;
            label2.append$jvm_debugger_coroutine(", ");
            String string = sourceName2 = DebuggerUtilsEx.getSourceName((Location)location2, (Function)new Function<Throwable, String>(this, location2){
                final /* synthetic */ SimpleColoredTextIconPresentationRenderer this$0;
                final /* synthetic */ Location $location;

                @NotNull
                public final String apply(@Nullable Throwable e) {
                    this.this$0.getLog().error("Error while trying to resolve sourceName for location", e, new String[]{this.$location.toString()});
                    return "Unknown Source";
                }
                {
                    this.this$0 = simpleColoredTextIconPresentationRenderer;
                    this.$location = location2;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceName");
            label2.append$jvm_debugger_coroutine(string);
        }
        return label2;
    }

    @NotNull
    public final SimpleColoredTextIcon renderCreationNode(@NotNull CoroutineInfoData infoData) {
        Intrinsics.checkParameterIsNotNull((Object)infoData, (String)"infoData");
        return new SimpleColoredTextIcon(AllIcons.Debugger.ThreadSuspended, true, KotlinDebuggerCoroutinesBundle.message("coroutine.dump.creation.frame", infoData.getName()));
    }

    @NotNull
    public final SimpleColoredTextIcon renderErrorNode(@NotNull String error2) {
        Intrinsics.checkParameterIsNotNull((Object)error2, (String)"error");
        return new SimpleColoredTextIcon(AllIcons.Actions.Lightning, false, error2);
    }

    @NotNull
    public final SimpleColoredTextIcon renderRoorNode(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        return new SimpleColoredTextIcon(null, true, text2);
    }

    @NotNull
    public final SimpleColoredTextIcon renderGroup(@NotNull String groupName) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        return new SimpleColoredTextIcon(AllIcons.Debugger.ThreadGroup, true, groupName);
    }

    public SimpleColoredTextIconPresentationRenderer() {
        ThreadsViewSettings threadsViewSettings = ThreadsViewSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadsViewSettings, (String)"ThreadsViewSettings.getInstance()");
        this.settings = threadsViewSettings;
    }
}

