/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.CodeFragmentCodegen;
import org.jetbrains.kotlin.codegen.CodeFragmentCodegenInfo;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationStatus;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilerKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameterAnalyzer;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameterInfo;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledDataDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.EvaluatorMemberScopeForMethod;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.EvaluatorModuleDescriptor;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001/B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJD\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&H\u0002J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+H\u0002J \u0010,\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010-\u001a\u00020.H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler;", "", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "status", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;)V", "compile", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler$CompilationResult;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "createDescriptorsForCodeFragment", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "declaration", "className", "Lorg/jetbrains/kotlin/name/Name;", "methodName", "parameterInfo", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterInfo;", "returnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "packageFragmentDescriptor", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "doCompile", "getLocalFunctionSuffixes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Dumb;", "", "parameters", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Smart;", "typeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "getMethodSignature", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor$MethodSignature;", "methodDescriptor", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "getReturnType", "defaultReturnType", "Lorg/jetbrains/kotlin/types/SimpleType;", "CompilationResult", "jvm-debugger-evaluation"})
public final class CodeFragmentCompiler {
    private final ExecutionContext executionContext;
    private final EvaluationStatus status;

    @NotNull
    public final CompilationResult compile(@NotNull KtCodeFragment codeFragment, @NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        return (CompilationResult)ApplicationUtilsKt.runReadAction((Function0)new Function0<CompilationResult>(this, codeFragment, bindingContext2, moduleDescriptor){
            final /* synthetic */ CodeFragmentCompiler this$0;
            final /* synthetic */ KtCodeFragment $codeFragment;
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ ModuleDescriptor $moduleDescriptor;

            @NotNull
            public final CompilationResult invoke() {
                return CodeFragmentCompiler.access$doCompile(this.this$0, this.$codeFragment, this.$bindingContext, this.$moduleDescriptor);
            }
            {
                this.this$0 = codeFragmentCompiler;
                this.$codeFragment = ktCodeFragment;
                this.$bindingContext = bindingContext2;
                this.$moduleDescriptor = moduleDescriptor;
                super(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompilationResult doCompile(KtCodeFragment codeFragment, BindingContext bindingContext2, ModuleDescriptor moduleDescriptor) {
        void classDescriptor2;
        boolean bl = codeFragment instanceof KtBlockCodeFragment || codeFragment instanceof KtExpressionCodeFragment;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unsupported code fragment type: " + codeFragment;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Project project2 = codeFragment.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"codeFragment.project");
        Project project3 = project2;
        ResolutionFacade resolutionFacade2 = KotlinEvaluatorBuilderKt.getResolutionFacadeForCodeFragment(codeFragment);
        ResolveSession resolveSession = (ResolveSession)resolutionFacade2.getFrontendService(ResolveSession.class);
        EvaluatorModuleDescriptor moduleDescriptorWrapper = new EvaluatorModuleDescriptor(codeFragment, moduleDescriptor, resolveSession);
        SimpleType simpleType2 = moduleDescriptor.getBuiltIns().getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"moduleDescriptor.builtIns.unitType");
        SimpleType defaultReturnType = simpleType2;
        KotlinType returnType2 = this.getReturnType(codeFragment, bindingContext2, defaultReturnType);
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        CommonConfigurationKeysKt.setLanguageVersionSettings(compilerConfiguration, PlatformKt.getLanguageVersionSettings((PsiElement)codeFragment));
        ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.BINARIES;
        Intrinsics.checkExpressionValueIsNotNull((Object)classBuilderFactory, (String)"ClassBuilderFactories.BINARIES");
        GenerationState generationState = new GenerationState.Builder(project3, classBuilderFactory, moduleDescriptorWrapper, bindingContext2, CollectionsKt.listOf((Object)codeFragment), compilerConfiguration).build();
        CodeFragmentParameterInfo parameterInfo = new CodeFragmentParameterAnalyzer(this.executionContext, codeFragment, bindingContext2, this.status).analyze();
        Name name2 = Name.identifier("Generated_for_debugger_class");
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(GENERATED_CLASS_NAME)");
        Name name3 = Name.identifier("generated_for_debugger_fun");
        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(GENERATED_FUNCTION_NAME)");
        Pair<ClassDescriptor, FunctionDescriptor> pair2 = this.createDescriptorsForCodeFragment(codeFragment, name2, name3, parameterInfo, returnType2, moduleDescriptorWrapper.getPackageFragmentForEvaluator());
        ClassDescriptor classDescriptor3 = (ClassDescriptor)pair2.component1();
        FunctionDescriptor methodDescriptor = (FunctionDescriptor)pair2.component2();
        CodeFragmentCodegenInfo codegenInfo = new CodeFragmentCodegenInfo((ClassDescriptor)classDescriptor2, methodDescriptor, parameterInfo.getParameters());
        CodeFragmentCodegen.Companion.setCodeFragmentInfo(codeFragment, codegenInfo);
        try {
            void $this$mapTo$iv$iv;
            KotlinCodegenFacade.compileCorrectFiles(generationState);
            List<OutputFile> list2 = generationState.getFactory().asList();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"generationState.factory.asList()");
            Iterable $this$map$iv = ClassFileUtilsKt.filterClassFiles(list2);
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                OutputFile outputFile = (OutputFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                ClassToLoad classToLoad = new ClassToLoad(CodeFragmentCompilerKt.access$getInternalClassName$p((OutputFile)it), it.getRelativePath(), it.asByteArray());
                collection.add(classToLoad);
            }
            List classes2 = (List)destination$iv$iv;
            CompiledDataDescriptor.MethodSignature methodSignature = this.getMethodSignature(methodDescriptor, parameterInfo, generationState);
            Map<CodeFragmentParameter.Dumb, String> functionSuffixes = this.getLocalFunctionSuffixes(parameterInfo.getParameters(), generationState.getTypeMapper());
            generationState.destroy();
            object = new CompilationResult(classes2, parameterInfo, functionSuffixes, methodSignature);
            return object;
        }
        finally {
            CodeFragmentCodegen.Companion.clearCodeFragmentInfo(codeFragment);
        }
    }

    private final Map<CodeFragmentParameter.Dumb, String> getLocalFunctionSuffixes(List<CodeFragmentParameter.Smart> parameters2, KotlinTypeMapper typeMapper2) {
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        for (CodeFragmentParameter.Smart parameter : parameters2) {
            String ownerClassName;
            if (parameter.getKind() != CodeFragmentParameter.Kind.LOCAL_FUNCTION) continue;
            String string = ownerClassName = typeMapper2.mapOwner(parameter.getTargetDescriptor()).getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ownerClassName");
            Integer n = StringsKt.lastIndexOf$default((CharSequence)string, (char)'$', (int)0, (boolean)false, (int)6, null);
            boolean bl2 = false;
            boolean bl3 = false;
            int it = ((Number)n).intValue();
            boolean bl4 = false;
            Integer n2 = it >= 0 ? n : null;
            if (n2 == null) {
                continue;
            }
            int lastDollarIndex = n2;
            result2.put(parameter.getDumb(), StringsKt.drop((String)ownerClassName, (int)lastDollarIndex));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final CompiledDataDescriptor.MethodSignature getMethodSignature(FunctionDescriptor methodDescriptor, CodeFragmentParameterInfo parameterInfo, GenerationState state) {
        void $this$mapTo$iv$iv;
        KotlinTypeMapper typeMapper2 = state.getTypeMapper();
        JvmMethodSignature asmSignature = KotlinTypeMapper.mapSignatureSkipGeneric$default(typeMapper2, methodDescriptor, null, 2, null);
        Iterable iterable = parameterInfo.getParameters();
        List<JvmMethodParameterSignature> list2 = asmSignature.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"asmSignature.valueParameters");
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)list2);
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void param;
            void $dstr$param$sigParam;
            Pair pair2 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CodeFragmentParameter.Smart smart = (CodeFragmentParameter.Smart)$dstr$param$sigParam.component1();
            JvmMethodParameterSignature sigParam = (JvmMethodParameterSignature)$dstr$param$sigParam.component2();
            Type type2 = CodeFragmentCodegen.Companion.getSharedTypeIfApplicable((CodeFragmentCodegenInfo.IParameter)param, typeMapper2);
            if (type2 == null) {
                JvmMethodParameterSignature jvmMethodParameterSignature = sigParam;
                Intrinsics.checkExpressionValueIsNotNull((Object)jvmMethodParameterSignature, (String)"sigParam");
                Type type3 = jvmMethodParameterSignature.getAsmType();
                type2 = type3;
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"sigParam.asmType");
            }
            Type type4 = type2;
            collection.add(type4);
        }
        List asmParameters = (List)destination$iv$iv;
        Type type5 = asmSignature.getReturnType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"asmSignature.returnType");
        return new CompiledDataDescriptor.MethodSignature(asmParameters, type5);
    }

    private final KotlinType getReturnType(KtCodeFragment codeFragment, BindingContext bindingContext2, SimpleType defaultReturnType) {
        Object object;
        KtCodeFragment ktCodeFragment = codeFragment;
        if (ktCodeFragment instanceof KtExpressionCodeFragment) {
            KotlinTypeInfo typeInfo = (KotlinTypeInfo)bindingContext2.get(BindingContext.EXPRESSION_TYPE_INFO, ((KtExpressionCodeFragment)codeFragment).getContentElement());
            object = typeInfo;
            if (object == null || (object = ((KotlinTypeInfo)object).getType()) == null) {
                object = defaultReturnType;
            }
        } else if (ktCodeFragment instanceof KtBlockCodeFragment) {
            KtBlockExpression blockExpression2 = ((KtBlockCodeFragment)codeFragment).getContentElement();
            List<KtExpression> list2 = blockExpression2.getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"blockExpression.statements");
            KtExpression ktExpression = (KtExpression)CollectionsKt.lastOrNull(list2);
            if (ktExpression == null) {
                return defaultReturnType;
            }
            KtExpression lastStatement = ktExpression;
            KotlinTypeInfo typeInfo = (KotlinTypeInfo)bindingContext2.get(BindingContext.EXPRESSION_TYPE_INFO, lastStatement);
            object = typeInfo;
            if (object == null || (object = ((KotlinTypeInfo)object).getType()) == null) {
                object = defaultReturnType;
            }
        } else {
            object = defaultReturnType;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<ClassDescriptor, FunctionDescriptor> createDescriptorsForCodeFragment(KtCodeFragment declaration2, Name className2, Name methodName2, CodeFragmentParameterInfo parameterInfo, KotlinType returnType2, PackageFragmentDescriptor packageFragmentDescriptor) {
        void $this$mapIndexedTo$iv$iv;
        ClassDescriptorImpl classDescriptor2 = new ClassDescriptorImpl(packageFragmentDescriptor, className2, Modality.FINAL, ClassKind.OBJECT, CollectionsKt.emptyList(), new KotlinSourceElement(declaration2), false, LockBasedStorageManager.NO_LOCKS);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = SimpleFunctionDescriptorImpl.create(classDescriptor2, Annotations.Companion.getEMPTY(), methodName2, CallableMemberDescriptor.Kind.SYNTHESIZED, classDescriptor2.getSource());
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptorImpl, (String)"SimpleFunctionDescriptor\u2026scriptor.source\n        )");
        SimpleFunctionDescriptorImpl methodDescriptor = simpleFunctionDescriptorImpl;
        Iterable $this$mapIndexed$iv = parameterInfo.getParameters();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void parameter;
            void index2;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            CodeFragmentParameter.Smart smart = (CodeFragmentParameter.Smart)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            boolean bl2 = false;
            CallableDescriptor callableDescriptor = methodDescriptor;
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            Name name2 = Name.identifier("" + 'p' + (int)index2);
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"p$index\")");
            KotlinType kotlinType = parameter.getTargetType();
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"SourceElement.NO_SOURCE");
            ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(callableDescriptor, null, (int)index2, annotations2, name2, kotlinType, false, false, false, null, sourceElement);
            collection2.add(valueParameterDescriptorImpl);
        }
        List parameters2 = (List)destination$iv$iv;
        methodDescriptor.initialize((ReceiverParameterDescriptor)null, classDescriptor2.getThisAsReceiverParameter(), CollectionsKt.emptyList(), parameters2, returnType2, Modality.FINAL, Visibilities.PUBLIC);
        EvaluatorMemberScopeForMethod memberScope2 = new EvaluatorMemberScopeForMethod(methodDescriptor);
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = ClassConstructorDescriptorImpl.create(classDescriptor2, Annotations.Companion.getEMPTY(), true, classDescriptor2.getSource());
        Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptorImpl, (String)"ClassConstructorDescript\u2026, classDescriptor.source)");
        ClassConstructorDescriptorImpl constructor2 = classConstructorDescriptorImpl;
        classDescriptor2.initialize(memberScope2, SetsKt.setOf((Object)constructor2), constructor2);
        return new Pair((Object)classDescriptor2, (Object)methodDescriptor);
    }

    public CodeFragmentCompiler(@NotNull ExecutionContext executionContext, @NotNull EvaluationStatus status2) {
        Intrinsics.checkParameterIsNotNull((Object)executionContext, (String)"executionContext");
        Intrinsics.checkParameterIsNotNull((Object)status2, (String)"status");
        this.executionContext = executionContext;
        this.status = status2;
    }

    public static final /* synthetic */ CompilationResult access$doCompile(CodeFragmentCompiler $this, KtCodeFragment codeFragment, BindingContext bindingContext2, ModuleDescriptor moduleDescriptor) {
        return $this.doCompile(codeFragment, bindingContext2, moduleDescriptor);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\u0015\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\fH\u00c6\u0003JC\u0010\u001a\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\nH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler$CompilationResult;", "", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "parameterInfo", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterInfo;", "localFunctionSuffixes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Dumb;", "", "mainMethodSignature", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor$MethodSignature;", "(Ljava/util/List;Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterInfo;Ljava/util/Map;Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor$MethodSignature;)V", "getClasses", "()Ljava/util/List;", "getLocalFunctionSuffixes", "()Ljava/util/Map;", "getMainMethodSignature", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor$MethodSignature;", "getParameterInfo", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterInfo;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "jvm-debugger-evaluation"})
    public static final class CompilationResult {
        @NotNull
        private final List<ClassToLoad> classes;
        @NotNull
        private final CodeFragmentParameterInfo parameterInfo;
        @NotNull
        private final Map<CodeFragmentParameter.Dumb, String> localFunctionSuffixes;
        @NotNull
        private final CompiledDataDescriptor.MethodSignature mainMethodSignature;

        @NotNull
        public final List<ClassToLoad> getClasses() {
            return this.classes;
        }

        @NotNull
        public final CodeFragmentParameterInfo getParameterInfo() {
            return this.parameterInfo;
        }

        @NotNull
        public final Map<CodeFragmentParameter.Dumb, String> getLocalFunctionSuffixes() {
            return this.localFunctionSuffixes;
        }

        @NotNull
        public final CompiledDataDescriptor.MethodSignature getMainMethodSignature() {
            return this.mainMethodSignature;
        }

        public CompilationResult(@NotNull List<ClassToLoad> classes2, @NotNull CodeFragmentParameterInfo parameterInfo, @NotNull Map<CodeFragmentParameter.Dumb, String> localFunctionSuffixes, @NotNull CompiledDataDescriptor.MethodSignature mainMethodSignature) {
            Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
            Intrinsics.checkParameterIsNotNull((Object)parameterInfo, (String)"parameterInfo");
            Intrinsics.checkParameterIsNotNull(localFunctionSuffixes, (String)"localFunctionSuffixes");
            Intrinsics.checkParameterIsNotNull((Object)mainMethodSignature, (String)"mainMethodSignature");
            this.classes = classes2;
            this.parameterInfo = parameterInfo;
            this.localFunctionSuffixes = localFunctionSuffixes;
            this.mainMethodSignature = mainMethodSignature;
        }

        @NotNull
        public final List<ClassToLoad> component1() {
            return this.classes;
        }

        @NotNull
        public final CodeFragmentParameterInfo component2() {
            return this.parameterInfo;
        }

        @NotNull
        public final Map<CodeFragmentParameter.Dumb, String> component3() {
            return this.localFunctionSuffixes;
        }

        @NotNull
        public final CompiledDataDescriptor.MethodSignature component4() {
            return this.mainMethodSignature;
        }

        @NotNull
        public final CompilationResult copy(@NotNull List<ClassToLoad> classes2, @NotNull CodeFragmentParameterInfo parameterInfo, @NotNull Map<CodeFragmentParameter.Dumb, String> localFunctionSuffixes, @NotNull CompiledDataDescriptor.MethodSignature mainMethodSignature) {
            Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
            Intrinsics.checkParameterIsNotNull((Object)parameterInfo, (String)"parameterInfo");
            Intrinsics.checkParameterIsNotNull(localFunctionSuffixes, (String)"localFunctionSuffixes");
            Intrinsics.checkParameterIsNotNull((Object)mainMethodSignature, (String)"mainMethodSignature");
            return new CompilationResult(classes2, parameterInfo, localFunctionSuffixes, mainMethodSignature);
        }

        public static /* synthetic */ CompilationResult copy$default(CompilationResult compilationResult, List list2, CodeFragmentParameterInfo codeFragmentParameterInfo, Map map2, CompiledDataDescriptor.MethodSignature methodSignature, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = compilationResult.classes;
            }
            if ((n & 2) != 0) {
                codeFragmentParameterInfo = compilationResult.parameterInfo;
            }
            if ((n & 4) != 0) {
                map2 = compilationResult.localFunctionSuffixes;
            }
            if ((n & 8) != 0) {
                methodSignature = compilationResult.mainMethodSignature;
            }
            return compilationResult.copy(list2, codeFragmentParameterInfo, map2, methodSignature);
        }

        @NotNull
        public String toString() {
            return "CompilationResult(classes=" + this.classes + ", parameterInfo=" + this.parameterInfo + ", localFunctionSuffixes=" + this.localFunctionSuffixes + ", mainMethodSignature=" + this.mainMethodSignature + ")";
        }

        public int hashCode() {
            List<ClassToLoad> list2 = this.classes;
            CodeFragmentParameterInfo codeFragmentParameterInfo = this.parameterInfo;
            Map<CodeFragmentParameter.Dumb, String> map2 = this.localFunctionSuffixes;
            CompiledDataDescriptor.MethodSignature methodSignature = this.mainMethodSignature;
            return (((list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (codeFragmentParameterInfo != null ? codeFragmentParameterInfo.hashCode() : 0)) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0)) * 31 + (methodSignature != null ? ((Object)methodSignature).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CompilationResult)) break block3;
                    CompilationResult compilationResult = (CompilationResult)object;
                    if (!Intrinsics.areEqual(this.classes, compilationResult.classes) || !Intrinsics.areEqual((Object)this.parameterInfo, (Object)compilationResult.parameterInfo) || !Intrinsics.areEqual(this.localFunctionSuffixes, compilationResult.localFunctionSuffixes) || !Intrinsics.areEqual((Object)this.mainMethodSignature, (Object)compilationResult.mainMethodSignature)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

