/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/render/DelegatedPropertyFieldDescriptor;", "Lcom/intellij/debugger/ui/impl/watch/FieldDescriptorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "objectRef", "Lcom/sun/jdi/ObjectReference;", "delegate", "Lcom/sun/jdi/Field;", "renderDelegatedProperty", "", "(Lcom/intellij/openapi/project/Project;Lcom/sun/jdi/ObjectReference;Lcom/sun/jdi/Field;Z)V", "getDelegate", "()Lcom/sun/jdi/Field;", "calcValue", "Lcom/sun/jdi/Value;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "findGetterForDelegatedProperty", "Lcom/sun/jdi/Method;", "getDeclaredType", "", "getDescriptorEvaluation", "Lcom/intellij/psi/PsiExpression;", "context", "Lcom/intellij/debugger/DebuggerContext;", "getName", "jvm-debugger-core"})
public final class DelegatedPropertyFieldDescriptor
extends FieldDescriptorImpl {
    @NotNull
    private final Field delegate;
    private final boolean renderDelegatedProperty;

    @Nullable
    public Value calcValue(@Nullable EvaluationContextImpl evaluationContext) {
        Value value2;
        ThreadReference threadReference;
        if (evaluationContext == null) {
            return null;
        }
        if (!this.renderDelegatedProperty) {
            return super.calcValue(evaluationContext);
        }
        Method method = this.findGetterForDelegatedProperty();
        SuspendContextImpl suspendContextImpl = evaluationContext.getSuspendContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)suspendContextImpl, (String)"evaluationContext.suspendContext");
        ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
        ThreadReference threadReference2 = threadReference = threadReferenceProxyImpl != null ? threadReferenceProxyImpl.getThreadReference() : null;
        if (method == null || threadReference == null) {
            return super.calcValue(evaluationContext);
        }
        try {
            Method method2 = method;
            ObjectReference objectReference = this.getObject();
            EvaluationContext evaluationContext2 = (EvaluationContext)evaluationContext;
            DebugProcessImpl debugProcessImpl = evaluationContext.getDebugProcess();
            boolean bl = false;
            List list2 = CollectionsKt.emptyList();
            SuspendContextImpl suspendContextImpl2 = evaluationContext.getSuspendContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)suspendContextImpl2, (String)"evaluationContext.suspendContext");
            value2 = debugProcessImpl.invokeInstanceMethod(evaluationContext2, objectReference, method2, list2, suspendContextImpl2.getSuspendPolicy());
        }
        catch (EvaluateException e) {
            value2 = e.getExceptionFromTargetVM();
        }
        return value2;
    }

    @NotNull
    public String getName() {
        String string = this.delegate.name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"delegate.name()");
        return StringsKt.removeSuffix((String)string, (CharSequence)"$delegate");
    }

    @Nullable
    public PsiExpression getDescriptorEvaluation(@Nullable DebuggerContext context2) {
        return null;
    }

    private final Method findGetterForDelegatedProperty() {
        String fieldName = this.getName();
        if (!Name.isValidIdentifier(fieldName)) {
            return null;
        }
        List<Method> list2 = this.getObject().referenceType().methodsByName(JvmAbi.getterName(fieldName));
        return list2 != null ? (Method)CollectionsKt.firstOrNull(list2) : null;
    }

    @Nullable
    public String getDeclaredType() {
        Type returnType2;
        Type type2;
        Method method = this.findGetterForDelegatedProperty();
        if (method == null) {
            return null;
        }
        Method getter2 = method;
        try {
            type2 = getter2.returnType();
        }
        catch (ClassNotLoadedException e) {
            return "<unknown>";
        }
        Type type3 = returnType2 = type2;
        return type3 != null ? type3.name() : null;
    }

    @NotNull
    public final Field getDelegate() {
        return this.delegate;
    }

    public DelegatedPropertyFieldDescriptor(@NotNull Project project2, @NotNull ObjectReference objectRef, @NotNull Field delegate2, boolean renderDelegatedProperty) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)objectRef, (String)"objectRef");
        Intrinsics.checkParameterIsNotNull((Object)delegate2, (String)"delegate");
        super(project2, objectRef, delegate2);
        this.delegate = delegate2;
        this.renderDelegatedProperty = renderDelegatedProperty;
    }
}

