/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.render;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerSettings;
import org.jetbrains.kotlin.idea.debugger.ToggleKotlinVariablesState;
import org.jetbrains.kotlin.idea.debugger.render.DelegatedPropertyFieldDescriptor;
import org.jetbrains.kotlin.idea.debugger.render.KotlinClassWithDelegatedPropertyRendererKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/render/KotlinClassWithDelegatedPropertyRenderer;", "Lcom/intellij/debugger/ui/tree/render/ClassRenderer;", "()V", "rendererSettings", "Lcom/intellij/debugger/settings/NodeRendererSettings;", "kotlin.jvm.PlatformType", "buildChildren", "", "value", "Lcom/sun/jdi/Value;", "builder", "Lcom/intellij/debugger/ui/tree/render/ChildrenBuilder;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "calcLabel", "", "descriptor", "Lcom/intellij/debugger/ui/tree/ValueDescriptor;", "evaluationContext", "listener", "Lcom/intellij/debugger/ui/tree/render/DescriptorLabelListener;", "calcToStringLabel", "isApplicable", "", "jdiType", "Lcom/sun/jdi/Type;", "jvm-debugger-core"})
public final class KotlinClassWithDelegatedPropertyRenderer
extends ClassRenderer {
    private final NodeRendererSettings rendererSettings = NodeRendererSettings.getInstance();

    public boolean isApplicable(@Nullable Type jdiType) {
        if (!super.isApplicable(jdiType)) {
            return false;
        }
        if (!(jdiType instanceof ReferenceType)) {
            return false;
        }
        if (!((ReferenceType)jdiType).isPrepared()) {
            KotlinClassWithDelegatedPropertyRendererKt.access$getLOG$p().info(KotlinClassWithDelegatedPropertyRendererKt.access$notPreparedClassMessage((ReferenceType)jdiType));
            return false;
        }
        try {
            boolean bl;
            block8: {
                List<Field> list2 = ((ReferenceType)jdiType).allFields();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"jdiType.allFields()");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Field it = (Field)element$iv;
                        boolean bl2 = false;
                        String string = it.name();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name()");
                        if (!StringsKt.endsWith$default((String)string, (String)"$delegate", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        catch (ClassNotPreparedException notPrepared) {
            KotlinClassWithDelegatedPropertyRendererKt.access$getLOG$p().error(KotlinClassWithDelegatedPropertyRendererKt.access$notPreparedClassMessage((ReferenceType)jdiType), (Throwable)notPrepared);
            return false;
        }
    }

    @NotNull
    public String calcLabel(@NotNull ValueDescriptor descriptor2, @NotNull EvaluationContext evaluationContext, @NotNull DescriptorLabelListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)evaluationContext, (String)"evaluationContext");
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        String res2 = this.calcToStringLabel(descriptor2, evaluationContext, listener2);
        if (res2 != null) {
            return res2;
        }
        String string = super.calcLabel(descriptor2, evaluationContext, listener2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"super.calcLabel(descript\u2026luationContext, listener)");
        return string;
    }

    private final String calcToStringLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener listener2) {
        ToStringRenderer toStringRenderer;
        NodeRendererSettings nodeRendererSettings = this.rendererSettings;
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeRendererSettings, (String)"rendererSettings");
        ToStringRenderer toStringRenderer2 = toStringRenderer = nodeRendererSettings.getToStringRenderer();
        Intrinsics.checkExpressionValueIsNotNull((Object)toStringRenderer2, (String)"toStringRenderer");
        if (toStringRenderer2.isEnabled()) {
            DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)evaluationContext.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getIns\u2026valuationContext.project)");
            DebuggerContextImpl debuggerContextImpl = debuggerManagerEx.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"DebuggerManagerEx.getIns\u2026nContext.project).context");
            if (DebuggerUtilKt.getCanRunEvaluation(debuggerContextImpl) && toStringRenderer.isApplicable(descriptor2.getType())) {
                return toStringRenderer.calcLabel(descriptor2, evaluationContext, listener2);
            }
        }
        return null;
    }

    public void buildChildren(@Nullable Value value2, @NotNull ChildrenBuilder builder2, @NotNull EvaluationContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)builder2, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!(value2 instanceof ObjectReference)) {
            return;
        }
        NodeManager nodeManager = builder2.getNodeManager();
        if (nodeManager == null) {
            Intrinsics.throwNpe();
        }
        NodeManager nodeManager2 = nodeManager;
        NodeDescriptorFactory nodeDescriptorFactory = builder2.getDescriptorManager();
        if (nodeDescriptorFactory == null) {
            Intrinsics.throwNpe();
        }
        NodeDescriptorFactory nodeDescriptorFactory2 = nodeDescriptorFactory;
        List<Field> fields2 = ((ObjectReference)value2).referenceType().allFields();
        if (fields2.isEmpty()) {
            MessageDescriptor messageDescriptor = MessageDescriptor.CLASS_HAS_NO_FIELDS;
            Intrinsics.checkExpressionValueIsNotNull((Object)messageDescriptor, (String)"MessageDescriptor.CLASS_HAS_NO_FIELDS");
            builder2.setChildren(CollectionsKt.listOf((Object)nodeManager2.createMessageNode(messageDescriptor.getLabel())));
            return;
        }
        ArrayList<DebuggerTreeNode> children2 = new ArrayList<DebuggerTreeNode>();
        for (Field field2 : fields2) {
            FieldDescriptor fieldDescriptor;
            if (!this.shouldDisplay(context2, (ObjectReference)value2, field2)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeDescriptorFactory2.getFieldDescriptor((NodeDescriptor)builder2.getParentDescriptor(), (ObjectReference)value2, field2), (String)"nodeDescriptorFactory.ge\u2026Descriptor, value, field)");
            String string = field2.name();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"field.name()");
            if (StringsKt.endsWith$default((String)string, (String)"$delegate", (boolean)false, (int)2, null)) {
                boolean shouldRenderDelegatedProperty = KotlinDebuggerSettings.Companion.getInstance().getDEBUG_RENDER_DELEGATED_PROPERTIES();
                if (shouldRenderDelegatedProperty && !ToggleKotlinVariablesState.Companion.getService().getKotlinVariableView()) {
                    children2.add(nodeManager2.createNode((NodeDescriptor)fieldDescriptor, context2));
                }
                DebugProcess debugProcess = context2.getDebugProcess();
                Intrinsics.checkExpressionValueIsNotNull((Object)debugProcess, (String)"context.debugProcess");
                Project project2 = debugProcess.getProject();
                if (project2 == null) {
                    Intrinsics.throwNpe();
                }
                ObjectReference objectReference = (ObjectReference)value2;
                Field field3 = field2;
                Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"field");
                DelegatedPropertyFieldDescriptor delegatedPropertyDescriptor = new DelegatedPropertyFieldDescriptor(project2, objectReference, field3, shouldRenderDelegatedProperty);
                children2.add(nodeManager2.createNode((NodeDescriptor)delegatedPropertyDescriptor, context2));
                continue;
            }
            children2.add(nodeManager2.createNode((NodeDescriptor)fieldDescriptor, context2));
        }
        XDebuggerSettingsManager xDebuggerSettingsManager = XDebuggerSettingsManager.getInstance();
        if (xDebuggerSettingsManager == null) {
            Intrinsics.throwNpe();
        }
        XDebuggerSettingsManager.DataViewSettings dataViewSettings = xDebuggerSettingsManager.getDataViewSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataViewSettings, (String)"XDebuggerSettingsManager\u2026ance()!!.dataViewSettings");
        if (dataViewSettings.isSortValues()) {
            Iterable iterable = children2;
            Comparator comparator = NodeManagerImpl.getNodeComparator();
            Intrinsics.checkExpressionValueIsNotNull((Object)comparator, (String)"NodeManagerImpl.getNodeComparator()");
            CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        }
        builder2.setChildren((List)children2);
    }
}

