/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.intellij.util.containers.OrderedSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethods;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTarget;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020 H\u0016J\u0010\u00105\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020:H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/SmartStepTargetVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "lines", "Lcom/intellij/util/Range;", "", "consumer", "Lcom/intellij/util/containers/OrderedSet;", "Lcom/intellij/debugger/actions/SmartStepTarget;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lcom/intellij/util/Range;Lcom/intellij/util/containers/OrderedSet;)V", "intrinsicMethods", "Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethods;", "append", "", "target", "getArgumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "it", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "isIntrinsic", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isInvokeInBuiltinFunction", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "recordFunction", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "recordFunctionCall", "expression", "recordGetter", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitArrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "visitForExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitSimpleNameExpression", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "jvm-debugger-core"})
public final class SmartStepTargetVisitor
extends KtTreeVisitorVoid {
    private final IntrinsicMethods intrinsicMethods;
    private final KtElement element;
    private final Range<Integer> lines;
    private final OrderedSet<SmartStepTarget> consumer;

    private final void append(SmartStepTarget target) {
        Collection collection = (Collection)this.consumer;
        boolean bl = false;
        collection.add(target);
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
        Intrinsics.checkParameterIsNotNull((Object)lambdaExpression2, (String)"lambdaExpression");
        KtFunctionLiteral ktFunctionLiteral = lambdaExpression2.getFunctionLiteral();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"lambdaExpression.functionLiteral");
        this.recordFunction(ktFunctionLiteral);
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        if (!this.recordFunction(function2)) {
            super.visitNamedFunction(function2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean recordFunction(KtFunction function2) {
        BindingContext context2 = ResolutionUtils.analyze$default((KtElement)function2, null, (int)1, null);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(CallUtilKt.getParentCall$default(function2, context2, false, 2, null), context2);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall3.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"resolvedCall.valueArguments");
        Map<ValueParameterDescriptor, ResolvedValueArgument> arguments2 = map2;
        Object object = arguments2;
        boolean bl = false;
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void param;
            boolean bl2;
            block5: {
                ResolvedValueArgument argument2;
                Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
                Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
                boolean bl3 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl3 = false;
                ResolvedValueArgument resolvedValueArgument = argument2 = entry2.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"argument");
                List<ValueArgument> list2 = resolvedValueArgument.getArguments();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"argument.arguments");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ValueArgument it = (ValueArgument)element$iv;
                        boolean bl4 = false;
                        ValueArgument valueArgument = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument, (String)"it");
                        if (!Intrinsics.areEqual((Object)this.getArgumentExpression(valueArgument), (Object)function2)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            CallableDescriptor resultingDescriptor = resolvedCall3.getResultingDescriptor();
            DeclarationDescriptor declarationDescriptor = resultingDescriptor;
            void v7 = param;
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"param");
            Name name2 = v7.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"param.name");
            String label2 = KotlinLambdaSmartStepTarget.Companion.calcLabel(declarationDescriptor, name2);
            boolean isInline = InlineUtil.isInline(resultingDescriptor);
            KotlinType kotlinType = param.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"param.type");
            boolean isSuspend = FunctionTypesKt.isSuspendFunctionType(kotlinType);
            KotlinLambdaSmartStepTarget target = new KotlinLambdaSmartStepTarget(label2, function2, this.lines, isInline, isSuspend);
            this.append(target);
            return true;
        }
        return false;
    }

    private final KtExpression getArgumentExpression(ValueArgument it) {
        KtExpression ktExpression;
        KtExpression ktExpression2 = it.getArgumentExpression();
        if (!(ktExpression2 instanceof KtLambdaExpression)) {
            ktExpression2 = null;
        }
        return (ktExpression = (KtLambdaExpression)ktExpression2) != null && (ktExpression = ktExpression.getFunctionLiteral()) != null ? (KtExpression)ktExpression : it.getArgumentExpression();
    }

    @Override
    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
    }

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            KtExpression ktExpression = expression2.getCondition();
            if (ktExpression == null) break block0;
            ktExpression.accept(this);
        }
    }

    @Override
    public void visitWhileExpression(@NotNull KtWhileExpression expression2) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            KtExpression ktExpression = expression2.getCondition();
            if (ktExpression == null) break block0;
            ktExpression.accept(this);
        }
    }

    @Override
    public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression2) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            KtExpression ktExpression = expression2.getCondition();
            if (ktExpression == null) break block0;
            ktExpression.accept(this);
        }
    }

    @Override
    public void visitForExpression(@NotNull KtForExpression expression2) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            KtExpression ktExpression = expression2.getLoopRange();
            if (ktExpression == null) break block0;
            ktExpression.accept(this);
        }
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            KtExpression ktExpression = expression2.getSubjectExpression();
            if (ktExpression == null) break block0;
            ktExpression.accept(this);
        }
    }

    @Override
    public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        this.recordFunctionCall(expression2);
        super.visitArrayAccessExpression(expression2);
    }

    @Override
    public void visitUnaryExpression(@NotNull KtUnaryExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"expression.operationReference");
        this.recordFunctionCall(ktSimpleNameExpression);
        super.visitUnaryExpression(expression2);
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
        this.recordFunctionCall(ktOperationReferenceExpression);
        super.visitBinaryExpression(expression2);
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtExpression calleeExpression2 = expression2.getCalleeExpression();
        if (calleeExpression2 != null) {
            this.recordFunctionCall(calleeExpression2);
        }
        super.visitCallExpression(expression2);
    }

    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        this.recordGetter(expression2);
        super.visitSimpleNameExpression(expression2);
    }

    private final void recordGetter(KtSimpleNameExpression expression2) {
        BindingContext bindingContext2 = ResolutionUtils.analyze$default((KtElement)expression2, null, (int)1, null);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, bindingContext2);
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        if (!(callableDescriptor instanceof PropertyDescriptor)) {
            callableDescriptor = null;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)callableDescriptor;
        if (propertyDescriptor == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
        PropertyGetterDescriptor getterDescriptor = propertyDescriptor2.getGetter();
        if (getterDescriptor == null || getterDescriptor.isDefault()) {
            return;
        }
        Project project2 = this.element.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"element.project");
        PsiElement psiElement2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, getterDescriptor);
        if (!(psiElement2 instanceof KtDeclaration)) {
            psiElement2 = null;
        }
        KtDeclaration ktDeclaration = (KtDeclaration)psiElement2;
        if (ktDeclaration == null) {
            return;
        }
        KtDeclaration ktDeclaration2 = ktDeclaration;
        ResolvedCall delegatedResolvedCall = (ResolvedCall)bindingContext2.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, getterDescriptor);
        if (delegatedResolvedCall != null) {
            Object d = delegatedResolvedCall.getResultingDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"delegatedResolvedCall.resultingDescriptor");
            FunctionDescriptor delegatedPropertyGetterDescriptor = (FunctionDescriptor)d;
            String label2 = propertyDescriptor2.getName() + '.' + KotlinMethodSmartStepTarget.Companion.calcLabel(delegatedPropertyGetterDescriptor);
            this.append(new KotlinMethodSmartStepTarget(delegatedPropertyGetterDescriptor, ktDeclaration2, label2, (PsiElement)expression2, this.lines));
        } else if (ktDeclaration2 instanceof KtPropertyAccessor && ((KtPropertyAccessor)ktDeclaration2).hasBody()) {
            String label3 = KotlinMethodSmartStepTarget.Companion.calcLabel(getterDescriptor);
            this.append(new KotlinMethodSmartStepTarget(getterDescriptor, ktDeclaration2, label3, (PsiElement)expression2, this.lines));
        }
    }

    private final void recordFunctionCall(KtExpression expression2) {
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)expression2, null, (int)1, null);
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        Object descriptor2 = resolvedCall3.getResultingDescriptor();
        if (!(descriptor2 instanceof FunctionDescriptor) || this.isIntrinsic((CallableMemberDescriptor)descriptor2)) {
            return;
        }
        Project project2 = this.element.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"element.project");
        PsiElement declaration2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, (DeclarationDescriptor)descriptor2);
        if (SpecialBuiltinMembers.isFromJava((CallableMemberDescriptor)descriptor2)) {
            if (declaration2 instanceof PsiMethod) {
                this.append((SmartStepTarget)new MethodSmartStepTarget((PsiMethod)declaration2, null, (PsiElement)expression2, false, this.lines));
            }
        } else {
            KtExpression ktExpression;
            if (declaration2 == null && !this.isInvokeInBuiltinFunction((DeclarationDescriptor)descriptor2)) {
                return;
            }
            PsiElement psiElement2 = declaration2;
            if (!(psiElement2 != null ? psiElement2 instanceof KtDeclaration : true)) {
                return;
            }
            if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary() && declaration2 instanceof KtClass && ((KtClass)declaration2).getAnonymousInitializers().isEmpty()) {
                return;
            }
            if (declaration2 instanceof KtCallableDeclaration && BreakpointTypeUtilsKt.isInlineOnly((KtCallableDeclaration)declaration2)) {
                return;
            }
            String callLabel = KotlinMethodSmartStepTarget.Companion.calcLabel((DeclarationDescriptor)descriptor2);
            Object d = descriptor2;
            String label2 = d instanceof FunctionInvokeDescriptor ? ((ktExpression = expression2) instanceof KtSimpleNameExpression ? (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>(expression2){
                final /* synthetic */ KtExpression $expression;

                public final String invoke() {
                    return ((KtSimpleNameExpression)this.$expression).getText();
                }
                {
                    this.$expression = ktExpression;
                    super(0);
                }
            }) + '.' + callLabel : callLabel) : callLabel;
            this.append(new KotlinMethodSmartStepTarget((CallableMemberDescriptor)descriptor2, (KtDeclaration)declaration2, label2, (PsiElement)expression2, this.lines));
        }
    }

    private final boolean isIntrinsic(CallableMemberDescriptor descriptor2) {
        return this.intrinsicMethods.getIntrinsic(descriptor2) != null;
    }

    private final boolean isInvokeInBuiltinFunction(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof FunctionInvokeDescriptor)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = ((FunctionInvokeDescriptor)descriptor2).getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor classDescriptor3 = classDescriptor2;
        SimpleType simpleType2 = classDescriptor3.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"classDescriptor.defaultType");
        return FunctionTypesKt.isBuiltinFunctionalType(simpleType2);
    }

    public SmartStepTargetVisitor(@NotNull KtElement element3, @NotNull Range<Integer> lines, @NotNull OrderedSet<SmartStepTarget> consumer2) {
        IntrinsicMethods intrinsicMethods;
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
            Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
            this.element = element3;
            this.lines = lines;
            this.consumer = consumer2;
            SmartStepTargetVisitor smartStepTargetVisitor = this;
            SmartStepTargetVisitor smartStepTargetVisitor2 = this;
            boolean bl = false;
            boolean bl2 = false;
            SmartStepTargetVisitor $this$run = smartStepTargetVisitor;
            boolean bl3 = false;
            Iterable $this$firstIsInstanceOrNull$iv = PlatformKt.getPlatform($this$run.element);
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof JdkPlatform)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (JdkPlatform)v0) == null || (object = ((JdkPlatform)object).getTargetVersion()) == null) {
            object = JvmTarget.DEFAULT;
        }
        Object jvmTarget = object;
        smartStepTargetVisitor2.intrinsicMethods = intrinsicMethods = new IntrinsicMethods((JvmTarget)jvmTarget);
    }
}

