/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.highlighter.AnnotationPresentationInfo$WhenMappings;
import org.jetbrains.kotlin.idea.highlighter.IdeErrorMessages;
import org.jetbrains.kotlin.idea.highlighter.KotlinSuppressableWarningProblemGroup;
import org.jetbrains.kotlin.idea.inspections.KotlinUniversalQuickFix;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ4\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00150\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J0\u0010 \u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u00032\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020$0#R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/AnnotationPresentationInfo;", "", "ranges", "", "Lcom/intellij/openapi/util/TextRange;", "nonDefaultMessage", "", "highlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "textAttributes", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "(Ljava/util/List;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;Lcom/intellij/openapi/editor/colors/TextAttributesKey;)V", "getHighlightType", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "getNonDefaultMessage", "()Ljava/lang/String;", "getRanges", "()Ljava/util/List;", "getTextAttributes", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "create", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "range", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "consumer", "Lkotlin/Function1;", "Lcom/intellij/lang/annotation/AnnotationBuilder;", "getDefaultMessage", "getMessage", "processDiagnostics", "diagnostics", "fixesMap", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "idea-core"})
public final class AnnotationPresentationInfo {
    @NotNull
    private final List<TextRange> ranges;
    @Nullable
    private final String nonDefaultMessage;
    @Nullable
    private final ProblemHighlightType highlightType;
    @Nullable
    private final TextAttributesKey textAttributes;

    public final void processDiagnostics(@NotNull AnnotationHolder holder2, @NotNull List<? extends Diagnostic> diagnostics2, @NotNull MultiMap<Diagnostic, IntentionAction> fixesMap) {
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        Intrinsics.checkParameterIsNotNull(diagnostics2, (String)"diagnostics");
        Intrinsics.checkParameterIsNotNull(fixesMap, (String)"fixesMap");
        for (TextRange range : this.ranges) {
            for (Diagnostic diagnostic : diagnostics2) {
                Collection fixes;
                Intrinsics.checkExpressionValueIsNotNull((Object)fixesMap.get((Object)diagnostic), (String)"fixesMap[diagnostic]");
                this.create(diagnostic, range, holder2, (Function1<? super AnnotationBuilder, Unit>)((Function1)new Function1<AnnotationBuilder, Unit>(fixes, diagnostic){
                    final /* synthetic */ Collection $fixes;
                    final /* synthetic */ Diagnostic $diagnostic;

                    public final void invoke(@NotNull AnnotationBuilder annotation2) {
                        Intrinsics.checkParameterIsNotNull((Object)annotation2, (String)"annotation");
                        Iterable $this$forEach$iv = this.$fixes;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            IntentionAction it = (IntentionAction)element$iv;
                            boolean bl = false;
                            IntentionAction intentionAction = it;
                            if (intentionAction instanceof KotlinUniversalQuickFix) {
                                annotation2.newFix(it).universal().registerFix();
                                continue;
                            }
                            if (!(intentionAction instanceof IntentionAction)) continue;
                            annotation2.newFix(it).registerFix();
                        }
                        if (this.$diagnostic.getSeverity() == Severity.WARNING) {
                            DiagnosticFactory<?> diagnosticFactory = this.$diagnostic.getFactory();
                            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory, (String)"diagnostic.factory");
                            annotation2.problemGroup((ProblemGroup)new KotlinSuppressableWarningProblemGroup(diagnosticFactory));
                            if (this.$fixes.isEmpty()) {
                                DiagnosticFactory<?> diagnosticFactory2 = this.$diagnostic.getFactory();
                                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory2, (String)"diagnostic.factory");
                                annotation2.newFix((IntentionAction)new EmptyIntentionAction(diagnosticFactory2.getName())).registerFix();
                            }
                        }
                    }
                    {
                        this.$fixes = collection;
                        this.$diagnostic = diagnostic;
                        super(1);
                    }
                }));
            }
        }
    }

    private final void create(Diagnostic diagnostic, TextRange range, AnnotationHolder holder2, Function1<? super AnnotationBuilder, Unit> consumer2) {
        ProblemHighlightType it;
        boolean bl;
        boolean bl2;
        ProblemHighlightType problemHighlightType2;
        HighlightSeverity highlightSeverity;
        switch (AnnotationPresentationInfo$WhenMappings.$EnumSwitchMapping$0[diagnostic.getSeverity().ordinal()]) {
            case 1: {
                highlightSeverity = HighlightSeverity.ERROR;
                break;
            }
            case 2: {
                if (this.highlightType == ProblemHighlightType.WEAK_WARNING) {
                    highlightSeverity = HighlightSeverity.WEAK_WARNING;
                    break;
                }
                highlightSeverity = HighlightSeverity.WARNING;
                break;
            }
            case 3: {
                highlightSeverity = HighlightSeverity.WEAK_WARNING;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        HighlightSeverity severity = highlightSeverity;
        String string = this.nonDefaultMessage;
        if (string == null) {
            string = this.getDefaultMessage(diagnostic);
        }
        AnnotationBuilder annotationBuilder = holder2.newAnnotation(severity, string).range(range).tooltip(this.getMessage(diagnostic));
        boolean bl3 = false;
        boolean bl4 = false;
        AnnotationBuilder builder2 = annotationBuilder;
        boolean bl5 = false;
        ProblemHighlightType problemHighlightType3 = this.highlightType;
        if (problemHighlightType3 != null) {
            problemHighlightType2 = problemHighlightType3;
            bl2 = false;
            bl = false;
            it = problemHighlightType2;
            boolean bl6 = false;
            builder2.highlightType(it);
        }
        bl3 = false;
        bl4 = false;
        builder2 = annotationBuilder;
        boolean bl7 = false;
        TextAttributesKey textAttributesKey = this.textAttributes;
        if (textAttributesKey != null) {
            problemHighlightType2 = textAttributesKey;
            bl2 = false;
            bl = false;
            it = problemHighlightType2;
            boolean bl8 = false;
            builder2.textAttributes((TextAttributesKey)it);
        }
        bl3 = false;
        bl4 = false;
        AnnotationBuilder it2 = annotationBuilder;
        boolean bl9 = false;
        AnnotationBuilder annotationBuilder2 = it2;
        Intrinsics.checkExpressionValueIsNotNull((Object)annotationBuilder2, (String)"it");
        consumer2.invoke((Object)annotationBuilder2);
        annotationBuilder.create();
    }

    private final String getMessage(Diagnostic diagnostic) {
        String message2;
        block8: {
            String string;
            block7: {
                String string2 = IdeErrorMessages.render(diagnostic);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"IdeErrorMessages.render(diagnostic)");
                message2 = string2;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isInternal()) break block7;
                Application application2 = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
                if (!application2.isUnitTestMode()) break block8;
            }
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory, (String)"diagnostic.factory");
            String string3 = diagnosticFactory.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"diagnostic.factory.name");
            String factoryName = string3;
            if (StringsKt.startsWith$default((String)message2, (String)"<html>", (boolean)false, (int)2, null)) {
                String string4 = message2;
                int n = "<html>".length();
                StringBuilder stringBuilder2 = new StringBuilder().append("<html>[").append(factoryName).append("] ");
                boolean bl = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                String string7 = string6;
                string = stringBuilder2.append(string7).toString();
            } else {
                string = message2 = '[' + factoryName + "] " + message2;
            }
        }
        if (!StringsKt.startsWith$default((String)message2, (String)"<html>", (boolean)false, (int)2, null)) {
            message2 = "<html><body>" + XmlStringUtil.escapeString((String)message2) + "</body></html>";
        }
        return message2;
    }

    private final String getDefaultMessage(Diagnostic diagnostic) {
        String message2;
        block3: {
            block2: {
                String string = DefaultErrorMessages.render(diagnostic);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DefaultErrorMessages.render(diagnostic)");
                message2 = string;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isInternal()) break block2;
                Application application2 = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
                if (!application2.isUnitTestMode()) break block3;
            }
            StringBuilder stringBuilder2 = new StringBuilder().append('[');
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory, (String)"diagnostic.factory");
            return stringBuilder2.append(diagnosticFactory.getName()).append("] ").append(message2).toString();
        }
        return message2;
    }

    @NotNull
    public final List<TextRange> getRanges() {
        return this.ranges;
    }

    @Nullable
    public final String getNonDefaultMessage() {
        return this.nonDefaultMessage;
    }

    @Nullable
    public final ProblemHighlightType getHighlightType() {
        return this.highlightType;
    }

    @Nullable
    public final TextAttributesKey getTextAttributes() {
        return this.textAttributes;
    }

    public AnnotationPresentationInfo(@NotNull List<? extends TextRange> ranges2, @Nullable String nonDefaultMessage, @Nullable ProblemHighlightType highlightType, @Nullable TextAttributesKey textAttributes) {
        Intrinsics.checkParameterIsNotNull(ranges2, (String)"ranges");
        this.ranges = ranges2;
        this.nonDefaultMessage = nonDefaultMessage;
        this.highlightType = highlightType;
        this.textAttributes = textAttributes;
    }

    public /* synthetic */ AnnotationPresentationInfo(List list2, String string, ProblemHighlightType problemHighlightType2, TextAttributesKey textAttributesKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            problemHighlightType2 = null;
        }
        if ((n & 8) != 0) {
            textAttributesKey = null;
        }
        this(list2, string, problemHighlightType2, textAttributesKey);
    }
}

