/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ScriptDiagnostic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.core.script.IdeScriptReportSink;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.highlighter.OutsidersPsiFileSupportUtils;
import org.jetbrains.kotlin.idea.highlighter.OutsidersPsiFileSupportWrapper;
import org.jetbrains.kotlin.idea.util.CidrUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightingUtil;", "", "()V", "hasCustomPropertyDeclaration", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "hasExtensionReceiverParameter", "shouldHighlight", "psiElement", "Lcom/intellij/psi/PsiElement;", "shouldHighlightErrors", "shouldHighlightScript", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea-core"})
public final class KotlinHighlightingUtil {
    public static final KotlinHighlightingUtil INSTANCE;

    public final boolean shouldHighlight(@NotNull PsiElement psiElement2) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
        PsiFile psiFile2 = psiElement2.getContainingFile();
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile == null) {
            return false;
        }
        KtFile ktFile2 = ktFile;
        if (ktFile2 instanceof KtCodeFragment && ((KtCodeFragment)ktFile2).getContext() != null) {
            return true;
        }
        VirtualFile virtualFile2 = ktFile2.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"ktFile.virtualFile");
        if (OutsidersPsiFileSupportWrapper.INSTANCE.isOutsiderFile(virtualFile2)) {
            Project project2 = ktFile2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"ktFile.project");
            VirtualFile virtualFile3 = ktFile2.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"ktFile.virtualFile");
            VirtualFile virtualFile4 = OutsidersPsiFileSupportUtils.INSTANCE.getOutsiderFileOrigin(project2, virtualFile3);
            if (virtualFile4 == null) {
                return false;
            }
            VirtualFile origin = virtualFile4;
            PsiFile psiFile3 = PsiManager.getInstance((Project)ktFile2.getProject()).findFile(origin);
            if (psiFile3 == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile3, (String)"PsiManager.getInstance(k\u2026e(origin) ?: return false");
            PsiFile psiFileOrigin = psiFile3;
            return this.shouldHighlight((PsiElement)psiFileOrigin);
        }
        if (ktFile2.isScript()) {
            return this.shouldHighlightScript(ktFile2);
        }
        return ProjectRootsUtil.isInProjectOrLibraryContent((PsiElement)ktFile2) && !(GetModuleInfoKt.getModuleInfo((PsiElement)ktFile2) instanceof NotUnderContentRootModuleInfo);
    }

    public final boolean shouldHighlightErrors(@NotNull PsiElement psiElement2) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
        PsiFile psiFile2 = psiElement2.getContainingFile();
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile == null) {
            return false;
        }
        KtFile ktFile2 = ktFile;
        if (ktFile2.isCompiled()) {
            return false;
        }
        if (ktFile2 instanceof KtCodeFragment && ((KtCodeFragment)ktFile2).getContext() != null) {
            return true;
        }
        if (ktFile2.isScript()) {
            return this.shouldHighlightScript(ktFile2);
        }
        return ProjectRootsUtil.isInProjectSource$default((PsiElement)ktFile2, false, 2, null);
    }

    private final boolean shouldHighlightScript(KtFile ktFile) {
        boolean bl;
        block7: {
            if (CidrUtil.isRunningInCidrIde()) {
                return false;
            }
            Project project2 = ktFile.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"ktFile.project");
            if (!ScriptConfigurationManager.Companion.getInstance(project2).hasConfiguration(ktFile)) {
                return false;
            }
            Iterable $this$any$iv = IdeScriptReportSink.Companion.getReports(ktFile);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ScriptDiagnostic it = (ScriptDiagnostic)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSeverity() == ScriptDiagnostic.Severity.FATAL)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Project project3 = ktFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"ktFile.project");
        if (!ScriptDefinitionsManager.Companion.getInstance(project3).isReady()) {
            return false;
        }
        return ProjectRootsUtil.isInProjectSource((PsiElement)ktFile, true);
    }

    public final boolean hasCustomPropertyDeclaration(@NotNull PropertyDescriptor descriptor2) {
        boolean hasCustomPropertyDeclaration;
        block1: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                hasCustomPropertyDeclaration = false;
                if (this.hasExtensionReceiverParameter(descriptor2)) break block1;
                PropertyGetterDescriptor propertyGetterDescriptor = descriptor2.getGetter();
                if (propertyGetterDescriptor != null && !propertyGetterDescriptor.isDefault()) break block2;
                PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
                if (propertySetterDescriptor == null) break block1;
                if (propertySetterDescriptor.isDefault()) break block1;
            }
            hasCustomPropertyDeclaration = true;
        }
        return hasCustomPropertyDeclaration;
    }

    public final boolean hasExtensionReceiverParameter(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return descriptor2.getExtensionReceiverParameter() != null;
    }

    private KotlinHighlightingUtil() {
    }

    static {
        KotlinHighlightingUtil kotlinHighlightingUtil;
        INSTANCE = kotlinHighlightingUtil = new KotlinHighlightingUtil();
    }
}

