/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.impl.HighlightRangeExtension;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.fir.FirResolution;
import org.jetbrains.kotlin.idea.fir.FirResolutionApiKt;
import org.jetbrains.kotlin.idea.fir.FirResolveState;
import org.jetbrains.kotlin.idea.fir.FirResolveStateKt;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.ElementAnnotator;
import org.jetbrains.kotlin.idea.highlighter.FunctionsHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingUtil;
import org.jetbrains.kotlin.idea.highlighter.KotlinPsiCheckerKt;
import org.jetbrains.kotlin.idea.highlighter.PropertiesHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.TypeKindHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.VariablesHighlightingVisitor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinPsiChecker;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/codeInsight/daemon/impl/HighlightRangeExtension;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotateElement", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "containingFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "annotateElementUsingFrontendIR", "isForceHighlightParents", "", "file", "Lcom/intellij/psi/PsiFile;", "shouldSuppressUnusedParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "Companion", "idea-core"})
public class KotlinPsiChecker
implements Annotator,
HighlightRangeExtension {
    private static final Key<Unit> UNRESOLVED_KEY;
    public static final Companion Companion;

    public void annotate(@NotNull PsiElement element3, @NotNull AnnotationHolder holder2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        PsiFile psiFile2 = element3.getContainingFile();
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile == null) {
            return;
        }
        KtFile file2 = ktFile;
        if (!KotlinHighlightingUtil.INSTANCE.shouldHighlight((PsiElement)file2)) {
            return;
        }
        if (FirResolution.INSTANCE.getEnabled()) {
            this.annotateElementUsingFrontendIR(element3, file2, holder2);
        } else {
            this.annotateElement(element3, file2, holder2);
        }
    }

    private final void annotateElement(PsiElement element3, KtFile containingFile, AnnotationHolder holder2) {
        AnalysisResult analysisResult = ResolutionUtils.analyzeWithAllCompilerChecks((KtFile)containingFile, (KtFile[])new KtFile[0]);
        if (analysisResult.isError()) {
            throw (Throwable)new ProcessCanceledException(analysisResult.getError());
        }
        BindingContext bindingContext2 = analysisResult.getBindingContext();
        AfterAnalysisHighlightingVisitor[] $this$forEach$iv = Companion.getAfterAnalysisVisitor(holder2, bindingContext2);
        boolean $i$f$forEach = false;
        AfterAnalysisHighlightingVisitor[] afterAnalysisHighlightingVisitorArray = $this$forEach$iv;
        int n = afterAnalysisHighlightingVisitorArray.length;
        for (int j = 0; j < n; ++j) {
            AfterAnalysisHighlightingVisitor element$iv;
            AfterAnalysisHighlightingVisitor visitor2 = element$iv = afterAnalysisHighlightingVisitorArray[j];
            boolean bl = false;
            element3.accept((PsiElementVisitor)visitor2);
        }
        Diagnostics diagnostics2 = bindingContext2.getDiagnostics();
        Intrinsics.checkExpressionValueIsNotNull((Object)diagnostics2, (String)"bindingContext.diagnostics");
        this.annotateElement(element3, holder2, diagnostics2);
    }

    private final void annotateElementUsingFrontendIR(PsiElement element3, KtFile containingFile, AnnotationHolder holder2) {
        if (!(element3 instanceof KtElement)) {
            return;
        }
        FirResolveState state = FirResolveStateKt.firResolveState(containingFile);
        FirResolutionApiKt.getOrBuildFirWithDiagnostics(containingFile, state);
        List<Diagnostic> diagnostics2 = state.getDiagnostics((KtElement)element3);
        if (diagnostics2.isEmpty()) {
            return;
        }
        if (KotlinHighlightingUtil.INSTANCE.shouldHighlightErrors(element3)) {
            new ElementAnnotator(element3, holder2, (Function1<? super KtParameter, Boolean>)((Function1)new Function1<KtParameter, Boolean>(this){
                final /* synthetic */ KotlinPsiChecker this$0;

                public final boolean invoke(@NotNull KtParameter param) {
                    Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
                    return this.this$0.shouldSuppressUnusedParameter(param);
                }
                {
                    this.this$0 = kotlinPsiChecker;
                    super(1);
                }
            })).registerDiagnosticsAnnotations((Collection<? extends Diagnostic>)diagnostics2);
        }
    }

    public boolean isForceHighlightParents(@NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return file2 instanceof KtFile;
    }

    protected boolean shouldSuppressUnusedParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        return false;
    }

    public final void annotateElement(@NotNull PsiElement element3, @NotNull AnnotationHolder holder2, @NotNull Diagnostics diagnostics2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)diagnostics2, (String)"diagnostics");
        Collection<Diagnostic> diagnosticsForElement = diagnostics2.forElement(element3);
        if (element3 instanceof KtNameReferenceExpression) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = diagnostics2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Diagnostic it = (Diagnostic)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getFactory(), Errors.UNRESOLVED_REFERENCE)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            boolean unresolved = bl;
            element3.putUserData(UNRESOLVED_KEY, unresolved ? Unit.INSTANCE : null);
        }
        if (diagnosticsForElement.isEmpty()) {
            return;
        }
        if (KotlinHighlightingUtil.INSTANCE.shouldHighlightErrors(element3)) {
            new ElementAnnotator(element3, holder2, (Function1<? super KtParameter, Boolean>)((Function1)new Function1<KtParameter, Boolean>(this){
                final /* synthetic */ KotlinPsiChecker this$0;

                public final boolean invoke(@NotNull KtParameter param) {
                    Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
                    return this.this$0.shouldSuppressUnusedParameter(param);
                }
                {
                    this.this$0 = kotlinPsiChecker;
                    super(1);
                }
            })).registerDiagnosticsAnnotations(diagnosticsForElement);
        }
    }

    static {
        Companion = new Companion(null);
        UNRESOLVED_KEY = new Key("KotlinPsiChecker.UNRESOLVED_KEY");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinPsiChecker$Companion;", "", "()V", "UNRESOLVED_KEY", "Lcom/intellij/openapi/util/Key;", "", "createQuickFixes", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getAfterAnalysisVisitor", "", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)[Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "wasUnresolved", "", "element", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "idea-core"})
    public static final class Companion {
        @NotNull
        public final AfterAnalysisHighlightingVisitor[] getAfterAnalysisVisitor(@NotNull AnnotationHolder holder2, @NotNull BindingContext bindingContext2) {
            Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            return new AfterAnalysisHighlightingVisitor[]{new PropertiesHighlightingVisitor(holder2, bindingContext2), new FunctionsHighlightingVisitor(holder2, bindingContext2), new VariablesHighlightingVisitor(holder2, bindingContext2), new TypeKindHighlightingVisitor(holder2, bindingContext2)};
        }

        @NotNull
        public final Collection<IntentionAction> createQuickFixes(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Collection collection = KotlinPsiCheckerKt.access$createQuickFixes(CollectionsKt.listOfNotNull((Object)diagnostic)).get((Object)diagnostic);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"createQuickFixes(listOfN\u2026(diagnostic))[diagnostic]");
            return collection;
        }

        public final boolean wasUnresolved(@NotNull KtNameReferenceExpression element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            return element3.getUserData(UNRESOLVED_KEY) != null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

