/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.HighlighterExtension;
import org.jetbrains.kotlin.idea.highlighter.HighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingUtil;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/PropertiesHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "attributeKeyByPropertyType", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "highlightPropertyDeclaration", "", "elementToHighlight", "Lcom/intellij/psi/PsiElement;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitSimpleNameExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "idea-core"})
public final class PropertiesHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        TextAttributesKey attributesKey;
        block10: {
            TextAttributesKey textAttributesKey;
            DeclarationDescriptor target;
            block9: {
                TextAttributesKey textAttributesKey2;
                block8: {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    if (expression2.getParent() instanceof KtThisExpression) {
                        return;
                    }
                    target = (DeclarationDescriptor)this.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression2);
                    if (target instanceof SyntheticFieldDescriptor) {
                        PsiElement psiElement2 = (PsiElement)expression2;
                        TextAttributesKey textAttributesKey3 = KotlinHighlightingColors.BACKING_FIELD_VARIABLE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey3, (String)"BACKING_FIELD_VARIABLE");
                        HighlightingVisitor.highlightName$default((HighlightingVisitor)this, psiElement2, textAttributesKey3, null, 4, null);
                        return;
                    }
                    if (!(target instanceof PropertyDescriptor)) {
                        return;
                    }
                    TextAttributesKey resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.getBindingContext());
                    textAttributesKey = resolvedCall2;
                    if (textAttributesKey == null) break block9;
                    TextAttributesKey textAttributesKey4 = textAttributesKey;
                    boolean bl = false;
                    boolean bl2 = false;
                    TextAttributesKey call2 = textAttributesKey4;
                    boolean bl3 = false;
                    Object[] objectArray = Extensions.getExtensions(HighlighterExtension.Companion.getEP_NAME());
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"Extensions.getExtensions\u2026lighterExtension.EP_NAME)");
                    Object[] $this$firstNotNullResult$iv = objectArray;
                    boolean $i$f$firstNotNullResult = false;
                    for (Object element$iv : $this$firstNotNullResult$iv) {
                        HighlighterExtension extension2 = (HighlighterExtension)element$iv;
                        boolean bl4 = false;
                        TextAttributesKey result$iv = extension2.highlightCall((PsiElement)expression2, (ResolvedCall<?>)call2);
                        if (result$iv == null) continue;
                        textAttributesKey2 = result$iv;
                        break block8;
                    }
                    textAttributesKey2 = null;
                }
                textAttributesKey = textAttributesKey2;
                if (textAttributesKey2 != null) break block10;
            }
            textAttributesKey = attributesKey = this.attributeKeyByPropertyType((PropertyDescriptor)target);
        }
        if (attributesKey != null) {
            HighlightingVisitor.highlightName$default((HighlightingVisitor)this, (PsiElement)expression2, attributesKey, null, 4, null);
        }
    }

    @Override
    public void visitProperty(@NotNull KtProperty property2) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        PsiElement psiElement2 = property2.getNameIdentifier();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"property.nameIdentifier ?: return");
        PsiElement nameIdentifier = psiElement2;
        VariableDescriptor propertyDescriptor = (VariableDescriptor)this.getBindingContext().get(BindingContext.VARIABLE, property2);
        if (propertyDescriptor instanceof PropertyDescriptor) {
            this.highlightPropertyDeclaration(nameIdentifier, (PropertyDescriptor)propertyDescriptor);
        }
        super.visitProperty(property2);
    }

    @Override
    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        PsiElement psiElement2 = parameter.getNameIdentifier();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parameter.nameIdentifier ?: return");
        PsiElement nameIdentifier = psiElement2;
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
        if (propertyDescriptor != null) {
            if (propertyDescriptor.isVar()) {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.MUTABLE_VARIABLE;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"MUTABLE_VARIABLE");
                HighlightingVisitor.highlightName$default((HighlightingVisitor)this, nameIdentifier, textAttributesKey, null, 4, null);
            }
            this.highlightPropertyDeclaration(nameIdentifier, propertyDescriptor);
        }
        super.visitParameter(parameter);
    }

    private final void highlightPropertyDeclaration(PsiElement elementToHighlight, PropertyDescriptor descriptor2) {
        TextAttributesKey textAttributesKey;
        TextAttributesKey textAttributesKey2 = this.attributeKeyForDeclarationFromExtensions(elementToHighlight, descriptor2);
        if (textAttributesKey2 == null) {
            textAttributesKey2 = textAttributesKey = this.attributeKeyByPropertyType(descriptor2);
        }
        if (textAttributesKey != null) {
            HighlightingVisitor.highlightName$default((HighlightingVisitor)this, elementToHighlight, textAttributesKey, null, 4, null);
        }
    }

    private final TextAttributesKey attributeKeyByPropertyType(PropertyDescriptor descriptor2) {
        return DynamicCallsKt.isDynamic(descriptor2) ? null : (KotlinHighlightingUtil.INSTANCE.hasExtensionReceiverParameter(descriptor2) ? (TowerUtilsKt.isSynthesized(descriptor2) ? KotlinHighlightingColors.SYNTHETIC_EXTENSION_PROPERTY : KotlinHighlightingColors.EXTENSION_PROPERTY) : (DescriptorUtils.isStaticDeclaration(descriptor2) ? (KotlinHighlightingUtil.INSTANCE.hasCustomPropertyDeclaration(descriptor2) ? KotlinHighlightingColors.PACKAGE_PROPERTY_CUSTOM_PROPERTY_DECLARATION : KotlinHighlightingColors.PACKAGE_PROPERTY) : (KotlinHighlightingUtil.INSTANCE.hasCustomPropertyDeclaration(descriptor2) ? KotlinHighlightingColors.INSTANCE_PROPERTY_CUSTOM_PROPERTY_DECLARATION : KotlinHighlightingColors.INSTANCE_PROPERTY)));
    }

    public PropertiesHighlightingVisitor(@NotNull AnnotationHolder holder2, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        super(holder2, bindingContext2);
    }
}

