/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.imports;

import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.imports.KotlinImportOptimizer;
import org.jetbrains.kotlin.idea.imports.OptimizedImportsBuilder;
import org.jetbrains.kotlin.idea.references.KtInvokeFunctionReference;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0003\u000e\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\fH\u0016R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer;", "Lcom/intellij/lang/ImportOptimizer;", "()V", "isDocumentUncommitted", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)Z", "prepareImports", "Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$OptimizeInformation;", "file", "processFile", "Lcom/intellij/lang/ImportOptimizer$CollectingInfoRunnable;", "Lcom/intellij/psi/PsiFile;", "supports", "CollectUsedDescriptorsVisitor", "Companion", "OptimizeInformation", "idea"})
public final class KotlinImportOptimizer
implements ImportOptimizer {
    private static final Companion.DO_NOTHING.1 DO_NOTHING;
    public static final Companion Companion;

    public boolean supports(@NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return file2 instanceof KtFile;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ImportOptimizer.CollectingInfoRunnable processFile(@NotNull PsiFile file2) {
        void add2;
        void remove2;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        PsiFile psiFile2 = file2;
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile == null) {
            return DO_NOTHING;
        }
        KtFile ktFile2 = ktFile;
        OptimizeInformation optimizeInformation = this.prepareImports(ktFile2);
        if (optimizeInformation == null) {
            return DO_NOTHING;
        }
        OptimizeInformation optimizeInformation2 = optimizeInformation;
        int n = optimizeInformation2.component1();
        int n2 = optimizeInformation2.component2();
        List<ImportPath> imports2 = optimizeInformation2.component3();
        return new ImportOptimizer.CollectingInfoRunnable((int)remove2, (int)add2, ktFile2, imports2){
            final /* synthetic */ int $remove;
            final /* synthetic */ int $add;
            final /* synthetic */ KtFile $ktFile;
            final /* synthetic */ List $imports;

            @NotNull
            public String getUserNotificationInfo() {
                return this.$remove == 0 ? KotlinBundle.message("import.optimizer.text.zero", new Object[0]) : KotlinBundle.message("import.optimizer.text.non.zero", this.$remove, KotlinBundle.message("import.optimizer.text.import", this.$remove), this.$add, KotlinBundle.message("import.optimizer.text.import", this.$add));
            }

            public void run() {
                KotlinImportOptimizer.Companion.replaceImports(this.$ktFile, this.$imports);
            }
            {
                this.$remove = $captured_local_variable$0;
                this.$add = $captured_local_variable$1;
                this.$ktFile = $captured_local_variable$2;
                this.$imports = $captured_local_variable$3;
            }
        };
    }

    private final boolean isDocumentUncommitted(@NotNull KtFile $this$isDocumentUncommitted) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)$this$isDocumentUncommitted.getProject());
        Document cachedDocument = documentManager.getCachedDocument((PsiFile)$this$isDocumentUncommitted);
        return cachedDocument != null && documentManager.isUncommited(cachedDocument);
    }

    /*
     * WARNING - void declaration
     */
    private final OptimizeInformation prepareImports(KtFile file2) {
        Collection<ImportPath> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.isDocumentUncommitted(file2)) {
            return null;
        }
        IdeaModuleInfo moduleInfo2 = GetModuleInfoKt.getNullableModuleInfo((PsiElement)file2);
        if (!(moduleInfo2 instanceof ModuleSourceInfo) && !(moduleInfo2 instanceof ScriptModuleInfo)) {
            return null;
        }
        List<KtImportDirective> oldImports = file2.getImportDirectives();
        if (oldImports.isEmpty()) {
            return null;
        }
        OptimizedImportsBuilder.InputData descriptorsToImport = Companion.collectDescriptorsToImport(file2, true);
        List<ImportPath> list2 = Companion.prepareOptimizedImports(file2, descriptorsToImport);
        if (list2 == null) {
            return null;
        }
        List<ImportPath> imports2 = list2;
        Iterable iterable = oldImports;
        Iterable iterable2 = imports2;
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtImportDirective ktImportDirective = (KtImportDirective)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ImportPath importPath = it.getImportPath();
            collection.add(importPath);
        }
        collection = (List)destination$iv$iv;
        Set intersect = CollectionsKt.intersect((Iterable)iterable2, (Iterable)collection);
        return new OptimizeInformation(imports2.size() - intersect.size(), oldImports.size() - intersect.size(), imports2);
    }

    static {
        Companion = new Companion(null);
        DO_NOTHING = new ImportOptimizer.CollectingInfoRunnable(){

            public void run() {
            }

            @NotNull
            public String getUserNotificationInfo() {
                return KotlinBundle.message("import.optimizer.notification.text.unused.imports.not.found", new Object[0]);
            }
        };
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$OptimizeInformation;", "", "add", "", "remove", "imports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "(IILjava/util/List;)V", "getAdd", "()I", "getImports", "()Ljava/util/List;", "getRemove", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "idea"})
    private static final class OptimizeInformation {
        private final int add;
        private final int remove;
        @NotNull
        private final List<ImportPath> imports;

        public final int getAdd() {
            return this.add;
        }

        public final int getRemove() {
            return this.remove;
        }

        @NotNull
        public final List<ImportPath> getImports() {
            return this.imports;
        }

        public OptimizeInformation(int add2, int remove2, @NotNull List<ImportPath> imports2) {
            Intrinsics.checkParameterIsNotNull(imports2, (String)"imports");
            this.add = add2;
            this.remove = remove2;
            this.imports = imports2;
        }

        public final int component1() {
            return this.add;
        }

        public final int component2() {
            return this.remove;
        }

        @NotNull
        public final List<ImportPath> component3() {
            return this.imports;
        }

        @NotNull
        public final OptimizeInformation copy(int add2, int remove2, @NotNull List<ImportPath> imports2) {
            Intrinsics.checkParameterIsNotNull(imports2, (String)"imports");
            return new OptimizeInformation(add2, remove2, imports2);
        }

        public static /* synthetic */ OptimizeInformation copy$default(OptimizeInformation optimizeInformation, int n, int n2, List list2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = optimizeInformation.add;
            }
            if ((n3 & 2) != 0) {
                n2 = optimizeInformation.remove;
            }
            if ((n3 & 4) != 0) {
                list2 = optimizeInformation.imports;
            }
            return optimizeInformation.copy(n, n2, list2);
        }

        @NotNull
        public String toString() {
            return "OptimizeInformation(add=" + this.add + ", remove=" + this.remove + ", imports=" + this.imports + ")";
        }

        public int hashCode() {
            List<ImportPath> list2 = this.imports;
            return (Integer.hashCode(this.add) * 31 + Integer.hashCode(this.remove)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof OptimizeInformation)) break block3;
                    OptimizeInformation optimizeInformation = (OptimizeInformation)object;
                    if (this.add != optimizeInformation.add || this.remove != optimizeInformation.remove || !Intrinsics.areEqual(this.imports, optimizeInformation.imports)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00015B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020+2\u0006\u0010,\u001a\u00020'H\u0016J\u0010\u00102\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\u001c\u001a>\u0012\u0004\u0012\u00020\r\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000f0\u001ej\b\u0012\u0004\u0012\u00020\u000f`\u001f0\u001dj\u001e\u0012\u0004\u0012\u00020\r\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000f0\u001ej\b\u0012\u0004\u0012\u00020\u000f`\u001f` X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$CollectUsedDescriptorsVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "abstractRefs", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$AbstractReference;", "Lkotlin/collections/ArrayList;", "aliases", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/name/Name;", "currentPackageName", "data", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "getData", "()Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "descriptorsToImport", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lkotlin/collections/LinkedHashSet;", "elementProgress", "", "elementsSize", "namesToImport", "Ljava/util/LinkedHashMap;", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "Lkotlin/collections/LinkedHashMap;", "getProgressIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "isAccessibleAsMember", "", "target", "place", "Lorg/jetbrains/kotlin/psi/KtElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "visitImportList", "importList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "visitKtElement", "visitPackageDirective", "directive", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "AbstractReferenceImpl", "idea"})
    private static final class CollectUsedDescriptorsVisitor
    extends KtVisitorVoid {
        private final int elementsSize;
        private int elementProgress;
        private final FqName currentPackageName;
        private final Map<FqName, List<Name>> aliases;
        private final LinkedHashSet<DeclarationDescriptor> descriptorsToImport;
        private final LinkedHashMap<FqName, HashSet<Name>> namesToImport;
        private final ArrayList<OptimizedImportsBuilder.AbstractReference> abstractRefs;
        @Nullable
        private final ProgressIndicator progressIndicator;

        @NotNull
        public final OptimizedImportsBuilder.InputData getData() {
            return new OptimizedImportsBuilder.InputData((Set)this.descriptorsToImport, (Map)this.namesToImport, (Collection)this.abstractRefs);
        }

        public void visitElement(@NotNull PsiElement element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            ProgressIndicatorProvider.checkCanceled();
            ++this.elementProgress;
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator != null) {
                progressIndicator.setFraction((double)this.elementProgress / (double)this.elementsSize);
            }
            element3.acceptChildren((PsiElementVisitor)this);
        }

        @Override
        public void visitImportList(@NotNull KtImportList importList) {
            Intrinsics.checkParameterIsNotNull((Object)importList, (String)"importList");
        }

        @Override
        public void visitPackageDirective(@NotNull KtPackageDirective directive) {
            Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
        }

        @Override
        public void visitKtElement(@NotNull KtElement element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            for (PsiReference reference2 : element3.getReferences()) {
                if (!(reference2 instanceof KtReference)) continue;
                this.abstractRefs.add(new AbstractReferenceImpl((KtReference)reference2));
                Collection<Name> names2 = ((KtReference)reference2).getResolvesByNames();
                BindingContext bindingContext2 = ResolutionUtils.analyze$default((KtElement)element3, null, (int)1, null);
                Collection targets = Companion.targets((KtReference)reference2, bindingContext2);
                for (DeclarationDescriptor target : targets) {
                    Object object;
                    FqName parentFqName;
                    FqName importableFqName;
                    DeclarationDescriptor importableDescriptor = DescriptorUtilsKt.getImportableDescriptor(target);
                    if (ImportsUtils.getImportableFqName((DeclarationDescriptor)target) == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)importableFqName.parent(), (String)"importableFqName.parent()");
                    if (target instanceof PackageViewDescriptor && Intrinsics.areEqual((Object)parentFqName, (Object)FqName.ROOT)) continue;
                    if (!(target instanceof PackageViewDescriptor) && Intrinsics.areEqual((Object)parentFqName, (Object)this.currentPackageName)) {
                        Map<FqName, List<Name>> map2 = this.aliases;
                        boolean bl = false;
                        Map<FqName, List<Name>> map3 = map2;
                        boolean bl2 = false;
                        if (!map3.containsKey(importableFqName)) continue;
                    }
                    if (!ReferenceUtilKt.canBeResolvedViaImport((KtReference)reference2, target, bindingContext2) || this.isAccessibleAsMember(importableDescriptor, element3, bindingContext2)) continue;
                    Collection<DeclarationDescriptor> collection = this.aliases.get(importableFqName);
                    boolean bl = false;
                    Collection collection2 = collection;
                    if (collection2 == null) {
                        collection2 = CollectionsKt.emptyList();
                    }
                    Set descriptorNames = CollectionsKt.intersect((Iterable)CollectionsKt.plus((Collection)collection2, (Object)importableFqName.shortName()), (Iterable)names2);
                    Map $this$getOrPut$iv = this.namesToImport;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(importableFqName);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        LinkedHashSet answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv.put(importableFqName, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    collection = (HashSet)object;
                    bl = false;
                    CollectionsKt.addAll((Collection)collection, (Iterable)descriptorNames);
                    collection = this.descriptorsToImport;
                    bl = false;
                    collection.add(importableDescriptor);
                }
            }
            super.visitKtElement(element3);
        }

        private final boolean isAccessibleAsMember(DeclarationDescriptor target, KtElement place, BindingContext bindingContext2) {
            boolean bl;
            block7: {
                if (!(target.getContainingDeclaration() instanceof ClassDescriptor)) {
                    return false;
                }
                Function1<HierarchicalScope, Boolean> $fun$isInScope$1 = new Function1<HierarchicalScope, Boolean>(target, bindingContext2, place){
                    final /* synthetic */ DeclarationDescriptor $target;
                    final /* synthetic */ BindingContext $bindingContext;
                    final /* synthetic */ KtElement $place;

                    public final boolean invoke(@NotNull HierarchicalScope scope2) {
                        boolean bl;
                        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
                        DeclarationDescriptor declarationDescriptor = this.$target;
                        if (declarationDescriptor instanceof FunctionDescriptor) {
                            Name name2 = ((FunctionDescriptor)this.$target).getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"target.name");
                            bl = ScopeUtilsKt.findFunction(scope2, name2, NoLookupLocation.FROM_IDE, (Function1<? super FunctionDescriptor, Boolean>)((Function1)new Function1<FunctionDescriptor, Boolean>(this){
                                final /* synthetic */ isAccessibleAsMember.1 this$0;

                                public final boolean invoke(@NotNull FunctionDescriptor it) {
                                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                    return Intrinsics.areEqual((Object)it, (Object)this.this$0.$target);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            })) != null && Intrinsics.areEqual((Object)((Boolean)this.$bindingContext.get(BindingContext.DEPRECATED_SHORT_NAME_ACCESS, this.$place)), (Object)true) ^ true;
                        } else if (declarationDescriptor instanceof PropertyDescriptor) {
                            Name name3 = ((PropertyDescriptor)this.$target).getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"target.name");
                            bl = ScopeUtilsKt.findVariable(scope2, name3, NoLookupLocation.FROM_IDE, (Function1<? super VariableDescriptor, Boolean>)((Function1)new Function1<VariableDescriptor, Boolean>(this){
                                final /* synthetic */ isAccessibleAsMember.1 this$0;

                                public final boolean invoke(@NotNull VariableDescriptor it) {
                                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                    return Intrinsics.areEqual((Object)it, (Object)this.this$0.$target);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            })) != null && Intrinsics.areEqual((Object)((Boolean)this.$bindingContext.get(BindingContext.DEPRECATED_SHORT_NAME_ACCESS, this.$place)), (Object)true) ^ true;
                        } else if (declarationDescriptor instanceof ClassDescriptor) {
                            Name name4 = ((ClassDescriptor)this.$target).getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)name4, (String)"target.name");
                            bl = Intrinsics.areEqual((Object)ScopeUtilsKt.findClassifier(scope2, name4, NoLookupLocation.FROM_IDE), (Object)this.$target) && Intrinsics.areEqual((Object)((Boolean)this.$bindingContext.get(BindingContext.DEPRECATED_SHORT_NAME_ACCESS, this.$place)), (Object)true) ^ true;
                        } else {
                            bl = false;
                        }
                        return bl;
                    }
                    {
                        this.$target = declarationDescriptor;
                        this.$bindingContext = bindingContext2;
                        this.$place = ktElement;
                        super(1);
                    }
                };
                LexicalScope resolutionScope = ScopeUtils.getResolutionScope((PsiElement)((PsiElement)place), (BindingContext)bindingContext2, (ResolutionFacade)ResolutionUtils.getResolutionFacade((KtElement)place));
                LexicalScope noImportsScope = ScopeUtilsKt.replaceImportingScopes(resolutionScope, null);
                if ($fun$isInScope$1.invoke((HierarchicalScope)noImportsScope)) {
                    return true;
                }
                if (target instanceof ClassDescriptor) {
                    bl = false;
                } else {
                    Iterable $this$any$iv = ScopeUtilsKt.getImplicitReceiversHierarchy(resolutionScope);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)element$iv;
                            boolean bl2 = false;
                            if (!$fun$isInScope$1.invoke((HierarchicalScope)ScopeUtilsKt.memberScopeAsImportingScope$default(it.getType().getMemberScope(), null, 1, null))) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
            }
            return bl;
        }

        @Nullable
        public final ProgressIndicator getProgressIndicator() {
            return this.progressIndicator;
        }

        /*
         * WARNING - void declaration
         */
        public CollectUsedDescriptorsVisitor(@NotNull KtFile file2, @Nullable ProgressIndicator progressIndicator) {
            Object object;
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            int n;
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            this.progressIndicator = progressIndicator;
            if (this.progressIndicator != null) {
                int size = 0;
                file2.accept(new KtVisitorVoid(size){
                    final /* synthetic */ int $size;

                    public void visitElement(@NotNull PsiElement element3) {
                        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                        ++this.$size;
                        element3.acceptChildren((PsiElementVisitor)this);
                    }
                    {
                        this.$size = $captured_local_variable$0;
                    }
                });
                n = size;
            } else {
                n = 0;
            }
            this.elementsSize = n;
            this.currentPackageName = file2.getPackageFqName();
            Sequence size = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)file2.getImportDirectives()), (Function1)aliases.1.INSTANCE), (Function1)aliases.2.INSTANCE);
            CollectUsedDescriptorsVisitor collectUsedDescriptorsVisitor = this;
            boolean $i$f$groupBy = false;
            void var5_7 = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Name name2;
                void it;
                Object object2;
                ImportPath it2 = (ImportPath)element$iv$iv;
                boolean $i$a$-groupBy-KotlinImportOptimizer$CollectUsedDescriptorsVisitor$aliases$52 = false;
                FqName key$iv$iv = it2.getFqName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                ImportPath $i$a$-groupBy-KotlinImportOptimizer$CollectUsedDescriptorsVisitor$aliases$52 = (ImportPath)element$iv$iv;
                object = list$iv$iv;
                boolean bl = false;
                if (it.getImportedName() == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.name.Name");
                }
                object.add(name2);
            }
            object = destination$iv$iv;
            collectUsedDescriptorsVisitor.aliases = object;
            this.descriptorsToImport = new LinkedHashSet();
            this.namesToImport = new LinkedHashMap();
            this.abstractRefs = new ArrayList();
        }

        public /* synthetic */ CollectUsedDescriptorsVisitor(KtFile ktFile, ProgressIndicator progressIndicator, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                progressIndicator = null;
            }
            this(ktFile, progressIndicator);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$CollectUsedDescriptorsVisitor$AbstractReferenceImpl;", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$AbstractReference;", "reference", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "(Lorg/jetbrains/kotlin/idea/references/KtReference;)V", "dependsOnNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getDependsOnNames", "()Ljava/util/Collection;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "resolve", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "toString", "", "idea"})
        private static final class AbstractReferenceImpl
        implements OptimizedImportsBuilder.AbstractReference {
            private final KtReference reference;

            @NotNull
            public KtElement getElement() {
                return this.reference.getElement();
            }

            @NotNull
            public Collection<Name> getDependsOnNames() {
                Collection<Name> resolvesByNames = this.reference.getResolvesByNames();
                if (this.reference instanceof KtInvokeFunctionReference) {
                    Collection<Name> additionalNames;
                    Object object;
                    KtCallExpression ktCallExpression = (KtCallExpression)((KtInvokeFunctionReference)this.reference).getElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktCallExpression, (String)"reference.element");
                    KtExpression ktExpression = ktCallExpression.getCalleeExpression();
                    if (!(ktExpression instanceof KtNameReferenceExpression)) {
                        ktExpression = null;
                    }
                    Collection<Name> collection = (object = (KtNameReferenceExpression)ktExpression) != null && (object = ReferenceUtilKt.getMainReference((KtSimpleNameExpression)object)) != null ? ((KtSimpleNameReference)object).getResolvesByNames() : (additionalNames = null);
                    if (additionalNames != null) {
                        return CollectionsKt.plus(resolvesByNames, (Iterable)additionalNames);
                    }
                }
                return resolvesByNames;
            }

            @NotNull
            public Collection<DeclarationDescriptor> resolve(@NotNull BindingContext bindingContext2) {
                Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
                return this.reference.resolveToDescriptors(bindingContext2);
            }

            @NotNull
            public String toString() {
                return this.reference.toString();
            }

            public AbstractReferenceImpl(@NotNull KtReference reference2) {
                Intrinsics.checkParameterIsNotNull((Object)reference2, (String)"reference");
                this.reference = reference2;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000M\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0007J\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$Companion;", "", "()V", "DO_NOTHING", "org/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$Companion$DO_NOTHING$1", "Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$Companion$DO_NOTHING$1;", "collectDescriptorsToImport", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "inProgressBar", "", "prepareOptimizedImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "data", "replaceImports", "", "imports", "targets", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "idea"})
    public static final class Companion {
        @NotNull
        public final OptimizedImportsBuilder.InputData collectDescriptorsToImport(@NotNull KtFile file2, boolean inProgressBar) {
            ProgressIndicator progressIndicator;
            ProgressIndicator progressIndicator2;
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            if (inProgressBar) {
                ProgressIndicatorProvider progressIndicatorProvider = ProgressIndicatorProvider.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicatorProvider, (String)"ProgressIndicatorProvider.getInstance()");
                progressIndicator2 = progressIndicatorProvider.getProgressIndicator();
            } else {
                progressIndicator2 = null;
            }
            ProgressIndicator progressIndicator3 = progressIndicator = progressIndicator2;
            if (progressIndicator3 != null) {
                Object[] objectArray = new Object[1];
                String string = file2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
                objectArray[0] = string;
                progressIndicator3.setText(KotlinBundle.message("import.optimizer.progress.indicator.text.collect.imports.for", objectArray));
            }
            ProgressIndicator progressIndicator4 = progressIndicator;
            if (progressIndicator4 != null) {
                progressIndicator4.setIndeterminate(false);
            }
            CollectUsedDescriptorsVisitor visitor2 = new CollectUsedDescriptorsVisitor(file2, progressIndicator);
            file2.accept(visitor2);
            return visitor2.getData();
        }

        public static /* synthetic */ OptimizedImportsBuilder.InputData collectDescriptorsToImport$default(Companion companion, KtFile ktFile, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.collectDescriptorsToImport(ktFile, bl);
        }

        @Nullable
        public final List<ImportPath> prepareOptimizedImports(@NotNull KtFile file2, @NotNull OptimizedImportsBuilder.InputData data2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
            KotlinCodeStyleSettings settings2 = KotlinCodeStyleSettings.getInstance(file2.getProject());
            OptimizedImportsBuilder.Options options2 = new OptimizedImportsBuilder.Options(settings2.NAME_COUNT_TO_USE_STAR_IMPORT, settings2.NAME_COUNT_TO_USE_STAR_IMPORT_FOR_MEMBERS, (Function1)new Function1<FqName, Boolean>(settings2){
                final /* synthetic */ KotlinCodeStyleSettings $settings;

                public final boolean invoke(@NotNull FqName fqName2) {
                    Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
                    return this.$settings.PACKAGES_TO_USE_STAR_IMPORTS.contains(fqName2.asString());
                }
                {
                    this.$settings = kotlinCodeStyleSettings;
                    super(1);
                }
            });
            return new OptimizedImportsBuilder(file2, data2, options2).buildOptimizedImports();
        }

        public final void replaceImports(@NotNull KtFile file2, @NotNull List<ImportPath> imports2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull(imports2, (String)"imports");
            KtImportList ktImportList = file2.getImportList();
            if (ktImportList == null) {
                return;
            }
            KtImportList importList = ktImportList;
            List<KtImportDirective> list2 = importList.getImports();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"importList.imports");
            List<KtImportDirective> oldImports = list2;
            Project project2 = file2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"file.project");
            KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
            for (ImportPath importPath : imports2) {
                importList.addBefore((PsiElement)psiFactory.createImportDirective(importPath), (PsiElement)CollectionsKt.lastOrNull(oldImports));
            }
            for (KtImportDirective ktImportDirective : oldImports) {
                ktImportDirective.delete();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private final Collection<DeclarationDescriptor> targets(@NotNull KtReference $this$targets, BindingContext bindingContext2) {
            Collection collection;
            Object object;
            ReadOnlySlice readOnlySlice = BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT;
            KtElement ktElement = $this$targets.getElement();
            if (!(ktElement instanceof KtReferenceExpression)) {
                ktElement = null;
            }
            if ((object = (ClassifierDescriptorWithTypeParameters)bindingContext2.get(readOnlySlice, (KtReferenceExpression)ktElement)) != null) {
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = object;
                boolean bl = false;
                boolean bl2 = false;
                ClassifierDescriptorWithTypeParameters it = classifierDescriptorWithTypeParameters;
                boolean bl3 = false;
                object = CollectionsKt.listOf((Object)it);
                if (object != null) {
                    collection = (Collection)object;
                    return collection;
                }
            }
            collection = $this$targets.resolveToDescriptors(bindingContext2);
            return collection;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

